/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.signer.AwsS3V4Signer;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;

public class S3Presigner {
    private Region region;
    private AwsCredentialsProvider awsCredentialsProvider;
    private Duration expirationTime;
    private Integer timeOffset;
    private S3PresignExecutionInterceptor presignInterceptor = new S3PresignExecutionInterceptor();
    private S3Client s3Client;

    private S3Presigner() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public URI presignS3DownloadLink(String bucketName, String fileName) throws SdkClientException {
        try {
            GetObjectRequest s3GetRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(fileName).build();
            ResponseInputStream response = this.s3Client.getObject(s3GetRequest);
            response.close();
            return this.presignInterceptor.getSignedURI();
        }
        catch (Throwable t) {
            if (t instanceof SdkClientException) {
                throw (SdkClientException)t;
            }
            throw SdkClientException.builder().cause(t).build();
        }
    }

    public URI presignS3UploadLink(String bucketName, String fileName) throws SdkClientException {
        try {
            PutObjectRequest s3PutRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(bucketName).key(fileName).build();
            PutObjectResponse response = this.s3Client.putObject(s3PutRequest, RequestBody.empty());
            return this.presignInterceptor.getSignedURI();
        }
        catch (Throwable t) {
            if (t instanceof SdkClientException) {
                throw (SdkClientException)t;
            }
            throw SdkClientException.builder().cause(t).build();
        }
    }

    public class S3PresignExecutionInterceptor
    implements ExecutionInterceptor {
        private final AwsS3V4Signer signer = AwsS3V4Signer.create();
        private URI signedURI;

        public void beforeTransmission(Context.BeforeTransmission context, ExecutionAttributes executionAttributes) {
            SdkHttpFullRequest modifiedSdkRequest = (SdkHttpFullRequest)((SdkHttpRequest.Builder)context.httpRequest().toBuilder()).clearHeaders().build();
            executionAttributes.putAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS, (Object)S3Presigner.this.awsCredentialsProvider.resolveCredentials());
            executionAttributes.putAttribute(AwsSignerExecutionAttribute.PRESIGNER_EXPIRATION, (Object)Instant.ofEpochSecond(System.currentTimeMillis() / 1000L).plus(S3Presigner.this.expirationTime));
            executionAttributes.putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, (Object)"s3");
            executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, (Object)S3Presigner.this.region);
            executionAttributes.putAttribute(AwsSignerExecutionAttribute.TIME_OFFSET, (Object)S3Presigner.this.timeOffset);
            SdkHttpFullRequest signedRequest = this.signer.presign(modifiedSdkRequest, executionAttributes);
            this.signedURI = signedRequest.getUri();
        }

        public URI getSignedURI() {
            return this.signedURI;
        }
    }

    public static class NullSdkHttpClient
    implements SdkHttpClient {
        public void close() {
        }

        public ExecutableHttpRequest prepareRequest(HttpExecuteRequest request) {
            return new ExecutableHttpRequest(){

                public HttpExecuteResponse call() {
                    return HttpExecuteResponse.builder().response((SdkHttpResponse)SdkHttpResponse.builder().statusCode(200).build()).responseBody(AbortableInputStream.create((InputStream)new ByteArrayInputStream(new byte[0]))).build();
                }

                public void abort() {
                }
            };
        }
    }

    public static class Builder {
        S3Presigner presigner = new S3Presigner();

        public S3Presigner build() {
            if (this.presigner.awsCredentialsProvider == null) {
                DefaultCredentialsProvider provider = DefaultCredentialsProvider.create();
                this.presigner.awsCredentialsProvider = provider;
            }
            if (this.presigner.region == null) {
                this.presigner.region = new DefaultAwsRegionProviderChain().getRegion();
            }
            if (this.presigner.expirationTime == null) {
                this.presigner.expirationTime = Duration.ofDays(4L);
            }
            if (this.presigner.timeOffset == null) {
                this.presigner.timeOffset = 2;
            }
            S3ClientBuilder s3Builder = (S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(this.presigner.region)).credentialsProvider(this.presigner.awsCredentialsProvider);
            s3Builder.overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().addExecutionInterceptor((ExecutionInterceptor)this.presigner.presignInterceptor).build());
            s3Builder.httpClient((SdkHttpClient)new NullSdkHttpClient());
            this.presigner.s3Client = (S3Client)s3Builder.build();
            return this.presigner;
        }

        public Builder awsCredentials(AwsCredentialsProvider awsCredentialsProvider) {
            this.presigner.awsCredentialsProvider = awsCredentialsProvider;
            return this;
        }

        public Builder region(Region region) {
            this.presigner.region = region;
            return this;
        }

        public Builder expiration(Duration expirationTime) {
            this.presigner.expirationTime = expirationTime;
            return this;
        }

        public Builder timeOffset(Integer timeOffset) {
            this.presigner.timeOffset = timeOffset;
            return this;
        }
    }
}

