/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.util.Vector;

class PrefixTree {
    String name;
    int value;
    boolean isInt = false;
    PrefixTree subname = null;
    PrefixTree list = null;
    boolean lastprefix = false;

    PrefixTree(String string) {
        this.name = string;
        this.checkInt();
    }

    static PrefixTree addName(PrefixTree prefixTree, String string) {
        if (prefixTree == null) {
            prefixTree = new PrefixTree(PrefixTree.prefix(string, 0));
        }
        prefixTree.add(string, 0);
        return prefixTree;
    }

    private void add(String string, int n) {
        String string2 = PrefixTree.prefix(string, n);
        if (string2 == null) {
            return;
        }
        if (string2.equals(this.name) && !this.lastprefix) {
            String string3 = PrefixTree.prefix(string, n + 1);
            if (string3 == null) {
                this.lastprefix = true;
                return;
            }
            if (this.subname == null) {
                this.subname = new PrefixTree(string3);
            }
            this.subname.add(string, n + 1);
        } else {
            if (this.list == null) {
                this.list = new PrefixTree(string2);
            }
            this.list.add(string, n);
        }
    }

    public static boolean equals(PrefixTree prefixTree, PrefixTree prefixTree2) {
        if (prefixTree == prefixTree2) {
            return true;
        }
        if (prefixTree == null || prefixTree2 == null) {
            return false;
        }
        if (!prefixTree.name.equals(prefixTree2.name)) {
            return false;
        }
        return PrefixTree.equals(prefixTree.subname, prefixTree2.subname) && PrefixTree.equals(prefixTree.list, prefixTree2.list);
    }

    PrefixTree[] getSubLists() {
        Vector<PrefixTree> vector = new Vector<PrefixTree>();
        PrefixTree prefixTree = this;
        PrefixTree prefixTree2 = this.list;
        vector.addElement(prefixTree);
        while (prefixTree2 != null) {
            if (!PrefixTree.equals(prefixTree.subname, prefixTree2.subname) || prefixTree.isInt != prefixTree2.isInt) {
                vector.addElement(prefixTree2);
                prefixTree = prefixTree2;
            }
            prefixTree2 = prefixTree2.list;
        }
        vector.addElement(null);
        Object[] objectArray = new PrefixTree[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    void checkInt() {
        try {
            this.value = Integer.parseInt(this.name);
            this.isInt = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    static String prefix(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if ((n2 = string.indexOf(46, n2)) < 0) {
                return null;
            }
            ++n2;
            ++n3;
        }
        int n4 = string.indexOf(46, n2);
        if (n4 < 0) {
            return string.substring(n2);
        }
        return string.substring(n2, n4);
    }

    public void getStrings(Vector vector, int n, String string) {
        PrefixTree prefixTree = this;
        while (prefixTree != null) {
            String string2 = string == null ? prefixTree.item() : string + PrefixTree.dotted(prefixTree.item());
            if (prefixTree.subname == null) {
                vector.addElement(string2);
            } else if (n > 0) {
                prefixTree.subname.getStrings(vector, n - 1, string2);
            } else {
                vector.addElement(string2 + PrefixTree.dotted(prefixTree.subname.toString()));
            }
            prefixTree = prefixTree.list;
        }
    }

    public int maxDepth() {
        PrefixTree prefixTree = this;
        int n = 0;
        while (prefixTree != null) {
            n = prefixTree.subname == null ? Math.max(n, 1) : Math.max(1 + prefixTree.subname.maxDepth(), n);
            prefixTree = prefixTree.list;
        }
        return n;
    }

    public String toString() {
        PrefixTree[] prefixTreeArray = this.getSubLists();
        String string = prefixTreeArray.length > 2 ? "{" : "";
        int n = 0;
        while (n < prefixTreeArray.length - 1) {
            string = n < prefixTreeArray.length - 2 ? string + PrefixTree.listString(prefixTreeArray[n], prefixTreeArray[n + 1]) + ", " : string + PrefixTree.listString(prefixTreeArray[n], prefixTreeArray[n + 1]);
            ++n;
        }
        if (prefixTreeArray.length > 2) {
            return string + "}";
        }
        return string;
    }

    static String listString(PrefixTree prefixTree, PrefixTree prefixTree2) {
        String string;
        if (prefixTree.list == prefixTree2) {
            string = prefixTree.item();
        } else if (PrefixTree.intRange(prefixTree, prefixTree2)) {
            string = PrefixTree.rangeString(prefixTree, prefixTree2);
        } else {
            string = "{" + prefixTree.item();
            PrefixTree prefixTree3 = prefixTree.list;
            while (prefixTree3 != prefixTree2) {
                string = string + ", " + prefixTree3.item();
                prefixTree3 = prefixTree3.list;
            }
            string = string + "}";
        }
        if (prefixTree.subname != null) {
            return string + PrefixTree.dotted(prefixTree.subname.toString());
        }
        return string;
    }

    private static String dotted(String string) {
        if (string.charAt(0) == '[') {
            return string;
        }
        return "." + string;
    }

    String item() {
        if (this.isInt) {
            return "[" + this.name + "]";
        }
        return this.name;
    }

    static boolean intRange(PrefixTree prefixTree, PrefixTree prefixTree2) {
        PrefixTree prefixTree3 = prefixTree;
        while (prefixTree3 != prefixTree2) {
            if (!prefixTree3.isInt) {
                return false;
            }
            prefixTree3 = prefixTree3.list;
        }
        return true;
    }

    static String rangeString(PrefixTree prefixTree, PrefixTree prefixTree2) {
        PrefixTree prefixTree3 = prefixTree;
        int n = 0;
        while (prefixTree3 != prefixTree2) {
            prefixTree3 = prefixTree3.list;
            ++n;
        }
        int[] nArray = new int[n];
        prefixTree3 = prefixTree;
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = prefixTree3.value;
            prefixTree3 = prefixTree3.list;
            ++n2;
        }
        PrefixTree.sort(nArray);
        if (PrefixTree.isOneRange(nArray)) {
            return "[" + nArray[0] + ".." + nArray[nArray.length - 1] + "]";
        }
        int n3 = 0;
        String string = "{";
        while (n3 < nArray.length) {
            int n4 = n3;
            while (n4 < nArray.length - 1 && nArray[n4 + 1] - nArray[n4] == 1) {
                ++n4;
            }
            string = n4 == n3 ? string + "[" + nArray[n3] + "]" : string + "[" + nArray[n3] + ".." + nArray[n4] + "]";
            n3 = n4 + 1;
            if (n3 >= nArray.length) continue;
            string = string + ", ";
        }
        string = string + "}";
        return string;
    }

    private static boolean isOneRange(int[] nArray) {
        int n = 0;
        while (n < nArray.length - 1) {
            if (nArray[n + 1] - nArray[n] != 1) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static void sort(int[] nArray) {
        int n = 0;
        while (n < nArray.length - 1) {
            int n2 = n;
            int n3 = n + 1;
            while (n3 < nArray.length) {
                if (nArray[n3] < nArray[n2]) {
                    n2 = n3;
                }
                ++n3;
            }
            int n4 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n4;
            ++n;
        }
    }
}

