/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.RectangularShape;
import com.xerox.VTM.glyphs.Translucent;
import com.xerox.VTM.glyphs.VPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.Arrays;
import net.claribole.zvtm.glyphs.CBCElement;
import net.claribole.zvtm.glyphs.DPathST;
import net.claribole.zvtm.glyphs.MOVElement;
import net.claribole.zvtm.glyphs.PathElement;
import net.claribole.zvtm.glyphs.QDCElement;
import net.claribole.zvtm.glyphs.SEGElement;
import net.claribole.zvtm.glyphs.VPathST;
import net.claribole.zvtm.glyphs.projection.ProjectedCoords;

public class DPath
extends Glyph
implements RectangularShape {
    static final short MOV = 0;
    static final short SEG = 1;
    static final short QDC = 2;
    static final short CBC = 3;
    public ProjectedCoords[] pc;
    PathElement[] elements;
    LongPoint endPoint;
    long spx;
    long spy;
    public long vw;
    public long vh;
    GeneralPath gp;
    int hw;
    int hh;
    int lhw;
    int lhh;

    public DPath() {
        this.spx = 0L;
        this.spy = 0L;
        this.vz = 0;
        this.endPoint = new LongPoint(this.spx, this.spy);
        this.vx = this.spx;
        this.vy = this.spy;
        this.elements = new PathElement[0];
        this.computeBounds();
        this.updateJava2DGeneralPath();
        this.sensit = true;
        this.setColor(Color.BLACK);
    }

    public DPath(long x, long y, int z, Color c) {
        this.spx = x;
        this.spy = y;
        this.vz = z;
        this.endPoint = new LongPoint(this.spx, this.spy);
        this.vx = this.spx;
        this.vy = this.spy;
        this.elements = new PathElement[0];
        this.computeBounds();
        this.updateJava2DGeneralPath();
        this.sensit = true;
        this.setColor(c);
    }

    public DPath(PathIterator pi, int z, Color c) {
        this.vz = z;
        double[] cds = new double[6];
        if (pi.currentSegment(cds) == 0) {
            this.spx = (long)cds[0];
            this.spy = (long)cds[1];
            pi.next();
        } else {
            this.spx = 0L;
            this.spy = 0L;
        }
        this.endPoint = new LongPoint(this.spx, this.spy);
        this.vx = this.spx;
        this.vy = this.spy;
        this.elements = new PathElement[0];
        while (!pi.isDone()) {
            int type = pi.currentSegment(cds);
            switch (type) {
                case 3: {
                    this.addCbCurve((long)cds[4], (long)cds[5], (long)cds[0], (long)cds[1], (long)cds[2], (long)cds[3], true);
                    break;
                }
                case 2: {
                    this.addQdCurve((long)cds[2], (long)cds[3], (long)cds[0], (long)cds[1], true);
                    break;
                }
                case 1: {
                    this.addSegment((long)cds[0], (long)cds[1], true);
                    break;
                }
                case 0: {
                    this.jump((long)cds[0], (long)cds[1], true);
                }
            }
            pi.next();
        }
        this.computeBounds();
        this.updateJava2DGeneralPath();
        this.sensit = true;
        this.setColor(c);
    }

    public void addCbCurve(long x, long y, long x1, long y1, long x2, long y2, boolean abs) {
        CBCElement e;
        if (abs) {
            e = new CBCElement(x, y, x1, y1, x2, y2);
            this.endPoint.setLocation(x, y);
        } else {
            e = new CBCElement(this.endPoint.x + x, this.endPoint.y + y, this.endPoint.x + x1, this.endPoint.y + y1, this.endPoint.x + x2, this.endPoint.y + y2);
            this.endPoint.translate(x, y);
        }
        PathElement[] tmp = new PathElement[this.elements.length + 1];
        System.arraycopy(this.elements, 0, tmp, 0, this.elements.length);
        tmp[this.elements.length] = e;
        Arrays.fill(this.elements, null);
        this.elements = tmp;
        this.computeBounds();
        this.updateJava2DGeneralPath();
    }

    public void addQdCurve(long x, long y, long x1, long y1, boolean abs) {
        QDCElement e;
        if (abs) {
            e = new QDCElement(x, y, x1, y1);
            this.endPoint.setLocation(x, y);
        } else {
            e = new QDCElement(this.endPoint.x + x, this.endPoint.y + y, this.endPoint.x + x1, this.endPoint.y + y1);
            this.endPoint.translate(x, y);
        }
        PathElement[] tmp = new PathElement[this.elements.length + 1];
        System.arraycopy(this.elements, 0, tmp, 0, this.elements.length);
        tmp[this.elements.length] = e;
        Arrays.fill(this.elements, null);
        this.elements = tmp;
        this.computeBounds();
        this.updateJava2DGeneralPath();
    }

    public void addSegment(long x, long y, boolean abs) {
        if (abs) {
            this.endPoint.setLocation(x, y);
        } else {
            this.endPoint.translate(x, y);
        }
        PathElement[] tmp = new PathElement[this.elements.length + 1];
        System.arraycopy(this.elements, 0, tmp, 0, this.elements.length);
        tmp[this.elements.length] = new SEGElement(this.endPoint.x, this.endPoint.y);
        Arrays.fill(this.elements, null);
        this.elements = tmp;
        this.computeBounds();
        this.updateJava2DGeneralPath();
    }

    public void jump(long x, long y, boolean abs) {
        if (abs) {
            this.endPoint.setLocation(x, y);
        } else {
            this.endPoint.translate(x, y);
        }
        if (this.elements.length == 0) {
            this.spx = this.vx = this.endPoint.x;
            this.spy = this.vy = this.endPoint.y;
        } else {
            PathElement[] tmp = new PathElement[this.elements.length + 1];
            System.arraycopy(this.elements, 0, tmp, 0, this.elements.length);
            tmp[this.elements.length] = new MOVElement(this.endPoint.x, this.endPoint.y);
            Arrays.fill(this.elements, null);
            this.elements = tmp;
        }
        this.computeBounds();
        this.updateJava2DGeneralPath();
    }

    public long getWidth() {
        return 2L * this.vw;
    }

    public long getHeight() {
        return 2L * this.vh;
    }

    public void setWidth(long w) {
    }

    public void setHeight(long h) {
    }

    public LongPoint getStartPoint() {
        return new LongPoint(this.spx, this.spy);
    }

    public LongPoint getEndPoint() {
        return new LongPoint(this.endPoint.x, this.endPoint.y);
    }

    public void initCams(int nbCam) {
        int i;
        this.pc = new ProjectedCoords[nbCam];
        for (i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjectedCoords();
        }
        for (i = 0; i < this.elements.length; ++i) {
            this.elements[i].initCams(nbCam);
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjectedCoords[] ta = this.pc;
                this.pc = new ProjectedCoords[ta.length + 1];
                System.arraycopy(ta, 0, this.pc, 0, ta.length);
                this.pc[this.pc.length - 1] = new ProjectedCoords();
            } else {
                System.err.println("DPath:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjectedCoords[1];
            this.pc[0] = new ProjectedCoords();
        } else {
            System.err.println("DPath:Error while adding camera " + verifIndex);
        }
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i].addCamera(verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i].removeCamera(index);
        }
    }

    public void resetMouseIn() {
    }

    public void resetMouseIn(int i) {
    }

    public void sizeTo(float factor) {
    }

    public void reSize(float factor) {
    }

    public void move(long x, long y) {
        Object[] t = new LongPoint[this.getNumberOfPoints()];
        Arrays.fill(t, new LongPoint(x, y));
        this.edit((LongPoint[])t, false);
        this.propagateMove(x, y);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public void moveTo(long x, long y) {
        this.propagateMove(x - this.vx, y - this.vy);
        Object[] t = new LongPoint[this.getNumberOfPoints()];
        Arrays.fill(t, new LongPoint(x, y));
        this.edit((LongPoint[])t, true);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public void orientTo(float angle) {
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = (float)Math.sqrt(Math.pow(this.vw, 2.0) + Math.pow(this.vh, 2.0));
    }

    public void computeBounds() {
        LongPoint[] allPoints = this.getAllPointsCoordinates();
        if (allPoints.length == 0) {
            this.vx = this.spx;
            this.vy = this.spy;
            this.vw = 0L;
            this.vh = 0L;
            return;
        }
        long[] wnes = new long[]{allPoints[0].x, allPoints[0].y, allPoints[0].x, allPoints[0].y};
        for (int i = 1; i < allPoints.length; ++i) {
            if (allPoints[i].x < wnes[0]) {
                wnes[0] = allPoints[i].x;
            }
            if (allPoints[i].x > wnes[2]) {
                wnes[2] = allPoints[i].x;
            }
            if (allPoints[i].y < wnes[3]) {
                wnes[3] = allPoints[i].y;
            }
            if (allPoints[i].y <= wnes[1]) continue;
            wnes[1] = allPoints[i].y;
        }
        this.vx = (wnes[0] + wnes[2]) / 2L;
        this.vy = (wnes[1] + wnes[3]) / 2L;
        this.vw = (wnes[2] - wnes[0]) / 2L;
        this.vh = (wnes[1] - wnes[3]) / 2L;
        this.computeSize();
    }

    public long[] getBounds() {
        long[] res = new long[]{this.vx - this.vw, this.vy + this.vh, this.vx + this.vw, this.vy - this.vh};
        return res;
    }

    public boolean coordsInsideBoundingBox(long x, long y) {
        return x >= this.vx - this.vw && x <= this.vx + this.vw && y >= this.vy - this.vh && y <= this.vy + this.vh;
    }

    public float getOrient() {
        return this.orient;
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return false;
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return false;
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return 0;
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.hw = d.width / 2;
        this.hh = d.height / 2;
        this.pc[i].cx = this.hw + Math.round((float)(this.spx - c.posx) * this.coef);
        this.pc[i].cy = this.hh - Math.round((float)(this.spy - c.posy) * this.coef);
        if (this.elements.length == 0) {
            return;
        }
        this.elements[0].project(i, this.hw, this.hh, c, this.coef, this.pc[i].cx, this.pc[i].cy);
        for (int j = 1; j < this.elements.length; ++j) {
            this.elements[j].project(i, this.hw, this.hh, c, this.coef, this.elements[j - 1].getX(i), this.elements[j - 1].getY(i));
        }
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.lhw = lensWidth / 2;
        this.lhh = lensHeight / 2;
        this.pc[i].lcx = this.lhw + Math.round((float)(this.spx - lensx) * this.coef);
        this.pc[i].lcy = this.lhh - Math.round((float)(this.spy - lensy) * this.coef);
        if (this.elements.length == 0) {
            return;
        }
        this.elements[0].projectForLens(i, this.lhw, this.lhh, lensx, lensy, this.coef, this.pc[i].lcx, this.pc[i].lcy);
        for (int j = 1; j < this.elements.length; ++j) {
            this.elements[j].projectForLens(i, this.lhw, this.lhh, lensx, lensy, this.coef, this.elements[j - 1].getlX(i), this.elements[j - 1].getlY(i));
        }
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        g.setColor(this.color);
        if (this.stroke != null) {
            g.setStroke(this.stroke);
            g.translate(dx, dy);
            for (int j = 0; j < this.elements.length; ++j) {
                if (this.elements[j].type == 0) continue;
                g.draw(this.elements[j].getShape(i));
            }
            g.translate(-dx, -dy);
            g.setStroke(stdS);
        } else {
            g.translate(dx, dy);
            for (int j = 0; j < this.elements.length; ++j) {
                if (this.elements[j].type == 0) continue;
                g.draw(this.elements[j].getShape(i));
            }
            g.translate(-dx, -dy);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        g.setColor(this.color);
        if (this.stroke != null) {
            g.setStroke(this.stroke);
            g.translate(dx, dy);
            for (int j = 0; j < this.elements.length; ++j) {
                if (this.elements[j].type == 0) continue;
                g.draw(this.elements[j].getlShape(i));
            }
            g.translate(-dx, -dy);
            g.setStroke(stdS);
        } else {
            g.translate(dx, dy);
            for (int j = 0; j < this.elements.length; ++j) {
                if (this.elements[j].type == 0) continue;
                g.draw(this.elements[j].getlShape(i));
            }
            g.translate(-dx, -dy);
        }
    }

    public boolean visibleInRegion(long wb, long nb, long eb, long sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        return this.vx - this.vw <= eb && this.vx + this.vw >= wb && this.vy - this.vh <= nb && this.vy + this.vh >= sb;
    }

    public boolean containedInRegion(long wb, long nb, long eb, long sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        return this.vx + this.vw <= eb && this.vx - this.vw >= wb && this.vy + this.vh <= nb && this.vy - this.vh >= sb;
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return this.gp.intersects(dvx - dvr, dvy - dvr, 2L * dvr, 2L * dvr) && !this.gp.contains(dvx - dvr, dvy - dvr, 2L * dvr, 2L * dvr);
    }

    public Object clone() {
        return null;
    }

    public void highlight(boolean b, Color selectedColor) {
        boolean update = false;
        if (b) {
            if (this.mouseInsideColor != null) {
                this.color = this.mouseInsideColor;
                update = true;
            }
        } else if (this.isSelected() && selectedColor != null) {
            this.color = selectedColor;
            update = true;
        } else if (this.mouseInsideColor != null) {
            this.color = this.fColor;
            update = true;
        }
        if (update) {
            try {
                this.vsm.repaintNow();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
        }
    }

    public void editElement(int index, long sx, long sy, long ex, long ey, LongPoint[] ctrlPoints, boolean abs) {
        if (index > -1 && index < this.elements.length && this.elements[index] != null) {
            if (index > 0) {
                if (abs) {
                    this.elements[index - 1].x = sx;
                    this.elements[index - 1].y = sy;
                } else {
                    this.elements[index - 1].x += sx;
                    this.elements[index - 1].y += sy;
                }
            } else if (abs) {
                this.spx = sx;
                this.spy = sy;
            } else {
                this.spx += sx;
                this.spy += sy;
            }
            PathElement el = this.elements[index];
            switch (el.type) {
                case 2: {
                    if (ctrlPoints == null || ctrlPoints.length <= 0 || ctrlPoints[0] == null) break;
                    if (abs) {
                        ((QDCElement)el).ctrlx = ctrlPoints[0].x;
                        ((QDCElement)el).ctrly = ctrlPoints[0].y;
                        break;
                    }
                    ((QDCElement)el).ctrlx += ctrlPoints[0].x;
                    ((QDCElement)el).ctrly += ctrlPoints[0].y;
                    break;
                }
                case 3: {
                    if (ctrlPoints == null || ctrlPoints.length <= 1 || ctrlPoints[0] == null || ctrlPoints[1] == null) break;
                    if (abs) {
                        ((CBCElement)el).ctrlx1 = ctrlPoints[0].x;
                        ((CBCElement)el).ctrly1 = ctrlPoints[0].y;
                        ((CBCElement)el).ctrlx2 = ctrlPoints[1].x;
                        ((CBCElement)el).ctrly2 = ctrlPoints[1].y;
                        break;
                    }
                    ((CBCElement)el).ctrlx1 += ctrlPoints[0].x;
                    ((CBCElement)el).ctrly1 += ctrlPoints[0].y;
                    ((CBCElement)el).ctrlx2 += ctrlPoints[1].x;
                    ((CBCElement)el).ctrly2 += ctrlPoints[1].y;
                }
            }
            if (abs) {
                el.x = ex;
                el.y = ey;
            } else {
                el.x += ex;
                el.y += ey;
            }
            if (index == this.elements.length - 1) {
                this.endPoint = new LongPoint(el.x, el.y);
            }
        }
        this.computeBounds();
        this.updateJava2DGeneralPath();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public void edit(LongPoint[] points, boolean abs) {
        int totalPointsCount = 1;
        block10: for (int i = 0; i < this.elements.length; ++i) {
            ++totalPointsCount;
            switch (this.elements[i].type) {
                case 3: {
                    totalPointsCount += 2;
                    continue block10;
                }
                case 2: {
                    ++totalPointsCount;
                }
            }
        }
        if (points != null && points.length == totalPointsCount) {
            if (abs) {
                this.spx = points[0].x;
                this.spy = points[0].y;
            } else {
                this.spx += points[0].x;
                this.spy += points[0].y;
            }
            int offset = 0;
            for (int i = 0; i < this.elements.length; ++i) {
                switch (this.elements[i].type) {
                    case 3: {
                        if (abs) {
                            ((CBCElement)this.elements[i]).ctrlx1 = points[i + 1 + offset].x;
                            ((CBCElement)this.elements[i]).ctrly1 = points[i + 1 + offset].y;
                            ((CBCElement)this.elements[i]).ctrlx2 = points[i + 2 + offset].x;
                            ((CBCElement)this.elements[i]).ctrly2 = points[i + 2 + offset].y;
                            this.elements[i].x = points[i + 3 + offset].x;
                            this.elements[i].y = points[i + 3 + offset].y;
                        } else {
                            ((CBCElement)this.elements[i]).ctrlx1 += points[i + 1 + offset].x;
                            ((CBCElement)this.elements[i]).ctrly1 += points[i + 1 + offset].y;
                            ((CBCElement)this.elements[i]).ctrlx2 += points[i + 2 + offset].x;
                            ((CBCElement)this.elements[i]).ctrly2 += points[i + 2 + offset].y;
                            this.elements[i].x += points[i + 3 + offset].x;
                            this.elements[i].y += points[i + 3 + offset].y;
                        }
                        offset += 2;
                        break;
                    }
                    case 2: {
                        if (abs) {
                            ((QDCElement)this.elements[i]).ctrlx = points[i + 1 + offset].x;
                            ((QDCElement)this.elements[i]).ctrly = points[i + 1 + offset].y;
                            this.elements[i].x = points[i + 2 + offset].x;
                            this.elements[i].y = points[i + 2 + offset].y;
                        } else {
                            ((QDCElement)this.elements[i]).ctrlx += points[i + 1 + offset].x;
                            ((QDCElement)this.elements[i]).ctrly += points[i + 1 + offset].y;
                            this.elements[i].x += points[i + 2 + offset].x;
                            this.elements[i].y += points[i + 2 + offset].y;
                        }
                        ++offset;
                        break;
                    }
                    default: {
                        if (abs) {
                            this.elements[i].x = points[i + 1 + offset].x;
                            this.elements[i].y = points[i + 1 + offset].y;
                            break;
                        }
                        this.elements[i].x += points[i + 1 + offset].x;
                        this.elements[i].y += points[i + 1 + offset].y;
                    }
                }
                if (i != this.elements.length - 1) continue;
                this.endPoint = new LongPoint(this.elements[i].x, this.elements[i].y);
            }
        }
        this.computeBounds();
        this.updateJava2DGeneralPath();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public int getElementsCount() {
        if (this.elements != null) {
            return this.elements.length;
        }
        return 0;
    }

    public int getElementType(int index) {
        if (this.elements != null && index > -1 && index < this.elements.length && this.elements[index] != null) {
            return this.elements[index].type;
        }
        return -1;
    }

    public LongPoint[] getElementPointsCoordinates(int index) {
        LongPoint[] result = null;
        if (this.elements != null && index > -1 && index < this.elements.length && this.elements[index] != null) {
            switch (this.elements[index].type) {
                case 3: {
                    result = new LongPoint[4];
                    result[0] = index == 0 ? new LongPoint(this.spx, this.spy) : new LongPoint(this.elements[index - 1].x, this.elements[index - 1].y);
                    result[3] = new LongPoint(this.elements[index].x, this.elements[index].y);
                    result[1] = new LongPoint(((CBCElement)this.elements[index]).ctrlx1, ((CBCElement)this.elements[index]).ctrly1);
                    result[2] = new LongPoint(((CBCElement)this.elements[index]).ctrlx2, ((CBCElement)this.elements[index]).ctrly2);
                    break;
                }
                case 2: {
                    result = new LongPoint[3];
                    result[0] = index == 0 ? new LongPoint(this.spx, this.spy) : new LongPoint(this.elements[index - 1].x, this.elements[index - 1].y);
                    result[2] = new LongPoint(this.elements[index].x, this.elements[index].y);
                    result[1] = new LongPoint(((QDCElement)this.elements[index]).ctrlx, ((QDCElement)this.elements[index]).ctrly);
                    break;
                }
                default: {
                    result = new LongPoint[]{index == 0 ? new LongPoint(this.spx, this.spy) : new LongPoint(this.elements[index - 1].x, this.elements[index - 1].y), new LongPoint(this.elements[index].x, this.elements[index].y)};
                }
            }
        }
        return result;
    }

    public int getNumberOfPoints() {
        int totalNumberOfPoints = 1;
        block4: for (int i = 0; i < this.elements.length; ++i) {
            ++totalNumberOfPoints;
            short type = this.elements[i].type;
            switch (type) {
                case 3: {
                    totalNumberOfPoints += 2;
                    continue block4;
                }
                case 2: {
                    ++totalNumberOfPoints;
                }
            }
        }
        return totalNumberOfPoints;
    }

    public LongPoint[] getAllPointsCoordinates() {
        int totalNumberOfPoints = this.getNumberOfPoints();
        LongPoint[] result = new LongPoint[totalNumberOfPoints];
        int offset = 0;
        result[0] = new LongPoint(this.spx, this.spy);
        block4: for (int i = 0; i < this.elements.length; ++i) {
            switch (this.elements[i].type) {
                case 3: {
                    PathElement el = (CBCElement)this.elements[i];
                    result[i + 1 + offset] = new LongPoint(el.ctrlx1, el.ctrly1);
                    result[i + 2 + offset] = new LongPoint(el.ctrlx2, el.ctrly2);
                    result[i + 3 + offset] = new LongPoint(el.x, el.y);
                    offset += 2;
                    continue block4;
                }
                case 2: {
                    PathElement el = (QDCElement)this.elements[i];
                    result[i + 1 + offset] = new LongPoint(((QDCElement)el).ctrlx, ((QDCElement)el).ctrly);
                    result[i + 2 + offset] = new LongPoint(((QDCElement)el).x, ((QDCElement)el).y);
                    ++offset;
                    continue block4;
                }
                default: {
                    result[i + 1 + offset] = new LongPoint(this.elements[i].x, this.elements[i].y);
                }
            }
        }
        return result;
    }

    public static LongPoint[] getFlattenedCoordinates(DPath path, LongPoint startPoint, LongPoint endPoint, boolean abs) {
        LongPoint[] result = path.getAllPointsCoordinates();
        if (!abs) {
            startPoint = new LongPoint(result[0].x + startPoint.x, result[0].y + startPoint.y);
            endPoint = new LongPoint(result[result.length - 1].x + endPoint.x, result[result.length - 1].y + endPoint.y);
        }
        long dx = Math.round((double)(endPoint.x - startPoint.x) / (double)result.length);
        long dy = Math.round((double)(endPoint.y - startPoint.y) / (double)result.length);
        for (int i = 0; i < result.length - 1; ++i) {
            result[i].x = startPoint.x + (long)i * dx;
            result[i].y = startPoint.y + (long)i * dy;
        }
        result[result.length - 1].x = endPoint.x;
        result[result.length - 1].y = endPoint.y;
        return result;
    }

    public static DPath fromVPath(VPath vp) {
        DPath res = null;
        if (vp != null) {
            res = vp instanceof VPathST ? new DPathST(vp.vx, vp.vy, vp.getZindex(), vp.getColor(), ((Translucent)((Object)vp)).getTranslucencyValue()) : new DPath(vp.vx, vp.vy, vp.getZindex(), vp.getColor());
            BasicStroke s = vp.getStroke();
            if (s != null) {
                res.setStroke(s);
            } else {
                res.setStrokeWidth(vp.getStrokeWidth());
            }
            PathIterator pi = vp.getJava2DPathIterator();
            pi.next();
            double[] cds = new double[6];
            while (!pi.isDone()) {
                int type = pi.currentSegment(cds);
                switch (type) {
                    case 3: {
                        res.addCbCurve((long)cds[4], (long)(-cds[5]), (long)cds[0], (long)(-cds[1]), (long)cds[2], (long)(-cds[3]), true);
                        break;
                    }
                    case 2: {
                        res.addQdCurve((long)cds[2], (long)(-cds[3]), (long)cds[0], (long)(-cds[1]), true);
                        break;
                    }
                    case 1: {
                        res.addSegment((long)cds[0], (long)(-cds[1]), true);
                        break;
                    }
                    case 0: {
                        res.jump((long)cds[0], (long)(-cds[1]), true);
                    }
                }
                pi.next();
            }
        }
        return res;
    }

    public static VPath toVPath(DPath dp) {
        VPath res = null;
        if (dp != null) {
            res = dp instanceof DPathST ? new VPathST(dp.spx, dp.spy, dp.vz, dp.getColor(), ((Translucent)((Object)dp)).getTranslucencyValue()) : new VPath(dp.spx, dp.spy, dp.vz, dp.getColor());
            BasicStroke s = dp.getStroke();
            if (s != null) {
                res.setStroke(s);
            } else {
                res.setStrokeWidth(dp.getStrokeWidth());
            }
            block6: for (int i = 0; i < dp.getElementsCount(); ++i) {
                int elType = dp.getElementType(i);
                LongPoint[] pts = dp.getElementPointsCoordinates(i);
                switch (elType) {
                    case 3: {
                        res.addCbCurve(pts[3].x, pts[3].y, pts[1].x, pts[1].y, pts[2].x, pts[2].y, true);
                        continue block6;
                    }
                    case 2: {
                        res.addQdCurve(pts[2].x, pts[2].y, pts[1].x, pts[1].y, true);
                        continue block6;
                    }
                    case 1: {
                        res.addSegment(pts[1].x, pts[1].y, true);
                        continue block6;
                    }
                    case 0: {
                        res.jump(pts[1].x, pts[1].y, true);
                    }
                }
            }
        }
        return res;
    }

    public PathIterator getSVGPathIterator() {
        GeneralPath res = new GeneralPath();
        res.moveTo(this.spx, -this.spy);
        block6: for (int i = 0; i < this.getElementsCount(); ++i) {
            int elType = this.getElementType(i);
            LongPoint[] pts = this.getElementPointsCoordinates(i);
            switch (elType) {
                case 3: {
                    res.curveTo(pts[1].x, -pts[1].y, pts[2].x, -pts[2].y, pts[3].x, -pts[3].y);
                    continue block6;
                }
                case 2: {
                    res.quadTo(pts[1].x, -pts[1].y, pts[2].x, -pts[2].y);
                    continue block6;
                }
                case 1: {
                    res.lineTo(pts[1].x, -pts[1].y);
                    continue block6;
                }
                case 0: {
                    res.moveTo(pts[1].x, -pts[1].y);
                }
            }
        }
        return res.getPathIterator(null);
    }

    public void updateJava2DGeneralPath() {
        this.gp = new GeneralPath();
        this.gp.moveTo(this.spx, this.spy);
        block6: for (int i = 0; i < this.getElementsCount(); ++i) {
            int elType = this.getElementType(i);
            LongPoint[] pts = this.getElementPointsCoordinates(i);
            switch (elType) {
                case 3: {
                    this.gp.curveTo(pts[1].x, pts[1].y, pts[2].x, pts[2].y, pts[3].x, pts[3].y);
                    continue block6;
                }
                case 2: {
                    this.gp.quadTo(pts[1].x, pts[1].y, pts[2].x, pts[2].y);
                    continue block6;
                }
                case 1: {
                    this.gp.lineTo(pts[1].x, pts[1].y);
                    continue block6;
                }
                case 0: {
                    this.gp.moveTo(pts[1].x, pts[1].y);
                }
            }
        }
    }

    public GeneralPath getJava2DGeneralPath() {
        return this.gp;
    }

    public PathIterator getJava2DPathIterator() {
        return this.gp.getPathIterator(null);
    }

    public float getStartTangentOrientation() {
        float res = 0.0f;
        if (this.elements.length > 0) {
            PathElement el = this.elements[0];
            long sx = 0L;
            long sy = 0L;
            switch (el.type) {
                case 3: {
                    sx = ((CBCElement)el).ctrlx1;
                    sy = ((CBCElement)el).ctrly1;
                    break;
                }
                case 2: {
                    sx = ((QDCElement)el).ctrlx;
                    sy = ((QDCElement)el).ctrly;
                    break;
                }
                default: {
                    sx = el.x;
                    sy = el.y;
                }
            }
            if (this.spx == sx) {
                res = this.spy > sy ? 1.5707964f : 4.712389f;
            } else {
                double tan = (double)(this.spy - sy) / (double)(this.spx - sx);
                res = (float)Math.atan(tan);
                if (this.spx < sx) {
                    res = (float)((double)res + Math.PI);
                }
                if (this.spx > sx && this.spy < sy) {
                    res = (float)((double)res + Math.PI * 2);
                }
            }
        }
        return res;
    }

    public float getEndTangentOrientation() {
        float res = 0.0f;
        if (this.elements.length > 0) {
            PathElement el = this.elements[this.elements.length - 1];
            long sx = 0L;
            long sy = 0L;
            switch (el.type) {
                case 3: {
                    sx = ((CBCElement)el).ctrlx2;
                    sy = ((CBCElement)el).ctrly2;
                    break;
                }
                case 2: {
                    sx = ((QDCElement)el).ctrlx;
                    sy = ((QDCElement)el).ctrly;
                    break;
                }
                default: {
                    if (this.elements.length > 1) {
                        sx = this.elements[this.elements.length - 2].x;
                        sy = this.elements[this.elements.length - 2].y;
                        break;
                    }
                    sx = this.spx;
                    sy = this.spy;
                }
            }
            if (el.x == sx) {
                res = el.y > sy ? 1.5707964f : 4.712389f;
            } else {
                double tan = (double)(el.y - sy) / (double)(el.x - sx);
                res = (float)Math.atan(tan);
                if (el.x < sx) {
                    res = (float)((double)res + Math.PI);
                }
                if (el.x > sx && el.y < sy) {
                    res = (float)((double)res + Math.PI * 2);
                }
            }
        }
        return res;
    }
}

