/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.glyphs.VSlice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import net.claribole.zvtm.glyphs.projection.ProjRing;

public class VRing
extends VSlice {
    ProjRing[] pr;
    float irr_p;
    Arc2D outerSlice = new Arc2D.Double(2);
    Ellipse2D innerSlice = new Ellipse2D.Double();
    Area subring;

    public VRing(LongPoint[] v, float irr, int z, Color c, Color bc) {
        this.initCoordArray(4);
        this.vx = v[0].x;
        this.vy = v[0].y;
        this.vz = z;
        this.irr_p = irr;
        this.computeSize();
        this.computeOrient();
        this.computeAngle();
        this.setColor(c);
        this.setBorderColor(bc);
    }

    public VRing(long x, long y, int z, long vs, double ag, float irr, double or, Color c, Color bc) {
        this.initCoordArray(4);
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.size = vs;
        this.vr = vs;
        this.irr_p = irr;
        this.orient = or;
        this.orientDeg = (int)Math.round(this.orient * 57.29577951308232);
        this.angle = ag;
        this.angleDeg = (int)Math.round(this.angle * 57.29577951308232);
        this.setColor(c);
        this.setBorderColor(bc);
    }

    public VRing(long x, long y, int z, long vs, int ag, float irr, int or, Color c, Color bc) {
        this.initCoordArray(4);
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.size = vs;
        this.vr = vs;
        this.irr_p = irr;
        this.orient = (double)or * (Math.PI / 180);
        this.orientDeg = or;
        this.angle = (double)ag * (Math.PI / 180);
        this.angleDeg = ag;
        this.setColor(c);
        this.setBorderColor(bc);
    }

    public void initCams(int nbCam) {
        this.pc = new ProjRing[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjRing();
        }
        this.pr = (ProjRing[])this.pc;
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjRing[] ta = (ProjRing[])this.pc;
                this.pc = new ProjRing[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjRing();
                this.pr = (ProjRing[])this.pc;
            } else {
                System.err.println("VRing:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjRing[1];
            this.pc[0] = new ProjRing();
        } else {
            System.err.println("VRing:Error while adding camera " + verifIndex);
        }
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return Math.sqrt(Math.pow(jpx - this.pc[camIndex].cx, 2.0) + Math.pow(jpy - this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].outerCircleRadius && this.pr[camIndex].ring.contains(jpx, jpy);
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        if (Math.sqrt(Math.pow(this.vx - dvx, 2.0) + Math.pow(this.vy - dvy, 2.0)) < (double)(dvr + this.vr)) {
            return this.pr[camIndex].ring.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
        }
        return false;
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        int hw = d.width / 2;
        int hh = d.height / 2;
        this.pc[i].cx = hw + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = hh - Math.round((float)(this.vy - c.posy) * this.coef);
        this.pc[i].outerCircleRadius = Math.round(this.size * this.coef);
        this.pr[i].innerRingRadius = Math.round(this.size * this.irr_p * this.coef);
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        int hw = lensWidth / 2;
        int hh = lensHeight / 2;
        this.pc[i].lcx = hw + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = hh - Math.round((float)(this.vy - lensy) * this.coef);
        this.pc[i].louterCircleRadius = Math.round(this.size * this.coef);
        this.pr[i].linnerRingRadius = Math.round(this.size * this.irr_p * this.coef);
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].outerCircleRadius > 2) {
            if (this.isFilled()) {
                this.outerSlice.setArc(dx + this.pc[i].cx - this.pc[i].outerCircleRadius, dy + this.pc[i].cy - this.pc[i].outerCircleRadius, 2 * this.pc[i].outerCircleRadius, 2 * this.pc[i].outerCircleRadius, (int)Math.round((double)this.orientDeg - (double)this.angleDeg / 2.0), this.angleDeg, 2);
                this.innerSlice.setFrame(dx + this.pc[i].cx - this.pr[i].innerRingRadius, dy + this.pc[i].cy - this.pr[i].innerRingRadius, 2 * this.pr[i].innerRingRadius, 2 * this.pr[i].innerRingRadius);
                this.pr[i].ring = new Area(this.outerSlice);
                this.subring = new Area(this.innerSlice);
                this.pr[i].ring.subtract(this.subring);
                g.setColor(this.color);
                g.fill(this.pr[i].ring);
            }
            if (this.isBorderDrawn()) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.draw(this.pr[i].ring);
                    g.setStroke(stdS);
                } else {
                    g.draw(this.pr[i].ring);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].louterCircleRadius > 2) {
            if (this.isFilled()) {
                this.outerSlice.setArc(dx + this.pc[i].lcx - this.pc[i].louterCircleRadius, dy + this.pc[i].lcy - this.pc[i].louterCircleRadius, 2 * this.pc[i].louterCircleRadius, 2 * this.pc[i].louterCircleRadius, (int)Math.round((double)this.orientDeg - (double)this.angleDeg / 2.0), this.angleDeg, 2);
                this.innerSlice.setFrame(dx + this.pc[i].lcx - this.pr[i].linnerRingRadius, dy + this.pc[i].lcy - this.pr[i].linnerRingRadius, 2 * this.pr[i].linnerRingRadius, 2 * this.pr[i].linnerRingRadius);
                this.pr[i].lring = new Area(this.outerSlice);
                this.subring = new Area(this.innerSlice);
                this.pr[i].lring.subtract(this.subring);
                g.setColor(this.color);
                g.fill(this.pr[i].lring);
            }
            if (this.isBorderDrawn()) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.draw(this.pr[i].lring);
                    g.setStroke(stdS);
                } else {
                    g.draw(this.pr[i].lring);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public Object clone() {
        return null;
    }
}

