/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.search.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.opensolaris.opengrok.search.context.LineMatcher;
import org.opensolaris.opengrok.search.context.PhraseMatcher;
import org.opensolaris.opengrok.search.context.PrefixMatcher;
import org.opensolaris.opengrok.search.context.TokenSetMatcher;
import org.opensolaris.opengrok.search.context.WildCardMatcher;

public final class QueryMatchers {
    private Set<String> caseSensitiveTerms;
    private Set<String> caseInsensitiveTerms;
    private List<LineMatcher> matchers;
    private Map<String, Boolean> fields;

    public LineMatcher[] getMatchers(Query query, Map<String, Boolean> fields) {
        this.caseSensitiveTerms = new HashSet<String>();
        this.caseInsensitiveTerms = new HashSet<String>();
        this.matchers = new ArrayList<LineMatcher>();
        this.fields = fields;
        this.getTerms(query);
        if (!this.caseSensitiveTerms.isEmpty()) {
            this.matchers.add(0, new TokenSetMatcher(this.caseSensitiveTerms, false));
        }
        if (!this.caseInsensitiveTerms.isEmpty()) {
            this.matchers.add(0, new TokenSetMatcher(this.caseInsensitiveTerms, true));
        }
        if (this.matchers.isEmpty()) {
            return null;
        }
        LineMatcher[] m = this.matchers.toArray(new LineMatcher[this.matchers.size()]);
        return m;
    }

    private void getTerms(Query query) {
        if (query instanceof BooleanQuery) {
            this.getBooleans((BooleanQuery)query);
        } else if (query instanceof PhraseQuery) {
            this.getPhrases((PhraseQuery)query);
        } else if (query instanceof WildcardQuery) {
            this.getWildTerm((WildcardQuery)query);
        } else if (query instanceof TermQuery) {
            this.getTerm((TermQuery)query);
        } else if (query instanceof PrefixQuery) {
            this.getPrefix((PrefixQuery)query);
        }
    }

    private void getBooleans(BooleanQuery query) {
        BooleanClause[] queryClauses = query.getClauses();
        for (int i = 0; i < queryClauses.length; ++i) {
            if (queryClauses[i].isProhibited()) continue;
            this.getTerms(queryClauses[i].getQuery());
        }
    }

    private void getPhrases(PhraseQuery query) {
        Term[] queryTerms = query.getTerms();
        if (queryTerms.length > 0 && this.useTerm(queryTerms[0])) {
            boolean caseInsensitive = this.isCaseInsensitive(queryTerms[0]);
            String[] termsArray = new String[queryTerms.length];
            for (int i = 0; i < queryTerms.length; ++i) {
                termsArray[i] = queryTerms[i].text();
            }
            this.matchers.add(new PhraseMatcher(termsArray, caseInsensitive));
        }
    }

    private void getTerm(TermQuery query) {
        Term term = query.getTerm();
        if (this.useTerm(term)) {
            String text = term.text();
            if (this.isCaseInsensitive(term)) {
                this.caseInsensitiveTerms.add(text);
            } else {
                this.caseSensitiveTerms.add(text);
            }
        }
    }

    private void getWildTerm(WildcardQuery query) {
        Term term = query.getTerm();
        if (this.useTerm(term)) {
            this.matchers.add(new WildCardMatcher(term.text(), this.isCaseInsensitive(term)));
        }
    }

    private void getPrefix(PrefixQuery query) {
        Term term = query.getPrefix();
        if (this.useTerm(term)) {
            this.matchers.add(new PrefixMatcher(term.text(), this.isCaseInsensitive(term)));
        }
    }

    private boolean useTerm(Term term) {
        return this.fields.keySet().contains(term.field());
    }

    private boolean isCaseInsensitive(Term term) {
        return this.fields.get(term.field());
    }
}

