/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.proxy;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.parosproxy.paros.common.AbstractParam;

public class ProxyParam
extends AbstractParam {
    private static final String PROXY_IP = "proxy.ip";
    private static final String PROXY_PORT = "proxy.port";
    private static final String USE_REVERSE_PROXY = "proxy.reverseProxy.use";
    private static final String REVERSE_PROXY_IP = "proxy.reverseProxy.ip";
    private static final String REVERSE_PROXY_HTTP_PORT = "proxy.reverseProxy.httpPort";
    private static final String REVERSE_PROXY_HTTPS_PORT = "proxy.reverseProxy.httpsPort";
    private String proxyIp = "localhost";
    private int proxyPort = 8080;
    private int proxySSLPort = 8443;
    private int useReverseProxy = 0;
    private String reverseProxyIp = "localhost";
    private int reverseProxyHttpPort = 80;
    private int reverseProxyHttpsPort = 443;

    protected void parse() {
        this.proxyIp = this.getConfig().getString(PROXY_IP, "localhost");
        try {
            this.proxyPort = this.getConfig().getInt(PROXY_PORT, 8080);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.proxySSLPort = 8443;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.reverseProxyIp = this.getConfig().getString(REVERSE_PROXY_IP);
        if (this.reverseProxyIp.equalsIgnoreCase("localhost") || this.reverseProxyIp.equalsIgnoreCase("127.0.0.1")) {
            try {
                this.reverseProxyIp = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace();
            }
        }
        this.reverseProxyHttpPort = this.getConfig().getInt(REVERSE_PROXY_HTTP_PORT, 80);
        this.reverseProxyHttpsPort = this.getConfig().getInt(REVERSE_PROXY_HTTPS_PORT, 443);
        this.useReverseProxy = this.getConfig().getInt(USE_REVERSE_PROXY, 0);
    }

    public String getProxyIp() {
        return this.proxyIp;
    }

    public void setProxyIp(String string) {
        this.proxyIp = string.trim();
        this.getConfig().setProperty(PROXY_IP, this.proxyIp);
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
        this.getConfig().setProperty(PROXY_PORT, Integer.toString(this.proxyPort));
    }

    public int getProxySSLPort() {
        return this.proxySSLPort;
    }

    public String getReverseProxyIp() {
        return this.reverseProxyIp;
    }

    public void setReverseProxyIp(String string) {
        this.reverseProxyIp = string.trim();
        this.getConfig().setProperty(REVERSE_PROXY_IP, this.reverseProxyIp);
    }

    public int getReverseProxyHttpPort() {
        return this.reverseProxyHttpPort;
    }

    public void setReverseProxyHttpPort(int n) {
        this.reverseProxyHttpPort = n;
        this.getConfig().setProperty(REVERSE_PROXY_HTTP_PORT, Integer.toString(this.reverseProxyHttpPort));
    }

    public int getReverseProxyHttpsPort() {
        return this.reverseProxyHttpsPort;
    }

    public void setReverseProxyHttpsPort(int n) {
        this.reverseProxyHttpsPort = n;
        this.getConfig().setProperty(REVERSE_PROXY_HTTPS_PORT, Integer.toString(this.reverseProxyHttpsPort));
    }

    public boolean isUseReverseProxy() {
        return this.useReverseProxy != 0;
    }

    public void setUseReverseProxy(boolean bl) {
        if (bl) {
            this.useReverseProxy = 1;
            this.getConfig().setProperty(USE_REVERSE_PROXY, Integer.toString(this.useReverseProxy));
            return;
        }
        this.useReverseProxy = 0;
        this.getConfig().setProperty(USE_REVERSE_PROXY, Integer.toString(this.useReverseProxy));
    }
}

