/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.List;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public final class JavaNetAuthenticator
implements Authenticator {
    public Request authenticate(Route route, Response response) throws IOException {
        List challenges = response.challenges();
        Request request = response.request();
        HttpUrl url = request.url();
        boolean proxyAuthorization = response.code() == 407;
        Proxy proxy = route.proxy();
        int size = challenges.size();
        for (int i = 0; i < size; ++i) {
            PasswordAuthentication auth;
            Challenge challenge = (Challenge)challenges.get(i);
            if (!"Basic".equalsIgnoreCase(challenge.scheme())) continue;
            if (proxyAuthorization) {
                InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
                auth = java.net.Authenticator.requestPasswordAuthentication(proxyAddress.getHostName(), this.getConnectToInetAddress(proxy, url), proxyAddress.getPort(), url.scheme(), challenge.realm(), challenge.scheme(), url.url(), Authenticator.RequestorType.PROXY);
            } else {
                auth = java.net.Authenticator.requestPasswordAuthentication(url.host(), this.getConnectToInetAddress(proxy, url), url.port(), url.scheme(), challenge.realm(), challenge.scheme(), url.url(), Authenticator.RequestorType.SERVER);
            }
            if (auth == null) continue;
            String credential = Credentials.basic((String)auth.getUserName(), (String)new String(auth.getPassword()));
            return request.newBuilder().header(proxyAuthorization ? "Proxy-Authorization" : "Authorization", credential).build();
        }
        return null;
    }

    private InetAddress getConnectToInetAddress(Proxy proxy, HttpUrl url) throws IOException {
        return proxy != null && proxy.type() != Proxy.Type.DIRECT ? ((InetSocketAddress)proxy.address()).getAddress() : InetAddress.getByName(url.host());
    }
}

