/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.ConfigurationGroup;
import org.apache.ivy.core.module.descriptor.ConfigurationIntersection;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;
import org.apache.ivy.util.Checks;

public class DefaultDependencyDescriptor
implements DependencyDescriptor {
    private static final Pattern SELF_FALLBACK_PATTERN = Pattern.compile("@(\\+[^\\(]+)?(\\(.*\\))?");
    private static final Pattern THIS_FALLBACK_PATTERN = Pattern.compile("#(\\+[^\\(]+)?(\\(.*\\))?");
    private final ModuleRevisionId revId;
    private ModuleRevisionId dynamicRevId;
    private Map confs = new LinkedHashMap();
    private Map dependencyArtifacts;
    private Map includeRules;
    private Map excludeRules;
    private boolean isForce;
    private boolean isChanging;
    private ModuleRevisionId parentId;
    private boolean isTransitive = true;
    private Namespace namespace = null;
    private final ModuleDescriptor md;
    private DependencyDescriptor asSystem = this;
    private ModuleRevisionId sourceModule;
    private Map doesExcludeCache = new HashMap();

    public static DependencyDescriptor transformInstance(DependencyDescriptor dependencyDescriptor, Namespace namespace) {
        NamespaceTransformer namespaceTransformer = namespace.getToSystemTransformer();
        if (namespaceTransformer.isIdentity()) {
            return dependencyDescriptor;
        }
        DefaultDependencyDescriptor defaultDependencyDescriptor = DefaultDependencyDescriptor.transformInstance(dependencyDescriptor, namespaceTransformer, false);
        defaultDependencyDescriptor.namespace = namespace;
        return defaultDependencyDescriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultDependencyDescriptor transformInstance(DependencyDescriptor dependencyDescriptor, NamespaceTransformer namespaceTransformer, boolean bl) {
        String[] stringArray;
        ModuleRevisionId moduleRevisionId = namespaceTransformer.transform(dependencyDescriptor.getParentRevisionId());
        ModuleRevisionId moduleRevisionId2 = namespaceTransformer.transform(dependencyDescriptor.getDependencyRevisionId());
        ModuleRevisionId moduleRevisionId3 = namespaceTransformer.transform(dependencyDescriptor.getDynamicConstraintDependencyRevisionId());
        DefaultDependencyDescriptor defaultDependencyDescriptor = new DefaultDependencyDescriptor(null, moduleRevisionId2, moduleRevisionId3, dependencyDescriptor.isForce(), dependencyDescriptor.isChanging(), dependencyDescriptor.isTransitive());
        defaultDependencyDescriptor.parentId = moduleRevisionId;
        ModuleRevisionId moduleRevisionId4 = dependencyDescriptor.getSourceModule();
        if (moduleRevisionId4 != null) {
            defaultDependencyDescriptor.sourceModule = namespaceTransformer.transform(moduleRevisionId4);
        }
        if ((stringArray = dependencyDescriptor.getModuleConfigurations()).length == 1 && "*".equals(stringArray[0])) {
            if (!(dependencyDescriptor instanceof DefaultDependencyDescriptor)) throw new IllegalArgumentException("dependency descriptor transformation does not support * module confs with descriptors which aren't DefaultDependencyDescriptor");
            DefaultDependencyDescriptor defaultDependencyDescriptor2 = (DefaultDependencyDescriptor)dependencyDescriptor;
            defaultDependencyDescriptor.confs = new LinkedHashMap(defaultDependencyDescriptor2.confs);
            defaultDependencyDescriptor.setExcludeRules(new LinkedHashMap(defaultDependencyDescriptor2.getExcludeRules()));
            defaultDependencyDescriptor.setIncludeRules(new LinkedHashMap(defaultDependencyDescriptor2.getIncludeRules()));
            defaultDependencyDescriptor.setDependencyArtifacts(new LinkedHashMap(defaultDependencyDescriptor2.getDependencyArtifacts()));
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                defaultDependencyDescriptor.confs.put(stringArray[i], new ArrayList<String>(Arrays.asList(dependencyDescriptor.getDependencyConfigurations(stringArray[i]))));
                defaultDependencyDescriptor.getExcludeRules().put(stringArray[i], new ArrayList<ExcludeRule>(Arrays.asList(dependencyDescriptor.getExcludeRules(stringArray[i]))));
                defaultDependencyDescriptor.getIncludeRules().put(stringArray[i], new ArrayList<IncludeRule>(Arrays.asList(dependencyDescriptor.getIncludeRules(stringArray[i]))));
                defaultDependencyDescriptor.getDependencyArtifacts().put(stringArray[i], new ArrayList<DependencyArtifactDescriptor>(Arrays.asList(dependencyDescriptor.getDependencyArtifacts(stringArray[i]))));
            }
        }
        if (!bl) return defaultDependencyDescriptor;
        defaultDependencyDescriptor.asSystem = dependencyDescriptor;
        return defaultDependencyDescriptor;
    }

    private DefaultDependencyDescriptor(DefaultDependencyDescriptor defaultDependencyDescriptor, ModuleRevisionId moduleRevisionId) {
        Checks.checkNotNull(defaultDependencyDescriptor, "dd");
        Checks.checkNotNull(moduleRevisionId, "revision");
        if (!moduleRevisionId.getModuleId().equals(defaultDependencyDescriptor.getDependencyId())) {
            throw new IllegalArgumentException("new ModuleRevisionId MUST have the same ModuleId as original one. original = " + defaultDependencyDescriptor.getDependencyId() + " new = " + moduleRevisionId.getModuleId());
        }
        this.md = defaultDependencyDescriptor.md;
        this.parentId = defaultDependencyDescriptor.parentId;
        this.revId = moduleRevisionId;
        this.dynamicRevId = defaultDependencyDescriptor.dynamicRevId;
        this.isForce = defaultDependencyDescriptor.isForce;
        this.isChanging = defaultDependencyDescriptor.isChanging;
        this.isTransitive = defaultDependencyDescriptor.isTransitive;
        this.namespace = defaultDependencyDescriptor.namespace;
        this.confs.putAll(defaultDependencyDescriptor.confs);
        this.excludeRules = defaultDependencyDescriptor.excludeRules == null ? null : new LinkedHashMap(defaultDependencyDescriptor.excludeRules);
        this.includeRules = defaultDependencyDescriptor.includeRules == null ? null : new LinkedHashMap(defaultDependencyDescriptor.includeRules);
        this.dependencyArtifacts = defaultDependencyDescriptor.dependencyArtifacts == null ? null : new LinkedHashMap(defaultDependencyDescriptor.dependencyArtifacts);
        this.sourceModule = defaultDependencyDescriptor.sourceModule;
    }

    public DefaultDependencyDescriptor(ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId, boolean bl, boolean bl2, boolean bl3) {
        this(moduleDescriptor, moduleRevisionId, moduleRevisionId, bl, bl2, bl3);
    }

    public DefaultDependencyDescriptor(ModuleRevisionId moduleRevisionId, boolean bl) {
        this(moduleRevisionId, bl, false);
    }

    public DefaultDependencyDescriptor(ModuleRevisionId moduleRevisionId, boolean bl, boolean bl2) {
        this(null, moduleRevisionId, moduleRevisionId, bl, bl2, true);
    }

    public DefaultDependencyDescriptor(ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2, boolean bl, boolean bl2, boolean bl3) {
        Checks.checkNotNull(moduleRevisionId, "mrid");
        Checks.checkNotNull(moduleRevisionId2, "dynamicConstraint");
        this.md = moduleDescriptor;
        this.revId = moduleRevisionId;
        this.dynamicRevId = moduleRevisionId2;
        this.isForce = bl;
        this.isChanging = bl2;
        this.isTransitive = bl3;
        this.sourceModule = moduleDescriptor == null ? null : moduleDescriptor.getModuleRevisionId();
    }

    @Override
    public ModuleId getDependencyId() {
        return this.getDependencyRevisionId().getModuleId();
    }

    @Override
    public ModuleRevisionId getDependencyRevisionId() {
        return this.revId;
    }

    @Override
    public ModuleRevisionId getDynamicConstraintDependencyRevisionId() {
        return this.dynamicRevId;
    }

    @Override
    public String[] getModuleConfigurations() {
        return this.confs.keySet().toArray(new String[this.confs.keySet().size()]);
    }

    @Override
    public String[] getDependencyConfigurations(String string) {
        return this.getDependencyConfigurations(string, string);
    }

    @Override
    public String[] getDependencyConfigurations(String string, String string2) {
        Object object;
        if (this.md != null) {
            object = this.md.getConfiguration(string);
            if (object instanceof ConfigurationIntersection) {
                Collection collection;
                ConfigurationIntersection configurationIntersection = (ConfigurationIntersection)object;
                HashSet<String> hashSet = new HashSet<String>();
                String[] stringArray = configurationIntersection.getIntersectedConfigurationNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    collection = this.getDependencyConfigurationsIncludingExtending(stringArray[i], string2);
                    if (hashSet.isEmpty()) {
                        hashSet.addAll(collection);
                        continue;
                    }
                    if (hashSet.contains("*")) {
                        hashSet.remove("*");
                        hashSet.addAll(collection);
                        continue;
                    }
                    if (collection.contains("*")) continue;
                    HashSet<String> hashSet2 = hashSet;
                    hashSet = new HashSet();
                    Object object2 = hashSet2.iterator();
                    while (object2.hasNext()) {
                        String string3 = (String)object2.next();
                        if (!collection.contains(string3)) continue;
                        hashSet.add(string3);
                    }
                }
                List list = (List)this.confs.get(string);
                if (list != null) {
                    hashSet.addAll(list);
                }
                if (hashSet.isEmpty() && (collection = (List)this.confs.get("*")) != null) {
                    for (Object object2 : collection) {
                        if (object2 != null && ((String)object2).startsWith("@+")) {
                            return new String[]{string + ((String)object2).substring(1)};
                        }
                        if (object2 == null || !((String)object2).equals("@")) continue;
                        return new String[]{string};
                    }
                }
                return hashSet.toArray(new String[hashSet.size()]);
            }
            if (object instanceof ConfigurationGroup) {
                ConfigurationGroup configurationGroup = (ConfigurationGroup)object;
                HashSet hashSet = new HashSet();
                String[] stringArray = configurationGroup.getMembersConfigurationNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    Collection collection = this.getDependencyConfigurationsIncludingExtending(stringArray[i], string2);
                    hashSet.addAll(collection);
                }
                return hashSet.toArray(new String[hashSet.size()]);
            }
        }
        if ((object = (List)this.confs.get(string)) == null) {
            object = (List)this.confs.get("%");
        }
        List list = (List)this.confs.get("*");
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet();
        if (object != null) {
            linkedHashSet.addAll((Collection<Object>)object);
        }
        if (list != null) {
            linkedHashSet.addAll(list);
        }
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        for (Object object3 : linkedHashSet) {
            String string4 = DefaultDependencyDescriptor.replaceSelfFallbackPattern((String)object3, string);
            if (string4 == null) {
                string4 = DefaultDependencyDescriptor.replaceThisFallbackPattern((String)object3, string2);
            }
            if (string4 != null) {
                object3 = string4;
            }
            linkedHashSet2.add((String)object3);
        }
        linkedHashSet = linkedHashSet2;
        if (linkedHashSet.remove("*")) {
            StringBuffer stringBuffer = new StringBuffer("*");
            for (String string4 : linkedHashSet) {
                if (!string4.startsWith("!")) continue;
                stringBuffer.append(string4);
            }
            return new String[]{stringBuffer.toString()};
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private Collection getDependencyConfigurationsIncludingExtending(String string, String string2) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(Arrays.asList(this.getDependencyConfigurations(string, string2)));
        Collection collection = Configuration.findConfigurationExtending(string, this.md.getConfigurations());
        for (Configuration configuration : collection) {
            linkedHashSet.addAll(Arrays.asList(this.getDependencyConfigurations(configuration.getName(), string2)));
        }
        return linkedHashSet;
    }

    protected static String replaceSelfFallbackPattern(String string, String string2) {
        return DefaultDependencyDescriptor.replaceFallbackConfigurationPattern(SELF_FALLBACK_PATTERN, string, string2);
    }

    protected static String replaceThisFallbackPattern(String string, String string2) {
        return DefaultDependencyDescriptor.replaceFallbackConfigurationPattern(THIS_FALLBACK_PATTERN, string, string2);
    }

    protected static String replaceFallbackConfigurationPattern(Pattern pattern, String string, String string2) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            String string3 = string2;
            if (matcher.group(1) != null) {
                string3 = string3 + matcher.group(1);
            }
            if (matcher.group(2) != null) {
                string3 = string3 + matcher.group(2);
            }
            return string3;
        }
        return null;
    }

    @Override
    public String[] getDependencyConfigurations(String[] stringArray) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            linkedHashSet.addAll(Arrays.asList(this.getDependencyConfigurations(stringArray[i])));
        }
        if (linkedHashSet.contains("*")) {
            return new String[]{"*"};
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    @Override
    public DependencyArtifactDescriptor[] getDependencyArtifacts(String string) {
        Set set = this.getCollectionForConfiguration(string, this.dependencyArtifacts);
        return set.toArray(new DependencyArtifactDescriptor[set.size()]);
    }

    @Override
    public IncludeRule[] getIncludeRules(String string) {
        Set set = this.getCollectionForConfiguration(string, this.includeRules);
        return set.toArray(new IncludeRule[set.size()]);
    }

    @Override
    public ExcludeRule[] getExcludeRules(String string) {
        Set set = this.getCollectionForConfiguration(string, this.excludeRules);
        return set.toArray(new ExcludeRule[set.size()]);
    }

    private Set getCollectionForConfiguration(String string, Map map) {
        if (map == null || map.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Collection collection = (Collection)map.get(string);
        Collection collection2 = (Collection)map.get("*");
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        if (collection != null) {
            linkedHashSet.addAll(collection);
        }
        if (collection2 != null) {
            linkedHashSet.addAll(collection2);
        }
        return linkedHashSet;
    }

    @Override
    public DependencyArtifactDescriptor[] getDependencyArtifacts(String[] stringArray) {
        LinkedHashSet<DependencyArtifactDescriptor> linkedHashSet = new LinkedHashSet<DependencyArtifactDescriptor>();
        for (int i = 0; i < stringArray.length; ++i) {
            linkedHashSet.addAll(Arrays.asList(this.getDependencyArtifacts(stringArray[i])));
        }
        return linkedHashSet.toArray(new DependencyArtifactDescriptor[linkedHashSet.size()]);
    }

    @Override
    public IncludeRule[] getIncludeRules(String[] stringArray) {
        LinkedHashSet<IncludeRule> linkedHashSet = new LinkedHashSet<IncludeRule>();
        for (int i = 0; i < stringArray.length; ++i) {
            linkedHashSet.addAll(Arrays.asList(this.getIncludeRules(stringArray[i])));
        }
        return linkedHashSet.toArray(new IncludeRule[linkedHashSet.size()]);
    }

    @Override
    public ExcludeRule[] getExcludeRules(String[] stringArray) {
        LinkedHashSet<ExcludeRule> linkedHashSet = new LinkedHashSet<ExcludeRule>();
        for (int i = 0; i < stringArray.length; ++i) {
            linkedHashSet.addAll(Arrays.asList(this.getExcludeRules(stringArray[i])));
        }
        return linkedHashSet.toArray(new ExcludeRule[linkedHashSet.size()]);
    }

    @Override
    public DependencyArtifactDescriptor[] getAllDependencyArtifacts() {
        if (this.dependencyArtifacts == null) {
            return new DependencyArtifactDescriptor[0];
        }
        Set set = this.mergeAll(this.dependencyArtifacts);
        return set.toArray(new DependencyArtifactDescriptor[set.size()]);
    }

    @Override
    public IncludeRule[] getAllIncludeRules() {
        if (this.includeRules == null) {
            return new IncludeRule[0];
        }
        Set set = this.mergeAll(this.includeRules);
        return set.toArray(new IncludeRule[set.size()]);
    }

    @Override
    public ExcludeRule[] getAllExcludeRules() {
        if (this.excludeRules == null) {
            return new ExcludeRule[0];
        }
        Set set = this.mergeAll(this.excludeRules);
        return set.toArray(new ExcludeRule[set.size()]);
    }

    private Set mergeAll(Map map) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Collection collection : map.values()) {
            linkedHashSet.addAll(collection);
        }
        return linkedHashSet;
    }

    public void addDependencyConfiguration(String string, String string2) {
        Object object;
        if (this.md != null && !"*".equals(string) && !"%".equals(string)) {
            object = string.startsWith("!") ? this.md.getConfiguration(string.substring(1)) : this.md.getConfiguration(string);
            if (object == null) {
                throw new IllegalArgumentException("Cannot add dependency '" + this.revId + "' to configuration '" + string + "' of module " + this.md.getModuleRevisionId() + " because this configuration doesn't exist!");
            }
            if (object instanceof ConfigurationGroup) {
                ConfigurationGroup configurationGroup = (ConfigurationGroup)object;
                String[] stringArray = configurationGroup.getMembersConfigurationNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addDependencyConfiguration(stringArray[i], string2);
                }
                return;
            }
        }
        if ((object = (ArrayList<String>)this.confs.get(string)) == null) {
            object = new ArrayList<String>();
            this.confs.put(string, object);
        }
        if (!object.contains(string2)) {
            object.add(string2);
        }
    }

    public void addDependencyArtifact(String string, DependencyArtifactDescriptor dependencyArtifactDescriptor) {
        this.addObjectToConfiguration(string, dependencyArtifactDescriptor, this.getDependencyArtifacts());
    }

    public void addIncludeRule(String string, IncludeRule includeRule) {
        this.addObjectToConfiguration(string, includeRule, this.getIncludeRules());
    }

    public void addExcludeRule(String string, ExcludeRule excludeRule) {
        this.doesExcludeCache.clear();
        this.addObjectToConfiguration(string, excludeRule, this.getExcludeRules());
    }

    private void addObjectToConfiguration(String string, Object object, Map map) {
        ArrayList<Object> arrayList = (ArrayList<Object>)map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
            map.put(string, arrayList);
        }
        arrayList.add(object);
    }

    private boolean doDoesExclude(String[] stringArray, ArtifactId artifactId) {
        ExcludeRule[] excludeRuleArray = this.getExcludeRules(stringArray);
        for (int i = 0; i < excludeRuleArray.length; ++i) {
            if (!MatcherHelper.matches(excludeRuleArray[i].getMatcher(), excludeRuleArray[i].getId(), artifactId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean doesExclude(String[] stringArray, ArtifactId artifactId) {
        String string;
        Boolean bl;
        if (this.namespace != null) {
            artifactId = NameSpaceHelper.transform(artifactId, this.namespace.getFromSystemTransformer());
        }
        if ((bl = (Boolean)this.doesExcludeCache.get(string = Arrays.toString(stringArray) + ":" + artifactId.toString())) == null) {
            bl = this.doDoesExclude(stringArray, artifactId);
            this.doesExcludeCache.put(string, bl);
        }
        return bl;
    }

    @Override
    public boolean canExclude() {
        return this.excludeRules != null && !this.excludeRules.isEmpty();
    }

    public String toString() {
        return "dependency: " + this.revId + " " + this.confs;
    }

    @Override
    public boolean isForce() {
        return this.isForce;
    }

    @Override
    public ModuleRevisionId getParentRevisionId() {
        return this.md != null ? this.md.getResolvedModuleRevisionId() : this.parentId;
    }

    @Override
    public boolean isChanging() {
        return this.isChanging;
    }

    @Override
    public boolean isTransitive() {
        return this.isTransitive;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public String getAttribute(String string) {
        return this.revId.getAttribute(string);
    }

    @Override
    public Map getAttributes() {
        return this.revId.getAttributes();
    }

    @Override
    public String getExtraAttribute(String string) {
        return this.revId.getExtraAttribute(string);
    }

    @Override
    public Map getExtraAttributes() {
        return this.revId.getExtraAttributes();
    }

    @Override
    public Map getQualifiedExtraAttributes() {
        return this.revId.getQualifiedExtraAttributes();
    }

    @Override
    public DependencyDescriptor asSystem() {
        return this.asSystem;
    }

    private void setDependencyArtifacts(Map map) {
        this.dependencyArtifacts = map;
    }

    private Map getDependencyArtifacts() {
        if (this.dependencyArtifacts == null) {
            this.dependencyArtifacts = new LinkedHashMap();
        }
        return this.dependencyArtifacts;
    }

    private void setIncludeRules(Map map) {
        this.includeRules = map;
    }

    private Map getIncludeRules() {
        if (this.includeRules == null) {
            this.includeRules = new LinkedHashMap();
        }
        return this.includeRules;
    }

    private void setExcludeRules(Map map) {
        this.doesExcludeCache.clear();
        this.excludeRules = map;
    }

    private Map getExcludeRules() {
        if (this.excludeRules == null) {
            this.excludeRules = new LinkedHashMap();
        }
        return this.excludeRules;
    }

    @Override
    public ModuleRevisionId getSourceModule() {
        return this.sourceModule;
    }

    @Override
    public DependencyDescriptor clone(ModuleRevisionId moduleRevisionId) {
        return new DefaultDependencyDescriptor(this, moduleRevisionId);
    }
}

