/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveData;

public class IvyNodeCallers {
    private Map callersByRootConf = new HashMap();
    private Map allCallers = new HashMap();
    private IvyNode node;

    public IvyNodeCallers(IvyNode ivyNode) {
        this.node = ivyNode;
    }

    public void addCaller(String string, IvyNode ivyNode, String string2, String string3, String[] stringArray, DependencyDescriptor dependencyDescriptor) {
        Caller caller;
        ModuleDescriptor moduleDescriptor = ivyNode.getDescriptor();
        ModuleRevisionId moduleRevisionId = ivyNode.getResolvedId();
        if (moduleRevisionId.getModuleId().equals(this.node.getId().getModuleId())) {
            throw new IllegalArgumentException("a module is not authorized to depend on itself: " + this.node.getId());
        }
        HashMap<ModuleRevisionId, Caller> hashMap = (HashMap<ModuleRevisionId, Caller>)this.callersByRootConf.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<ModuleRevisionId, Caller>();
            this.callersByRootConf.put(string, hashMap);
        }
        if ((caller = (Caller)hashMap.get(moduleRevisionId)) == null) {
            caller = new Caller(moduleDescriptor, moduleRevisionId, dependencyDescriptor, ivyNode.canExclude(string));
            hashMap.put(moduleRevisionId, caller);
        }
        caller.addConfiguration(string3, stringArray);
        IvyNode ivyNode2 = ivyNode.getRealNode();
        for (ModuleId moduleId : ivyNode2.getAllCallersModuleIds()) {
            this.allCallers.put(moduleId, ivyNode2);
        }
        this.allCallers.put(moduleRevisionId.getModuleId(), ivyNode);
    }

    void removeCaller(String string, ModuleRevisionId moduleRevisionId) {
        this.allCallers.remove(moduleRevisionId.getModuleId());
        Map map = (Map)this.callersByRootConf.get(string);
        if (map != null) {
            map.remove(moduleRevisionId);
        }
    }

    public Caller[] getCallers(String string) {
        Map map = (Map)this.callersByRootConf.get(string);
        if (map == null) {
            return new Caller[0];
        }
        return map.values().toArray(new Caller[map.values().size()]);
    }

    public Caller[] getAllCallers() {
        HashSet hashSet = new HashSet();
        for (Map map : this.callersByRootConf.values()) {
            hashSet.addAll(map.values());
        }
        return hashSet.toArray(new Caller[hashSet.size()]);
    }

    public Caller[] getAllRealCallers() {
        HashSet<Caller> hashSet = new HashSet<Caller>();
        for (Map map : this.callersByRootConf.values()) {
            for (Caller caller : map.values()) {
                if (!caller.isRealCaller()) continue;
                hashSet.add(caller);
            }
        }
        return hashSet.toArray(new Caller[hashSet.size()]);
    }

    public Collection getAllCallersModuleIds() {
        return this.allCallers.keySet();
    }

    void updateFrom(IvyNodeCallers ivyNodeCallers, String string, boolean bl) {
        Map map = (Map)ivyNodeCallers.callersByRootConf.get(string);
        if (map != null) {
            HashMap<ModuleRevisionId, Caller> hashMap = (HashMap<ModuleRevisionId, Caller>)this.callersByRootConf.get(string);
            if (hashMap == null) {
                hashMap = new HashMap<ModuleRevisionId, Caller>();
                this.callersByRootConf.put(string, hashMap);
            }
            for (Caller caller : map.values()) {
                if (hashMap.containsKey(caller.getModuleRevisionId())) continue;
                if (!bl) {
                    caller.setRealCaller(false);
                }
                hashMap.put(caller.getModuleRevisionId(), caller);
            }
        }
    }

    public IvyNode getDirectCallerFor(ModuleId moduleId) {
        return (IvyNode)this.allCallers.get(moduleId);
    }

    boolean doesCallersExclude(String string, Artifact artifact) {
        return this.doesCallersExclude(string, artifact, new Stack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doesCallersExclude(String string, Artifact artifact, Stack stack) {
        stack.push(this.node.getId());
        try {
            int n;
            Caller[] callerArray = this.getCallers(string);
            if (callerArray.length == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            for (n = 0; n < callerArray.length; ++n) {
                if (!callerArray[n].canExclude()) {
                    boolean bl2 = false;
                    return bl2;
                }
                ModuleDescriptor moduleDescriptor = callerArray[n].getModuleDescriptor();
                Boolean bl3 = this.node.doesExclude(moduleDescriptor, string, callerArray[n].getCallerConfigurations(), callerArray[n].getDependencyDescriptor(), artifact, stack);
                if (bl3 == null) continue;
                if (!bl3.booleanValue()) {
                    boolean bl4 = false;
                    return bl4;
                }
                bl = false;
            }
            n = bl ? 0 : 1;
            return n != 0;
        }
        finally {
            stack.pop();
        }
    }

    public static class Caller {
        private ModuleDescriptor md;
        private ModuleRevisionId mrid;
        private Map confs = new HashMap();
        private DependencyDescriptor dd;
        private boolean callerCanExclude;
        private boolean real = true;

        public Caller(ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId, DependencyDescriptor dependencyDescriptor, boolean bl) {
            this.md = moduleDescriptor;
            this.mrid = moduleRevisionId;
            this.dd = dependencyDescriptor;
            this.callerCanExclude = bl;
        }

        public void addConfiguration(String string, String[] stringArray) {
            String[] stringArray2;
            this.updateConfs(string, stringArray);
            Configuration configuration = this.md.getConfiguration(string);
            if (configuration != null && (stringArray2 = configuration.getExtends()) != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    this.addConfiguration(stringArray2[i], stringArray);
                }
            }
        }

        private void updateConfs(String string, String[] stringArray) {
            String[] stringArray2 = (String[])this.confs.get(string);
            if (stringArray2 != null) {
                HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray2));
                hashSet.addAll(Arrays.asList(stringArray));
                this.confs.put(string, hashSet.toArray(new String[hashSet.size()]));
            } else {
                this.confs.put(string, stringArray);
            }
        }

        public String[] getCallerConfigurations() {
            return this.confs.keySet().toArray(new String[this.confs.keySet().size()]);
        }

        public ModuleRevisionId getModuleRevisionId() {
            return this.mrid;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Caller)) {
                return false;
            }
            Caller caller = (Caller)object;
            return caller.confs.equals(this.confs) && this.mrid.equals(caller.mrid);
        }

        public int hashCode() {
            int n = 31;
            n = n * 13 + this.confs.hashCode();
            n = n * 13 + this.mrid.hashCode();
            return n;
        }

        public String toString() {
            return this.mrid.toString();
        }

        public ModuleRevisionId getAskedDependencyId(ResolveData resolveData) {
            return this.dd.getDependencyRevisionId();
        }

        public ModuleDescriptor getModuleDescriptor() {
            return this.md;
        }

        public boolean canExclude() {
            return this.callerCanExclude || this.md.canExclude() || this.dd.canExclude();
        }

        public DependencyDescriptor getDependencyDescriptor() {
            return this.dd;
        }

        public void setRealCaller(boolean bl) {
            this.real = bl;
        }

        public boolean isRealCaller() {
            return this.real;
        }
    }
}

