/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dht;

import edu.emory.mathcs.jtransforms.dht.FloatDHT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class FloatDHT_2D {
    private int n1;
    private int n2;
    private int[] ip;
    private float[] w;
    private float[] t;
    private FloatDHT_1D dhtn2;
    private FloatDHT_1D dhtn1;
    private int oldNthread;
    private int nt;

    public FloatDHT_2D(int n, int n2) {
        if (!ConcurrencyUtils.isPowerOf2(n) || !ConcurrencyUtils.isPowerOf2(n2)) {
            throw new IllegalArgumentException("n1, n2 must be power of two numbers");
        }
        if (n <= 1 || n2 <= 1) {
            throw new IllegalArgumentException("n1, n2 must be greater than 1");
        }
        this.n1 = n;
        this.n2 = n2;
        this.ip = new int[2 + (int)Math.ceil(Math.sqrt(Math.max(n / 2, n2 / 2)))];
        this.w = new float[(int)Math.ceil(Math.max((double)n * 1.5, (double)n2 * 1.5))];
        this.dhtn2 = new FloatDHT_1D(n2, this.ip, this.w);
        this.dhtn1 = new FloatDHT_1D(n, this.ip, this.w);
        this.oldNthread = ConcurrencyUtils.getNumberOfProcessors();
        this.nt = 4 * this.oldNthread * n;
        if (n2 == 2 * this.oldNthread) {
            this.nt >>= 1;
        } else if (n2 < 2 * this.oldNthread) {
            this.nt >>= 2;
        }
        this.t = new float[this.nt];
    }

    public void forward(float[] fArray) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (n4 > (n2 = this.ip[1])) {
            n2 = n4;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 4 * n * this.n1;
            if (this.n2 == 2 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 2 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.ddxt2d_subth(-1, fArray, true);
            this.ddxt2d0_subth(-1, fArray, true);
        } else {
            this.ddxt2d_sub(-1, fArray, true);
            for (int i = 0; i < this.n1; ++i) {
                this.dhtn2.forward(fArray, i * this.n2);
            }
        }
        this.y_transform(fArray);
    }

    public void forward(float[][] fArray) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (n4 > (n2 = this.ip[1])) {
            n2 = n4;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 4 * n * this.n1;
            if (this.n2 == 2 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 2 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.ddxt2d_subth(-1, fArray, true);
            this.ddxt2d0_subth(-1, fArray, true);
        } else {
            this.ddxt2d_sub(-1, fArray, true);
            for (int i = 0; i < this.n1; ++i) {
                this.dhtn2.forward(fArray[i]);
            }
        }
        this.y_transform(fArray);
    }

    public void inverse(float[] fArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (n4 > (n2 = this.ip[1])) {
            n2 = n4;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 4 * n * this.n1;
            if (this.n2 == 2 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 2 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.ddxt2d_subth(1, fArray, bl);
            this.ddxt2d0_subth(1, fArray, bl);
        } else {
            this.ddxt2d_sub(1, fArray, bl);
            for (int i = 0; i < this.n1; ++i) {
                this.dhtn2.inverse(fArray, i * this.n2, bl);
            }
        }
        this.y_transform(fArray);
    }

    public void inverse(float[][] fArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (n4 > (n2 = this.ip[1])) {
            n2 = n4;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 4 * n * this.n1;
            if (this.n2 == 2 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 2 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.ddxt2d_subth(1, fArray, bl);
            this.ddxt2d0_subth(1, fArray, bl);
        } else {
            this.ddxt2d_sub(1, fArray, bl);
            for (int i = 0; i < this.n1; ++i) {
                this.dhtn2.inverse(fArray[i], bl);
            }
        }
        this.y_transform(fArray);
    }

    private void ddxt2d_subth(final int n, final float[] fArray, final boolean bl) {
        int n2;
        int n3;
        int n4 = n3 = ConcurrencyUtils.getNumberOfProcessors();
        int n5 = 4 * this.n1;
        if (this.n2 == 2 * n3) {
            n5 >>= 1;
        } else if (this.n2 < 2 * n3) {
            n4 = this.n2;
            n5 >>= 2;
        }
        final int n6 = n4;
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            n2 = i;
            final int n7 = n5 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    block17: {
                        int n11;
                        block18: {
                            int n22;
                            int n3;
                            int n4;
                            block16: {
                                if (FloatDHT_2D.this.n2 <= 2 * n6) break block16;
                                if (n == -1) {
                                    for (int i = 4 * n2; i < FloatDHT_2D.this.n2; i += 4 * n6) {
                                        int n5;
                                        int n62;
                                        int n72;
                                        for (n72 = 0; n72 < FloatDHT_2D.this.n1; ++n72) {
                                            n62 = n72 * FloatDHT_2D.this.n2 + i;
                                            n5 = n7 + FloatDHT_2D.this.n1 + n72;
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n7 + n72] = fArray[n62];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n5] = fArray[n62 + 1];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n5 + ((FloatDHT_2D)FloatDHT_2D.this).n1] = fArray[n62 + 2];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n5 + 2 * ((FloatDHT_2D)FloatDHT_2D.this).n1] = fArray[n62 + 3];
                                        }
                                        FloatDHT_2D.this.dhtn1.forward(FloatDHT_2D.this.t, n7);
                                        FloatDHT_2D.this.dhtn1.forward(FloatDHT_2D.this.t, n7 + FloatDHT_2D.this.n1);
                                        FloatDHT_2D.this.dhtn1.forward(FloatDHT_2D.this.t, n7 + 2 * FloatDHT_2D.this.n1);
                                        FloatDHT_2D.this.dhtn1.forward(FloatDHT_2D.this.t, n7 + 3 * FloatDHT_2D.this.n1);
                                        for (n72 = 0; n72 < FloatDHT_2D.this.n1; ++n72) {
                                            n62 = n72 * FloatDHT_2D.this.n2 + i;
                                            n5 = n7 + FloatDHT_2D.this.n1 + n72;
                                            fArray[n62] = FloatDHT_2D.this.t[n7 + n72];
                                            fArray[n62 + 1] = FloatDHT_2D.this.t[n5];
                                            fArray[n62 + 2] = FloatDHT_2D.this.t[n5 + FloatDHT_2D.this.n1];
                                            fArray[n62 + 3] = FloatDHT_2D.this.t[n5 + 2 * FloatDHT_2D.this.n1];
                                        }
                                    }
                                } else {
                                    for (int i = 4 * n2; i < FloatDHT_2D.this.n2; i += 4 * n6) {
                                        int n8;
                                        int n9;
                                        int n10;
                                        for (n10 = 0; n10 < FloatDHT_2D.this.n1; ++n10) {
                                            n9 = n10 * FloatDHT_2D.this.n2 + i;
                                            n8 = n7 + FloatDHT_2D.this.n1 + n10;
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n7 + n10] = fArray[n9];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n8] = fArray[n9 + 1];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n8 + ((FloatDHT_2D)FloatDHT_2D.this).n1] = fArray[n9 + 2];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n8 + 2 * ((FloatDHT_2D)FloatDHT_2D.this).n1] = fArray[n9 + 3];
                                        }
                                        FloatDHT_2D.this.dhtn1.inverse(FloatDHT_2D.this.t, n7, bl);
                                        FloatDHT_2D.this.dhtn1.inverse(FloatDHT_2D.this.t, n7 + FloatDHT_2D.this.n1, bl);
                                        FloatDHT_2D.this.dhtn1.inverse(FloatDHT_2D.this.t, n7 + 2 * FloatDHT_2D.this.n1, bl);
                                        FloatDHT_2D.this.dhtn1.inverse(FloatDHT_2D.this.t, n7 + 3 * FloatDHT_2D.this.n1, bl);
                                        for (n10 = 0; n10 < FloatDHT_2D.this.n1; ++n10) {
                                            n9 = n10 * FloatDHT_2D.this.n2 + i;
                                            n8 = n7 + FloatDHT_2D.this.n1 + n10;
                                            fArray[n9] = FloatDHT_2D.this.t[n7 + n10];
                                            fArray[n9 + 1] = FloatDHT_2D.this.t[n8];
                                            fArray[n9 + 2] = FloatDHT_2D.this.t[n8 + FloatDHT_2D.this.n1];
                                            fArray[n9 + 3] = FloatDHT_2D.this.t[n8 + 2 * FloatDHT_2D.this.n1];
                                        }
                                    }
                                }
                                break block17;
                            }
                            if (FloatDHT_2D.this.n2 != 2 * n6) break block18;
                            for (n4 = 0; n4 < FloatDHT_2D.this.n1; ++n4) {
                                n3 = n4 * FloatDHT_2D.this.n2 + 2 * n2;
                                n22 = n7 + n4;
                                ((FloatDHT_2D)FloatDHT_2D.this).t[n22] = fArray[n3];
                                ((FloatDHT_2D)FloatDHT_2D.this).t[n22 + ((FloatDHT_2D)FloatDHT_2D.this).n1] = fArray[n3 + 1];
                            }
                            if (n == -1) {
                                FloatDHT_2D.this.dhtn1.forward(FloatDHT_2D.this.t, n7);
                                FloatDHT_2D.this.dhtn1.forward(FloatDHT_2D.this.t, n7 + FloatDHT_2D.this.n1);
                            } else {
                                FloatDHT_2D.this.dhtn1.inverse(FloatDHT_2D.this.t, n7, bl);
                                FloatDHT_2D.this.dhtn1.inverse(FloatDHT_2D.this.t, n7 + FloatDHT_2D.this.n1, bl);
                            }
                            for (n4 = 0; n4 < FloatDHT_2D.this.n1; ++n4) {
                                n3 = n4 * FloatDHT_2D.this.n2 + 2 * n2;
                                n22 = n7 + n4;
                                fArray[n3] = FloatDHT_2D.this.t[n22];
                                fArray[n3 + 1] = FloatDHT_2D.this.t[n22 + FloatDHT_2D.this.n1];
                            }
                            break block17;
                        }
                        if (FloatDHT_2D.this.n2 != n6) break block17;
                        for (n11 = 0; n11 < FloatDHT_2D.this.n1; ++n11) {
                            ((FloatDHT_2D)FloatDHT_2D.this).t[n7 + n11] = fArray[n11 * FloatDHT_2D.this.n2 + n2];
                        }
                        if (n == -1) {
                            FloatDHT_2D.this.dhtn1.forward(FloatDHT_2D.this.t, n7);
                        } else {
                            FloatDHT_2D.this.dhtn1.inverse(FloatDHT_2D.this.t, n7, bl);
                        }
                        for (n11 = 0; n11 < FloatDHT_2D.this.n1; ++n11) {
                            fArray[n11 * ((FloatDHT_2D)FloatDHT_2D.this).n2 + n2] = FloatDHT_2D.this.t[n7 + n11];
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n4; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void ddxt2d_subth(final int n, final float[][] fArray, final boolean bl) {
        int n2;
        int n3;
        int n4 = n3 = ConcurrencyUtils.getNumberOfProcessors();
        int n5 = 4 * this.n1;
        if (this.n2 == 2 * n3) {
            n5 >>= 1;
        } else if (this.n2 < 2 * n3) {
            n4 = this.n2;
            n5 >>= 2;
        }
        final int n6 = n4;
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            n2 = i;
            final int n7 = n5 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    block17: {
                        int n8;
                        block18: {
                            int n22;
                            int n3;
                            block16: {
                                if (FloatDHT_2D.this.n2 <= 2 * n6) break block16;
                                if (n == -1) {
                                    for (int i = 4 * n2; i < FloatDHT_2D.this.n2; i += 4 * n6) {
                                        int n4;
                                        int n5;
                                        for (n5 = 0; n5 < FloatDHT_2D.this.n1; ++n5) {
                                            n4 = n7 + FloatDHT_2D.this.n1 + n5;
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n7 + n5] = fArray[n5][i];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n4] = fArray[n5][i + 1];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n4 + ((FloatDHT_2D)FloatDHT_2D.this).n1] = fArray[n5][i + 2];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n4 + 2 * ((FloatDHT_2D)FloatDHT_2D.this).n1] = fArray[n5][i + 3];
                                        }
                                        FloatDHT_2D.this.dhtn1.forward(FloatDHT_2D.this.t, n7);
                                        FloatDHT_2D.this.dhtn1.forward(FloatDHT_2D.this.t, n7 + FloatDHT_2D.this.n1);
                                        FloatDHT_2D.this.dhtn1.forward(FloatDHT_2D.this.t, n7 + 2 * FloatDHT_2D.this.n1);
                                        FloatDHT_2D.this.dhtn1.forward(FloatDHT_2D.this.t, n7 + 3 * FloatDHT_2D.this.n1);
                                        for (n5 = 0; n5 < FloatDHT_2D.this.n1; ++n5) {
                                            n4 = n7 + FloatDHT_2D.this.n1 + n5;
                                            fArray[n5][i] = FloatDHT_2D.this.t[n7 + n5];
                                            fArray[n5][i + 1] = FloatDHT_2D.this.t[n4];
                                            fArray[n5][i + 2] = FloatDHT_2D.this.t[n4 + FloatDHT_2D.this.n1];
                                            fArray[n5][i + 3] = FloatDHT_2D.this.t[n4 + 2 * FloatDHT_2D.this.n1];
                                        }
                                    }
                                } else {
                                    for (int i = 4 * n2; i < FloatDHT_2D.this.n2; i += 4 * n6) {
                                        int n62;
                                        int n72;
                                        for (n72 = 0; n72 < FloatDHT_2D.this.n1; ++n72) {
                                            n62 = n7 + FloatDHT_2D.this.n1 + n72;
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n7 + n72] = fArray[n72][i];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n62] = fArray[n72][i + 1];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n62 + ((FloatDHT_2D)FloatDHT_2D.this).n1] = fArray[n72][i + 2];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n62 + 2 * ((FloatDHT_2D)FloatDHT_2D.this).n1] = fArray[n72][i + 3];
                                        }
                                        FloatDHT_2D.this.dhtn1.inverse(FloatDHT_2D.this.t, n7, bl);
                                        FloatDHT_2D.this.dhtn1.inverse(FloatDHT_2D.this.t, n7 + FloatDHT_2D.this.n1, bl);
                                        FloatDHT_2D.this.dhtn1.inverse(FloatDHT_2D.this.t, n7 + 2 * FloatDHT_2D.this.n1, bl);
                                        FloatDHT_2D.this.dhtn1.inverse(FloatDHT_2D.this.t, n7 + 3 * FloatDHT_2D.this.n1, bl);
                                        for (n72 = 0; n72 < FloatDHT_2D.this.n1; ++n72) {
                                            n62 = n7 + FloatDHT_2D.this.n1 + n72;
                                            fArray[n72][i] = FloatDHT_2D.this.t[n7 + n72];
                                            fArray[n72][i + 1] = FloatDHT_2D.this.t[n62];
                                            fArray[n72][i + 2] = FloatDHT_2D.this.t[n62 + FloatDHT_2D.this.n1];
                                            fArray[n72][i + 3] = FloatDHT_2D.this.t[n62 + 2 * FloatDHT_2D.this.n1];
                                        }
                                    }
                                }
                                break block17;
                            }
                            if (FloatDHT_2D.this.n2 != 2 * n6) break block18;
                            for (n3 = 0; n3 < FloatDHT_2D.this.n1; ++n3) {
                                n22 = n7 + n3;
                                ((FloatDHT_2D)FloatDHT_2D.this).t[n22] = fArray[n3][2 * n2];
                                ((FloatDHT_2D)FloatDHT_2D.this).t[n22 + ((FloatDHT_2D)FloatDHT_2D.this).n1] = fArray[n3][2 * n2 + 1];
                            }
                            if (n == -1) {
                                FloatDHT_2D.this.dhtn1.forward(FloatDHT_2D.this.t, n7);
                                FloatDHT_2D.this.dhtn1.forward(FloatDHT_2D.this.t, n7 + FloatDHT_2D.this.n1);
                            } else {
                                FloatDHT_2D.this.dhtn1.inverse(FloatDHT_2D.this.t, n7, bl);
                                FloatDHT_2D.this.dhtn1.inverse(FloatDHT_2D.this.t, n7 + FloatDHT_2D.this.n1, bl);
                            }
                            for (n3 = 0; n3 < FloatDHT_2D.this.n1; ++n3) {
                                n22 = n7 + n3;
                                fArray[n3][2 * n2] = FloatDHT_2D.this.t[n22];
                                fArray[n3][2 * n2 + 1] = FloatDHT_2D.this.t[n22 + FloatDHT_2D.this.n1];
                            }
                            break block17;
                        }
                        if (FloatDHT_2D.this.n2 != n6) break block17;
                        for (n8 = 0; n8 < FloatDHT_2D.this.n1; ++n8) {
                            ((FloatDHT_2D)FloatDHT_2D.this).t[n7 + n8] = fArray[n8][n2];
                        }
                        if (n == -1) {
                            FloatDHT_2D.this.dhtn1.forward(FloatDHT_2D.this.t, n7);
                        } else {
                            FloatDHT_2D.this.dhtn1.inverse(FloatDHT_2D.this.t, n7, bl);
                        }
                        for (n8 = 0; n8 < FloatDHT_2D.this.n1; ++n8) {
                            fArray[n8][n2] = FloatDHT_2D.this.t[n7 + n8];
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n4; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void ddxt2d0_subth(final int n, final float[] fArray, final boolean bl) {
        int n2;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        final int n4 = n3 > this.n1 ? this.n1 : n3;
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            n2 = i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n == -1) {
                        for (int i = n2; i < FloatDHT_2D.this.n1; i += n4) {
                            FloatDHT_2D.this.dhtn2.forward(fArray, i * FloatDHT_2D.this.n2);
                        }
                    } else {
                        for (int i = n2; i < FloatDHT_2D.this.n1; i += n4) {
                            FloatDHT_2D.this.dhtn2.inverse(fArray, i * FloatDHT_2D.this.n2, bl);
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n4; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void ddxt2d0_subth(final int n, final float[][] fArray, final boolean bl) {
        int n2;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        final int n4 = n3 > this.n1 ? this.n1 : n3;
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            n2 = i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n == -1) {
                        for (int i = n2; i < FloatDHT_2D.this.n1; i += n4) {
                            FloatDHT_2D.this.dhtn2.forward(fArray[i]);
                        }
                    } else {
                        for (int i = n2; i < FloatDHT_2D.this.n1; i += n4) {
                            FloatDHT_2D.this.dhtn2.inverse(fArray[i], bl);
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n4; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void ddxt2d_sub(int n, float[] fArray, boolean bl) {
        block13: {
            int n2;
            int n3;
            block12: {
                if (this.n2 <= 2) break block12;
                if (n == -1) {
                    for (int i = 0; i < this.n2; i += 4) {
                        int n4;
                        int n5;
                        int n6;
                        for (n6 = 0; n6 < this.n1; ++n6) {
                            n5 = n6 * this.n2 + i;
                            n4 = this.n1 + n6;
                            this.t[n6] = fArray[n5];
                            this.t[n4] = fArray[n5 + 1];
                            this.t[n4 + this.n1] = fArray[n5 + 2];
                            this.t[n4 + 2 * this.n1] = fArray[n5 + 3];
                        }
                        this.dhtn1.forward(this.t, 0);
                        this.dhtn1.forward(this.t, this.n1);
                        this.dhtn1.forward(this.t, 2 * this.n1);
                        this.dhtn1.forward(this.t, 3 * this.n1);
                        for (n6 = 0; n6 < this.n1; ++n6) {
                            n5 = n6 * this.n2 + i;
                            n4 = this.n1 + n6;
                            fArray[n5] = this.t[n6];
                            fArray[n5 + 1] = this.t[n4];
                            fArray[n5 + 2] = this.t[n4 + this.n1];
                            fArray[n5 + 3] = this.t[n4 + 2 * this.n1];
                        }
                    }
                } else {
                    for (int i = 0; i < this.n2; i += 4) {
                        int n7;
                        int n8;
                        int n9;
                        for (n9 = 0; n9 < this.n1; ++n9) {
                            n8 = n9 * this.n2 + i;
                            n7 = this.n1 + n9;
                            this.t[n9] = fArray[n8];
                            this.t[n7] = fArray[n8 + 1];
                            this.t[n7 + this.n1] = fArray[n8 + 2];
                            this.t[n7 + 2 * this.n1] = fArray[n8 + 3];
                        }
                        this.dhtn1.inverse(this.t, 0, bl);
                        this.dhtn1.inverse(this.t, this.n1, bl);
                        this.dhtn1.inverse(this.t, 2 * this.n1, bl);
                        this.dhtn1.inverse(this.t, 3 * this.n1, bl);
                        for (n9 = 0; n9 < this.n1; ++n9) {
                            n8 = n9 * this.n2 + i;
                            n7 = this.n1 + n9;
                            fArray[n8] = this.t[n9];
                            fArray[n8 + 1] = this.t[n7];
                            fArray[n8 + 2] = this.t[n7 + this.n1];
                            fArray[n8 + 3] = this.t[n7 + 2 * this.n1];
                        }
                    }
                }
                break block13;
            }
            if (this.n2 != 2) break block13;
            for (n3 = 0; n3 < this.n1; ++n3) {
                n2 = n3 * this.n2;
                this.t[n3] = fArray[n2];
                this.t[this.n1 + n3] = fArray[n2 + 1];
            }
            if (n == -1) {
                this.dhtn1.forward(this.t, 0);
                this.dhtn1.forward(this.t, this.n1);
            } else {
                this.dhtn1.inverse(this.t, 0, bl);
                this.dhtn1.inverse(this.t, this.n1, bl);
            }
            for (n3 = 0; n3 < this.n1; ++n3) {
                n2 = n3 * this.n2;
                fArray[n2] = this.t[n3];
                fArray[n2 + 1] = this.t[this.n1 + n3];
            }
        }
    }

    private void ddxt2d_sub(int n, float[][] fArray, boolean bl) {
        block13: {
            int n2;
            block12: {
                if (this.n2 <= 2) break block12;
                if (n == -1) {
                    for (int i = 0; i < this.n2; i += 4) {
                        int n3;
                        int n4;
                        for (n4 = 0; n4 < this.n1; ++n4) {
                            n3 = this.n1 + n4;
                            this.t[n4] = fArray[n4][i];
                            this.t[n3] = fArray[n4][i + 1];
                            this.t[n3 + this.n1] = fArray[n4][i + 2];
                            this.t[n3 + 2 * this.n1] = fArray[n4][i + 3];
                        }
                        this.dhtn1.forward(this.t, 0);
                        this.dhtn1.forward(this.t, this.n1);
                        this.dhtn1.forward(this.t, 2 * this.n1);
                        this.dhtn1.forward(this.t, 3 * this.n1);
                        for (n4 = 0; n4 < this.n1; ++n4) {
                            n3 = this.n1 + n4;
                            fArray[n4][i] = this.t[n4];
                            fArray[n4][i + 1] = this.t[n3];
                            fArray[n4][i + 2] = this.t[n3 + this.n1];
                            fArray[n4][i + 3] = this.t[n3 + 2 * this.n1];
                        }
                    }
                } else {
                    for (int i = 0; i < this.n2; i += 4) {
                        int n5;
                        int n6;
                        for (n6 = 0; n6 < this.n1; ++n6) {
                            n5 = this.n1 + n6;
                            this.t[n6] = fArray[n6][i];
                            this.t[n5] = fArray[n6][i + 1];
                            this.t[n5 + this.n1] = fArray[n6][i + 2];
                            this.t[n5 + 2 * this.n1] = fArray[n6][i + 3];
                        }
                        this.dhtn1.inverse(this.t, 0, bl);
                        this.dhtn1.inverse(this.t, this.n1, bl);
                        this.dhtn1.inverse(this.t, 2 * this.n1, bl);
                        this.dhtn1.inverse(this.t, 3 * this.n1, bl);
                        for (n6 = 0; n6 < this.n1; ++n6) {
                            n5 = this.n1 + n6;
                            fArray[n6][i] = this.t[n6];
                            fArray[n6][i + 1] = this.t[n5];
                            fArray[n6][i + 2] = this.t[n5 + this.n1];
                            fArray[n6][i + 3] = this.t[n5 + 2 * this.n1];
                        }
                    }
                }
                break block13;
            }
            if (this.n2 != 2) break block13;
            for (n2 = 0; n2 < this.n1; ++n2) {
                this.t[n2] = fArray[n2][0];
                this.t[this.n1 + n2] = fArray[n2][1];
            }
            if (n == -1) {
                this.dhtn1.forward(this.t, 0);
                this.dhtn1.forward(this.t, this.n1);
            } else {
                this.dhtn1.inverse(this.t, 0, bl);
                this.dhtn1.inverse(this.t, this.n1, bl);
            }
            for (n2 = 0; n2 < this.n1; ++n2) {
                fArray[n2][0] = this.t[n2];
                fArray[n2][1] = this.t[this.n1 + n2];
            }
        }
    }

    private void makewt(int n) {
        this.ip[0] = n;
        this.ip[1] = 1;
        if (n > 2) {
            int n2;
            int n3 = n >> 1;
            float f = (float)(Math.atan(1.0) / (double)n3);
            float f2 = (float)Math.cos(f * (float)n3);
            this.w[0] = 1.0f;
            this.w[1] = f2;
            if (n3 == 4) {
                this.w[2] = (float)Math.cos(f * 2.0f);
                this.w[3] = (float)Math.sin(f * 2.0f);
            } else if (n3 > 4) {
                this.makeipt(n);
                this.w[2] = (float)(0.5 / Math.cos(f * 2.0f));
                this.w[3] = (float)(0.5 / Math.cos(f * 6.0f));
                for (n2 = 4; n2 < n3; n2 += 4) {
                    this.w[n2] = (float)Math.cos(f * (float)n2);
                    this.w[n2 + 1] = (float)Math.sin(f * (float)n2);
                    this.w[n2 + 2] = (float)Math.cos(3.0f * f * (float)n2);
                    this.w[n2 + 3] = (float)(-Math.sin(3.0f * f * (float)n2));
                }
            }
            int n4 = 0;
            while (n3 > 2) {
                float f3;
                float f4;
                int n5 = n4 + n3;
                this.w[n5] = 1.0f;
                this.w[n5 + 1] = f2;
                if ((n3 >>= 1) == 4) {
                    f4 = this.w[n4 + 4];
                    f3 = this.w[n4 + 5];
                    this.w[n5 + 2] = f4;
                    this.w[n5 + 3] = f3;
                } else if (n3 > 4) {
                    f4 = this.w[n4 + 4];
                    float f5 = this.w[n4 + 6];
                    this.w[n5 + 2] = (float)(0.5 / (double)f4);
                    this.w[n5 + 3] = (float)(0.5 / (double)f5);
                    for (n2 = 4; n2 < n3; n2 += 4) {
                        int n6 = n4 + 2 * n2;
                        int n7 = n5 + n2;
                        f4 = this.w[n6];
                        f3 = this.w[n6 + 1];
                        f5 = this.w[n6 + 2];
                        float f6 = this.w[n6 + 3];
                        this.w[n7] = f4;
                        this.w[n7 + 1] = f3;
                        this.w[n7 + 2] = f5;
                        this.w[n7 + 3] = f6;
                    }
                }
                n4 = n5;
            }
        }
    }

    private void makeipt(int n) {
        this.ip[2] = 0;
        this.ip[3] = 16;
        int n2 = 2;
        for (int i = n; i > 32; i >>= 2) {
            int n3 = n2 << 1;
            int n4 = n3 << 3;
            for (int j = n2; j < n3; ++j) {
                int n5;
                this.ip[n2 + j] = n5 = this.ip[j] << 2;
                this.ip[n3 + j] = n5 + n4;
            }
            n2 = n3;
        }
    }

    private void makect(int n, float[] fArray, int n2) {
        this.ip[1] = n;
        if (n > 1) {
            int n3 = n >> 1;
            float f = (float)Math.atan(1.0) / (float)n3;
            fArray[n2] = (float)Math.cos(f * (float)n3);
            fArray[n2 + n3] = 0.5f * fArray[n2];
            for (int i = 1; i < n3; ++i) {
                fArray[n2 + i] = (float)(0.5 * Math.cos(f * (float)i));
                fArray[n2 + n - i] = (float)(0.5 * Math.sin(f * (float)i));
            }
        }
    }

    private void y_transform(float[] fArray) {
        for (int i = 0; i <= this.n1 / 2; ++i) {
            for (int j = 0; j <= this.n2 / 2; ++j) {
                int n = (this.n1 - i) % this.n1;
                int n2 = (this.n2 - j) % this.n2;
                float f = fArray[i * this.n2 + j];
                float f2 = fArray[n * this.n2 + j];
                float f3 = fArray[i * this.n2 + n2];
                float f4 = fArray[n * this.n2 + n2];
                float f5 = (f + f4 - (f2 + f3)) / 2.0f;
                fArray[i * this.n2 + j] = f - f5;
                fArray[n * this.n2 + j] = f2 + f5;
                fArray[i * this.n2 + n2] = f3 + f5;
                fArray[n * this.n2 + n2] = f4 - f5;
            }
        }
    }

    private void y_transform(float[][] fArray) {
        for (int i = 0; i <= this.n1 / 2; ++i) {
            for (int j = 0; j <= this.n2 / 2; ++j) {
                int n = (this.n1 - i) % this.n1;
                int n2 = (this.n2 - j) % this.n2;
                float f = fArray[i][j];
                float f2 = fArray[n][j];
                float f3 = fArray[i][n2];
                float f4 = fArray[n][n2];
                float f5 = (f + f4 - (f2 + f3)) / 2.0f;
                fArray[i][j] = f - f5;
                fArray[n][j] = f2 + f5;
                fArray[i][n2] = f3 + f5;
                fArray[n][n2] = f4 - f5;
            }
        }
    }
}

