/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Dimension;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;

public class BaseFileChooserUI
extends MetalFileChooserUI {
    private FileView fileView = new BaseFileView();
    private static final int PREF_WIDTH = 580;
    private static final int PREF_HEIGHT = 340;
    private static Dimension PREF_SIZE = new Dimension(580, 340);

    public BaseFileChooserUI(JFileChooser fileChooser) {
        super(fileChooser);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BaseFileChooserUI((JFileChooser)c);
    }

    public Dimension getPreferredSize(JComponent c) {
        int prefWidth = BaseFileChooserUI.PREF_SIZE.width;
        Dimension d = c.getLayout().preferredLayoutSize(c);
        if (d != null) {
            return new Dimension(d.width < prefWidth ? prefWidth : d.width, d.height < BaseFileChooserUI.PREF_SIZE.height ? BaseFileChooserUI.PREF_SIZE.height : d.height);
        }
        return new Dimension(prefWidth, BaseFileChooserUI.PREF_SIZE.height);
    }

    public FileView getFileView(JFileChooser fc) {
        if (JTattooUtilities.getJavaVersion() < 1.4) {
            return super.getFileView(fc);
        }
        return this.fileView;
    }

    protected class BaseFileView
    extends BasicFileChooserUI.BasicFileView {
        protected BaseFileView() {
            super(BaseFileChooserUI.this);
        }

        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            if (f != null) {
                icon = BaseFileChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(f);
            }
            if (icon == null) {
                icon = super.getIcon(f);
            }
            this.cacheIcon(f, icon);
            return icon;
        }
    }
}

