/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public class MemoryComboBox
extends JComboBox {
    private static final long serialVersionUID = -1059386228875239787L;
    public static final int NO_MAX = -1;
    private int _maxMemoryCount = -1;

    public MemoryComboBox() {
        this(-1);
    }

    public MemoryComboBox(int maxMemoryCount) {
        this.setMaxMemoryCount(maxMemoryCount);
    }

    public void setMaxMemoryCount(int value) {
        this._maxMemoryCount = value > -1 ? value : -1;
    }

    public void addItem(Object item) {
        if (item != null) {
            this.removeItem(item);
            this.insertItemAt(item, 0);
            this.setSelectedIndex(0);
            if (this._maxMemoryCount > -1 && this.getItemCount() > this._maxMemoryCount) {
                this.removeItemAt(this.getItemCount() - 1);
            }
        }
    }

    public void insertItemAt(Object anObject, int index) {
        super.insertItemAt(anObject, index);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                while (MemoryComboBox.this._maxMemoryCount > -1 && MemoryComboBox.this.getItemCount() > MemoryComboBox.this._maxMemoryCount) {
                    MemoryComboBox.this.removeItemAt(0);
                }
            }
        });
    }
}

