/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.cpu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.cpu.StackTraceSnapshotBuilder;
import org.graalvm.visualvm.lib.profiler.actions.TakeSnapshotAction;
import org.graalvm.visualvm.lib.profiler.api.ActionsSupport;
import org.graalvm.visualvm.lib.profiler.api.GoToSource;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.cpu.LiveCPUView;
import org.graalvm.visualvm.lib.ui.swing.GrayLabel;
import org.graalvm.visualvm.lib.ui.swing.MultiButtonGroup;
import org.graalvm.visualvm.sampler.AbstractSamplerSupport;
import org.graalvm.visualvm.sampler.cpu.Bundle;
import org.graalvm.visualvm.sampler.cpu.CPUSamplerSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

final class CPUView
extends JPanel {
    private final AbstractSamplerSupport.Refresher refresher;
    private boolean forceRefresh = false;
    private final CPUSamplerSupport.SnapshotDumper snapshotDumper;
    private final CPUSamplerSupport.ThreadDumper threadDumper;
    private StackTraceSnapshotBuilder builder;
    private ProfilerToolbar toolbar;
    private LiveCPUView cpuView;
    private JLabel lrLabel;
    private JToggleButton lrPauseButton;
    private JButton lrRefreshButton;
    private JToggleButton lrDeltasButton;
    private JLabel pdLabel;
    private JButton pdSnapshotButton;
    private boolean popupPause;
    private JToggleButton[] toggles;
    private AbstractButton threaddumpButton;

    CPUView(AbstractSamplerSupport.Refresher refresher, CPUSamplerSupport.SnapshotDumper snapshotDumper, CPUSamplerSupport.ThreadDumper threadDumper, Application application) {
        this.refresher = refresher;
        this.snapshotDumper = snapshotDumper;
        this.threadDumper = threadDumper;
        this.initComponents(application);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && CPUView.this.isShowing()) {
                    CPUView.this.refresher.refresh();
                }
            }
        });
    }

    void setBuilder(StackTraceSnapshotBuilder builder) {
        this.builder = builder;
    }

    void initSession() {
        this.pdSnapshotButton.setEnabled(false);
    }

    void refresh() {
        if (!this.isShowing() || this.lrPauseButton.isSelected() && !this.forceRefresh) {
            return;
        }
        this.forceRefresh = false;
        try {
            CPUResultsSnapshot snapshot = this.builder.createSnapshot(System.currentTimeMillis());
            this.cpuView.setData(snapshot, true);
        }
        catch (CPUResultsSnapshot.NoDataAvailableException noDataAvailableException) {
            // empty catch block
        }
        this.pdSnapshotButton.setEnabled(this.snapshotDumper != null);
    }

    void starting() {
        this.lrPauseButton.setEnabled(true);
        this.lrRefreshButton.setEnabled(false);
        this.lrDeltasButton.setEnabled(true);
        this.cpuView.resetData();
    }

    void stopping() {
        this.lrPauseButton.setEnabled(false);
        this.lrRefreshButton.setEnabled(false);
        this.lrDeltasButton.setEnabled(false);
    }

    void terminated() {
        this.lrPauseButton.setEnabled(false);
        this.lrRefreshButton.setEnabled(false);
        this.lrDeltasButton.setEnabled(false);
        this.threaddumpButton.setEnabled(false);
    }

    private void initComponents(Application application) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.cpuView = new LiveCPUView(null){

            protected boolean showSourceSupported() {
                return GoToSource.isAvailable();
            }

            protected boolean profileMethodSupported() {
                return false;
            }

            protected boolean profileClassSupported() {
                return false;
            }

            protected void showSource(ClientUtils.SourceCodeSelection value) {
                Lookup.Provider project = null;
                String className = value.getClassName();
                String methodName = value.getMethodName();
                String methodSig = value.getMethodSignature();
                GoToSource.openSource(project, (String)className, (String)methodName, (String)methodSig);
            }

            protected void selectForProfiling(ClientUtils.SourceCodeSelection value) {
            }

            protected void popupShowing() {
                if (CPUView.this.lrPauseButton.isEnabled() && !CPUView.this.lrRefreshButton.isEnabled()) {
                    CPUView.this.popupPause = true;
                    CPUView.this.lrPauseButton.setSelected(true);
                }
            }

            protected void popupHidden() {
                if (CPUView.this.lrPauseButton.isEnabled() && CPUView.this.popupPause) {
                    CPUView.this.popupPause = false;
                    CPUView.this.lrPauseButton.setSelected(false);
                }
            }

            protected void foundInForwardCalls() {
                super.foundInForwardCalls();
                CPUView.this.toggles[0].setSelected(true);
            }

            protected void foundInHotSpots() {
                super.foundInHotSpots();
                CPUView.this.toggles[1].setSelected(true);
            }

            protected void foundInReverseCalls() {
                super.foundInReverseCalls();
                CPUView.this.toggles[2].setSelected(true);
            }
        };
        this.cpuView.putClientProperty((Object)"profiled_application", (Object)application);
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        String filterKey = "filter-action-key";
        AbstractAction filterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action action = CPUView.this.cpuView.getActionMap().get("filter-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(e);
                }
            }
        };
        ActionsSupport.registerAction((String)"filter-action-key", (Action)filterAction, (ActionMap)actionMap, (InputMap)inputMap);
        String findKey = "find-action-key";
        AbstractAction findAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action action = CPUView.this.cpuView.getActionMap().get("find-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(e);
                }
            }
        };
        ActionsSupport.registerAction((String)"find-action-key", (Action)findAction, (ActionMap)actionMap, (InputMap)inputMap);
        this.lrLabel = new GrayLabel(Bundle.MethodsFeatureUI_liveResults());
        this.lrPauseButton = new JToggleButton(Icons.getIcon((String)"GeneralIcons.Pause")){

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                boolean paused = CPUView.this.lrPauseButton.isSelected();
                CPUView.this.lrRefreshButton.setEnabled(paused && !CPUView.this.popupPause);
                if (!paused) {
                    CPUView.this.refresher.refresh();
                }
            }
        };
        this.lrPauseButton.setToolTipText(Bundle.MethodsFeatureUI_pauseResults());
        this.lrRefreshButton = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                CPUView.this.forceRefresh = true;
                CPUView.this.refresher.refresh();
            }
        };
        this.lrRefreshButton.setToolTipText(Bundle.MethodsFeatureUI_updateResults());
        this.lrRefreshButton.setEnabled(false);
        Icon icon = Icons.getIcon((String)"ProfilerIcons.DeltaResults");
        this.lrDeltasButton = new JToggleButton(icon){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                if (!CPUView.this.cpuView.setDiffView(this.isSelected())) {
                    this.setSelected(false);
                }
                this.setToolTipText(this.isSelected() ? Bundle.MethodsFeatureUI_showAbsolute() : Bundle.MethodsFeatureUI_showDeltas());
            }
        };
        this.lrDeltasButton.setToolTipText(Bundle.MethodsFeatureUI_showDeltas());
        MultiButtonGroup group = new MultiButtonGroup();
        this.toggles = new JToggleButton[3];
        JToggleButton forwardCalls = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.NodeForward")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                CPUView.this.cpuView.setView(this.isSelected(), CPUView.this.toggles[1].isSelected(), CPUView.this.toggles[2].isSelected());
                CPUView.this.refresh();
            }
        };
        forwardCalls.putClientProperty("JButton.buttonType", "segmented");
        forwardCalls.putClientProperty("JButton.segmentPosition", "first");
        forwardCalls.setToolTipText(Bundle.MethodsFeatureUI_viewForward());
        group.add((AbstractButton)forwardCalls);
        this.toggles[0] = forwardCalls;
        forwardCalls.setSelected(true);
        JToggleButton hotSpots = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.TabHotSpots")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                CPUView.this.cpuView.setView(CPUView.this.toggles[0].isSelected(), this.isSelected(), CPUView.this.toggles[2].isSelected());
                CPUView.this.refresh();
            }
        };
        hotSpots.putClientProperty("JButton.buttonType", "segmented");
        hotSpots.putClientProperty("JButton.segmentPosition", "middle");
        hotSpots.setToolTipText(Bundle.MethodsFeatureUI_viewHotSpots());
        group.add((AbstractButton)hotSpots);
        this.toggles[1] = hotSpots;
        hotSpots.setSelected(false);
        JToggleButton reverseCalls = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.NodeReverse")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                CPUView.this.cpuView.setView(CPUView.this.toggles[0].isSelected(), CPUView.this.toggles[1].isSelected(), this.isSelected());
                CPUView.this.refresh();
            }
        };
        reverseCalls.putClientProperty("JButton.buttonType", "segmented");
        reverseCalls.putClientProperty("JButton.segmentPosition", "last");
        reverseCalls.setToolTipText(Bundle.MethodsFeatureUI_viewReverse());
        group.add((AbstractButton)reverseCalls);
        this.toggles[2] = reverseCalls;
        reverseCalls.setSelected(false);
        this.pdLabel = new GrayLabel(Bundle.MethodsFeatureUI_profilingData());
        this.pdSnapshotButton = new JButton((Action)TakeSnapshotAction.getInstance()){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                CPUView.this.snapshotDumper.takeSnapshot((event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
            }
        };
        this.pdSnapshotButton.setText(Bundle.MethodsFeatureUI_snapshot());
        this.pdSnapshotButton.putClientProperty("JComponent.sizeVariant", "regular");
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.lrPauseButton);
        this.toolbar.add((Component)this.lrRefreshButton);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrDeltasButton);
        this.toolbar.addSpace(2);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new GrayLabel(Bundle.MethodsFeatureUI_view()));
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)forwardCalls);
        this.toolbar.add((Component)hotSpots);
        this.toolbar.add((Component)reverseCalls);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.cpuView.createThreadSelector());
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.pdLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.pdSnapshotButton);
        this.toolbar.addFiller();
        this.threaddumpButton = new JButton(NbBundle.getMessage(CPUView.class, (String)"LBL_Thread_dump")){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                CPUView.this.threadDumper.takeThreadDump((event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width += 5;
                return dim;
            }
        };
        this.threaddumpButton.setToolTipText(NbBundle.getMessage(CPUView.class, (String)"TOOLTIP_Thread_dump"));
        this.threaddumpButton.setOpaque(false);
        this.threaddumpButton.setEnabled(this.threadDumper != null);
        this.toolbar.add((Component)this.threaddumpButton);
        this.cpuView.setView(true, false, false);
        this.add((Component)this.toolbar.getComponent(), "North");
        this.add((Component)this.cpuView, "Center");
    }
}

