/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.recipes.leader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.recipes.leader.LeaderElectionAware;
import org.apache.zookeeper.recipes.leader.LeaderOffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElectionSupport
implements Watcher {
    private static final Logger logger = LoggerFactory.getLogger(LeaderElectionSupport.class);
    private ZooKeeper zooKeeper;
    private State state = State.STOP;
    private Set<LeaderElectionAware> listeners = Collections.synchronizedSet(new HashSet());
    private String rootNodeName;
    private LeaderOffer leaderOffer;
    private String hostName;

    public synchronized void start() {
        this.state = State.START;
        this.dispatchEvent(EventType.START);
        logger.info("Starting leader election support");
        if (this.zooKeeper == null) {
            throw new IllegalStateException("No instance of zookeeper provided. Hint: use setZooKeeper()");
        }
        if (this.hostName == null) {
            throw new IllegalStateException("No hostname provided. Hint: use setHostName()");
        }
        try {
            this.makeOffer();
            this.determineElectionStatus();
        }
        catch (KeeperException e) {
            this.becomeFailed((Exception)((Object)e));
            return;
        }
        catch (InterruptedException e) {
            this.becomeFailed(e);
            return;
        }
    }

    public synchronized void stop() {
        this.state = State.STOP;
        this.dispatchEvent(EventType.STOP_START);
        logger.info("Stopping leader election support");
        if (this.leaderOffer != null) {
            try {
                this.zooKeeper.delete(this.leaderOffer.getNodePath(), -1);
                logger.info("Removed leader offer {}", (Object)this.leaderOffer.getNodePath());
            }
            catch (InterruptedException e) {
                this.becomeFailed(e);
            }
            catch (KeeperException e) {
                this.becomeFailed((Exception)((Object)e));
            }
        }
        this.dispatchEvent(EventType.STOP_COMPLETE);
    }

    private void makeOffer() throws KeeperException, InterruptedException {
        this.state = State.OFFER;
        this.dispatchEvent(EventType.OFFER_START);
        this.leaderOffer = new LeaderOffer();
        this.leaderOffer.setHostName(this.hostName);
        this.leaderOffer.setNodePath(this.zooKeeper.create(this.rootNodeName + "/n_", this.hostName.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL));
        logger.debug("Created leader offer {}", (Object)this.leaderOffer);
        this.dispatchEvent(EventType.OFFER_COMPLETE);
    }

    private void determineElectionStatus() throws KeeperException, InterruptedException {
        this.state = State.DETERMINE;
        this.dispatchEvent(EventType.DETERMINE_START);
        String[] components = this.leaderOffer.getNodePath().split("/");
        this.leaderOffer.setId(Integer.valueOf(components[components.length - 1].substring("n_".length())));
        List<LeaderOffer> leaderOffers = this.toLeaderOffers(this.zooKeeper.getChildren(this.rootNodeName, false));
        for (int i = 0; i < leaderOffers.size(); ++i) {
            LeaderOffer leaderOffer = leaderOffers.get(i);
            if (!leaderOffer.getId().equals(this.leaderOffer.getId())) continue;
            logger.debug("There are {} leader offers. I am {} in line.", (Object)leaderOffers.size(), (Object)i);
            this.dispatchEvent(EventType.DETERMINE_COMPLETE);
            if (i == 0) {
                this.becomeLeader();
                break;
            }
            this.becomeReady(leaderOffers.get(i - 1));
            break;
        }
    }

    private void becomeReady(LeaderOffer neighborLeaderOffer) throws KeeperException, InterruptedException {
        this.dispatchEvent(EventType.READY_START);
        logger.info("{} not elected leader. Watching node:{}", (Object)this.leaderOffer.getNodePath(), (Object)neighborLeaderOffer.getNodePath());
        Stat stat = this.zooKeeper.exists(neighborLeaderOffer.getNodePath(), (Watcher)this);
        if (stat != null) {
            logger.debug("We're behind {} in line and they're alive. Keeping an eye on them.", (Object)neighborLeaderOffer.getNodePath());
            this.state = State.READY;
            this.dispatchEvent(EventType.READY_COMPLETE);
        } else {
            logger.info("We were behind {} but it looks like they died. Back to determination.", (Object)neighborLeaderOffer.getNodePath());
            this.determineElectionStatus();
        }
    }

    private void becomeLeader() {
        this.state = State.ELECTED;
        this.dispatchEvent(EventType.ELECTED_START);
        logger.info("Becoming leader with node:{}", (Object)this.leaderOffer.getNodePath());
        this.dispatchEvent(EventType.ELECTED_COMPLETE);
    }

    private void becomeFailed(Exception e) {
        logger.error("Failed in state {} - Exception:{}", (Object)this.state, (Object)e);
        this.state = State.FAILED;
        this.dispatchEvent(EventType.FAILED);
    }

    public String getLeaderHostName() throws KeeperException, InterruptedException {
        List<LeaderOffer> leaderOffers = this.toLeaderOffers(this.zooKeeper.getChildren(this.rootNodeName, false));
        if (leaderOffers.size() > 0) {
            return leaderOffers.get(0).getHostName();
        }
        return null;
    }

    private List<LeaderOffer> toLeaderOffers(List<String> strings) throws KeeperException, InterruptedException {
        ArrayList<LeaderOffer> leaderOffers = new ArrayList<LeaderOffer>(strings.size());
        for (String offer : strings) {
            String hostName = new String(this.zooKeeper.getData(this.rootNodeName + "/" + offer, false, null));
            leaderOffers.add(new LeaderOffer(Integer.valueOf(offer.substring("n_".length())), this.rootNodeName + "/" + offer, hostName));
        }
        Collections.sort(leaderOffers, new LeaderOffer.IdComparator());
        return leaderOffers;
    }

    public void process(WatchedEvent event) {
        if (event.getType().equals((Object)Watcher.Event.EventType.NodeDeleted) && !event.getPath().equals(this.leaderOffer.getNodePath()) && this.state != State.STOP) {
            logger.debug("Node {} deleted. Need to run through the election process.", (Object)event.getPath());
            try {
                this.determineElectionStatus();
            }
            catch (KeeperException e) {
                this.becomeFailed((Exception)((Object)e));
            }
            catch (InterruptedException e) {
                this.becomeFailed(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(EventType eventType) {
        logger.debug("Dispatching event:{}", (Object)eventType);
        Set<LeaderElectionAware> set = this.listeners;
        synchronized (set) {
            if (this.listeners.size() > 0) {
                for (LeaderElectionAware observer : this.listeners) {
                    observer.onElectionEvent(eventType);
                }
            }
        }
    }

    public void addListener(LeaderElectionAware listener) {
        this.listeners.add(listener);
    }

    public void removeListener(LeaderElectionAware listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return "{ state:" + (Object)((Object)this.state) + " leaderOffer:" + this.leaderOffer + " zooKeeper:" + this.zooKeeper + " hostName:" + this.hostName + " listeners:" + this.listeners + " }";
    }

    public String getRootNodeName() {
        return this.rootNodeName;
    }

    public void setRootNodeName(String rootNodeName) {
        this.rootNodeName = rootNodeName;
    }

    public ZooKeeper getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(ZooKeeper zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public static enum State {
        START,
        OFFER,
        DETERMINE,
        ELECTED,
        READY,
        FAILED,
        STOP;

    }

    public static enum EventType {
        START,
        OFFER_START,
        OFFER_COMPLETE,
        DETERMINE_START,
        DETERMINE_COMPLETE,
        ELECTED_START,
        ELECTED_COMPLETE,
        READY_START,
        READY_COMPLETE,
        FAILED,
        STOP_START,
        STOP_COMPLETE;

    }
}

