/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet;

import com.sun.grizzly.http.servlet.FilterChainImpl;
import com.sun.grizzly.http.servlet.FilterConfigImpl;
import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.http.servlet.HttpServletResponseImpl;
import com.sun.grizzly.http.servlet.ServletConfigImpl;
import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.ClassLoaderUtil;
import com.sun.grizzly.util.Grizzly;
import com.sun.grizzly.util.IntrospectionUtils;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.Cookie;
import com.sun.grizzly.util.http.HttpRequestURIDecoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletAdapter
extends GrizzlyAdapter {
    public static final int REQUEST_RESPONSE_NOTES = 29;
    public static final int SERVLETCONFIG_NOTES = 30;
    public static final String LOAD_ON_STARTUP = "load-on-startup";
    protected volatile Servlet servletInstance = null;
    private FilterChainImpl filterChain = new FilterChainImpl();
    private transient ArrayList<String> listeners;
    private String servletPath = "";
    private String contextPath = "";
    private String fullUrlPath = "/";
    private boolean loadOnStartup = false;
    private HashMap<String, String> parameters;
    private volatile boolean filterChainConfigured = false;
    private ReentrantLock filterChainReady = new ReentrantLock();
    private final ServletContextImpl servletCtx;
    private ServletConfigImpl servletConfig;
    protected HashMap<String, Object> properties = new HashMap();

    public ServletAdapter() {
        this(".");
    }

    public ServletAdapter(Servlet servlet) {
        this(".");
        this.servletInstance = servlet;
    }

    public ServletAdapter(String publicDirectory) {
        this(publicDirectory, new ServletContextImpl(), new HashMap<String, String>(), new ArrayList<String>());
    }

    protected ServletAdapter(String publicDirectory, ServletContextImpl servletCtx, HashMap<String, String> parameters, ArrayList<String> listeners) {
        super(publicDirectory);
        this.servletCtx = servletCtx;
        this.servletConfig = new ServletConfigImpl(servletCtx);
        this.parameters = parameters;
        this.listeners = listeners;
    }

    public ServletAdapter(Servlet servlet, ServletContextImpl servletContext) {
        super(".");
        this.servletInstance = servlet;
        this.servletCtx = servletContext;
    }

    @Override
    public void start() {
        try {
            this.initWebDir();
            this.configureClassLoader(this.webDir.getCanonicalPath());
            this.configureServletEnv();
            this.fullUrlPath = this.contextPath + this.servletPath;
            this.setResourcesContextPath(this.fullUrlPath);
            if (this.loadOnStartup) {
                this.loadServlet();
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "start", t);
        }
    }

    protected void configureClassLoader(String appliPath) throws IOException {
        Thread.currentThread().setContextClassLoader(ClassLoaderUtil.createURLClassLoader(appliPath));
    }

    @Override
    public void service(GrizzlyRequest request, GrizzlyResponse response) {
        try {
            Cookie[] cookies;
            Request req = request.getRequest();
            Response res = response.getResponse();
            String uri = request.getRequestURI();
            if (!uri.startsWith(this.fullUrlPath)) {
                this.customizeErrorPage(response, "Resource Not Found", 404);
                return;
            }
            HttpServletRequestImpl httpRequest = (HttpServletRequestImpl)req.getNote(29);
            HttpServletResponseImpl httpResponse = (HttpServletResponseImpl)res.getNote(29);
            if (httpRequest == null) {
                httpRequest = new HttpServletRequestImpl(request);
                httpResponse = new HttpServletResponseImpl(response);
                req.setNote(29, httpRequest);
                res.setNote(29, httpResponse);
            }
            if ((cookies = request.getCookies()) != null) {
                for (Cookie c : cookies) {
                    if (!"JSESSIONID".equals(c.getName())) continue;
                    request.setRequestedSessionId(c.getValue());
                    request.setRequestedSessionCookie(true);
                    break;
                }
            }
            this.loadServlet();
            httpRequest.setContextImpl(this.servletCtx);
            httpRequest.setServletPath(this.servletPath);
            httpRequest.initSession();
            httpResponse.addHeader("server", "grizzly/" + Grizzly.getDotedVersion());
            this.filterChain.invokeFilterChain(httpRequest, httpResponse);
        }
        catch (Throwable ex) {
            this.logger.log(Level.SEVERE, "service exception:", ex);
            this.customizeErrorPage(response, "Internal Error", 500);
        }
    }

    public void customizeErrorPage(GrizzlyResponse response, String message, int errorCode) {
        response.setStatus(errorCode, message);
        response.setContentType("text/html");
        try {
            response.getWriter().write("<html><body><h1>" + message + "</h1></body></html>");
            response.getWriter().flush();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadServlet() throws ServletException {
        try {
            this.filterChainReady.lock();
            if (this.filterChainConfigured) {
                return;
            }
            if (this.servletInstance == null) {
                String servletClassName = System.getProperty("com.sun.grizzly.servletClass");
                if (servletClassName != null) {
                    this.servletInstance = (Servlet)ClassLoaderUtil.load(servletClassName);
                }
                if (this.servletInstance != null) {
                    this.logger.info("Loading Servlet: " + this.servletInstance.getClass().getName());
                }
            }
            if (this.servletInstance != null) {
                this.servletInstance.init(this.servletConfig);
            }
            this.filterChain.setServlet(this.servletConfig, this.servletInstance);
            this.filterChain.init();
            this.filterChainConfigured = true;
        }
        finally {
            this.filterChainReady.unlock();
        }
    }

    protected void configureServletEnv() throws ServletException {
        MessageBytes c = MessageBytes.newInstance();
        this.fullUrlPath = this.contextPath + this.servletPath;
        if (!this.fullUrlPath.equals("")) {
            char[] ch = this.fullUrlPath.toCharArray();
            c.setChars(ch, 0, ch.length);
            HttpRequestURIDecoder.normalize(c);
            this.fullUrlPath = c.getCharChunk().toString();
        }
        if (this.fullUrlPath.equals("/")) {
            this.contextPath = "";
        }
        this.servletCtx.setInitParameter(this.parameters);
        this.servletCtx.setContextPath(this.contextPath);
        this.servletCtx.setBasePath(this.getRootFolder());
        this.configureProperties(this.servletCtx);
        this.servletCtx.initListeners(this.listeners);
        this.configureProperties(this.servletConfig);
    }

    @Override
    public void afterService(GrizzlyRequest request, GrizzlyResponse response) throws Exception {
        this.filterChain.recycle();
    }

    public void addInitParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void addContextParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void addFilter(Filter filter, String filterName, Map initParameters) {
        FilterConfigImpl filterConfig = new FilterConfigImpl(this.servletCtx);
        filterConfig.setFilter(filter);
        filterConfig.setFilterName(filterName);
        filterConfig.setInitParameters(initParameters);
        this.filterChain.addFilter(filterConfig);
    }

    public Servlet getServletInstance() {
        return this.servletInstance;
    }

    public void setServletInstance(Servlet servletInstance) {
        this.servletInstance = servletInstance;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void addServletListener(String listenerName) {
        this.listeners.add(listenerName);
    }

    private void configureProperties(Object object) {
        for (String name : this.properties.keySet()) {
            String value = this.properties.get(name).toString();
            IntrospectionUtils.setProperty(object, name, value);
        }
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        int pos;
        if (name.equalsIgnoreCase(LOAD_ON_STARTUP) && value != null && new Integer(value.toString()) <= 1) {
            this.loadOnStartup = true;
        }
        if ((pos = name.indexOf("-")) > 0) {
            String pre = name.substring(0, pos);
            String post = name.substring(pos + 1);
            name = pre + post;
        }
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.servletCtx.destroyListeners();
    }

    public ServletAdapter newServletAdapter(Servlet servlet) {
        ServletAdapter sa = new ServletAdapter(".", this.servletCtx, this.parameters, this.listeners);
        sa.setServletInstance(servlet);
        sa.setServletPath(this.servletPath);
        return sa;
    }

    protected ServletContextImpl getServletCtx() {
        return this.servletCtx;
    }

    protected ArrayList<String> getListeners() {
        return this.listeners;
    }

    protected HashMap<String, String> getParameters() {
        return this.parameters;
    }
}

