/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.service.impl;

import com.amazon.aes.service.RegionMapping;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionMappingImpl
implements RegionMapping {
    private final List<String> regions;
    private final List<List<String>> lines = new ArrayList<List<String>>();

    public RegionMappingImpl(List<String> regions) {
        this.regions = regions;
    }

    public RegionMapping add(List<String> line) {
        if (line == null || line.size() != this.regions.size()) {
            throw new RuntimeException("Tried to add a line of unexpected length.");
        }
        this.lines.add(line);
        return this;
    }

    @Override
    public String map(String object, String dstRegion) {
        int dstIndex = this.regions.indexOf(dstRegion);
        if (dstIndex < 0) {
            throw new RuntimeException("Unknown region " + dstRegion);
        }
        for (List<String> line : this.lines) {
            if (line.indexOf(object) < 0) continue;
            return line.get(dstIndex);
        }
        return null;
    }
}

