/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DeleteDhcpOptions
extends BaseCmd {
    private String dhcpOptionsId;

    public DeleteDhcpOptions(String[] args) {
        super("ec2deldopt", "ec2-delete-dhcp-options");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected String getOptionString() {
        return "DHCP_OPTIONS";
    }

    private Options getOptions() {
        return new Options();
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Deletes a set of DHCP options. The DHCP_OPTIONS parameter is the ID of");
        System.out.println("     the DHCP options you want to delete.");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.dhcpOptionsId = this.getNonOptions()[0];
        RequestResultPair rsp = jec2.deleteDhcpOptions(this.dhcpOptionsId);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputObjectId(System.out, "DHCPOPTIONS", this.dhcpOptionsId);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.assertNonOptionSet("DHCP_OPTIONS");
        this.warnIfTooManyNonOptions();
    }

    public static void main(String[] args) {
        new DeleteDhcpOptions(args).invoke();
    }
}

