/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.aggregate;

import java.util.List;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.aggregate.EnclosedAgg;
import org.elasticsearch.xpack.sql.expression.function.aggregate.NumericAggregate;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public class Max
extends NumericAggregate
implements EnclosedAgg {
    public Max(Source source, Expression field) {
        super(source, field);
    }

    @Override
    protected NodeInfo<Max> info() {
        return NodeInfo.create(this, Max::new, this.field());
    }

    @Override
    public Max replaceChildren(List<Expression> newChildren) {
        return new Max(this.source(), newChildren.get(0));
    }

    @Override
    public DataType dataType() {
        return this.field().dataType();
    }

    @Override
    public String innerName() {
        return "max";
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (this.field().dataType().isString()) {
            return TypeResolutions.isExact(this.field(), this.sourceText(), Expressions.ParamOrdinal.DEFAULT);
        }
        return TypeResolutions.isNumericOrDate(this.field(), this.sourceText(), Expressions.ParamOrdinal.DEFAULT);
    }
}

