/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class UnfollowAction
extends Action<Request, AcknowledgedResponse, RequestBuilder> {
    public static final UnfollowAction INSTANCE = new UnfollowAction();
    public static final String NAME = "indices:admin/xpack/ccr/unfollow";

    private UnfollowAction() {
        super(NAME);
    }

    public AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, INSTANCE);
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, AcknowledgedResponse, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, Action<Request, AcknowledgedResponse, RequestBuilder> action) {
            super(client, action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest {
        private String followerIndex;

        public Request(String followerIndex) {
            this.followerIndex = followerIndex;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.followerIndex = in.readString();
        }

        public Request() {
        }

        public String getFollowerIndex() {
            return this.followerIndex;
        }

        public void setFollowerIndex(String followerIndex) {
            this.followerIndex = followerIndex;
        }

        public String[] indices() {
            return new String[]{this.followerIndex};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException e = null;
            if (this.followerIndex == null) {
                e = ValidateActions.addValidationError((String)"follower index is missing", e);
            }
            return e;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.followerIndex);
        }
    }
}

