/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class GetApiKeyRequest
extends ActionRequest {
    private String realmName;
    private String userName;
    private String apiKeyId;
    private String apiKeyName;

    public GetApiKeyRequest() {
        this(null, null, null, null);
    }

    public GetApiKeyRequest(StreamInput in) throws IOException {
        super(in);
        this.realmName = in.readOptionalString();
        this.userName = in.readOptionalString();
        this.apiKeyId = in.readOptionalString();
        this.apiKeyName = in.readOptionalString();
    }

    public GetApiKeyRequest(@Nullable String realmName, @Nullable String userName, @Nullable String apiKeyId, @Nullable String apiKeyName) {
        this.realmName = realmName;
        this.userName = userName;
        this.apiKeyId = apiKeyId;
        this.apiKeyName = apiKeyName;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getApiKeyId() {
        return this.apiKeyId;
    }

    public String getApiKeyName() {
        return this.apiKeyName;
    }

    public static GetApiKeyRequest usingRealmName(String realmName) {
        return new GetApiKeyRequest(realmName, null, null, null);
    }

    public static GetApiKeyRequest usingUserName(String userName) {
        return new GetApiKeyRequest(null, userName, null, null);
    }

    public static GetApiKeyRequest usingRealmAndUserName(String realmName, String userName) {
        return new GetApiKeyRequest(realmName, userName, null, null);
    }

    public static GetApiKeyRequest usingApiKeyId(String apiKeyId) {
        return new GetApiKeyRequest(null, null, apiKeyId, null);
    }

    public static GetApiKeyRequest usingApiKeyName(String apiKeyName) {
        return new GetApiKeyRequest(null, null, null, apiKeyName);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!(Strings.hasText((String)this.realmName) || Strings.hasText((String)this.userName) || Strings.hasText((String)this.apiKeyId) || Strings.hasText((String)this.apiKeyName))) {
            validationException = ValidateActions.addValidationError((String)"One of [api key id, api key name, username, realm name] must be specified", (ActionRequestValidationException)validationException);
        }
        if ((Strings.hasText((String)this.apiKeyId) || Strings.hasText((String)this.apiKeyName)) && (Strings.hasText((String)this.realmName) || Strings.hasText((String)this.userName))) {
            validationException = ValidateActions.addValidationError((String)"username or realm name must not be specified when the api key id or api key name is specified", validationException);
        }
        if (Strings.hasText((String)this.apiKeyId) && Strings.hasText((String)this.apiKeyName)) {
            validationException = ValidateActions.addValidationError((String)"only one of [api key id, api key name] can be specified", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.realmName);
        out.writeOptionalString(this.userName);
        out.writeOptionalString(this.apiKeyId);
        out.writeOptionalString(this.apiKeyName);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.realmName = in.readOptionalString();
        this.userName = in.readOptionalString();
        this.apiKeyId = in.readOptionalString();
        this.apiKeyName = in.readOptionalString();
    }
}

