/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.HardlinkCopyDirectoryWrapper;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardRecoveryException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.LocalShardSnapshot;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardSplittingQuery;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.Repository;

final class StoreRecovery {
    private final Logger logger;
    private final ShardId shardId;

    StoreRecovery(ShardId shardId, Logger logger) {
        this.logger = logger;
        this.shardId = shardId;
    }

    boolean recoverFromStore(IndexShard indexShard) {
        if (this.canRecover(indexShard)) {
            RecoverySource.Type recoveryType = indexShard.recoveryState().getRecoverySource().getType();
            assert (recoveryType == RecoverySource.Type.EMPTY_STORE || recoveryType == RecoverySource.Type.EXISTING_STORE) : "expected store recovery type but was: " + (Object)((Object)recoveryType);
            return this.executeRecovery(indexShard, () -> {
                this.logger.debug("starting recovery from store ...");
                this.internalRecoverFromStore(indexShard);
            });
        }
        return false;
    }

    boolean recoverFromLocalShards(BiConsumer<String, MappingMetaData> mappingUpdateConsumer, IndexShard indexShard, List<LocalShardSnapshot> shards) throws IOException {
        if (this.canRecover(indexShard)) {
            boolean isSplit;
            RecoverySource.Type recoveryType = indexShard.recoveryState().getRecoverySource().getType();
            assert (recoveryType == RecoverySource.Type.LOCAL_SHARDS) : "expected local shards recovery type: " + (Object)((Object)recoveryType);
            if (shards.isEmpty()) {
                throw new IllegalArgumentException("shards must not be empty");
            }
            Set indices = shards.stream().map(s -> s.getIndex()).collect(Collectors.toSet());
            if (indices.size() > 1) {
                throw new IllegalArgumentException("can't add shards from more than one index");
            }
            IndexMetaData sourceMetaData = shards.get(0).getIndexMetaData();
            for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : sourceMetaData.getMappings()) {
                mappingUpdateConsumer.accept((String)objectObjectCursor.key, (MappingMetaData)objectObjectCursor.value);
            }
            indexShard.mapperService().merge(sourceMetaData, MapperService.MergeReason.MAPPING_RECOVERY, true);
            Sort indexSort = indexShard.getIndexSort();
            boolean bl = indexShard.mapperService().hasNested();
            boolean bl2 = isSplit = sourceMetaData.getNumberOfShards() < indexShard.indexSettings().getNumberOfShards();
            assert (!isSplit || sourceMetaData.getCreationVersion().onOrAfter(Version.V_6_0_0_alpha1)) : "for split we require a single type but the index is created before 6.0.0";
            return this.executeRecovery(indexShard, () -> {
                this.logger.debug("starting recovery from local shards {}", (Object)shards);
                try {
                    Directory directory = indexShard.store().directory();
                    Directory[] sources = (Directory[])shards.stream().map(LocalShardSnapshot::getSnapshotDirectory).toArray(Directory[]::new);
                    long maxSeqNo = shards.stream().mapToLong(LocalShardSnapshot::maxSeqNo).max().getAsLong();
                    long maxUnsafeAutoIdTimestamp = shards.stream().mapToLong(LocalShardSnapshot::maxUnsafeAutoIdTimestamp).max().getAsLong();
                    this.addIndices(indexShard.recoveryState().getIndex(), directory, indexSort, sources, maxSeqNo, maxUnsafeAutoIdTimestamp, indexShard.indexSettings().getIndexMetaData(), indexShard.shardId().id(), isSplit, hasNested);
                    this.internalRecoverFromStore(indexShard);
                    indexShard.getEngine().forceMerge(false, -1, false, false, false);
                }
                catch (IOException ex) {
                    throw new IndexShardRecoveryException(indexShard.shardId(), "failed to recover from local shards", ex);
                }
            });
        }
        return false;
    }

    void addIndices(RecoveryState.Index indexRecoveryStats, Directory target, Sort indexSort, Directory[] sources, long maxSeqNo, long maxUnsafeAutoIdTimestamp, IndexMetaData indexMetaData, int shardId, boolean split, boolean hasNested) throws IOException {
        Lucene.cleanLuceneIndex(target);
        assert (sources.length > 0);
        int luceneIndexCreatedVersionMajor = Lucene.readSegmentInfos(sources[0]).getIndexCreatedVersionMajor();
        new SegmentInfos(luceneIndexCreatedVersionMajor).commit(target);
        HardlinkCopyDirectoryWrapper hardLinkOrCopyTarget = new HardlinkCopyDirectoryWrapper(target);
        IndexWriterConfig iwc = new IndexWriterConfig(null).setSoftDeletesField("__soft_deletes").setCommitOnClose(false).setMergePolicy(NoMergePolicy.INSTANCE).setOpenMode(IndexWriterConfig.OpenMode.APPEND);
        if (indexSort != null) {
            iwc.setIndexSort(indexSort);
        }
        try (IndexWriter writer = new IndexWriter((Directory)new StatsDirectoryWrapper((Directory)hardLinkOrCopyTarget, indexRecoveryStats), iwc);){
            writer.addIndexes(sources);
            if (split) {
                writer.deleteDocuments(new Query[]{new ShardSplittingQuery(indexMetaData, shardId, hasNested)});
            }
            writer.setLiveCommitData(() -> {
                HashMap<String, String> liveCommitData = new HashMap<String, String>(3);
                liveCommitData.put("max_seq_no", Long.toString(maxSeqNo));
                liveCommitData.put("local_checkpoint", Long.toString(maxSeqNo));
                liveCommitData.put("max_unsafe_auto_id_timestamp", Long.toString(maxUnsafeAutoIdTimestamp));
                return liveCommitData.entrySet().iterator();
            });
            writer.commit();
        }
    }

    boolean recoverFromRepository(IndexShard indexShard, Repository repository) {
        if (this.canRecover(indexShard)) {
            RecoverySource.Type recoveryType = indexShard.recoveryState().getRecoverySource().getType();
            assert (recoveryType == RecoverySource.Type.SNAPSHOT) : "expected snapshot recovery type: " + (Object)((Object)recoveryType);
            RecoverySource.SnapshotRecoverySource recoverySource = (RecoverySource.SnapshotRecoverySource)indexShard.recoveryState().getRecoverySource();
            return this.executeRecovery(indexShard, () -> {
                this.logger.debug("restoring from {} ...", (Object)indexShard.recoveryState().getRecoverySource());
                this.restore(indexShard, repository, recoverySource);
            });
        }
        return false;
    }

    private boolean canRecover(IndexShard indexShard) {
        if (indexShard.state() == IndexShardState.CLOSED) {
            return false;
        }
        if (!indexShard.routingEntry().primary()) {
            throw new IndexShardRecoveryException(this.shardId, "Trying to recover when the shard is in backup state", null);
        }
        return true;
    }

    private boolean executeRecovery(IndexShard indexShard, Runnable recoveryRunnable) throws IndexShardRecoveryException {
        try {
            recoveryRunnable.run();
            IndexShardState shardState = indexShard.state();
            RecoveryState recoveryState = indexShard.recoveryState();
            assert (shardState != IndexShardState.CREATED && shardState != IndexShardState.RECOVERING) : "recovery process of " + this.shardId + " didn't get to post_recovery. shardState [" + (Object)((Object)shardState) + "]";
            if (this.logger.isTraceEnabled()) {
                RecoveryState.Index index = recoveryState.getIndex();
                StringBuilder sb = new StringBuilder();
                sb.append("    index    : files           [").append(index.totalFileCount()).append("] with total_size [").append(new ByteSizeValue(index.totalBytes())).append("], took[").append(TimeValue.timeValueMillis((long)index.time())).append("]\n");
                sb.append("             : recovered_files [").append(index.recoveredFileCount()).append("] with total_size [").append(new ByteSizeValue(index.recoveredBytes())).append("]\n");
                sb.append("             : reusing_files   [").append(index.reusedFileCount()).append("] with total_size [").append(new ByteSizeValue(index.reusedBytes())).append("]\n");
                sb.append("    verify_index    : took [").append(TimeValue.timeValueMillis((long)recoveryState.getVerifyIndex().time())).append("], check_index [").append(TimeValue.timeValueMillis((long)recoveryState.getVerifyIndex().checkIndexTime())).append("]\n");
                sb.append("    translog : number_of_operations [").append(recoveryState.getTranslog().recoveredOperations()).append("], took [").append(TimeValue.timeValueMillis((long)recoveryState.getTranslog().time())).append("]");
                this.logger.trace("recovery completed from [shard_store], took [{}]\n{}", (Object)TimeValue.timeValueMillis((long)recoveryState.getTimer().time()), (Object)sb);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("recovery completed from [shard_store], took [{}]", (Object)TimeValue.timeValueMillis((long)recoveryState.getTimer().time()));
            }
            return true;
        }
        catch (IndexShardRecoveryException e) {
            if (indexShard.state() == IndexShardState.CLOSED) {
                return false;
            }
            if (e.getCause() instanceof IndexShardClosedException || e.getCause() instanceof IndexShardNotStartedException) {
                return false;
            }
            throw e;
        }
        catch (IndexShardClosedException | IndexShardNotStartedException e) {
        }
        catch (Exception e) {
            if (indexShard.state() == IndexShardState.CLOSED) {
                return false;
            }
            throw new IndexShardRecoveryException(this.shardId, "failed recovery", e);
        }
        return false;
    }

    private void internalRecoverFromStore(IndexShard indexShard) throws IndexShardRecoveryException {
        RecoveryState recoveryState = indexShard.recoveryState();
        boolean indexShouldExists = recoveryState.getRecoverySource().getType() != RecoverySource.Type.EMPTY_STORE;
        indexShard.prepareForIndexRecovery();
        long version = -1L;
        SegmentInfos si = null;
        Store store = indexShard.store();
        store.incRef();
        try {
            try {
                block24: {
                    store.failIfCorrupted();
                    try {
                        si = store.readLastCommittedSegmentsInfo();
                    }
                    catch (Exception e) {
                        String files = "_unknown_";
                        try {
                            files = Arrays.toString(store.directory().listAll());
                        }
                        catch (Exception inner) {
                            inner.addSuppressed(e);
                            files = files + " (failure=" + ExceptionsHelper.detailedMessage(inner) + ")";
                        }
                        if (!indexShouldExists) break block24;
                        throw new IndexShardRecoveryException(this.shardId, "shard allocated for local recovery (post api), should exist, but doesn't, current files: " + files, e);
                    }
                }
                if (si != null) {
                    if (indexShouldExists) {
                        version = si.getVersion();
                    } else {
                        this.logger.trace("cleaning existing shard, shouldn't exists");
                        Lucene.cleanLuceneIndex(store.directory());
                        si = null;
                    }
                }
            }
            catch (Exception e) {
                throw new IndexShardRecoveryException(this.shardId, "failed to fetch index version after copying it over", e);
            }
            recoveryState.getIndex().updateVersion(version);
            if (recoveryState.getRecoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) {
                assert (indexShouldExists);
                store.bootstrapNewHistory();
                SegmentInfos segmentInfos = store.readLastCommittedSegmentsInfo();
                long localCheckpoint = Long.parseLong((String)segmentInfos.userData.get("local_checkpoint"));
                String translogUUID = Translog.createEmptyTranslog(indexShard.shardPath().resolveTranslog(), localCheckpoint, this.shardId, indexShard.getPendingPrimaryTerm());
                store.associateIndexWithNewTranslog(translogUUID);
                StoreRecovery.writeEmptyRetentionLeasesFile(indexShard);
            } else if (indexShouldExists) {
                if (recoveryState.getRecoverySource().shouldBootstrapNewHistoryUUID()) {
                    store.bootstrapNewHistory();
                    StoreRecovery.writeEmptyRetentionLeasesFile(indexShard);
                }
                if (indexShard.indexSettings().getIndexVersionCreated().before(Version.V_6_0_0_rc1) && store.ensureIndexHas6xCommitTags()) {
                    si = store.readLastCommittedSegmentsInfo();
                }
                try {
                    RecoveryState.Index index = recoveryState.getIndex();
                    if (si != null) {
                        this.addRecoveredFileDetails(si, store, index);
                    }
                }
                catch (IOException e) {
                    this.logger.debug("failed to list file details", (Throwable)e);
                }
            } else {
                store.createEmpty();
                String translogUUID = Translog.createEmptyTranslog(indexShard.shardPath().resolveTranslog(), -1L, this.shardId, indexShard.getPendingPrimaryTerm());
                store.associateIndexWithNewTranslog(translogUUID);
                StoreRecovery.writeEmptyRetentionLeasesFile(indexShard);
            }
            indexShard.openEngineAndRecoverFromTranslog();
            indexShard.getEngine().fillSeqNoGaps(indexShard.getPendingPrimaryTerm());
            indexShard.finalizeRecovery();
            indexShard.postRecovery("post recovery from shard_store");
        }
        catch (IOException | EngineException e) {
            throw new IndexShardRecoveryException(this.shardId, "failed to recover from gateway", e);
        }
        finally {
            store.decRef();
        }
    }

    private static void writeEmptyRetentionLeasesFile(IndexShard indexShard) throws IOException {
        assert (indexShard.getRetentionLeases().leases().isEmpty()) : indexShard.getRetentionLeases();
        indexShard.persistRetentionLeases();
        assert (indexShard.loadRetentionLeases().leases().isEmpty());
    }

    private void addRecoveredFileDetails(SegmentInfos si, Store store, RecoveryState.Index index) throws IOException {
        Directory directory = store.directory();
        for (String name : Lucene.files(si)) {
            long length = directory.fileLength(name);
            index.addFileDetail(name, length, true);
        }
    }

    private void restore(IndexShard indexShard, Repository repository, RecoverySource.SnapshotRecoverySource restoreSource) {
        RecoveryState.Translog translogState = indexShard.recoveryState().getTranslog();
        if (restoreSource == null) {
            throw new IndexShardRestoreFailedException(this.shardId, "empty restore source");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] restoring shard [{}]", (Object)restoreSource.snapshot(), (Object)this.shardId);
        }
        try {
            translogState.totalOperations(0);
            translogState.totalOperationsOnStart(0);
            indexShard.prepareForIndexRecovery();
            ShardId snapshotShardId = this.shardId;
            String indexName = restoreSource.index();
            if (!this.shardId.getIndexName().equals(indexName)) {
                snapshotShardId = new ShardId(indexName, "_na_", this.shardId.id());
            }
            IndexId indexId = repository.getRepositoryData().resolveIndexId(indexName);
            repository.restoreShard(indexShard, restoreSource.snapshot().getSnapshotId(), restoreSource.version(), indexId, snapshotShardId, indexShard.recoveryState());
            Store store = indexShard.store();
            store.bootstrapNewHistory();
            SegmentInfos segmentInfos = store.readLastCommittedSegmentsInfo();
            long localCheckpoint = Long.parseLong((String)segmentInfos.userData.get("local_checkpoint"));
            String translogUUID = Translog.createEmptyTranslog(indexShard.shardPath().resolveTranslog(), localCheckpoint, this.shardId, indexShard.getPendingPrimaryTerm());
            store.associateIndexWithNewTranslog(translogUUID);
            assert (indexShard.shardRouting.primary()) : "only primary shards can recover from store";
            StoreRecovery.writeEmptyRetentionLeasesFile(indexShard);
            indexShard.openEngineAndRecoverFromTranslog();
            indexShard.getEngine().fillSeqNoGaps(indexShard.getPendingPrimaryTerm());
            indexShard.finalizeRecovery();
            indexShard.postRecovery("restore done");
        }
        catch (Exception e) {
            throw new IndexShardRestoreFailedException(this.shardId, "restore failed", e);
        }
    }

    static final class StatsDirectoryWrapper
    extends FilterDirectory {
        private final RecoveryState.Index index;

        StatsDirectoryWrapper(Directory in, RecoveryState.Index indexRecoveryStats) {
            super(in);
            this.index = indexRecoveryStats;
        }

        public void copyFrom(Directory from, String src, final String dest, IOContext context) throws IOException {
            final long l = from.fileLength(src);
            final AtomicBoolean copies = new AtomicBoolean(false);
            this.in.copyFrom((Directory)new FilterDirectory(from){

                public IndexInput openInput(String name, IOContext context) throws IOException {
                    index.addFileDetail(dest, l, false);
                    copies.set(true);
                    final IndexInput input = this.in.openInput(name, context);
                    return new IndexInput("StatsDirectoryWrapper(" + input.toString() + ")"){

                        public void close() throws IOException {
                            input.close();
                        }

                        public long getFilePointer() {
                            throw new UnsupportedOperationException("only straight copies are supported");
                        }

                        public void seek(long pos) throws IOException {
                            throw new UnsupportedOperationException("seeks are not supported");
                        }

                        public long length() {
                            return input.length();
                        }

                        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
                            throw new UnsupportedOperationException("slices are not supported");
                        }

                        public byte readByte() throws IOException {
                            throw new UnsupportedOperationException("use a buffer if you wanna perform well");
                        }

                        public void readBytes(byte[] b, int offset, int len) throws IOException {
                            input.readBytes(b, offset, len);
                            index.addRecoveredBytesToFile(dest, len);
                        }
                    };
                }
            }, src, dest, context);
            if (!copies.get()) {
                this.index.addFileDetail(dest, l, true);
            } else {
                assert (this.index.getFileDetails(dest) != null) : "File [" + dest + "] has no file details";
                assert (this.index.getFileDetails(dest).recovered() == l) : this.index.getFileDetails(dest).toString();
            }
        }

        public Set<String> getPendingDeletions() throws IOException {
            return this.in.getPendingDeletions();
        }
    }
}

