/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Extensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class LDAPResult
implements Serializable,
LDAPResponse {
    static final byte TYPE_REFERRAL_URLS = -93;
    private static final long serialVersionUID = 2215819095653175991L;
    private final Byte protocolOpType;
    private final Control[] responseControls;
    private final int messageID;
    private final ResultCode resultCode;
    private final String diagnosticMessage;
    private final String matchedDN;
    private final String[] referralURLs;

    protected LDAPResult(LDAPResult result) {
        this.protocolOpType = result.protocolOpType;
        this.messageID = result.messageID;
        this.resultCode = result.resultCode;
        this.diagnosticMessage = result.diagnosticMessage;
        this.matchedDN = result.matchedDN;
        this.referralURLs = result.referralURLs;
        this.responseControls = result.responseControls;
    }

    public LDAPResult(int messageID, ResultCode resultCode) {
        this(null, messageID, resultCode, null, null, StaticUtils.NO_STRINGS, NO_CONTROLS);
    }

    public LDAPResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, Control[] responseControls) {
        this(null, messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, responseControls);
    }

    public LDAPResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, List<String> referralURLs, List<Control> responseControls) {
        this(null, messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, responseControls);
    }

    private LDAPResult(Byte protocolOpType, int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, Control[] responseControls) {
        this.protocolOpType = protocolOpType;
        this.messageID = messageID;
        this.resultCode = resultCode;
        this.diagnosticMessage = diagnosticMessage;
        this.matchedDN = matchedDN;
        this.referralURLs = referralURLs == null ? StaticUtils.NO_STRINGS : referralURLs;
        this.responseControls = responseControls == null ? NO_CONTROLS : responseControls;
    }

    private LDAPResult(Byte protocolOpType, int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, List<String> referralURLs, List<Control> responseControls) {
        this.protocolOpType = protocolOpType;
        this.messageID = messageID;
        this.resultCode = resultCode;
        this.diagnosticMessage = diagnosticMessage;
        this.matchedDN = matchedDN;
        if (referralURLs == null || referralURLs.isEmpty()) {
            this.referralURLs = StaticUtils.NO_STRINGS;
        } else {
            this.referralURLs = new String[referralURLs.size()];
            referralURLs.toArray(this.referralURLs);
        }
        if (responseControls == null || responseControls.isEmpty()) {
            this.responseControls = NO_CONTROLS;
        } else {
            this.responseControls = new Control[responseControls.size()];
            responseControls.toArray(this.responseControls);
        }
    }

    static LDAPResult readLDAPResultFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        try {
            String diagnosticMessage;
            ASN1StreamReaderSequence protocolOpSequence = reader.beginSequence();
            byte protocolOpType = protocolOpSequence.getType();
            ResultCode resultCode = ResultCode.valueOf(reader.readEnumerated());
            String matchedDN = reader.readString();
            if (matchedDN.isEmpty()) {
                matchedDN = null;
            }
            if ((diagnosticMessage = reader.readString()).isEmpty()) {
                diagnosticMessage = null;
            }
            String[] referralURLs = StaticUtils.NO_STRINGS;
            if (protocolOpSequence.hasMoreElements()) {
                ArrayList<String> refList = new ArrayList<String>(1);
                ASN1StreamReaderSequence refSequence = reader.beginSequence();
                while (refSequence.hasMoreElements()) {
                    refList.add(reader.readString());
                }
                referralURLs = new String[refList.size()];
                refList.toArray(referralURLs);
            }
            Control[] responseControls = NO_CONTROLS;
            if (messageSequence.hasMoreElements()) {
                ArrayList<Control> controlList = new ArrayList<Control>(1);
                ASN1StreamReaderSequence controlSequence = reader.beginSequence();
                while (controlSequence.hasMoreElements()) {
                    controlList.add(Control.readFrom(reader));
                }
                responseControls = new Control[controlList.size()];
                controlList.toArray(responseControls);
            }
            return new LDAPResult((Byte)protocolOpType, messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, responseControls);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_RESULT_CANNOT_DECODE.get(ae.getMessage()), ae);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_RESULT_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public final int getMessageID() {
        return this.messageID;
    }

    public final ResultCode getResultCode() {
        return this.resultCode;
    }

    public final String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    public final String getMatchedDN() {
        return this.matchedDN;
    }

    public final String[] getReferralURLs() {
        return this.referralURLs;
    }

    public final Control[] getResponseControls() {
        return this.responseControls;
    }

    public final boolean hasResponseControl() {
        return this.responseControls.length > 0;
    }

    public final boolean hasResponseControl(String oid) {
        for (Control c : this.responseControls) {
            if (!c.getOID().equals(oid)) continue;
            return true;
        }
        return false;
    }

    public final Control getResponseControl(String oid) {
        for (Control c : this.responseControls) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        return null;
    }

    public String getResultString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("result code='");
        buffer.append(this.resultCode);
        buffer.append('\'');
        if (this.diagnosticMessage != null && !this.diagnosticMessage.isEmpty()) {
            buffer.append(" diagnostic message='");
            buffer.append(this.diagnosticMessage);
            buffer.append('\'');
        }
        if (this.matchedDN != null && !this.matchedDN.isEmpty()) {
            buffer.append("  matched DN='");
            buffer.append(this.matchedDN);
            buffer.append('\'');
        }
        if (this.referralURLs != null && this.referralURLs.length > 0) {
            buffer.append("  referral URLs={");
            for (int i = 0; i < this.referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(this.referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        int i;
        buffer.append("LDAPResult(resultCode=");
        buffer.append(this.resultCode);
        if (this.messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(this.messageID);
        }
        if (this.protocolOpType != null) {
            switch (this.protocolOpType) {
                case 105: {
                    buffer.append(", opType='add'");
                    break;
                }
                case 97: {
                    buffer.append(", opType='bind'");
                    break;
                }
                case 111: {
                    buffer.append(", opType='compare'");
                    break;
                }
                case 107: {
                    buffer.append(", opType='delete'");
                    break;
                }
                case 120: {
                    buffer.append(", opType='extended'");
                    break;
                }
                case 103: {
                    buffer.append(", opType='modify'");
                    break;
                }
                case 109: {
                    buffer.append(", opType='modify DN'");
                    break;
                }
                case 101: {
                    buffer.append(", opType='search'");
                }
            }
        }
        if (this.diagnosticMessage != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(this.diagnosticMessage);
            buffer.append('\'');
        }
        if (this.matchedDN != null) {
            buffer.append(", matchedDN='");
            buffer.append(this.matchedDN);
            buffer.append('\'');
        }
        if (this.referralURLs.length > 0) {
            buffer.append(", referralURLs={");
            for (i = 0; i < this.referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(this.referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if (this.responseControls.length > 0) {
            buffer.append(", responseControls={");
            for (i = 0; i < this.responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

