/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.attribute.AttributeSignature;
import jd.core.model.classfile.constant.Constant;
import jd.core.model.classfile.constant.ConstantFieldref;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokespecial;
import jd.core.model.instruction.bytecode.instruction.Invokevirtual;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.fast.instruction.FastLabel;
import jd.core.model.reference.ReferenceMap;
import jd.core.process.analyzer.classfile.AccessorAnalyzer;
import jd.core.process.analyzer.classfile.FieldNameGenerator;
import jd.core.process.analyzer.classfile.LocalVariableAnalyzer;
import jd.core.process.analyzer.classfile.reconstructor.AssignmentInstructionReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.DotClass118AReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.DotClass14Reconstructor;
import jd.core.process.analyzer.classfile.reconstructor.DupStoreThisReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.InitDexEnumFieldsReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.InitInstanceFieldsReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.InitStaticFieldsReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.NewInstructionReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.OuterReferenceReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.PostIncReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.PreIncReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.SimpleNewInstructionReconstructor;
import jd.core.process.analyzer.classfile.visitor.CheckCastAndConvertInstructionVisitor;
import jd.core.process.analyzer.classfile.visitor.ReplaceStringBuxxxerVisitor;
import jd.core.process.analyzer.classfile.visitor.SetConstantTypeInStringIndexOfMethodsVisitor;
import jd.core.process.analyzer.instruction.bytecode.InstructionListBuilder;
import jd.core.process.analyzer.instruction.fast.DupLocalVariableAnalyzer;
import jd.core.process.analyzer.instruction.fast.FastInstructionListBuilder;
import jd.core.process.analyzer.instruction.fast.ReturnLineNumberAnalyzer;
import jd.core.process.analyzer.variable.DefaultVariableNameGenerator;
import jd.core.util.SignatureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFileAnalyzer {
    public static void Analyze(ReferenceMap referenceMap, ClassFile classFile) {
        HashMap<String, ClassFile> innerClassesMap;
        if (classFile.getInnerClassFiles() != null) {
            innerClassesMap = new HashMap<String, ClassFile>(10);
            innerClassesMap.put(classFile.getThisClassName(), classFile);
            ClassFileAnalyzer.PopulateInnerClassMap(innerClassesMap, classFile);
        } else {
            innerClassesMap = null;
        }
        ClassFileAnalyzer.AnalyzeClass(referenceMap, innerClassesMap, classFile);
    }

    private static void PopulateInnerClassMap(HashMap<String, ClassFile> innerClassesMap, ClassFile classFile) {
        ArrayList<ClassFile> innerClassFiles = classFile.getInnerClassFiles();
        if (innerClassFiles != null) {
            int length = innerClassFiles.size();
            int i = 0;
            while (i < length) {
                ClassFile innerClassFile = innerClassFiles.get(i);
                innerClassesMap.put(innerClassFile.getThisClassName(), innerClassFile);
                ClassFileAnalyzer.PopulateInnerClassMap(innerClassesMap, innerClassFile);
                ++i;
            }
        }
    }

    private static void AnalyzeClass(ReferenceMap referenceMap, HashMap<String, ClassFile> innerClassesMap, ClassFile classFile) {
        if ((classFile.access_flags & 0x1000) != 0) {
            ClassFileAnalyzer.AnalyzeSyntheticClass(classFile);
        } else {
            HashMap<Integer, List<Instruction>> eclipseSwitchMaps = new HashMap<Integer, List<Instruction>>();
            ClassFileAnalyzer.PreAnalyzeMethods(eclipseSwitchMaps, classFile);
            ArrayList<ClassFile> innerClassFiles = classFile.getInnerClassFiles();
            if (innerClassFiles != null) {
                int length = innerClassFiles.size();
                int i = 0;
                while (i < length) {
                    ClassFileAnalyzer.AnalyzeClass(referenceMap, innerClassesMap, innerClassFiles.get(i));
                    ++i;
                }
            }
            ClassFileAnalyzer.CheckUnicityOfFieldNames(classFile);
            ClassFileAnalyzer.CheckUnicityOfFieldrefNames(classFile);
            ClassFileAnalyzer.AnalyzeMethods(referenceMap, innerClassesMap, classFile);
            ClassFileAnalyzer.CheckAssertionsDisabledField(classFile);
            if ((classFile.access_flags & 0x4000) != 0) {
                ClassFileAnalyzer.AnalyzeEnum(classFile);
            }
        }
    }

    private static void AnalyzeSyntheticClass(ClassFile classFile) {
        if ((classFile.access_flags & 8) != 0 && classFile.getOuterClass() != null && classFile.getInternalAnonymousClassName() != null && classFile.getFields() != null && classFile.getMethods() != null && classFile.getFields().length > 0 && classFile.getMethods().length == 1 && (classFile.getMethods()[0].access_flags & 0x101F) == 8) {
            ClassFile outerClassFile = classFile.getOuterClass();
            ConstantPool outerConstants = outerClassFile.getConstantPool();
            ConstantPool constants = classFile.getConstantPool();
            Method method = classFile.getMethods()[0];
            try {
                ClassFileAnalyzer.AnalyzeMethodref(classFile);
                ArrayList<Instruction> list = new ArrayList<Instruction>();
                ArrayList<Instruction> listForAnalyze = new ArrayList<Instruction>();
                InstructionListBuilder.Build(classFile, method, list, listForAnalyze);
                int length = list.size();
                int index = 0;
                while (index < length) {
                    if (((Instruction)list.get((int)index)).opcode == 179) {
                        String fieldName;
                        ConstantNameAndType cnat;
                        Field field;
                        PutStatic ps = (PutStatic)list.get(index);
                        ConstantFieldref cfr = constants.getConstantFieldref(ps.index);
                        if (cfr.class_index == classFile.getThisClassIndex() && (field = ClassFileAnalyzer.SearchField(classFile, cnat = constants.getConstantNameAndType(cfr.name_and_type_index))) != null && (field.access_flags & 0x101F) == 4120 && (fieldName = constants.getConstantUtf8(cnat.name_index)).startsWith("$SwitchMap$")) {
                            ArrayList<Integer> enumNameIndexes = new ArrayList<Integer>();
                            index += 3;
                            while (index < length) {
                                Instruction instruction = (Instruction)list.get(index - 2);
                                if (instruction.opcode != 272 || ((Instruction)list.get((int)(index - 1))).opcode != 167 || ((Instruction)list.get((int)index)).opcode != 58) break;
                                instruction = ((ArrayStoreInstruction)instruction).indexref;
                                if (instruction.opcode != 182) break;
                                instruction = ((Invokevirtual)instruction).objectref;
                                if (instruction.opcode != 178) break;
                                cfr = constants.getConstantFieldref(((GetStatic)instruction).index);
                                cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
                                String enumName = constants.getConstantUtf8(cnat.name_index);
                                int outerEnumNameIndex = outerConstants.addConstantUtf8(enumName);
                                enumNameIndexes.add(outerEnumNameIndex);
                                index += 3;
                            }
                            int outerFieldNameIndex = outerConstants.addConstantUtf8(fieldName);
                            outerClassFile.getSwitchMaps().put(outerFieldNameIndex, enumNameIndexes);
                            index -= 3;
                            ++index;
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                method.setContainsError(true);
            }
        }
    }

    private static Field SearchField(ClassFile classFile, ConstantNameAndType cnat) {
        Field[] fields = classFile.getFields();
        int i = fields.length;
        while (i-- > 0) {
            Field field = fields[i];
            if (field.name_index != cnat.name_index || field.descriptor_index != cnat.descriptor_index) continue;
            return field;
        }
        return null;
    }

    private static void AnalyzeMethodref(ClassFile classFile) {
        ConstantPool constants = classFile.getConstantPool();
        int i = constants.size() - 1;
        while (i >= 0) {
            Constant constant = constants.get(i);
            if (constant != null && (constant.tag == 10 || constant.tag == 11)) {
                ConstantMethodref cmr = (ConstantMethodref)constant;
                ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.name_and_type_index);
                if (cnat != null) {
                    String signature = constants.getConstantUtf8(cnat.descriptor_index);
                    cmr.setParameterSignatures(SignatureUtil.GetParameterSignatures(signature));
                    cmr.setReturnedSignature(SignatureUtil.GetMethodReturnedSignature(signature));
                }
            }
            --i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void CheckUnicityOfFieldNames(ClassFile classFile) {
        fields = classFile.getFields();
        if (fields == null) {
            return;
        }
        constants = classFile.getConstantPool();
        map = new HashMap<String, ArrayList<Field>>();
        i = fields.length;
        while (i-- > 0) {
            field = fields[i];
            if ((field.access_flags & 5) != 0) continue;
            name = constants.getConstantUtf8(field.name_index);
            list = (ArrayList)map.get(name);
            if (list == null) {
                list = new ArrayList(5);
                map.put(name, list);
            }
            list.add(field);
        }
        for (String name : map.keySet()) {
            list = (ArrayList)map.get(name);
            j = list.size();
            if (j >= 2) ** GOTO lbl27
            continue;
lbl-1000:
            // 1 sources

            {
                field = (Field)list.get(j);
                newName = FieldNameGenerator.GenerateName(constants.getConstantUtf8(field.descriptor_index), constants.getConstantUtf8(field.name_index));
                field.name_index = newNameIndex = constants.addConstantUtf8(newName);
lbl27:
                // 2 sources

                ** while (j-- > 0)
            }
lbl28:
            // 1 sources

        }
    }

    /*
     * Unable to fully structure code
     */
    private static void CheckUnicityOfFieldrefNames(ClassFile classFile) {
        constants = classFile.getConstantPool();
        i = constants.size();
        array = new Object[i];
        while (i-- > 0) {
            constant = constants.get(i);
            if (constant == null || constant.tag != 9) continue;
            cfr = (ConstantFieldref)constant;
            map = (HashMap<String, ArrayList<E>>)array[cfr.class_index];
            if (map == null) {
                array[cfr.class_index] = map = new HashMap<String, ArrayList<E>>();
            }
            cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
            name = constants.getConstantUtf8(cnat.name_index);
            list = (ArrayList<ConstantNameAndType>)map.get(name);
            if (list != null) {
                if (((ConstantNameAndType)list.get((int)0)).descriptor_index == cnat.descriptor_index) continue;
                list.add(cnat);
                continue;
            }
            list = new ArrayList<ConstantNameAndType>(5);
            map.put(name, list);
            list.add(cnat);
        }
        i = array.length;
        while (i-- > 0) {
            if (array[i] == null) continue;
            map = (HashMap)array[i];
            for (String name : map.keySet()) {
                list = (ArrayList)map.get(name);
                k = list.size();
                if (k >= 2) ** GOTO lbl38
                continue;
lbl-1000:
                // 1 sources

                {
                    cnat = (ConstantNameAndType)list.get(k);
                    signature = constants.getConstantUtf8(cnat.descriptor_index);
                    newName = FieldNameGenerator.GenerateName(signature, name);
                    cnat.name_index = constants.addConstantUtf8(newName);
lbl38:
                    // 2 sources

                    ** while (k-- > 0)
                }
lbl39:
                // 1 sources

            }
        }
    }

    private static void CheckAssertionsDisabledField(ClassFile classFile) {
        ConstantPool constants = classFile.getConstantPool();
        Field[] fields = classFile.getFields();
        if (fields == null) {
            return;
        }
        int i = fields.length;
        while (i-- > 0) {
            String name;
            Field field = fields[i];
            if ((field.access_flags & 0x101F) != 24 || field.getValueAndMethod() == null || !(name = constants.getConstantUtf8(field.name_index)).equals("$assertionsDisabled")) continue;
            field.access_flags |= 0x1000;
        }
    }

    private static boolean HasAAccessorMethodName(ClassFile classFile, Method method) {
        String methodName = classFile.getConstantPool().getConstantUtf8(method.name_index);
        if (!methodName.startsWith("access$")) {
            return false;
        }
        int i = methodName.length();
        while (i-- > "access$".length()) {
            if (Character.isDigit(methodName.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean HasAEclipseSwitchTableMethodName(ClassFile classFile, Method method) {
        String methodName = classFile.getConstantPool().getConstantUtf8(method.name_index);
        if (!methodName.startsWith("$SWITCH_TABLE$")) {
            return false;
        }
        String methodDescriptor = classFile.getConstantPool().getConstantUtf8(method.descriptor_index);
        return methodDescriptor.equals("()[I");
    }

    private static void ParseEclipseOrDexSwitchTableMethod(ClassFile classFile, Method method) {
        List<Instruction> list = method.getInstructions();
        int length = list.size();
        if (length >= 6 && list.get((int)0).opcode == 264 && list.get((int)1).opcode == 262 && list.get((int)2).opcode == 273 && list.get((int)3).opcode == 87 && list.get((int)4).opcode == 58) {
            ConstantPool constants = classFile.getConstantPool();
            ArrayList<Integer> enumNameIndexes = new ArrayList<Integer>();
            int index = 7;
            while (index < length) {
                Instruction instruction = list.get(index - 2);
                if (instruction.opcode != 272 || list.get((int)(index - 1)).opcode != 167 || list.get((int)index).opcode != 87) break;
                instruction = ((ArrayStoreInstruction)instruction).indexref;
                if (instruction.opcode != 182) break;
                instruction = ((Invokevirtual)instruction).objectref;
                if (instruction.opcode != 178) break;
                ConstantFieldref cfr = constants.getConstantFieldref(((GetStatic)instruction).index);
                ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
                enumNameIndexes.add(cnat.name_index);
                index += 3;
            }
            classFile.getSwitchMaps().put(method.name_index, enumNameIndexes);
        } else if (length >= 7 && list.get((int)0).opcode == 58 && list.get((int)1).opcode == 262 && list.get((int)2).opcode == 273 && list.get((int)3).opcode == 58 && list.get((int)4).opcode == 272) {
            ConstantPool constants = classFile.getConstantPool();
            ArrayList<Integer> enumNameIndexes = new ArrayList<Integer>();
            int index = 4;
            while (index < length) {
                Instruction instruction = list.get(index);
                if (instruction.opcode != 272) break;
                instruction = ((ArrayStoreInstruction)instruction).indexref;
                if (instruction.opcode != 182) break;
                instruction = ((Invokevirtual)instruction).objectref;
                if (instruction.opcode != 178) break;
                ConstantFieldref cfr = constants.getConstantFieldref(((GetStatic)instruction).index);
                ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
                enumNameIndexes.add(cnat.name_index);
                ++index;
            }
            classFile.getSwitchMaps().put(method.name_index, enumNameIndexes);
        }
    }

    private static void PreAnalyzeMethods(HashMap<Integer, List<Instruction>> eclipseSwitchMaps, ClassFile classFile) {
        ClassFileAnalyzer.AnalyzeMethodref(classFile);
        Method[] methods = classFile.getMethods();
        if (methods == null) {
            return;
        }
        int length = methods.length;
        DefaultVariableNameGenerator variableNameGenerator = new DefaultVariableNameGenerator(classFile);
        int outerThisFieldrefIndex = 0;
        int i = 0;
        while (i < length) {
            Method method = methods[i];
            try {
                if (method.getCode() == null) {
                    if ((method.access_flags & 0x1040) == 0) {
                        LocalVariableAnalyzer.Analyze(classFile, method, variableNameGenerator, null, null);
                    }
                } else {
                    ArrayList<Instruction> list = new ArrayList<Instruction>();
                    ArrayList<Instruction> listForAnalyze = new ArrayList<Instruction>();
                    InstructionListBuilder.Build(classFile, method, list, listForAnalyze);
                    method.setInstructions(list);
                    if ((method.access_flags & 0xF) == 8 && ClassFileAnalyzer.HasAAccessorMethodName(classFile, method)) {
                        AccessorAnalyzer.Analyze(classFile, method);
                        method.access_flags |= 0x1000;
                    } else if ((method.access_flags & 0x1040) == 0) {
                        LocalVariableAnalyzer.Analyze(classFile, method, variableNameGenerator, list, listForAnalyze);
                        outerThisFieldrefIndex = ClassFileAnalyzer.SearchOuterThisFieldrefIndex(classFile, method, list, outerThisFieldrefIndex);
                    } else if ((method.access_flags & 0x100F) == 4104 && ClassFileAnalyzer.HasAEclipseSwitchTableMethodName(classFile, method)) {
                        ClassFileAnalyzer.ParseEclipseOrDexSwitchTableMethod(classFile, method);
                    }
                }
            }
            catch (Exception e) {
                method.setContainsError(true);
            }
            ++i;
        }
        if (outerThisFieldrefIndex != 0) {
            ClassFileAnalyzer.AnalyzeOuterReferences(classFile, outerThisFieldrefIndex);
        }
    }

    private static void AnalyzeMethods(ReferenceMap referenceMap, HashMap<String, ClassFile> innerClassesMap, ClassFile classFile) {
        Method method;
        Method[] methods = classFile.getMethods();
        if (methods == null) {
            return;
        }
        int length = methods.length;
        OuterReferenceReconstructor outerReferenceReconstructor = innerClassesMap != null ? new OuterReferenceReconstructor(innerClassesMap, classFile) : null;
        int i = 0;
        while (i < length) {
            method = methods[i];
            if ((method.access_flags & 0x1040) == 0 && method.getCode() != null && !method.containsError()) {
                try {
                    List<Instruction> list = method.getInstructions();
                    if (outerReferenceReconstructor != null) {
                        outerReferenceReconstructor.reconstruct(method, list);
                    }
                    NewInstructionReconstructor.Reconstruct(classFile, method, list);
                    SimpleNewInstructionReconstructor.Reconstruct(classFile, method, list);
                    PreIncReconstructor.Reconstruct(list);
                    PostIncReconstructor.Reconstruct(list);
                    DotClass118AReconstructor.Reconstruct(referenceMap, classFile, list);
                    DotClass14Reconstructor.Reconstruct(referenceMap, classFile, list);
                    ClassFileAnalyzer.ReplaceStringBufferAndStringBuilder(classFile, list);
                    ClassFileAnalyzer.RemoveUnusedPopInstruction(list);
                    ClassFileAnalyzer.TransformTestOnLongOrDouble(list);
                    ClassFileAnalyzer.SetConstantTypeInStringIndexOfMethods(classFile, list);
                    DupStoreThisReconstructor.Reconstruct(list);
                    AssignmentInstructionReconstructor.Reconstruct(list);
                    CheckCastAndConvertInstructionVisitor.visit(classFile.getConstantPool(), list);
                    ArrayList<Instruction> fastList = new ArrayList<Instruction>(list);
                    method.setFastNodes(fastList);
                    FastInstructionListBuilder.Build(referenceMap, classFile, method, fastList);
                    DupLocalVariableAnalyzer.Declare(classFile, method, fastList);
                }
                catch (Exception e) {
                    method.setContainsError(true);
                }
            }
            ++i;
        }
        InitDexEnumFieldsReconstructor.Reconstruct(classFile);
        InitStaticFieldsReconstructor.Reconstruct(classFile);
        InitInstanceFieldsReconstructor.Reconstruct(classFile);
        i = 0;
        while (i < length) {
            method = methods[i];
            if ((method.access_flags & 0x1040) == 0 && method.getCode() != null && method.getFastNodes() != null && !method.containsError()) {
                try {
                    ClassFileAnalyzer.AnalyseAndModifyConstructors(classFile, method);
                    ReturnLineNumberAnalyzer.Check(method);
                    ClassFileAnalyzer.RemoveLastReturnInstruction(method);
                }
                catch (Exception e) {
                    method.setContainsError(true);
                }
            }
            ++i;
        }
    }

    private static int SearchOuterThisFieldrefIndex(ClassFile classFile, Method method, List<Instruction> list, int outerThisFieldrefIndex) {
        if (!classFile.isAInnerClass() || (classFile.access_flags & 8) != 0) {
            return 0;
        }
        ConstantPool constants = classFile.getConstantPool();
        if (method.name_index != constants.instanceConstructorIndex) {
            return outerThisFieldrefIndex;
        }
        AttributeSignature as = method.getAttributeSignature();
        String methodSignature = constants.getConstantUtf8(as == null ? method.descriptor_index : as.signature_index);
        if (methodSignature.charAt(1) == ')') {
            return 0;
        }
        int length = list.size();
        int i = 0;
        while (i < length) {
            Instruction instruction = list.get(i);
            if (instruction.opcode == 181) {
                PutField pf = (PutField)instruction;
                if (pf.objectref.opcode == 25 && pf.valueref.opcode == 25 && ((ALoad)pf.objectref).index == 0 && ((ALoad)pf.valueref).index == 1 && (outerThisFieldrefIndex == 0 || pf.index == outerThisFieldrefIndex)) {
                    return pf.index;
                }
            } else if (instruction.opcode == 183) {
                Invokespecial is = (Invokespecial)instruction;
                ConstantMethodref cmr = constants.getConstantMethodref(is.index);
                if (cmr.class_index == classFile.getThisClassIndex()) {
                    ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.name_and_type_index);
                    if (cnat.name_index == constants.instanceConstructorIndex) {
                        return outerThisFieldrefIndex;
                    }
                }
            }
            ++i;
        }
        return 0;
    }

    private static void AnalyzeOuterReferences(ClassFile classFile, int outerThisFieldrefIndex) {
        Method[] methods = classFile.getMethods();
        if (methods == null) {
            return;
        }
        int length = methods.length;
        ConstantPool constants = classFile.getConstantPool();
        ConstantFieldref cfr = constants.getConstantFieldref(outerThisFieldrefIndex);
        if (cfr.class_index == classFile.getThisClassIndex()) {
            ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
            Field[] fields = classFile.getFields();
            if (fields != null) {
                int i = fields.length - 1;
                while (i >= 0) {
                    Field field = fields[i];
                    if (field.name_index == cnat.name_index && field.descriptor_index == cnat.descriptor_index) {
                        classFile.setOuterThisField(field);
                        field.access_flags |= 0x1000;
                        break;
                    }
                    --i;
                }
            }
        }
        int i = 0;
        while (i < length) {
            List<Instruction> list;
            Method method = methods[i];
            if (method.getCode() != null && !method.containsError() && (list = method.getInstructions()) != null) {
                int listLength = list.size();
                if (method.name_index == constants.instanceConstructorIndex) {
                    int index = 0;
                    while (index < listLength) {
                        Instruction instruction = list.get(index);
                        if (instruction.opcode == 181 && ((PutField)instruction).index == outerThisFieldrefIndex) {
                            list.remove(index);
                            break;
                        }
                        ++index;
                    }
                } else if ((method.access_flags & 0x1008) == 8 && method.name_index != constants.classConstructorIndex && listLength == 1 && classFile.isAInnerClass()) {
                    Instruction instruction = list.get(0);
                    if (instruction.opcode == 273) {
                        instruction = ((ReturnInstruction)instruction).valueref;
                        if (instruction.opcode == 180) {
                            GetField gf = (GetField)instruction;
                            if (gf.objectref.opcode == 25 && ((ALoad)gf.objectref).index == 0) {
                                cfr = constants.getConstantFieldref(gf.index);
                                if (cfr.class_index == classFile.getThisClassIndex()) {
                                    ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
                                    Field outerField = classFile.getOuterThisField();
                                    if (cnat.descriptor_index == outerField.descriptor_index && cnat.name_index == outerField.name_index) {
                                        method.access_flags |= 0x1000;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    private static void AnalyseAndModifyConstructors(ClassFile classFile, Method method) {
        ConstantPool constants = classFile.getConstantPool();
        if (method.name_index == constants.instanceConstructorIndex) {
            List<Instruction> list = method.getFastNodes();
            while (list.size() > 0) {
                Instruction instruction = list.get(0);
                if (instruction.opcode == 183) {
                    Invokespecial is = (Invokespecial)instruction;
                    if (is.objectref.opcode == 25 && ((ALoad)is.objectref).index == 0) {
                        ConstantMethodref cmr = constants.getConstantMethodref(is.index);
                        ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.name_and_type_index);
                        if (cnat.name_index == constants.instanceConstructorIndex) {
                            if (cmr.class_index != classFile.getSuperClassIndex()) break;
                            int count = is.args.size();
                            method.setSuperConstructorParameterCount(count);
                            if ((classFile.access_flags & 0x4000) != 0) {
                                if (count != 2) break;
                                list.remove(0);
                                break;
                            }
                            if (count != 0) break;
                            list.remove(0);
                            break;
                        }
                    }
                } else if (instruction.opcode == 181) {
                    PutField pf = (PutField)instruction;
                    switch (pf.valueref.opcode) {
                        case 21: 
                        case 25: 
                        case 268: {
                            IndexInstruction ii = (IndexInstruction)pf.valueref;
                            if (ii.index <= 1) break;
                            ConstantFieldref cfr = constants.getConstantFieldref(pf.index);
                            ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
                            Field field = classFile.getField(cnat.name_index, cnat.descriptor_index);
                            field.anonymousClassConstructorParameterIndex = ii.index - 1;
                            field.access_flags |= 0x1000;
                        }
                    }
                }
                list.remove(0);
            }
        }
    }

    private static void RemoveLastReturnInstruction(Method method) {
        int length;
        List<Instruction> list = method.getFastNodes();
        if (list != null && (length = list.size()) > 0) {
            switch (list.get((int)(length - 1)).opcode) {
                case 177: {
                    list.remove(length - 1);
                    break;
                }
                case 320: {
                    FastLabel fl = (FastLabel)list.get(length - 1);
                    if (fl.instruction.opcode != 177) break;
                    fl.instruction = null;
                }
            }
        }
    }

    private static void ReplaceStringBufferAndStringBuilder(ClassFile classFile, List<Instruction> list) {
        ReplaceStringBuxxxerVisitor visitor = new ReplaceStringBuxxxerVisitor(classFile.getConstantPool());
        int length = list.size();
        int i = 0;
        while (i < length) {
            visitor.visit(list.get(i));
            ++i;
        }
    }

    private static void RemoveUnusedPopInstruction(List<Instruction> list) {
        int index = list.size();
        while (index-- > 0) {
            Instruction instruction = list.get(index);
            if (instruction.opcode != 87) continue;
            switch (((Pop)instruction).objectref.opcode) {
                case 21: 
                case 25: 
                case 178: 
                case 180: 
                case 268: 
                case 285: {
                    list.remove(index);
                }
            }
        }
    }

    private static void TransformTestOnLongOrDouble(List<Instruction> list) {
        int index = list.size();
        while (index-- > 0) {
            Instruction instruction = list.get(index);
            if (instruction.opcode != 260) continue;
            IfInstruction ii = (IfInstruction)instruction;
            switch (ii.cmp) {
                case 0: 
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    if (ii.value.opcode != 267) break;
                    BinaryOperatorInstruction boi = (BinaryOperatorInstruction)ii.value;
                    if (!"<".equals(boi.operator)) break;
                    list.set(index, new IfCmp(261, ii.offset, ii.lineNumber, ii.cmp, boi.value1, boi.value2, ii.branch));
                }
            }
        }
    }

    private static void SetConstantTypeInStringIndexOfMethods(ClassFile classFile, List<Instruction> list) {
        SetConstantTypeInStringIndexOfMethodsVisitor visitor = new SetConstantTypeInStringIndexOfMethodsVisitor(classFile.getConstantPool());
        visitor.visit(list);
    }

    private static void AnalyzeEnum(ClassFile classFile) {
        if (classFile.getFields() == null) {
            return;
        }
        ConstantPool constants = classFile.getConstantPool();
        String enumArraySignature = "[" + classFile.getInternalClassName();
        Field[] fields = classFile.getFields();
        int i = fields.length - 1;
        while (i >= 0) {
            Field field = fields[i];
            if ((field.access_flags & 0x5000) != 0 && field.getValueAndMethod() != null) {
                String fieldName;
                Instruction instruction = field.getValueAndMethod().getValue();
                if ((instruction.opcode == 282 || instruction.opcode == 283) && constants.getConstantUtf8(field.descriptor_index).equals(enumArraySignature) && ((fieldName = constants.getConstantUtf8(field.name_index)).equals("$VALUES") || fieldName.equals("ENUM$VALUES"))) {
                    classFile.setEnumValues(((InitArrayInstruction)instruction).values);
                    break;
                }
            }
            --i;
        }
    }
}

