/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.attribute.AttributeSignature;
import jd.core.model.classfile.constant.ConstantFieldref;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.AStore;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BIPush;
import jd.core.model.instruction.bytecode.instruction.BranchInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.ExceptionLoad;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.Goto;
import jd.core.model.instruction.bytecode.instruction.IConst;
import jd.core.model.instruction.bytecode.instruction.IInc;
import jd.core.model.instruction.bytecode.instruction.ILoad;
import jd.core.model.instruction.bytecode.instruction.IStore;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.model.instruction.bytecode.instruction.Invokevirtual;
import jd.core.model.instruction.bytecode.instruction.Jsr;
import jd.core.model.instruction.bytecode.instruction.Ldc;
import jd.core.model.instruction.bytecode.instruction.LoadInstruction;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.Return;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.Switch;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastFor;
import jd.core.model.instruction.fast.instruction.FastForEach;
import jd.core.model.instruction.fast.instruction.FastInstruction;
import jd.core.model.instruction.fast.instruction.FastLabel;
import jd.core.model.instruction.fast.instruction.FastList;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTest2Lists;
import jd.core.model.instruction.fast.instruction.FastTestList;
import jd.core.model.instruction.fast.instruction.FastTry;
import jd.core.model.reference.ReferenceMap;
import jd.core.process.analyzer.classfile.reconstructor.AssignmentOperatorReconstructor;
import jd.core.process.analyzer.classfile.visitor.SearchInstructionByOpcodeVisitor;
import jd.core.process.analyzer.instruction.bytecode.ComparisonInstructionAnalyzer;
import jd.core.process.analyzer.instruction.bytecode.reconstructor.AssertInstructionReconstructor;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import jd.core.process.analyzer.instruction.fast.FastCodeExceptionAnalyzer;
import jd.core.process.analyzer.instruction.fast.SingleDupLoadAnalyzer;
import jd.core.process.analyzer.instruction.fast.UnexpectedElementException;
import jd.core.process.analyzer.instruction.fast.UnexpectedInstructionException;
import jd.core.process.analyzer.instruction.fast.reconstructor.DotClass118BReconstructor;
import jd.core.process.analyzer.instruction.fast.reconstructor.DotClassEclipseReconstructor;
import jd.core.process.analyzer.instruction.fast.reconstructor.EmptySynchronizedBlockReconstructor;
import jd.core.process.analyzer.instruction.fast.reconstructor.IfGotoToIfReconstructor;
import jd.core.process.analyzer.instruction.fast.reconstructor.InitArrayInstructionReconstructor;
import jd.core.process.analyzer.instruction.fast.reconstructor.RemoveDupConstantsAttributes;
import jd.core.process.analyzer.instruction.fast.reconstructor.TernaryOpInReturnReconstructor;
import jd.core.process.analyzer.instruction.fast.reconstructor.TernaryOpReconstructor;
import jd.core.process.analyzer.util.InstructionUtil;
import jd.core.util.IntSet;
import jd.core.util.SignatureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastInstructionListBuilder {
    private static final boolean DECLARED = true;
    private static final boolean NOT_DECLARED = false;

    public static void Build(ReferenceMap referenceMap, ClassFile classFile, Method method, List<Instruction> list) throws Exception {
        if (list == null || list.isEmpty()) {
            return;
        }
        List<FastCodeExceptionAnalyzer.FastCodeException> lfce = FastCodeExceptionAnalyzer.AggregateCodeExceptions(method, list);
        LocalVariables localVariables = method.getLocalVariables();
        FastInstructionListBuilder.InitDelcarationFlags(localVariables);
        IntSet offsetLabelSet = new IntSet();
        int returnOffset = -1;
        if (list.size() > 0) {
            Instruction instruction = list.get(list.size() - 1);
            if (instruction.opcode == 177) {
                returnOffset = instruction.offset;
            }
        }
        if (lfce != null) {
            int i = lfce.size() - 1;
            while (i >= 0) {
                FastCodeExceptionAnalyzer.FastCodeException fce = lfce.get(i);
                if (fce.synchronizedFlag) {
                    FastInstructionListBuilder.CreateSynchronizedBlock(referenceMap, classFile, list, localVariables, fce);
                } else {
                    FastInstructionListBuilder.CreateFastTry(referenceMap, classFile, method, list, localVariables, fce, returnOffset);
                }
                --i;
            }
        }
        FastInstructionListBuilder.ExecuteReconstructors(referenceMap, classFile, list, localVariables);
        FastInstructionListBuilder.AnalyzeList(classFile, method, list, localVariables, offsetLabelSet, -1, -1, -1, -1, -1, -1, returnOffset);
        if (offsetLabelSet.size() > 0) {
            FastInstructionListBuilder.AddLabels(list, offsetLabelSet);
        }
    }

    private static void InitDelcarationFlags(LocalVariables localVariables) {
        int nbrOfLocalVariables = localVariables.size();
        int indexOfFirstLocalVariable = localVariables.getIndexOfFirstLocalVariable();
        int i = 0;
        while (i < indexOfFirstLocalVariable && i < nbrOfLocalVariables) {
            localVariables.getLocalVariableAt((int)i).declarationFlag = true;
            ++i;
        }
        i = indexOfFirstLocalVariable;
        while (i < nbrOfLocalVariables) {
            LocalVariable lv = localVariables.getLocalVariableAt(i);
            lv.declarationFlag = lv.exceptionOrReturnAddress;
            ++i;
        }
    }

    private static void CreateSynchronizedBlock(ReferenceMap referenceMap, ClassFile classFile, List<Instruction> list, LocalVariables localVariables, FastCodeExceptionAnalyzer.FastCodeException fce) {
        int index = InstructionUtil.getIndexForOffset(list, fce.tryFromOffset);
        Instruction instruction = list.get(index);
        int synchronizedBlockJumpOffset = -1;
        if (fce.type == 2) {
            int fastSynchronizedOffset;
            int tryFromIndex = index;
            index = InstructionUtil.getIndexForOffset(list, fce.finallyFromOffset);
            int subProcedureOffset = list.get((int)(index + 2)).offset;
            while (index-- > tryFromIndex) {
                instruction = list.get(index);
                if (instruction.opcode != 168) continue;
                int jumpOffset = ((Jsr)instruction).GetJumpOffset();
                list.remove(index);
                if (jumpOffset == subProcedureOffset) break;
            }
            int finallyFromOffset = fce.finallyFromOffset;
            index = InstructionUtil.getIndexForOffset(list, fce.afterOffset);
            if (index == -1) {
                index = list.size() - 1;
                while (list.get((int)index).offset >= finallyFromOffset) {
                    list.remove(index--);
                }
            } else if (index > 0) {
                --index;
                while (list.get((int)index).offset >= finallyFromOffset) {
                    list.remove(index--);
                }
            }
            ArrayList<Instruction> instructions = new ArrayList<Instruction>();
            if (index > 0) {
                int tryFromOffset = fce.tryFromOffset;
                while (list.get((int)index).offset >= tryFromOffset) {
                    instructions.add(list.remove(index--));
                }
            }
            if (instructions.size() > 0) {
                Instruction lastInstruction = (Instruction)instructions.get(0);
                fastSynchronizedOffset = lastInstruction.offset;
            } else {
                fastSynchronizedOffset = -1;
            }
            synchronizedBlockJumpOffset = FastInstructionListBuilder.SearchMinusJumpOffset(instructions, 0, instructions.size(), fce.tryFromOffset, fce.afterOffset);
            Collections.reverse(instructions);
            FastInstructionListBuilder.ExecuteReconstructors(referenceMap, classFile, instructions, localVariables);
            MonitorEnter menter = (MonitorEnter)list.remove(index--);
            int fastSynchronizedLineNumber = menter.lineNumber;
            if (menter.objectref.opcode != 25) {
                throw new UnexpectedInstructionException();
            }
            int varMonitorIndex = ((IndexInstruction)menter.objectref).index;
            localVariables.removeLocalVariableWithIndexAndOffset(varMonitorIndex, menter.offset);
            AStore astore = (AStore)list.get(index);
            Instruction monitor = astore.valueref;
            int branch = 1;
            if (fastSynchronizedOffset != -1 && synchronizedBlockJumpOffset != -1) {
                branch = synchronizedBlockJumpOffset - fastSynchronizedOffset;
            }
            FastSynchronized fastSynchronized = new FastSynchronized(319, fastSynchronizedOffset, fastSynchronizedLineNumber, branch, instructions);
            fastSynchronized.monitor = monitor;
            list.set(index, fastSynchronized);
        } else if (fce.type == 6) {
            ArrayList<Instruction> instructions = new ArrayList<Instruction>();
            instruction = list.remove(index);
            int fastSynchronizedOffset = instruction.offset;
            instructions.add(instruction);
            synchronizedBlockJumpOffset = FastInstructionListBuilder.SearchMinusJumpOffset(instructions, 0, instructions.size(), fce.tryFromOffset, fce.afterOffset);
            MonitorEnter menter = (MonitorEnter)list.remove(index - 1);
            AStore astore = (AStore)list.get(index - 2);
            Instruction monitor = astore.valueref;
            int varMonitorIndex = astore.index;
            localVariables.removeLocalVariableWithIndexAndOffset(varMonitorIndex, menter.offset);
            int branch = 1;
            if (synchronizedBlockJumpOffset != -1) {
                branch = synchronizedBlockJumpOffset - fastSynchronizedOffset;
            }
            FastSynchronized fastSynchronized = new FastSynchronized(319, fastSynchronizedOffset, menter.lineNumber, branch, instructions);
            fastSynchronized.monitor = monitor;
            list.set(index - 2, fastSynchronized);
        } else if (instruction.opcode == 195) {
            if (list.get((int)(--index)).opcode == 194) {
                Instruction monitor;
                MonitorEnter me = (MonitorEnter)list.remove(index);
                if (me.objectref.opcode == 265) {
                    AssignmentInstruction ai = (AssignmentInstruction)me.objectref;
                    AStore astore = (AStore)ai.value1;
                    monitor = ai.value2;
                    localVariables.removeLocalVariableWithIndexAndOffset(astore.index, astore.offset);
                    list.remove(index);
                } else {
                    list.remove(index);
                    AStore astore = (AStore)list.remove(--index);
                    monitor = astore.valueref;
                    localVariables.removeLocalVariableWithIndexAndOffset(astore.index, astore.offset);
                }
                ArrayList<Instruction> instructions = new ArrayList<Instruction>();
                Instruction gi = list.remove(index);
                if (gi.opcode != 167 || ((Goto)gi).GetJumpOffset() != fce.afterOffset) {
                    instructions.add(gi);
                }
                if (list.get((int)index).opcode == 58) {
                    list.remove(index);
                }
                Instruction monitorexit = list.remove(index);
                FastInstructionListBuilder.ExecuteReconstructors(referenceMap, classFile, instructions, localVariables);
                FastSynchronized fastSynchronized = new FastSynchronized(319, monitorexit.offset, instruction.lineNumber, 1, instructions);
                fastSynchronized.monitor = monitor;
                list.set(index, fastSynchronized);
            } else {
                Instruction monitor;
                int varMonitorIndex;
                MonitorEnter menter;
                list.remove(index);
                list.remove(index);
                list.remove(index);
                instruction = list.remove(index);
                switch (instruction.opcode) {
                    case 58: {
                        menter = (MonitorEnter)list.remove(index);
                        AStore astore = (AStore)instruction;
                        varMonitorIndex = astore.index;
                        monitor = astore.valueref;
                        break;
                    }
                    case 194: {
                        menter = (MonitorEnter)instruction;
                        AssignmentInstruction ai = (AssignmentInstruction)menter.objectref;
                        AStore astore = (AStore)ai.value1;
                        varMonitorIndex = astore.index;
                        monitor = ai.value2;
                        break;
                    }
                    default: {
                        throw new UnexpectedInstructionException();
                    }
                }
                localVariables.removeLocalVariableWithIndexAndOffset(varMonitorIndex, menter.offset);
                ArrayList<Instruction> instructions = new ArrayList<Instruction>();
                while (true) {
                    instruction = list.get(index);
                    if (instruction.opcode == 195) {
                        MonitorExit mexit = (MonitorExit)instruction;
                        if (mexit.objectref.opcode == 25) {
                            LoadInstruction li = (LoadInstruction)mexit.objectref;
                            if (li.index == varMonitorIndex) break;
                        }
                    }
                    instructions.add(list.remove(index));
                }
                if (index + 1 < list.size() && list.get((int)(index + 1)).opcode == 273) {
                    Instruction monitorexit = list.get(index);
                    Instruction value = ((ReturnInstruction)list.get((int)(index + 1))).valueref;
                    if (monitorexit.offset > value.offset) {
                        instructions.add(list.remove(index + 1));
                    }
                }
                FastInstructionListBuilder.ExecuteReconstructors(referenceMap, classFile, instructions, localVariables);
                synchronizedBlockJumpOffset = FastInstructionListBuilder.SearchMinusJumpOffset(instructions, 0, instructions.size(), fce.tryFromOffset, fce.afterOffset);
                int branch = 1;
                if (synchronizedBlockJumpOffset != -1) {
                    branch = synchronizedBlockJumpOffset - instruction.offset;
                }
                FastSynchronized fastSynchronized = new FastSynchronized(319, instruction.offset, menter.lineNumber, branch, instructions);
                fastSynchronized.monitor = monitor;
                list.set(index, fastSynchronized);
            }
        } else {
            index = fce.afterOffset > list.get((int)(list.size() - 1)).offset ? list.size() : InstructionUtil.getIndexForOffset(list, fce.afterOffset);
            int lastOffset = list.get((int)(--index)).offset;
            Instruction i = null;
            int finallyFromOffset = fce.finallyFromOffset;
            while (list.get((int)index).offset >= finallyFromOffset) {
                i = list.remove(index--);
            }
            int exceptionLoadIndex = -1;
            if (i != null && i.opcode == 58) {
                AStore astore = (AStore)i;
                if (astore.valueref.opcode == 270) {
                    exceptionLoadIndex = astore.index;
                }
            }
            ArrayList<Instruction> instructions = new ArrayList<Instruction>();
            i = null;
            if (index > 0) {
                int tryFromOffset = fce.tryFromOffset;
                i = list.get(index);
                if (i.offset >= tryFromOffset) {
                    instructions.add(i);
                    while (index-- > 0) {
                        i = list.get(index);
                        if (i.offset < tryFromOffset) break;
                        list.remove(index + 1);
                        instructions.add(i);
                    }
                    list.set(index + 1, null);
                }
            }
            Instruction lastInstruction = (Instruction)instructions.get(0);
            synchronizedBlockJumpOffset = FastInstructionListBuilder.SearchMinusJumpOffset(instructions, 0, instructions.size(), fce.tryFromOffset, fce.afterOffset);
            Collections.reverse(instructions);
            int lineNumber = i == null ? Instruction.UNKNOWN_LINE_NUMBER : i.lineNumber;
            int lenght = instructions.size();
            int monitorLocalVariableIndex = FastInstructionListBuilder.GetMonitorLocalVariableIndex(list, index);
            if (lenght > 0) {
                lastInstruction = (Instruction)instructions.get(lenght - 1);
                switch (lastInstruction.opcode) {
                    case 167: {
                        instructions.remove(--lenght);
                        if (lenght <= 0) break;
                        lastInstruction = (Instruction)instructions.get(lenght - 1);
                        break;
                    }
                    case 273: {
                        if (--lenght <= 0) break;
                        lastInstruction = (Instruction)instructions.get(lenght - 1);
                    }
                }
                FastInstructionListBuilder.RemoveAllMonitorExitInstructions(instructions, lenght, monitorLocalVariableIndex);
                int lastIndex = list.size() - 1;
                i = list.get(lastIndex);
                if (i != null && i.opcode == 191) {
                    AThrow at = (AThrow)list.get(lastIndex);
                    switch (at.value.opcode) {
                        case 270: {
                            ExceptionLoad el = (ExceptionLoad)at.value;
                            if (el.exceptionNameIndex != 0) break;
                            list.remove(lastIndex);
                            break;
                        }
                        case 25: {
                            ALoad aload = (ALoad)at.value;
                            if (aload.index != exceptionLoadIndex) break;
                            list.remove(lastIndex);
                        }
                    }
                }
            }
            if (monitorLocalVariableIndex != -1) {
                MonitorEnter menter = (MonitorEnter)list.get(index);
                localVariables.removeLocalVariableWithIndexAndOffset(monitorLocalVariableIndex, menter.offset);
            }
            int branch = 1;
            if (synchronizedBlockJumpOffset != -1) {
                branch = synchronizedBlockJumpOffset - lastOffset;
            }
            FastSynchronized fastSynchronized = new FastSynchronized(319, lastOffset, lineNumber, branch, instructions);
            FastInstructionListBuilder.ExecuteReconstructors(referenceMap, classFile, instructions, localVariables);
            list.set(index + 1, fastSynchronized);
            fastSynchronized.monitor = FastInstructionListBuilder.FormatAndExtractMonitor(list, index);
        }
    }

    private static Instruction FormatAndExtractMonitor(List<Instruction> list, int index) {
        MonitorEnter menter = (MonitorEnter)list.remove(index--);
        switch (menter.objectref.opcode) {
            case 265: {
                return ((AssignmentInstruction)menter.objectref).value2;
            }
            case 263: {
                list.remove(index--);
                DupStore dupstore = (DupStore)list.remove(index);
                return dupstore.objectref;
            }
            case 25: {
                AStore astore = (AStore)list.remove(index);
                return astore.valueref;
            }
        }
        return null;
    }

    private static void RemoveAllMonitorExitInstructions(List<Instruction> instructions, int lenght, int monitorLocalVariableIndex) {
        int index = lenght;
        while (index-- > 0) {
            Instruction instruction = instructions.get(index);
            if (instruction.opcode == 195) {
                int aloadIndex;
                MonitorExit mexit = (MonitorExit)instruction;
                if (mexit.objectref.opcode != 25 || (aloadIndex = ((ALoad)mexit.objectref).index) != monitorLocalVariableIndex) continue;
                instructions.remove(index);
                continue;
            }
            if (instruction.opcode == 318) {
                FastTry ft = (FastTry)instruction;
                FastInstructionListBuilder.RemoveAllMonitorExitInstructions(ft.instructions, ft.instructions.size(), monitorLocalVariableIndex);
                int i = ft.catches.size();
                while (i-- > 0) {
                    FastTry.FastCatch fc = ft.catches.get(i);
                    FastInstructionListBuilder.RemoveAllMonitorExitInstructions(fc.instructions, fc.instructions.size(), monitorLocalVariableIndex);
                }
                if (ft.finallyInstructions == null) continue;
                FastInstructionListBuilder.RemoveAllMonitorExitInstructions(ft.finallyInstructions, ft.finallyInstructions.size(), monitorLocalVariableIndex);
                continue;
            }
            if (instruction.opcode != 319) continue;
            FastSynchronized fsy = (FastSynchronized)instruction;
            FastInstructionListBuilder.RemoveAllMonitorExitInstructions(fsy.instructions, fsy.instructions.size(), monitorLocalVariableIndex);
        }
    }

    private static int GetMonitorLocalVariableIndex(List<Instruction> list, int index) {
        MonitorEnter menter = (MonitorEnter)list.get(index);
        switch (menter.objectref.opcode) {
            case 263: {
                return ((AStore)list.get((int)(index - 1))).index;
            }
            case 25: {
                return ((ALoad)menter.objectref).index;
            }
            case 265: {
                Instruction i = ((AssignmentInstruction)menter.objectref).value1;
                if (i.opcode != 25) break;
                return ((ALoad)i).index;
            }
        }
        return -1;
    }

    private static void CreateFastTry(ReferenceMap referenceMap, ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, FastCodeExceptionAnalyzer.FastCodeException fce, int returnOffset) throws Exception {
        int tryJumpOffsetTmp;
        int index;
        int afterListOffset = fce.afterOffset;
        int tryJumpOffset = -1;
        int lastIndex = list.size() - 1;
        if (afterListOffset == -1 || afterListOffset > list.get((int)lastIndex).offset) {
            index = lastIndex;
        } else {
            index = InstructionUtil.getIndexForOffset(list, afterListOffset);
            assert (index != -1);
            --index;
        }
        int lastOffset = list.get((int)index).offset;
        ArrayList<Instruction> finallyInstructions = null;
        if (fce.finallyFromOffset > 0) {
            int finallyFromOffset = fce.finallyFromOffset;
            finallyInstructions = new ArrayList<Instruction>();
            while (list.get((int)index).offset >= finallyFromOffset) {
                finallyInstructions.add(list.remove(index--));
            }
            if (finallyInstructions.size() == 0) {
                throw new RuntimeException("Unexpected structure for finally block");
            }
            Collections.reverse(finallyInstructions);
            int firstOffset = ((Instruction)finallyInstructions.get((int)0)).offset;
            int minimalJumpOffset = FastInstructionListBuilder.SearchMinusJumpOffset(finallyInstructions, 0, finallyInstructions.size(), firstOffset, afterListOffset);
            afterListOffset = firstOffset;
            if (minimalJumpOffset != -1 && afterListOffset > minimalJumpOffset) {
                afterListOffset = minimalJumpOffset;
            }
        }
        ArrayList<FastTry.FastCatch> catches = null;
        if (fce.catches != null) {
            int i = fce.catches.size();
            catches = new ArrayList<FastTry.FastCatch>(i);
            while (i-- > 0) {
                FastCodeExceptionAnalyzer.FastCodeExceptionCatch fcec = fce.catches.get(i);
                fcec.toOffset = afterListOffset;
                int fromOffset = fcec.fromOffset;
                ArrayList<Instruction> instructions = new ArrayList<Instruction>();
                while (list.get((int)index).offset >= fromOffset) {
                    instructions.add(list.remove(index));
                    if (index == 0) break;
                    --index;
                }
                int instructionsLength = instructions.size();
                if (instructionsLength > 0) {
                    Instruction lastInstruction = (Instruction)instructions.get(0);
                    int tryJumpOffsetTmp2 = FastInstructionListBuilder.SearchMinusJumpOffset(instructions, 0, instructionsLength, fce.tryFromOffset, fce.afterOffset);
                    if (tryJumpOffsetTmp2 != -1) {
                        if (tryJumpOffset == -1) {
                            tryJumpOffset = tryJumpOffsetTmp2;
                        } else if (tryJumpOffset > tryJumpOffsetTmp2) {
                            tryJumpOffset = tryJumpOffsetTmp2;
                        }
                    }
                    Collections.reverse(instructions);
                    ExceptionLoad el = FastInstructionListBuilder.SearchExceptionLoadInstruction(instructions);
                    if (el != null) {
                        int offset = lastInstruction.offset;
                        catches.add(0, new FastTry.FastCatch(offset, el.offset, fcec.type, fcec.otherTypes, el.index, instructions));
                        int firstOffset = ((Instruction)instructions.get((int)0)).offset;
                        int minimalJumpOffset = FastInstructionListBuilder.SearchMinusJumpOffset(instructions, 0, instructions.size(), firstOffset, offset);
                        if (afterListOffset > firstOffset) {
                            afterListOffset = firstOffset;
                        }
                        if (minimalJumpOffset == -1 || afterListOffset <= minimalJumpOffset) continue;
                        afterListOffset = minimalJumpOffset;
                        continue;
                    }
                    throw new UnexpectedInstructionException();
                }
                throw new RuntimeException("Empty catch block");
            }
        }
        ArrayList<Instruction> tryInstructions = new ArrayList<Instruction>();
        if (fce.tryToOffset < afterListOffset) {
            index = FastCodeExceptionAnalyzer.ComputeTryToIndex(list, fce, index, afterListOffset);
        }
        int tryFromOffset = fce.tryFromOffset;
        Instruction i = list.get(index);
        if (i.offset >= tryFromOffset) {
            tryInstructions.add(i);
            while (index-- > 0) {
                i = list.get(index);
                if (i.offset < tryFromOffset) break;
                list.remove(index + 1);
                tryInstructions.add(i);
            }
            list.set(index + 1, null);
        }
        if ((tryJumpOffsetTmp = FastInstructionListBuilder.SearchMinusJumpOffset(tryInstructions, 0, tryInstructions.size(), fce.tryFromOffset, fce.tryToOffset)) != -1) {
            if (tryJumpOffset == -1) {
                tryJumpOffset = tryJumpOffsetTmp;
            } else if (tryJumpOffset > tryJumpOffsetTmp) {
                tryJumpOffset = tryJumpOffsetTmp;
            }
        }
        Collections.reverse(tryInstructions);
        int lineNumber = ((Instruction)tryInstructions.get((int)0)).lineNumber;
        if (tryJumpOffset == -1) {
            tryJumpOffset = lastOffset + 1;
        }
        FastTry fastTry = new FastTry(318, lastOffset, lineNumber, tryJumpOffset - lastOffset, tryInstructions, catches, finallyInstructions);
        FastCodeExceptionAnalyzer.FormatFastTry(localVariables, fce, fastTry, returnOffset);
        FastInstructionListBuilder.ExecuteReconstructors(referenceMap, classFile, tryInstructions, localVariables);
        if (catches != null) {
            int length = catches.size();
            int j = 0;
            while (j < length) {
                FastTry.FastCatch fc = (FastTry.FastCatch)catches.get(j);
                List<Instruction> catchInstructions = fc.instructions;
                FastInstructionListBuilder.ExecuteReconstructors(referenceMap, classFile, catchInstructions, localVariables);
                ++j;
            }
        }
        if (finallyInstructions != null) {
            FastInstructionListBuilder.ExecuteReconstructors(referenceMap, classFile, finallyInstructions, localVariables);
        }
        list.set(index + 1, fastTry);
    }

    private static ExceptionLoad SearchExceptionLoadInstruction(List<Instruction> instructions) throws Exception {
        int length = instructions.size();
        int i = 0;
        while (i < length) {
            Instruction instruction = SearchInstructionByOpcodeVisitor.visit(instructions.get(i), 270);
            if (instruction != null) {
                return (ExceptionLoad)instruction;
            }
            ++i;
        }
        return null;
    }

    private static void ExecuteReconstructors(ReferenceMap referenceMap, ClassFile classFile, List<Instruction> list, LocalVariables localVariables) {
        EmptySynchronizedBlockReconstructor.Reconstruct(localVariables, list);
        DotClass118BReconstructor.Reconstruct(referenceMap, classFile, list);
        DotClassEclipseReconstructor.Reconstruct(referenceMap, classFile, list);
        IfGotoToIfReconstructor.Reconstruct(list);
        ComparisonInstructionAnalyzer.Aggregate(list);
        AssertInstructionReconstructor.Reconstruct(classFile, list);
        TernaryOpReconstructor.Reconstruct(list);
        InitArrayInstructionReconstructor.Reconstruct(list);
        AssignmentOperatorReconstructor.Reconstruct(list);
        RemoveDupConstantsAttributes.Reconstruct(list);
    }

    private static void RemoveNoJumpGotoInstruction(List<Instruction> list, int afterListOffset) {
        int branch;
        int index = list.size();
        if (index == 0) {
            return;
        }
        Instruction instruction = list.get(--index);
        int lastInstructionOffset = instruction.offset;
        if (instruction.opcode == 167 && (branch = ((Goto)instruction).branch) >= 0 && instruction.offset + branch <= afterListOffset) {
            list.remove(index);
        }
        while (index-- > 0) {
            instruction = list.get(index);
            if (instruction.opcode == 167 && (branch = ((Goto)instruction).branch) >= 0 && instruction.offset + branch <= lastInstructionOffset) {
                list.remove(index);
            }
            lastInstructionOffset = instruction.offset;
        }
    }

    private static void RemoveSyntheticReturn(List<Instruction> list, int afterListOffset, int returnOffset) {
        if (afterListOffset == returnOffset) {
            int index = list.size();
            if (index == 1) {
                FastInstructionListBuilder.RemoveSyntheticReturn(list, --index);
            } else if (index-- > 1 && list.get((int)index).lineNumber < list.get((int)(index - 1)).lineNumber) {
                FastInstructionListBuilder.RemoveSyntheticReturn(list, index);
            }
        }
    }

    private static void RemoveSyntheticReturn(List<Instruction> list, int index) {
        switch (list.get((int)index).opcode) {
            case 177: {
                list.remove(index);
                break;
            }
            case 320: {
                FastLabel fl = (FastLabel)list.get(index);
                if (fl.instruction.opcode != 177) break;
                fl.instruction = null;
            }
        }
    }

    private static void AddCastInstructionOnReturn(ClassFile classFile, Method method, List<Instruction> list) {
        ConstantPool constants = classFile.getConstantPool();
        LocalVariables localVariables = method.getLocalVariables();
        AttributeSignature as = method.getAttributeSignature();
        int signatureIndex = as == null ? method.descriptor_index : as.signature_index;
        String signature = constants.getConstantUtf8(signatureIndex);
        String methodReturnedSignature = SignatureUtil.GetMethodReturnedSignature(signature);
        int index = list.size();
        while (index-- > 0) {
            Instruction instruction = list.get(index);
            if (instruction.opcode != 273) continue;
            ReturnInstruction ri = (ReturnInstruction)instruction;
            String returnedSignature = ri.valueref.getReturnedSignature(constants, localVariables);
            if (returnedSignature == null || !returnedSignature.equals("Ljava/lang/Object;") || methodReturnedSignature.equals("Ljava/lang/Object;")) continue;
            signatureIndex = constants.addConstantUtf8(methodReturnedSignature);
            if (ri.valueref.opcode == 192) {
                ((CheckCast)ri.valueref).index = signatureIndex;
                continue;
            }
            ri.valueref = new CheckCast(192, ri.valueref.offset, ri.valueref.lineNumber, signatureIndex, ri.valueref);
        }
    }

    private static void AnalyzeList(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int beforeListOffset, int afterListOffset, int breakOffset, int returnOffset) {
        FastInstructionListBuilder.CreateLoops(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, beforeListOffset, afterListOffset, returnOffset);
        FastInstructionListBuilder.CreateSwitch(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, returnOffset);
        FastInstructionListBuilder.AnalyzeTryAndSynchronized(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, beforeListOffset, afterListOffset, breakOffset, returnOffset);
        TernaryOpInReturnReconstructor.Reconstruct(list);
        FastInstructionListBuilder.CreateIfElse(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, breakOffset, returnOffset);
        FastInstructionListBuilder.RemoveNopGoto(list);
        FastInstructionListBuilder.AddDeclarations(list, localVariables, beforeListOffset);
        FastInstructionListBuilder.RemoveNoJumpGotoInstruction(list, afterListOffset);
        FastInstructionListBuilder.CreateBreakAndContinue(method, list, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, breakOffset, returnOffset);
        SingleDupLoadAnalyzer.Cleanup(list);
        FastInstructionListBuilder.RemoveSyntheticReturn(list, afterListOffset, returnOffset);
        FastInstructionListBuilder.AddCastInstructionOnReturn(classFile, method, list);
    }

    private static void AnalyzeTryAndSynchronized(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int beforeListOffset, int afterListOffset, int breakOffset, int returnOffset) {
        int index = list.size();
        while (index-- > 0) {
            Instruction instruction = list.get(index);
            switch (instruction.opcode) {
                case 318: {
                    FastTry ft = (FastTry)instruction;
                    int tmpBeforeListOffset = index > 0 ? list.get((int)(index - 1)).offset : beforeListOffset;
                    FastInstructionListBuilder.AnalyzeList(classFile, method, ft.instructions, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, tmpBeforeListOffset, afterListOffset, breakOffset, returnOffset);
                    int length = ft.catches.size();
                    int i = 0;
                    while (i < length) {
                        FastInstructionListBuilder.AnalyzeList(classFile, method, ft.catches.get((int)i).instructions, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, tmpBeforeListOffset, afterListOffset, breakOffset, returnOffset);
                        ++i;
                    }
                    if (ft.finallyInstructions == null) break;
                    FastInstructionListBuilder.AnalyzeList(classFile, method, ft.finallyInstructions, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, tmpBeforeListOffset, afterListOffset, breakOffset, returnOffset);
                    break;
                }
                case 319: {
                    FastSynchronized fs = (FastSynchronized)instruction;
                    int tmpBeforeListOffset = index > 0 ? list.get((int)(index - 1)).offset : beforeListOffset;
                    FastInstructionListBuilder.AnalyzeList(classFile, method, fs.instructions, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, tmpBeforeListOffset, afterListOffset, breakOffset, returnOffset);
                    break;
                }
                case 194: 
                case 195: {
                    list.remove(index);
                }
            }
            afterListOffset = instruction.offset;
        }
    }

    private static void RemoveNopGoto(List<Instruction> list) {
        int length = list.size();
        if (length > 1) {
            int nextOffset = list.get((int)(length - 1)).offset;
            int index = length - 2;
            while (index >= 0) {
                Instruction instruction = list.get(index);
                if (instruction.opcode == 167) {
                    Goto gi = (Goto)instruction;
                    if (gi.branch >= 0 && gi.GetJumpOffset() <= nextOffset) {
                        list.remove(index);
                    }
                }
                nextOffset = instruction.offset;
                --index;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void AddDeclarations(List<Instruction> list, LocalVariables localVariables, int beforeListOffset) {
        int length = list.size();
        if (length > 0) {
            LocalVariable lv;
            int lastOffset = list.get((int)(length - 1)).offset;
            int i = 0;
            while (i < length) {
                Instruction instruction = list.get(i);
                block0 : switch (instruction.opcode) {
                    case 54: 
                    case 58: 
                    case 269: {
                        StoreInstruction si = (StoreInstruction)instruction;
                        lv = localVariables.getLocalVariableWithIndexAndOffset(si.index, si.offset);
                        if (lv == null || lv.declarationFlag || beforeListOffset >= lv.start_pc || lv.start_pc + lv.length - 1 > lastOffset) break;
                        list.set(i, new FastDeclaration(317, si.offset, si.lineNumber, si.index, si));
                        lv.declarationFlag = true;
                        FastInstructionListBuilder.UpdateNewAndInitArrayInstruction(si);
                        break;
                    }
                    case 304: {
                        StoreInstruction si;
                        FastFor ff = (FastFor)instruction;
                        if (ff.init == null) break;
                        switch (ff.init.opcode) {
                            case 54: 
                            case 58: 
                            case 269: {
                                si = (StoreInstruction)ff.init;
                                lv = localVariables.getLocalVariableWithIndexAndOffset(si.index, si.offset);
                                if (lv == null || lv.declarationFlag || beforeListOffset >= lv.start_pc || lv.start_pc + lv.length - 1 > lastOffset) break block0;
                                ff.init = new FastDeclaration(317, si.offset, si.lineNumber, si.index, si);
                                lv.declarationFlag = true;
                                FastInstructionListBuilder.UpdateNewAndInitArrayInstruction(si);
                            }
                        }
                        break;
                    }
                }
                ++i;
            }
            int lvLength = localVariables.size();
            int i2 = 0;
            while (i2 < lvLength) {
                lv = localVariables.getLocalVariableAt(i2);
                if (!lv.declarationFlag && beforeListOffset < lv.start_pc && lv.start_pc + lv.length - 1 <= lastOffset) {
                    int indexForNewDeclaration = InstructionUtil.getIndexForOffset(list, lv.start_pc);
                    if (indexForNewDeclaration == -1) {
                        indexForNewDeclaration = 0;
                    }
                    list.add(indexForNewDeclaration, new FastDeclaration(317, lv.start_pc, Instruction.UNKNOWN_LINE_NUMBER, lv.index, null));
                    lv.declarationFlag = true;
                }
                ++i2;
            }
        }
    }

    private static void UpdateNewAndInitArrayInstruction(Instruction instruction) {
        switch (instruction.opcode) {
            case 58: {
                Instruction valueref = ((StoreInstruction)instruction).valueref;
                if (valueref.opcode != 283) break;
                valueref.opcode = 282;
            }
        }
    }

    private static void CreateBreakAndContinue(Method method, List<Instruction> list, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int afterListOffset, int breakOffset, int returnOffset) {
        int length = list.size();
        int index = 0;
        while (index < length) {
            Instruction instruction = list.get(index);
            switch (instruction.opcode) {
                case 260: 
                case 261: 
                case 262: 
                case 284: {
                    ReturnInstruction ri;
                    LoadInstruction load;
                    BranchInstruction bi = (BranchInstruction)instruction;
                    int jumpOffset = bi.GetJumpOffset();
                    if (beforeLoopEntryOffset < jumpOffset && jumpOffset <= loopEntryOffset) {
                        list.set(index, new FastInstruction(308, bi.offset, bi.lineNumber, bi));
                        break;
                    }
                    if (ByteCodeUtil.JumpTo(method.getCode(), breakOffset, jumpOffset)) {
                        list.set(index, new FastInstruction(309, bi.offset, bi.lineNumber, bi));
                        break;
                    }
                    if (ByteCodeUtil.JumpTo(method.getCode(), jumpOffset, returnOffset)) {
                        ArrayList<Instruction> instructions = new ArrayList<Instruction>(1);
                        instructions.add(new Return(177, bi.offset, Instruction.UNKNOWN_LINE_NUMBER));
                        list.set(index, new FastTestList(306, bi.offset, bi.lineNumber, jumpOffset - bi.offset, bi, instructions));
                        break;
                    }
                    byte[] code = method.getCode();
                    if (code.length == jumpOffset + 2 && (load = FastInstructionListBuilder.DuplicateLoadInstruction(code[jumpOffset] & 0xFF, bi.offset, Instruction.UNKNOWN_LINE_NUMBER)) != null && (ri = FastInstructionListBuilder.DuplacateReturnInstruction(code[jumpOffset + 1] & 0xFF, bi.offset, Instruction.UNKNOWN_LINE_NUMBER, load)) != null) {
                        ArrayList<Instruction> instructions = new ArrayList<Instruction>(1);
                        instructions.add(ri);
                        list.set(index, new FastTestList(306, bi.offset, bi.lineNumber, jumpOffset - bi.offset, bi, instructions));
                        break;
                    }
                    offsetLabelSet.add(jumpOffset);
                    list.set(index, new FastInstruction(310, bi.offset, bi.lineNumber, bi));
                    break;
                }
                case 167: {
                    ReturnInstruction ri;
                    LoadInstruction load;
                    Goto g = (Goto)instruction;
                    int jumpOffset = g.GetJumpOffset();
                    int lineNumber = g.lineNumber;
                    if (index == 0 || list.get((int)(index - 1)).lineNumber == lineNumber) {
                        lineNumber = Instruction.UNKNOWN_LINE_NUMBER;
                    }
                    if (beforeLoopEntryOffset < jumpOffset && jumpOffset <= loopEntryOffset) {
                        if (afterListOffset == afterBodyLoopOffset && index + 1 == length) {
                            list.remove(index);
                            break;
                        }
                        list.set(index, new FastInstruction(311, g.offset, lineNumber, null));
                        break;
                    }
                    if (ByteCodeUtil.JumpTo(method.getCode(), breakOffset, jumpOffset)) {
                        list.set(index, new FastInstruction(312, g.offset, lineNumber, null));
                        break;
                    }
                    if (ByteCodeUtil.JumpTo(method.getCode(), jumpOffset, returnOffset)) {
                        list.set(index, new Return(177, g.offset, lineNumber));
                        break;
                    }
                    byte[] code = method.getCode();
                    if (code.length == jumpOffset + 2 && (load = FastInstructionListBuilder.DuplicateLoadInstruction(code[jumpOffset] & 0xFF, g.offset, lineNumber)) != null && (ri = FastInstructionListBuilder.DuplacateReturnInstruction(code[jumpOffset + 1] & 0xFF, g.offset, lineNumber, load)) != null) {
                        if (index > 0) {
                            instruction = list.get(index - 1);
                            if (load.lineNumber == instruction.lineNumber && 54 <= instruction.opcode && instruction.opcode <= 78 && load.index == ((StoreInstruction)instruction).index) {
                                StoreInstruction si = (StoreInstruction)instruction;
                                ri.valueref = si.valueref;
                                list.remove(--index);
                                --length;
                            }
                        }
                        list.set(index, ri);
                        break;
                    }
                    offsetLabelSet.add(jumpOffset);
                    list.set(index, new FastInstruction(313, g.offset, lineNumber, g));
                }
            }
            ++index;
        }
    }

    private static LoadInstruction DuplicateLoadInstruction(int opcode, int offset, int lineNumber) {
        switch (opcode) {
            case 21: {
                return new ILoad(21, offset, lineNumber, 0);
            }
            case 22: {
                return new LoadInstruction(268, offset, lineNumber, 0, "J");
            }
            case 23: {
                return new LoadInstruction(268, offset, lineNumber, 0, "F");
            }
            case 24: {
                return new LoadInstruction(268, offset, lineNumber, 0, "D");
            }
            case 25: {
                return new ALoad(25, offset, lineNumber, 0);
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return new ILoad(21, offset, lineNumber, opcode - 26);
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return new LoadInstruction(268, offset, lineNumber, opcode - 30, "J");
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return new LoadInstruction(268, offset, lineNumber, opcode - 34, "F");
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                return new LoadInstruction(268, offset, lineNumber, opcode - 38, "D");
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return new ALoad(25, offset, lineNumber, opcode - 42);
            }
        }
        return null;
    }

    private static ReturnInstruction DuplacateReturnInstruction(int opcode, int offset, int lineNumber, Instruction instruction) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                return new ReturnInstruction(273, offset, lineNumber, instruction);
            }
        }
        return null;
    }

    private static int UnoptimizeIfElseInLoop(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeListOffset, int afterListOffset, int returnOffset, int offset, int jumpOffset, int index) {
        int length;
        int firstLoopInstructionIndex = InstructionUtil.getIndexForOffset(list, jumpOffset);
        if (firstLoopInstructionIndex != -1 && index + 1 < (length = list.size())) {
            int afterLoopJumpOffset;
            int afterLoopInstructionOffset = list.get((int)(index + 1)).offset;
            Instruction firstLoopInstruction = list.get(firstLoopInstructionIndex);
            switch (firstLoopInstruction.opcode) {
                case 167: 
                case 260: 
                case 261: 
                case 262: 
                case 284: 
                case 318: 
                case 319: {
                    BranchInstruction bi = (BranchInstruction)firstLoopInstruction;
                    afterLoopJumpOffset = bi.GetJumpOffset();
                    break;
                }
                default: {
                    afterLoopJumpOffset = -1;
                }
            }
            if (afterLoopJumpOffset > afterLoopInstructionOffset) {
                int lastInstructionoffset;
                int afterLoopInstructionIndex = InstructionUtil.getIndexForOffset(list, afterLoopJumpOffset);
                if (afterLoopInstructionIndex == -1 && afterLoopJumpOffset <= afterListOffset) {
                    afterLoopInstructionIndex = length;
                }
                if (afterLoopInstructionIndex != -1 && InstructionUtil.CheckNoJumpToInterval(list, 0, firstLoopInstructionIndex, offset, lastInstructionoffset = list.get((int)(afterLoopInstructionIndex - 1)).offset) && InstructionUtil.CheckNoJumpToInterval(list, afterLoopInstructionIndex, list.size(), offset, lastInstructionoffset)) {
                    Instruction lastInstruction = list.get(afterLoopInstructionIndex - 1);
                    Goto newGi = new Goto(167, lastInstruction.offset, Instruction.UNKNOWN_LINE_NUMBER, jumpOffset - lastInstruction.offset);
                    list.add(afterLoopInstructionIndex, newGi);
                    return FastInstructionListBuilder.AnalyzeBackGoto(classFile, method, list, localVariables, offsetLabelSet, beforeListOffset, afterLoopJumpOffset, returnOffset, afterLoopInstructionIndex, newGi, jumpOffset);
                }
            }
        }
        return -1;
    }

    private static int UnoptimizeIfiniteLoop(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeListOffset, int afterListOffset, int returnOffset, BranchInstruction bi, int jumpOffset, int jumpIndex) {
        int length = list.size();
        if (jumpIndex + 1 >= length) {
            return -1;
        }
        Instruction instruction = list.get(jumpIndex + 1);
        if (instruction.opcode != 167) {
            return -1;
        }
        int afterGotoOffset = jumpIndex + 2 >= length ? afterListOffset : list.get((int)(jumpIndex + 2)).offset;
        Goto g = (Goto)instruction;
        int jumpGotoOffset = g.GetJumpOffset();
        if (g.offset >= jumpGotoOffset || jumpGotoOffset > afterGotoOffset) {
            return -1;
        }
        int newGotoOffset = g.offset + 1;
        bi.SetJumpOffset(newGotoOffset);
        Goto newGoto = new Goto(167, newGotoOffset, Instruction.UNKNOWN_LINE_NUMBER, jumpOffset - newGotoOffset);
        list.add(jumpIndex + 2, newGoto);
        return FastInstructionListBuilder.AnalyzeBackGoto(classFile, method, list, localVariables, offsetLabelSet, beforeListOffset, jumpGotoOffset, returnOffset, jumpIndex + 2, newGoto, jumpOffset);
    }

    /*
     * Unable to fully structure code
     */
    private static void CreateLoops(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int beforeListOffset, int afterListOffset, int returnOffset) {
        index = list.size();
        if (true) ** GOTO lbl8
        do {
            instruction = list.get(index);
            switch (instruction.opcode) {
                case 167: 
                case 260: 
                case 261: 
                case 262: 
                case 284: {
                    if (!FastInstructionListBuilder.UnoptimizeLoopInLoop(list, beforeListOffset, index, instruction)) break;
                }
            }
lbl8:
            // 4 sources

            v0 = ++index;
            --index;
        } while (v0 > 0);
        index = list.size();
        block9: while (index-- > 0) {
            instruction = list.get(index);
            switch (instruction.opcode) {
                case 260: 
                case 261: 
                case 262: 
                case 284: {
                    bi = (BranchInstruction)instruction;
                    if (bi.branch >= 0 || beforeListOffset >= (jumpOffset = bi.GetJumpOffset()) || beforeLoopEntryOffset < jumpOffset && jumpOffset <= loopEntryOffset) continue block9;
                    newIndex = FastInstructionListBuilder.UnoptimizeIfElseInLoop(classFile, method, list, localVariables, offsetLabelSet, beforeListOffset, afterListOffset, returnOffset, bi.offset, jumpOffset, index);
                    if (newIndex == -1) {
                        newIndex = FastInstructionListBuilder.UnoptimizeIfiniteLoop(classFile, method, list, localVariables, offsetLabelSet, beforeListOffset, afterListOffset, returnOffset, bi, jumpOffset, index);
                    }
                    if (newIndex == -1) {
                        index = FastInstructionListBuilder.AnalyzeBackIf(classFile, method, list, localVariables, offsetLabelSet, beforeListOffset, returnOffset, index, bi);
                        break;
                    }
                    index = newIndex;
                    break;
                }
                case 167: {
                    gi = (Goto)instruction;
                    if (gi.branch >= 0 || beforeListOffset >= (jumpOffset = gi.GetJumpOffset()) || beforeLoopEntryOffset < jumpOffset && jumpOffset <= loopEntryOffset) continue block9;
                    newIndex = FastInstructionListBuilder.UnoptimizeIfElseInLoop(classFile, method, list, localVariables, offsetLabelSet, beforeListOffset, afterListOffset, returnOffset, gi.offset, jumpOffset, index);
                    if (newIndex == -1) {
                        index = FastInstructionListBuilder.AnalyzeBackGoto(classFile, method, list, localVariables, offsetLabelSet, beforeListOffset, gi.offset, returnOffset, index, gi, jumpOffset);
                        break;
                    }
                    index = newIndex;
                    break;
                }
                case 318: 
                case 319: {
                    fl = (FastList)instruction;
                    if (fl.instructions.size() <= 0) break;
                    previousOffset = index > 0 ? list.get((int)(index - 1)).offset : beforeListOffset;
                    jumpOffset = fl.GetJumpOffset();
                    if (jumpOffset == -1 || previousOffset < jumpOffset || beforeListOffset >= jumpOffset || beforeLoopEntryOffset < jumpOffset && jumpOffset <= loopEntryOffset) continue block9;
                    fl.branch = 1;
                    afterSubListOffset = index + 1 < list.size() ? list.get((int)(index + 1)).offset : afterListOffset;
                    index = FastInstructionListBuilder.AnalyzeBackGoto(classFile, method, list, localVariables, offsetLabelSet, beforeListOffset, afterSubListOffset, returnOffset, index, fl, jumpOffset);
                }
            }
        }
    }

    private static boolean UnoptimizeLoopInLoop(List<Instruction> list, int beforeListOffset, int index, Instruction instruction) {
        BranchInstruction bi = (BranchInstruction)instruction;
        if (bi.branch >= 0) {
            return false;
        }
        int jumpOffset = bi.GetJumpOffset();
        if (jumpOffset <= beforeListOffset) {
            return false;
        }
        int indexBi = index;
        block15: while (true) {
            if (index == 0) {
                return false;
            }
            instruction = list.get(--index);
            if (instruction.offset <= jumpOffset) break;
            switch (instruction.opcode) {
                case 170: 
                case 171: {
                    Switch s = (Switch)instruction;
                    if (s.offset + s.defaultOffset > bi.offset) {
                        return false;
                    }
                    int j = s.offsets.length;
                    do {
                        if (j-- <= 0) continue block15;
                    } while (s.offset + s.offsets[j] <= bi.offset);
                    return false;
                }
            }
        }
        instruction = list.get(index + 1);
        if (bi == instruction) {
            return false;
        }
        switch (instruction.opcode) {
            case 260: 
            case 261: 
            case 262: 
            case 284: {
                int j;
                Switch s;
                BranchInstruction bi2 = (BranchInstruction)instruction;
                if (bi2.branch >= 0) {
                    return false;
                }
                int i = 0;
                while (i < index) {
                    instruction = list.get(i);
                    switch (instruction.opcode) {
                        case 170: 
                        case 171: {
                            s = (Switch)instruction;
                            if (s.offset + s.defaultOffset > bi2.offset) {
                                return false;
                            }
                            j = s.offsets.length;
                            while (j-- > 0) {
                                if (s.offset + s.offsets[j] <= bi2.offset) continue;
                                return false;
                            }
                            break;
                        }
                    }
                    ++i;
                }
                int jumpOffset2 = bi2.GetJumpOffset();
                block19: while (true) {
                    if (index == 0) {
                        return false;
                    }
                    instruction = list.get(--index);
                    if (instruction.offset <= jumpOffset2) break;
                    switch (instruction.opcode) {
                        case 170: 
                        case 171: {
                            s = (Switch)instruction;
                            if (s.offset + s.defaultOffset > bi.offset) {
                                return false;
                            }
                            j = s.offsets.length;
                            do {
                                if (j-- <= 0) continue block19;
                            } while (s.offset + s.offsets[j] <= bi.offset);
                            return false;
                        }
                    }
                }
                Instruction target = list.get(index + 1);
                if (bi2 == target) {
                    return false;
                }
                int i2 = 0;
                while (i2 < index) {
                    instruction = list.get(i2);
                    switch (instruction.opcode) {
                        case 170: 
                        case 171: {
                            Switch s2 = (Switch)instruction;
                            if (s2.offset + s2.defaultOffset > bi2.offset) {
                                return false;
                            }
                            int j2 = s2.offsets.length;
                            while (j2-- > 0) {
                                if (s2.offset + s2.offsets[j2] <= bi2.offset) continue;
                                return false;
                            }
                            break;
                        }
                    }
                    ++i2;
                }
                if (bi.opcode == 167) {
                    list.add(indexBi + 1, new Goto(167, bi.offset + 1, Instruction.UNKNOWN_LINE_NUMBER, jumpOffset2 - bi.offset - 1));
                    bi2.SetJumpOffset(bi.offset + 1);
                    break;
                }
                if (target.opcode == 167 && ((Goto)target).GetJumpOffset() == jumpOffset2) {
                    bi.SetJumpOffset(jumpOffset2);
                    break;
                }
                list.add(index + 1, new Goto(167, jumpOffset2 - 1, Instruction.UNKNOWN_LINE_NUMBER, jumpOffset - jumpOffset2 + 1));
                bi.SetJumpOffset(jumpOffset2 - 1);
                return true;
            }
        }
        return false;
    }

    private static void CreateIfElse(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int afterListOffset, int breakOffset, int returnOffset) {
        int length = list.size();
        int index = 0;
        while (index < length) {
            Instruction instruction = list.get(index);
            switch (instruction.opcode) {
                case 260: 
                case 261: 
                case 262: 
                case 284: {
                    FastInstructionListBuilder.AnalyzeIfAndIfElse(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, breakOffset, returnOffset, index, (ConditionalBranchInstruction)instruction);
                    length = list.size();
                }
            }
            ++index;
        }
    }

    private static void CreateSwitch(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int afterListOffset, int returnOffset) {
        int index = 0;
        while (index < list.size()) {
            Instruction instruction = list.get(index);
            switch (instruction.opcode) {
                case 171: {
                    FastInstructionListBuilder.AnalyzeLookupSwitch(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, returnOffset, index, (LookupSwitch)instruction);
                    break;
                }
                case 170: {
                    index = FastInstructionListBuilder.AnalyzeTableSwitch(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, returnOffset, index, (TableSwitch)instruction);
                }
            }
            ++index;
        }
    }

    private static void RemoveLocalVariable(Method method, IndexInstruction ii) {
        LocalVariable lv = method.getLocalVariables().searchLocalVariableWithIndexAndOffset(ii.index, ii.offset);
        if (lv != null && ii.offset == lv.start_pc) {
            method.getLocalVariables().removeLocalVariableWithIndexAndOffset(ii.index, ii.offset);
        }
    }

    private static int AnalyzeBackIf(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeListOffset, int returnOffset, int testIndex, Instruction test) {
        int index;
        block31: {
            int breakOffset;
            int subListLength;
            int beforeLoopEntryOffset;
            ArrayList<Instruction> subList;
            block30: {
                index = testIndex - 1;
                subList = new ArrayList<Instruction>();
                int firstOffset = ((BranchInstruction)test).GetJumpOffset();
                beforeLoopEntryOffset = index >= 0 ? list.get((int)index).offset : beforeListOffset;
                while (index >= 0 && list.get((int)index).offset >= firstOffset) {
                    subList.add(list.remove(index--));
                }
                subListLength = subList.size();
                if (index >= 0) {
                    beforeListOffset = list.get((int)index).offset;
                }
                breakOffset = FastInstructionListBuilder.SearchMinusJumpOffset(subList, 0, subListLength, beforeListOffset, test.offset);
                BranchInstruction jumpInstructionBeforeLoop = null;
                if (index >= 0) {
                    int i = index + 1;
                    block10: while (i-- > 0) {
                        Instruction instruction = list.get(i);
                        switch (instruction.opcode) {
                            case 167: 
                            case 260: 
                            case 261: 
                            case 262: 
                            case 284: 
                            case 318: 
                            case 319: {
                                int lastBodyOffset;
                                BranchInstruction bi = (BranchInstruction)instruction;
                                int offset = bi.GetJumpOffset();
                                int n = lastBodyOffset = subList.size() > 0 ? ((Instruction)subList.get((int)0)).offset : bi.offset;
                                if (lastBodyOffset >= offset || offset > test.offset) continue block10;
                                jumpInstructionBeforeLoop = bi;
                                i = 0;
                            }
                        }
                    }
                }
                if (jumpInstructionBeforeLoop == null) break block30;
                if (jumpInstructionBeforeLoop.opcode == 167) {
                    list.remove(index--);
                }
                Instruction beforeLoop = index >= 0 && index < list.size() ? list.get(index) : null;
                Instruction lastBodyLoop = null;
                Instruction beforeLastBodyLoop = null;
                if (subListLength > 0) {
                    lastBodyLoop = (Instruction)subList.get(0);
                    if (subListLength > 1) {
                        beforeLastBodyLoop = (Instruction)subList.get(1);
                        if (!InstructionUtil.CheckNoJumpToInterval(subList, 0, subListLength, lastBodyLoop.offset, test.offset)) {
                            lastBodyLoop = null;
                            beforeLastBodyLoop = null;
                        }
                    }
                }
                int typeLoop = FastInstructionListBuilder.GetLoopType(beforeLoop, test, beforeLastBodyLoop, lastBodyLoop);
                switch (typeLoop) {
                    case 2: {
                        if (subListLength > 0) {
                            Collections.reverse(subList);
                            FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLoopEntryOffset, test.offset, test.offset, jumpInstructionBeforeLoop.offset, test.offset, breakOffset, returnOffset);
                        }
                        int branch = 1;
                        if (breakOffset != -1) {
                            branch = breakOffset - test.offset;
                        }
                        list.set(++index, new FastTestList(301, test.offset, test.lineNumber, branch, test, subList));
                        break block31;
                    }
                    case 3: {
                        list.remove(index);
                        if (subListLength > 0) {
                            Collections.reverse(subList);
                            FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLoopEntryOffset, test.offset, test.offset, jumpInstructionBeforeLoop.offset, test.offset, breakOffset, returnOffset);
                        }
                        FastInstructionListBuilder.CreateForLoopCase1(classFile, method, list, index, beforeLoop, test, subList, breakOffset);
                        break block31;
                    }
                    case 6: {
                        int branch;
                        if (subListLength > 1) {
                            Collections.reverse(subList);
                            subList.remove(--subListLength);
                            FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLastBodyLoop.offset, lastBodyLoop.offset, lastBodyLoop.offset, jumpInstructionBeforeLoop.offset, lastBodyLoop.offset, breakOffset, returnOffset);
                            branch = 1;
                            if (breakOffset != -1) {
                                branch = breakOffset - test.offset;
                            }
                            list.set(++index, new FastFor(304, test.offset, test.lineNumber, branch, null, test, lastBodyLoop, subList));
                        } else {
                            if (subListLength == 1) {
                                FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLoopEntryOffset, test.offset, test.offset, jumpInstructionBeforeLoop.offset, test.offset, breakOffset, returnOffset);
                            }
                            branch = 1;
                            if (breakOffset != -1) {
                                branch = breakOffset - test.offset;
                            }
                            list.set(++index, new FastTestList(301, test.offset, test.lineNumber, branch, test, subList));
                        }
                        break block31;
                    }
                    case 7: {
                        if (subListLength > 0) {
                            list.remove(index);
                            Collections.reverse(subList);
                            subList.remove(--subListLength);
                            if (subListLength > 0) {
                                FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLastBodyLoop.offset, lastBodyLoop.offset, lastBodyLoop.offset, jumpInstructionBeforeLoop.offset, lastBodyLoop.offset, breakOffset, returnOffset);
                            }
                        }
                        index = FastInstructionListBuilder.CreateForLoopCase3(classFile, method, list, index, beforeLoop, test, lastBodyLoop, subList, breakOffset);
                        break block31;
                    }
                    default: {
                        throw new UnexpectedElementException("AnalyzeBackIf");
                    }
                }
            }
            if (subListLength > 0) {
                Collections.reverse(subList);
                FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLoopEntryOffset, test.offset, test.offset, beforeListOffset, test.offset, breakOffset, returnOffset);
                int branch = 1;
                if (breakOffset != -1) {
                    branch = breakOffset - test.offset;
                }
                list.set(++index, new FastTestList(302, test.offset, Instruction.UNKNOWN_LINE_NUMBER, branch, test, subList));
            } else {
                list.set(++index, new FastTestList(301, test.offset, test.lineNumber, 1, test, null));
            }
        }
        return index;
    }

    private static int SearchMinusJumpOffset(List<Instruction> list, int fromIndex, int toIndex, int beforeListOffset, int lastListOffset) {
        int breakOffset = -1;
        int index = toIndex;
        block6: while (index-- > fromIndex) {
            Instruction instruction = list.get(index);
            switch (instruction.opcode) {
                case 167: 
                case 260: 
                case 261: 
                case 262: 
                case 284: {
                    BranchInstruction bi = (BranchInstruction)instruction;
                    int jumpOffset = bi.GetJumpOffset();
                    if (jumpOffset == -1 || jumpOffset > beforeListOffset && lastListOffset >= jumpOffset || breakOffset != -1 && breakOffset <= jumpOffset) continue block6;
                    breakOffset = jumpOffset;
                    break;
                }
                case 301: 
                case 302: 
                case 304: 
                case 305: 
                case 319: {
                    int jumpOffset;
                    FastList fl = (FastList)instruction;
                    List instructions = fl.instructions;
                    if (instructions == null || (jumpOffset = FastInstructionListBuilder.SearchMinusJumpOffset(instructions, 0, instructions.size(), beforeListOffset, lastListOffset)) == -1 || jumpOffset > beforeListOffset && lastListOffset >= jumpOffset || breakOffset != -1 && breakOffset <= jumpOffset) continue block6;
                    breakOffset = jumpOffset;
                    break;
                }
                case 318: {
                    List<Instruction> finallyInstructions;
                    List instructions;
                    FastTry ft = (FastTry)instruction;
                    int jumpOffset = ft.GetJumpOffset();
                    if (!(jumpOffset == -1 || jumpOffset > beforeListOffset && lastListOffset >= jumpOffset || breakOffset != -1 && breakOffset <= jumpOffset)) {
                        breakOffset = jumpOffset;
                    }
                    if (!((jumpOffset = FastInstructionListBuilder.SearchMinusJumpOffset(instructions = ft.instructions, 0, instructions.size(), beforeListOffset, lastListOffset)) == -1 || jumpOffset > beforeListOffset && lastListOffset >= jumpOffset || breakOffset != -1 && breakOffset <= jumpOffset)) {
                        breakOffset = jumpOffset;
                    }
                    int i = ft.catches.size();
                    while (i-- > 0) {
                        List<Instruction> catchInstructions = ft.catches.get((int)i).instructions;
                        jumpOffset = FastInstructionListBuilder.SearchMinusJumpOffset(catchInstructions, 0, catchInstructions.size(), beforeListOffset, lastListOffset);
                        if (jumpOffset == -1 || jumpOffset > beforeListOffset && lastListOffset >= jumpOffset || breakOffset != -1 && breakOffset <= jumpOffset) continue;
                        breakOffset = jumpOffset;
                    }
                    if (ft.finallyInstructions == null || (jumpOffset = FastInstructionListBuilder.SearchMinusJumpOffset(finallyInstructions = ft.finallyInstructions, 0, finallyInstructions.size(), beforeListOffset, lastListOffset)) == -1 || jumpOffset > beforeListOffset && lastListOffset >= jumpOffset || breakOffset != -1 && breakOffset <= jumpOffset) continue block6;
                    breakOffset = jumpOffset;
                    break;
                }
                case 314: 
                case 315: 
                case 316: {
                    FastSwitch fs = (FastSwitch)instruction;
                    int jumpOffset = fs.GetJumpOffset();
                    if (!(jumpOffset == -1 || jumpOffset > beforeListOffset && lastListOffset >= jumpOffset || breakOffset != -1 && breakOffset <= jumpOffset)) {
                        breakOffset = jumpOffset;
                    }
                    int i = fs.pairs.length;
                    while (i-- > 0) {
                        List<Instruction> caseInstructions = fs.pairs[i].getInstructions();
                        if (caseInstructions == null || (jumpOffset = FastInstructionListBuilder.SearchMinusJumpOffset(caseInstructions, 0, caseInstructions.size(), beforeListOffset, lastListOffset)) == -1 || jumpOffset > beforeListOffset && lastListOffset >= jumpOffset || breakOffset != -1 && breakOffset <= jumpOffset) continue;
                        breakOffset = jumpOffset;
                    }
                    continue block6;
                }
            }
        }
        return breakOffset;
    }

    private static int GetMaxOffset(Instruction beforeWhileLoop, Instruction test) {
        return beforeWhileLoop.offset > test.offset ? beforeWhileLoop.offset : test.offset;
    }

    private static int GetMaxOffset(Instruction beforeWhileLoop, Instruction test, Instruction lastBodyWhileLoop) {
        int offset = FastInstructionListBuilder.GetMaxOffset(beforeWhileLoop, test);
        return offset > lastBodyWhileLoop.offset ? offset : lastBodyWhileLoop.offset;
    }

    private static Instruction CreateForEachVariableInstruction(Instruction i) {
        switch (i.opcode) {
            case 317: {
                ((FastDeclaration)i).instruction = null;
                return i;
            }
            case 58: {
                return new ALoad(25, i.offset, i.lineNumber, ((AStore)i).index);
            }
            case 54: {
                return new ILoad(21, i.offset, i.lineNumber, ((IStore)i).index);
            }
            case 269: {
                return new LoadInstruction(268, i.offset, i.lineNumber, ((StoreInstruction)i).index, ((StoreInstruction)i).getReturnedSignature(null, null));
            }
        }
        return i;
    }

    private static void CreateForLoopCase1(ClassFile classFile, Method method, List<Instruction> list, int beforeWhileLoopIndex, Instruction beforeWhileLoop, Instruction test, List<Instruction> subList, int breakOffset) {
        int forLoopOffset = FastInstructionListBuilder.GetMaxOffset(beforeWhileLoop, test);
        int branch = 1;
        if (breakOffset != -1) {
            branch = breakOffset - forLoopOffset;
        }
        if (FastInstructionListBuilder.IsAForEachIteratorPattern(classFile, method, beforeWhileLoop, test, subList)) {
            Instruction variable = FastInstructionListBuilder.CreateForEachVariableInstruction(subList.remove(0));
            InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)((AStore)beforeWhileLoop).valueref;
            Instruction values = insi.objectref;
            FastInstructionListBuilder.RemoveLocalVariable(method, (StoreInstruction)beforeWhileLoop);
            list.set(beforeWhileLoopIndex, new FastForEach(305, forLoopOffset, beforeWhileLoop.lineNumber, branch, variable, values, subList));
        } else {
            list.set(beforeWhileLoopIndex, new FastFor(304, forLoopOffset, beforeWhileLoop.lineNumber, branch, beforeWhileLoop, test, null, subList));
        }
    }

    private static int CreateForLoopCase3(ClassFile classFile, Method method, List<Instruction> list, int beforeWhileLoopIndex, Instruction beforeWhileLoop, Instruction test, Instruction lastBodyWhileLoop, List<Instruction> subList, int breakOffset) {
        int forLoopOffset = FastInstructionListBuilder.GetMaxOffset(beforeWhileLoop, test, lastBodyWhileLoop);
        int branch = 1;
        if (breakOffset != -1) {
            branch = breakOffset - forLoopOffset;
        }
        switch (FastInstructionListBuilder.GetForEachArrayPatternType(classFile, beforeWhileLoop, test, lastBodyWhileLoop, list, beforeWhileLoopIndex, subList)) {
            case 1: {
                Instruction variable = FastInstructionListBuilder.CreateForEachVariableInstruction(subList.remove(0));
                StoreInstruction beforeBeforeWhileLoop = (StoreInstruction)list.remove(--beforeWhileLoopIndex);
                AssignmentInstruction ai = (AssignmentInstruction)((ArrayLength)beforeBeforeWhileLoop.valueref).arrayref;
                Instruction values = ai.value2;
                FastInstructionListBuilder.RemoveLocalVariable(method, beforeBeforeWhileLoop);
                FastInstructionListBuilder.RemoveLocalVariable(method, (StoreInstruction)beforeWhileLoop);
                FastInstructionListBuilder.RemoveLocalVariable(method, (AStore)ai.value1);
                list.set(beforeWhileLoopIndex, new FastForEach(305, forLoopOffset, variable.lineNumber, branch, variable, values, subList));
                break;
            }
            case 2: {
                Instruction variable = FastInstructionListBuilder.CreateForEachVariableInstruction(subList.remove(0));
                StoreInstruction beforeBeforeWhileLoop = (StoreInstruction)list.remove(--beforeWhileLoopIndex);
                StoreInstruction beforeBeforeBeforeWhileLoop = (StoreInstruction)list.remove(--beforeWhileLoopIndex);
                Instruction values = beforeBeforeBeforeWhileLoop.valueref;
                FastInstructionListBuilder.RemoveLocalVariable(method, beforeBeforeWhileLoop);
                FastInstructionListBuilder.RemoveLocalVariable(method, (StoreInstruction)beforeWhileLoop);
                FastInstructionListBuilder.RemoveLocalVariable(method, beforeBeforeBeforeWhileLoop);
                list.set(beforeWhileLoopIndex, new FastForEach(305, forLoopOffset, variable.lineNumber, branch, variable, values, subList));
                break;
            }
            case 3: {
                Instruction variable = FastInstructionListBuilder.CreateForEachVariableInstruction(subList.remove(0));
                StoreInstruction siIndex = (StoreInstruction)list.remove(--beforeWhileLoopIndex);
                StoreInstruction siTmpArray = (StoreInstruction)list.remove(--beforeWhileLoopIndex);
                Instruction values = siTmpArray.valueref;
                FastInstructionListBuilder.RemoveLocalVariable(method, (StoreInstruction)beforeWhileLoop);
                FastInstructionListBuilder.RemoveLocalVariable(method, siIndex);
                FastInstructionListBuilder.RemoveLocalVariable(method, siTmpArray);
                list.set(beforeWhileLoopIndex, new FastForEach(305, forLoopOffset, variable.lineNumber, branch, variable, values, subList));
                break;
            }
            default: {
                list.set(beforeWhileLoopIndex, new FastFor(304, forLoopOffset, beforeWhileLoop.lineNumber, branch, beforeWhileLoop, test, lastBodyWhileLoop, subList));
            }
        }
        return beforeWhileLoopIndex;
    }

    private static boolean IsAForEachIteratorPattern(ClassFile classFile, Method method, Instruction init, Instruction test, List<Instruction> subList) {
        if (classFile.getMajorVersion() < 49 || subList.size() == 0) {
            return false;
        }
        Instruction firstInstruction = subList.get(0);
        if (test.lineNumber != firstInstruction.lineNumber) {
            return false;
        }
        if (init.opcode != 58) {
            return false;
        }
        AStore astoreIterator = (AStore)init;
        if (astoreIterator.valueref.opcode != 185 && astoreIterator.valueref.opcode != 182) {
            return false;
        }
        LocalVariable lv = method.getLocalVariables().getLocalVariableWithIndexAndOffset(astoreIterator.index, astoreIterator.offset);
        if (lv == null || lv.signature_index == 0) {
            return false;
        }
        ConstantPool constants = classFile.getConstantPool();
        InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)astoreIterator.valueref;
        ConstantMethodref cmr = constants.getConstantMethodref(insi.index);
        ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.name_and_type_index);
        String iteratorMethodName = constants.getConstantUtf8(cnat.name_index);
        if (!"iterator".equals(iteratorMethodName)) {
            return false;
        }
        String iteratorMethodDescriptor = constants.getConstantUtf8(cnat.descriptor_index);
        if (!"()Ljava/util/Iterator;".equals(iteratorMethodDescriptor)) {
            return false;
        }
        if (test.opcode != 260) {
            return false;
        }
        IfInstruction ifi = (IfInstruction)test;
        if (ifi.value.opcode != 185) {
            return false;
        }
        insi = (InvokeNoStaticInstruction)ifi.value;
        if (insi.objectref.opcode != 25 || ((ALoad)insi.objectref).index != astoreIterator.index) {
            return false;
        }
        cmr = constants.getConstantMethodref(insi.index);
        cnat = constants.getConstantNameAndType(cmr.name_and_type_index);
        String hasNextMethodName = constants.getConstantUtf8(cnat.name_index);
        if (!"hasNext".equals(hasNextMethodName)) {
            return false;
        }
        String hasNextMethodDescriptor = constants.getConstantUtf8(cnat.descriptor_index);
        if (!"()Z".equals(hasNextMethodDescriptor)) {
            return false;
        }
        if (firstInstruction.opcode != 317) {
            return false;
        }
        FastDeclaration declaration = (FastDeclaration)firstInstruction;
        if (declaration.instruction == null) {
            return false;
        }
        if (declaration.instruction.opcode != 58) {
            return false;
        }
        AStore astoreVariable = (AStore)declaration.instruction;
        if (astoreVariable.valueref.opcode == 192) {
            CheckCast cc = (CheckCast)astoreVariable.valueref;
            if (cc.objectref.opcode != 185) {
                return false;
            }
            insi = (InvokeNoStaticInstruction)cc.objectref;
        } else {
            if (astoreVariable.valueref.opcode != 185) {
                return false;
            }
            insi = (InvokeNoStaticInstruction)astoreVariable.valueref;
        }
        if (insi.objectref.opcode != 25 || ((ALoad)insi.objectref).index != astoreIterator.index) {
            return false;
        }
        cmr = constants.getConstantMethodref(insi.index);
        cnat = constants.getConstantNameAndType(cmr.name_and_type_index);
        String nextMethodName = constants.getConstantUtf8(cnat.name_index);
        if (!"next".equals(nextMethodName)) {
            return false;
        }
        String nextMethodDescriptor = constants.getConstantUtf8(cnat.descriptor_index);
        return "()Ljava/lang/Object;".equals(nextMethodDescriptor);
    }

    private static int GetForEachArraySun15PatternType(Instruction init, Instruction test, Instruction inc, Instruction firstInstruction, StoreInstruction siLenght) {
        ArrayLength al = (ArrayLength)siLenght.valueref;
        if (al.arrayref.opcode != 265) {
            return 0;
        }
        AssignmentInstruction ai = (AssignmentInstruction)al.arrayref;
        if (!ai.operator.equals("=") || ai.value1.opcode != 58) {
            return 0;
        }
        StoreInstruction siTmpArray = (StoreInstruction)ai.value1;
        if (init.opcode != 54) {
            return 0;
        }
        StoreInstruction siIndex = (StoreInstruction)init;
        if (siIndex.valueref.opcode != 256) {
            return 0;
        }
        IConst iconst = (IConst)siIndex.valueref;
        if (iconst.value != 0 || !iconst.signature.equals("I")) {
            return 0;
        }
        if (test.opcode != 261) {
            return 0;
        }
        IfCmp ifcmp = (IfCmp)test;
        if (ifcmp.value1.opcode != 21 || ifcmp.value2.opcode != 21 || ((ILoad)ifcmp.value1).index != siIndex.index || ((ILoad)ifcmp.value2).index != siLenght.index) {
            return 0;
        }
        if (inc.opcode != 132 || ((IInc)inc).index != siIndex.index || ((IInc)inc).count != 1) {
            return 0;
        }
        if (firstInstruction.opcode == 317) {
            FastDeclaration declaration = (FastDeclaration)firstInstruction;
            if (declaration.instruction == null) {
                return 0;
            }
            firstInstruction = declaration.instruction;
        }
        if (firstInstruction.opcode != 269 && firstInstruction.opcode != 58 && firstInstruction.opcode != 54) {
            return 0;
        }
        StoreInstruction siVariable = (StoreInstruction)firstInstruction;
        if (siVariable.valueref.opcode != 271) {
            return 0;
        }
        ArrayLoadInstruction ali = (ArrayLoadInstruction)siVariable.valueref;
        if (ali.arrayref.opcode != 25 || ali.indexref.opcode != 21 || ((ALoad)ali.arrayref).index != siTmpArray.index || ((ILoad)ali.indexref).index != siIndex.index) {
            return 0;
        }
        return 1;
    }

    private static int GetForEachArraySun16PatternType(Instruction init, Instruction test, Instruction inc, Instruction firstInstruction, StoreInstruction siLenght, Instruction beforeBeforeForInstruction) {
        ArrayLength al = (ArrayLength)siLenght.valueref;
        if (al.arrayref.opcode != 25) {
            return 0;
        }
        if (beforeBeforeForInstruction.opcode != 58) {
            return 0;
        }
        StoreInstruction siTmpArray = (StoreInstruction)beforeBeforeForInstruction;
        if (siTmpArray.index != ((IndexInstruction)al.arrayref).index) {
            return 0;
        }
        if (init.opcode != 54) {
            return 0;
        }
        StoreInstruction siIndex = (StoreInstruction)init;
        if (siIndex.valueref.opcode != 256) {
            return 0;
        }
        IConst iconst = (IConst)siIndex.valueref;
        if (iconst.value != 0 || !iconst.signature.equals("I")) {
            return 0;
        }
        if (test.opcode != 261) {
            return 0;
        }
        IfCmp ifcmp = (IfCmp)test;
        if (ifcmp.value1.opcode != 21 || ifcmp.value2.opcode != 21 || ((ILoad)ifcmp.value1).index != siIndex.index || ((ILoad)ifcmp.value2).index != siLenght.index) {
            return 0;
        }
        if (inc.opcode != 132 || ((IInc)inc).index != siIndex.index || ((IInc)inc).count != 1) {
            return 0;
        }
        if (firstInstruction.opcode == 317) {
            FastDeclaration declaration = (FastDeclaration)firstInstruction;
            if (declaration.instruction == null) {
                return 0;
            }
            firstInstruction = declaration.instruction;
        }
        if (firstInstruction.opcode != 269 && firstInstruction.opcode != 58 && firstInstruction.opcode != 54) {
            return 0;
        }
        StoreInstruction siVariable = (StoreInstruction)firstInstruction;
        if (siVariable.valueref.opcode != 271) {
            return 0;
        }
        ArrayLoadInstruction ali = (ArrayLoadInstruction)siVariable.valueref;
        if (ali.arrayref.opcode != 25 || ali.indexref.opcode != 21 || ((ALoad)ali.arrayref).index != siTmpArray.index || ((ILoad)ali.indexref).index != siIndex.index) {
            return 0;
        }
        return 2;
    }

    private static int GetForEachArrayIbmPatternType(ClassFile classFile, Instruction init, Instruction test, Instruction inc, List<Instruction> list, int beforeWhileLoopIndex, Instruction firstInstruction, StoreInstruction siIndex) {
        IConst icont = (IConst)siIndex.valueref;
        if (icont.value != 0) {
            return 0;
        }
        if (beforeWhileLoopIndex < 2) {
            return 0;
        }
        Instruction beforeBeforeForInstruction = list.get(beforeWhileLoopIndex - 2);
        if (test.lineNumber != beforeBeforeForInstruction.lineNumber) {
            return 0;
        }
        if (beforeBeforeForInstruction.opcode != 58) {
            return 0;
        }
        StoreInstruction siTmpArray = (StoreInstruction)beforeBeforeForInstruction;
        if (init.opcode != 54) {
            return 0;
        }
        StoreInstruction siLenght = (StoreInstruction)init;
        if (siLenght.valueref.opcode != 190) {
            return 0;
        }
        ArrayLength al = (ArrayLength)siLenght.valueref;
        if (al.arrayref.opcode != 25) {
            return 0;
        }
        if (((ALoad)al.arrayref).index != siTmpArray.index) {
            return 0;
        }
        if (test.opcode != 261) {
            return 0;
        }
        IfCmp ifcmp = (IfCmp)test;
        if (ifcmp.value1.opcode != 21 || ifcmp.value2.opcode != 21 || ((ILoad)ifcmp.value1).index != siIndex.index || ((ILoad)ifcmp.value2).index != siLenght.index) {
            return 0;
        }
        if (inc.opcode != 132 || ((IInc)inc).index != siIndex.index || ((IInc)inc).count != 1) {
            return 0;
        }
        if (firstInstruction.opcode != 317) {
            return 0;
        }
        FastDeclaration declaration = (FastDeclaration)firstInstruction;
        if (declaration.instruction == null) {
            return 0;
        }
        if (declaration.instruction.opcode != 269 && declaration.instruction.opcode != 58 && declaration.instruction.opcode != 54) {
            return 0;
        }
        StoreInstruction siVariable = (StoreInstruction)declaration.instruction;
        if (siVariable.valueref.opcode != 271) {
            return 0;
        }
        ArrayLoadInstruction ali = (ArrayLoadInstruction)siVariable.valueref;
        if (ali.arrayref.opcode != 25 || ali.indexref.opcode != 21 || ((ALoad)ali.arrayref).index != siTmpArray.index || ((ILoad)ali.indexref).index != siIndex.index) {
            return 0;
        }
        return 3;
    }

    private static int GetForEachArrayPatternType(ClassFile classFile, Instruction init, Instruction test, Instruction inc, List<Instruction> list, int beforeWhileLoopIndex, List<Instruction> subList) {
        if (classFile.getMajorVersion() < 49 || beforeWhileLoopIndex == 0 || subList.size() == 0) {
            return 0;
        }
        Instruction firstInstruction = subList.get(0);
        if (test.lineNumber != firstInstruction.lineNumber) {
            return 0;
        }
        Instruction beforeForInstruction = list.get(beforeWhileLoopIndex - 1);
        if (test.lineNumber != beforeForInstruction.lineNumber) {
            return 0;
        }
        if (beforeForInstruction.opcode != 54) {
            return 0;
        }
        StoreInstruction si = (StoreInstruction)beforeForInstruction;
        if (si.valueref.opcode == 190) {
            ArrayLength al = (ArrayLength)si.valueref;
            if (al.arrayref.opcode == 265) {
                return FastInstructionListBuilder.GetForEachArraySun15PatternType(init, test, inc, firstInstruction, si);
            }
            if (beforeWhileLoopIndex > 1) {
                Instruction beforeBeforeForInstruction = list.get(beforeWhileLoopIndex - 2);
                return FastInstructionListBuilder.GetForEachArraySun16PatternType(init, test, inc, firstInstruction, si, beforeBeforeForInstruction);
            }
        }
        if (si.valueref.opcode == 256) {
            return FastInstructionListBuilder.GetForEachArrayIbmPatternType(classFile, init, test, inc, list, beforeWhileLoopIndex, firstInstruction, si);
        }
        return 0;
    }

    private static int GetLoopType(Instruction beforeLoop, Instruction test, Instruction beforeLastBodyLoop, Instruction lastBodyLoop) {
        if (beforeLoop == null) {
            if (test == null) {
                if (lastBodyLoop == null) {
                    return 0;
                }
                return beforeLastBodyLoop != null && beforeLastBodyLoop.lineNumber > lastBodyLoop.lineNumber ? 4 : 0;
            }
            if (lastBodyLoop == null) {
                return 2;
            }
            if (test.lineNumber == Instruction.UNKNOWN_LINE_NUMBER) {
                return 2;
            }
            return test.lineNumber == lastBodyLoop.lineNumber ? 6 : 2;
        }
        if (beforeLoop.opcode == 265) {
            beforeLoop = ((AssignmentInstruction)beforeLoop).value1;
        }
        if (test == null) {
            if (lastBodyLoop == null) {
                return 0;
            }
            if (lastBodyLoop.opcode == 265) {
                lastBodyLoop = ((AssignmentInstruction)lastBodyLoop).value1;
            }
            if (beforeLoop.lineNumber == Instruction.UNKNOWN_LINE_NUMBER) {
                return FastInstructionListBuilder.CheckBeforeLoopAndLastBodyLoop(beforeLoop, lastBodyLoop) ? 5 : 0;
            }
            if (beforeLoop.lineNumber == lastBodyLoop.lineNumber) {
                return 5;
            }
            return beforeLastBodyLoop != null && beforeLastBodyLoop.lineNumber > lastBodyLoop.lineNumber ? 4 : 0;
        }
        if (lastBodyLoop == null) {
            if (beforeLoop.lineNumber == Instruction.UNKNOWN_LINE_NUMBER) {
                return 2;
            }
            return beforeLoop.lineNumber == test.lineNumber ? 3 : 2;
        }
        if (lastBodyLoop.opcode == 265) {
            lastBodyLoop = ((AssignmentInstruction)lastBodyLoop).value1;
        }
        if (beforeLoop.lineNumber == Instruction.UNKNOWN_LINE_NUMBER) {
            return FastInstructionListBuilder.CheckBeforeLoopAndLastBodyLoop(beforeLoop, lastBodyLoop) ? 7 : 2;
        }
        if (beforeLastBodyLoop == null) {
            if (beforeLoop.lineNumber == test.lineNumber) {
                return beforeLoop.lineNumber == lastBodyLoop.lineNumber ? 7 : 3;
            }
            return test.lineNumber == lastBodyLoop.lineNumber ? 6 : 2;
        }
        if (beforeLastBodyLoop.lineNumber >= lastBodyLoop.lineNumber) {
            if (beforeLoop.lineNumber == test.lineNumber) {
                return 7;
            }
            return FastInstructionListBuilder.CheckBeforeLoopAndLastBodyLoop(beforeLoop, lastBodyLoop) ? 7 : 6;
        }
        return beforeLoop.lineNumber == test.lineNumber ? 3 : 2;
    }

    private static boolean CheckBeforeLoopAndLastBodyLoop(Instruction beforeLoop, Instruction lastBodyLoop) {
        switch (beforeLoop.opcode) {
            case 25: 
            case 58: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 268: 
            case 269: {
                switch (lastBodyLoop.opcode) {
                    case 25: 
                    case 58: 
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 268: 
                    case 269: {
                        return ((IndexInstruction)beforeLoop).index == ((IndexInstruction)lastBodyLoop).index;
                    }
                }
                break;
            }
            case 54: {
                if (beforeLoop.opcode != lastBodyLoop.opcode && lastBodyLoop.opcode != 132) break;
                return ((IndexInstruction)beforeLoop).index == ((IndexInstruction)lastBodyLoop).index;
            }
        }
        return false;
    }

    private static int AnalyzeBackGoto(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeListOffset, int afterSubListOffset, int returnOffset, int jumpInstructionIndex, Instruction jumpInstruction, int firstOffset) {
        ArrayList<Instruction> subList = new ArrayList<Instruction>();
        int index = jumpInstructionIndex - 1;
        switch (jumpInstruction.opcode) {
            case 318: 
            case 319: {
                subList.add(list.get(jumpInstructionIndex));
                list.set(jumpInstructionIndex, null);
            }
        }
        while (index >= 0 && list.get((int)index).offset >= firstOffset) {
            subList.add(list.remove(index--));
        }
        int subListLength = subList.size();
        if (subListLength > 0) {
            Instruction beforeLoop;
            Instruction instruction = beforeLoop = index >= 0 ? list.get(index) : null;
            if (beforeLoop != null) {
                beforeListOffset = beforeLoop.offset;
            }
            Instruction instruction2 = (Instruction)subList.get(subListLength - 1);
            int breakOffset = FastInstructionListBuilder.SearchMinusJumpOffset(subList, 0, subListLength, beforeListOffset, jumpInstruction.offset);
            BranchInstruction test = null;
            switch (instruction2.opcode) {
                case 260: 
                case 261: 
                case 262: 
                case 284: {
                    BranchInstruction bi = (BranchInstruction)instruction2;
                    if (bi.GetJumpOffset() != breakOffset) break;
                    test = bi;
                }
            }
            Instruction lastBodyLoop = null;
            Instruction beforeLastBodyLoop = null;
            if (subListLength > 0) {
                lastBodyLoop = (Instruction)subList.get(0);
                if (lastBodyLoop == test) {
                    lastBodyLoop = null;
                } else if (subListLength > 1) {
                    beforeLastBodyLoop = (Instruction)subList.get(1);
                    if (beforeLastBodyLoop == test) {
                        beforeLastBodyLoop = null;
                    }
                    if (!InstructionUtil.CheckNoJumpToInterval(subList, 0, subListLength, lastBodyLoop.offset, jumpInstruction.offset)) {
                        lastBodyLoop = null;
                        beforeLastBodyLoop = null;
                    } else if (!InstructionUtil.CheckNoJumpToInterval(subList, 0, subListLength, beforeListOffset, firstOffset)) {
                        lastBodyLoop = null;
                        beforeLastBodyLoop = null;
                    }
                }
            }
            int typeLoop = FastInstructionListBuilder.GetLoopType(beforeLoop, test, beforeLastBodyLoop, lastBodyLoop);
            switch (typeLoop) {
                case 0: {
                    Collections.reverse(subList);
                    Instruction firstBodyLoop = (Instruction)subList.get(0);
                    FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeListOffset, firstBodyLoop.offset, afterSubListOffset, beforeListOffset, afterSubListOffset, breakOffset, returnOffset);
                    int branch = 1;
                    if (breakOffset != -1) {
                        branch = breakOffset - jumpInstruction.offset;
                    }
                    list.set(++index, new FastList(303, jumpInstruction.offset, Instruction.UNKNOWN_LINE_NUMBER, branch, subList));
                    break;
                }
                case 1: {
                    Collections.reverse(subList);
                    Instruction firstBodyLoop = (Instruction)subList.get(0);
                    FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLoop.offset, firstBodyLoop.offset, afterSubListOffset, beforeListOffset, afterSubListOffset, breakOffset, returnOffset);
                    int branch = 1;
                    if (breakOffset != -1) {
                        branch = breakOffset - jumpInstruction.offset;
                    }
                    list.set(++index, new FastList(303, jumpInstruction.offset, Instruction.UNKNOWN_LINE_NUMBER, branch, subList));
                    break;
                }
                case 2: {
                    subList.remove(--subListLength);
                    if (subListLength > 0) {
                        Collections.reverse(subList);
                        int beforeTestOffset = beforeLoop == null ? (beforeListOffset == -1 ? -1 : beforeListOffset) : beforeLoop.offset;
                        FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeTestOffset, test.offset, afterSubListOffset, test.offset, afterSubListOffset, breakOffset, returnOffset);
                    }
                    int branch = 1;
                    if (breakOffset != -1) {
                        branch = breakOffset - jumpInstruction.offset;
                    }
                    ComparisonInstructionAnalyzer.InverseComparison(test);
                    list.set(++index, new FastTestList(301, jumpInstruction.offset, test.lineNumber, branch, test, subList));
                    break;
                }
                case 3: {
                    list.remove(index);
                    subList.remove(--subListLength);
                    if (subListLength > 0) {
                        lastBodyLoop = (Instruction)subList.get(0);
                        Collections.reverse(subList);
                        FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLoop.offset, test.offset, afterSubListOffset, test.offset, afterSubListOffset, breakOffset, returnOffset);
                    }
                    ComparisonInstructionAnalyzer.InverseComparison(test);
                    FastInstructionListBuilder.CreateForLoopCase1(classFile, method, list, index, beforeLoop, test, subList, breakOffset);
                    break;
                }
                case 4: {
                    Collections.reverse(subList);
                    subList.remove(--subListLength);
                    if (subListLength > 0) {
                        beforeLastBodyLoop = (Instruction)subList.get(--subListLength);
                        FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLastBodyLoop.offset, lastBodyLoop.offset, lastBodyLoop.offset, beforeListOffset, afterSubListOffset, breakOffset, returnOffset);
                    }
                    int branch = 1;
                    if (breakOffset != -1) {
                        branch = breakOffset - jumpInstruction.offset;
                    }
                    list.set(++index, new FastFor(304, jumpInstruction.offset, lastBodyLoop.lineNumber, branch, null, null, lastBodyLoop, subList));
                    break;
                }
                case 5: {
                    list.remove(index);
                    Collections.reverse(subList);
                    subList.remove(--subListLength);
                    if (subListLength > 0) {
                        beforeLastBodyLoop = (Instruction)subList.get(--subListLength);
                        FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLastBodyLoop.offset, lastBodyLoop.offset, lastBodyLoop.offset, beforeListOffset, afterSubListOffset, breakOffset, returnOffset);
                    }
                    int branch = 1;
                    if (breakOffset != -1) {
                        branch = breakOffset - jumpInstruction.offset;
                    }
                    list.set(index, new FastFor(304, jumpInstruction.offset, lastBodyLoop.lineNumber, branch, beforeLoop, null, lastBodyLoop, subList));
                    break;
                }
                case 6: {
                    subList.remove(--subListLength);
                    if (subListLength > 1) {
                        Collections.reverse(subList);
                        subList.remove(--subListLength);
                        if (subListLength > 0) {
                            beforeLastBodyLoop = (Instruction)subList.get(subListLength - 1);
                            FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLastBodyLoop.offset, lastBodyLoop.offset, lastBodyLoop.offset, test.offset, afterSubListOffset, breakOffset, returnOffset);
                        }
                        int branch = 1;
                        if (breakOffset != -1) {
                            branch = breakOffset - jumpInstruction.offset;
                        }
                        ComparisonInstructionAnalyzer.InverseComparison(test);
                        list.set(++index, new FastFor(304, jumpInstruction.offset, lastBodyLoop.lineNumber, branch, null, test, lastBodyLoop, subList));
                        break;
                    }
                    if (subListLength == 1) {
                        int beforeTestOffset = beforeLoop == null ? (beforeListOffset == -1 ? -1 : beforeListOffset) : beforeLoop.offset;
                        FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeTestOffset, test.offset, lastBodyLoop.offset, test.offset, afterSubListOffset, breakOffset, returnOffset);
                    }
                    int branch = 1;
                    if (breakOffset != -1) {
                        branch = breakOffset - jumpInstruction.offset;
                    }
                    ComparisonInstructionAnalyzer.InverseComparison(test);
                    list.set(++index, new FastTestList(301, jumpInstruction.offset, test.lineNumber, branch, test, subList));
                    break;
                }
                case 7: {
                    list.remove(index);
                    subList.remove(--subListLength);
                    Collections.reverse(subList);
                    subList.remove(--subListLength);
                    if (subListLength > 0) {
                        beforeLastBodyLoop = (Instruction)subList.get(subListLength - 1);
                        FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLastBodyLoop.offset, lastBodyLoop.offset, lastBodyLoop.offset, test.offset, afterSubListOffset, breakOffset, returnOffset);
                    }
                    ComparisonInstructionAnalyzer.InverseComparison(test);
                    index = FastInstructionListBuilder.CreateForLoopCase3(classFile, method, list, index, beforeLoop, test, lastBodyLoop, subList, breakOffset);
                }
            }
        } else {
            list.set(++index, new FastList(303, jumpInstruction.offset, Instruction.UNKNOWN_LINE_NUMBER, 0, subList));
        }
        return index;
    }

    private static void AnalyzeIfAndIfElse(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int afterListOffset, int breakOffset, int returnOffset, int testIndex, ConditionalBranchInstruction test) {
        int length = list.size();
        if (length == 0) {
            return;
        }
        int elseOffset = test.GetJumpOffset();
        if (test.branch < 0 && beforeLoopEntryOffset < elseOffset && elseOffset <= loopEntryOffset && afterBodyLoopOffset == afterListOffset) {
            elseOffset = afterListOffset;
        }
        if (elseOffset <= test.offset || afterListOffset != -1 && elseOffset > afterListOffset) {
            return;
        }
        int index = testIndex + 1;
        if (index < length) {
            ArrayList<Instruction> subList = new ArrayList<Instruction>();
            length = FastInstructionListBuilder.ExtrackBlock(list, subList, index, length, elseOffset);
            int subListLength = subList.size();
            if (subListLength == 0) {
                ComparisonInstructionAnalyzer.InverseComparison(test);
                list.set(testIndex, new FastTestList(306, test.offset, test.lineNumber, elseOffset - test.offset, test, null));
                return;
            }
            int beforeSubListOffset = test.offset;
            Instruction beforeElseBlock = (Instruction)subList.get(subListLength - 1);
            int minusJumpOffset = FastInstructionListBuilder.SearchMinusJumpOffset(subList, 0, subListLength, test.offset, beforeElseBlock.offset);
            int lastListOffset = list.get((int)(length - 1)).offset;
            if (minusJumpOffset == -1 && subListLength > 1 && beforeElseBlock.opcode == 177 && (afterListOffset == -1 || afterListOffset == returnOffset || ByteCodeUtil.JumpTo(method.getCode(), ByteCodeUtil.NextInstructionOffset(method.getCode(), lastListOffset), returnOffset))) {
                if (((Instruction)subList.get((int)(subListLength - 2))).lineNumber > beforeElseBlock.lineNumber) {
                    minusJumpOffset = returnOffset == -1 ? lastListOffset + 1 : returnOffset;
                } else if (index < length && list.get((int)index).lineNumber < beforeElseBlock.lineNumber) {
                    int n = minusJumpOffset = returnOffset == -1 ? lastListOffset + 1 : returnOffset;
                }
            }
            if (minusJumpOffset != -1) {
                int positiveJumpOffset;
                if (subListLength == 1 && beforeElseBlock.opcode == 167) {
                    FastInstructionListBuilder.CreateBreakAndContinue(method, subList, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, breakOffset, returnOffset);
                    ComparisonInstructionAnalyzer.InverseComparison(test);
                    list.set(testIndex, new FastTestList(306, beforeElseBlock.offset, test.lineNumber, elseOffset - beforeElseBlock.offset, test, subList));
                    return;
                }
                int afterIfElseOffset = minusJumpOffset < test.offset && beforeLoopEntryOffset < minusJumpOffset && minusJumpOffset <= loopEntryOffset ? (((positiveJumpOffset = FastInstructionListBuilder.SearchMinusJumpOffset(subList, 0, subListLength, -1, beforeElseBlock.offset)) == -1 || positiveJumpOffset >= afterListOffset) && afterBodyLoopOffset == afterListOffset ? afterListOffset : positiveJumpOffset) : minusJumpOffset;
                if (afterIfElseOffset > elseOffset && (afterListOffset == -1 || afterIfElseOffset <= afterListOffset || ByteCodeUtil.JumpTo(method.getCode(), ByteCodeUtil.NextInstructionOffset(method.getCode(), lastListOffset), afterIfElseOffset))) {
                    if (beforeElseBlock.opcode == 167 && ((Goto)beforeElseBlock).GetJumpOffset() == minusJumpOffset || beforeElseBlock.opcode == 177) {
                        subList.remove(subListLength - 1);
                    }
                    ArrayList<Instruction> subElseList = new ArrayList<Instruction>();
                    length = FastInstructionListBuilder.ExtrackBlock(list, subElseList, index, length, afterIfElseOffset);
                    if (subElseList.size() > 0) {
                        FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, beforeSubListOffset, afterIfElseOffset, breakOffset, returnOffset);
                        beforeSubListOffset = beforeElseBlock.offset;
                        FastInstructionListBuilder.AnalyzeList(classFile, method, subElseList, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, beforeSubListOffset, afterIfElseOffset, breakOffset, returnOffset);
                        int subElseListLength = subElseList.size();
                        int lastIfElseOffset = subElseListLength > 0 ? ((Instruction)subElseList.get((int)(subElseListLength - 1))).offset : beforeSubListOffset;
                        ComparisonInstructionAnalyzer.InverseComparison(test);
                        list.set(testIndex, new FastTest2Lists(307, lastIfElseOffset, test.lineNumber, afterIfElseOffset - lastIfElseOffset, test, subList, subElseList));
                        return;
                    }
                }
            }
            FastInstructionListBuilder.AnalyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, beforeSubListOffset, elseOffset, breakOffset, returnOffset);
            ComparisonInstructionAnalyzer.InverseComparison(test);
            list.set(testIndex, new FastTestList(306, beforeElseBlock.offset, test.lineNumber, elseOffset - beforeElseBlock.offset, test, subList));
        } else if (elseOffset == breakOffset) {
            list.set(testIndex, new FastInstruction(309, test.offset, test.lineNumber, test));
        } else {
            list.set(testIndex, new FastTestList(306, test.offset, test.lineNumber, elseOffset - test.offset, test, null));
        }
    }

    private static int ExtrackBlock(List<Instruction> list, List<Instruction> subList, int index, int length, int endOffset) {
        while (index < length && list.get((int)index).offset < endOffset) {
            subList.add(list.remove(index));
            --length;
        }
        return length;
    }

    private static void AnalyzeLookupSwitch(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int afterListOffset, int returnOffset, int switchIndex, LookupSwitch ls) {
        int pairLength = ls.keys.length;
        FastSwitch.Pair[] pairs = new FastSwitch.Pair[pairLength + 1];
        boolean defaultFlag = true;
        int pairIndex = 0;
        int i = 0;
        while (i < pairLength) {
            if (defaultFlag && ls.offsets[i] > ls.defaultOffset) {
                pairs[pairIndex++] = new FastSwitch.Pair(true, 0, ls.offset + ls.defaultOffset);
                defaultFlag = false;
            }
            pairs[pairIndex++] = new FastSwitch.Pair(false, ls.keys[i], ls.offset + ls.offsets[i]);
            ++i;
        }
        if (defaultFlag) {
            pairs[pairIndex++] = new FastSwitch.Pair(true, 0, ls.offset + ls.defaultOffset);
        }
        int switchOpcode = FastInstructionListBuilder.AnalyzeSwitchType(classFile, ls.key);
        if (classFile.getMajorVersion() >= 51 && switchOpcode == 314 && ls.key.opcode == 21 && switchIndex > 2 && FastInstructionListBuilder.AnalyzeSwitchString(classFile, localVariables, list, switchIndex, ls, pairs)) {
            list.remove(--switchIndex);
            list.remove(--switchIndex);
            list.remove(--switchIndex);
            switchOpcode = 316;
        }
        FastInstructionListBuilder.AnalyzeSwitch(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, returnOffset, switchIndex, switchOpcode, ls.offset, ls.lineNumber, ls.key, pairs, pairLength);
    }

    private static int AnalyzeSwitchType(ClassFile classFile, Instruction i) {
        if (i.opcode == 271) {
            ArrayLoadInstruction ali = (ArrayLoadInstruction)i;
            if (ali.indexref.opcode == 182) {
                if (ali.arrayref.opcode == 178) {
                    GetStatic gs = (GetStatic)ali.arrayref;
                    ConstantPool constants = classFile.getConstantPool();
                    ConstantFieldref cfr = constants.getConstantFieldref(gs.index);
                    ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
                    if (classFile.getSwitchMaps().containsKey(cnat.name_index)) {
                        Invokevirtual iv = (Invokevirtual)ali.indexref;
                        if (iv.args.size() == 0) {
                            ConstantMethodref cmr = constants.getConstantMethodref(iv.index);
                            cnat = constants.getConstantNameAndType(cmr.name_and_type_index);
                            if ("ordinal".equals(constants.getConstantUtf8(cnat.name_index))) {
                                return 315;
                            }
                        }
                    }
                } else if (ali.arrayref.opcode == 184) {
                    Invokestatic is = (Invokestatic)ali.arrayref;
                    if (is.args.size() == 0) {
                        ConstantPool constants = classFile.getConstantPool();
                        ConstantMethodref cmr = constants.getConstantMethodref(is.index);
                        if (cmr.class_index == classFile.getThisClassIndex()) {
                            ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.name_and_type_index);
                            if (classFile.getSwitchMaps().containsKey(cnat.name_index)) {
                                Invokevirtual iv = (Invokevirtual)ali.indexref;
                                if (iv.args.size() == 0) {
                                    cmr = constants.getConstantMethodref(iv.index);
                                    cnat = constants.getConstantNameAndType(cmr.name_and_type_index);
                                    if ("ordinal".equals(constants.getConstantUtf8(cnat.name_index))) {
                                        return 315;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return 314;
    }

    private static int AnalyzeTableSwitch(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int afterListOffset, int returnOffset, int switchIndex, TableSwitch ts) {
        int pairLength = ts.offsets.length;
        FastSwitch.Pair[] pairs = new FastSwitch.Pair[pairLength + 1];
        boolean defaultFlag = true;
        int pairIndex = 0;
        int i = 0;
        while (i < pairLength) {
            if (defaultFlag && ts.offsets[i] > ts.defaultOffset) {
                pairs[pairIndex++] = new FastSwitch.Pair(true, 0, ts.offset + ts.defaultOffset);
                defaultFlag = false;
            }
            pairs[pairIndex++] = new FastSwitch.Pair(false, ts.low + i, ts.offset + ts.offsets[i]);
            ++i;
        }
        if (defaultFlag) {
            pairs[pairIndex++] = new FastSwitch.Pair(true, 0, ts.offset + ts.defaultOffset);
        }
        int switchOpcode = FastInstructionListBuilder.AnalyzeSwitchType(classFile, ts.key);
        if (classFile.getMajorVersion() >= 51 && switchOpcode == 314 && ts.key.opcode == 21 && switchIndex > 2 && FastInstructionListBuilder.AnalyzeSwitchString(classFile, localVariables, list, switchIndex, ts, pairs)) {
            list.remove(--switchIndex);
            list.remove(--switchIndex);
            list.remove(--switchIndex);
            switchOpcode = 316;
        }
        FastInstructionListBuilder.AnalyzeSwitch(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, returnOffset, switchIndex, switchOpcode, ts.offset, ts.lineNumber, ts.key, pairs, pairLength);
        return switchIndex;
    }

    private static boolean AnalyzeSwitchString(ClassFile classFile, LocalVariables localVariables, List<Instruction> list, int switchIndex, Switch s, FastSwitch.Pair[] pairs) {
        FastSwitch.Pair pair;
        Instruction instruction = list.get(switchIndex - 3);
        if (instruction.opcode != 58 || instruction.lineNumber != s.key.lineNumber) {
            return false;
        }
        AStore astore = (AStore)instruction;
        instruction = list.get(switchIndex - 2);
        if (instruction.opcode != 54 || instruction.lineNumber != astore.lineNumber) {
            return false;
        }
        instruction = list.get(switchIndex - 1);
        if (instruction.opcode != 314 || instruction.lineNumber != astore.lineNumber) {
            return false;
        }
        FastSwitch previousSwitch = (FastSwitch)instruction;
        if (previousSwitch.test.opcode != 182) {
            return false;
        }
        Invokevirtual iv = (Invokevirtual)previousSwitch.test;
        if (iv.objectref.opcode != 25 || iv.args.size() != 0) {
            return false;
        }
        ConstantPool constants = classFile.getConstantPool();
        ConstantMethodref cmr = constants.getConstantMethodref(iv.index);
        if (!cmr.getReturnedSignature().equals("I")) {
            return false;
        }
        String className = constants.getConstantClassName(cmr.class_index);
        if (!className.equals("java/lang/String")) {
            return false;
        }
        ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.name_and_type_index);
        String descriptorName = constants.getConstantUtf8(cnat.descriptor_index);
        if (!descriptorName.equals("()I")) {
            return false;
        }
        String methodName = constants.getConstantUtf8(cnat.name_index);
        if (!methodName.equals("hashCode")) {
            return false;
        }
        FastSwitch.Pair[] previousPairs = previousSwitch.pairs;
        int i = previousPairs.length;
        if (i == 0) {
            return false;
        }
        int tsKeyIloadIndex = ((ILoad)s.key).index;
        int previousSwitchAloadIndex = ((ALoad)iv.objectref).index;
        HashMap<Integer, Integer> stringIndexes = new HashMap<Integer, Integer>();
        block4: while (i-- > 0) {
            block20: {
                pair = previousPairs[i];
                if (pair.isDefault()) continue;
                List<Instruction> instructions = pair.getInstructions();
                while (true) {
                    int length;
                    if ((length = instructions.size()) == 0) {
                        return false;
                    }
                    instruction = instructions.get(0);
                    if (instruction.opcode == 306) {
                        switch (length) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                if (instructions.get((int)1).opcode == 312) break;
                            }
                            default: {
                                return false;
                            }
                        }
                        FastTestList ftl = (FastTestList)instruction;
                        if (ftl.instructions.size() == 1 && FastInstructionListBuilder.AnalyzeSwitchStringTestInstructions(constants, cmr, tsKeyIloadIndex, previousSwitchAloadIndex, stringIndexes, ftl.test, (Instruction)ftl.instructions.get(0), 7)) continue block4;
                        return false;
                    }
                    if (instruction.opcode != 307) break block20;
                    if (length != 1) {
                        return false;
                    }
                    FastTest2Lists ft2l = (FastTest2Lists)instruction;
                    if (ft2l.instructions.size() != 1 || !FastInstructionListBuilder.AnalyzeSwitchStringTestInstructions(constants, cmr, tsKeyIloadIndex, previousSwitchAloadIndex, stringIndexes, ft2l.test, (Instruction)ft2l.instructions.get(0), 7)) break;
                    instructions = ft2l.instructions2;
                }
                return false;
            }
            return false;
        }
        i = pairs.length;
        while (i-- > 0) {
            pair = pairs[i];
            if (pair.isDefault()) continue;
            pair.setKey((Integer)stringIndexes.get(pair.getKey()));
        }
        localVariables.removeLocalVariableWithIndexAndOffset(tsKeyIloadIndex, s.key.offset);
        localVariables.removeLocalVariableWithIndexAndOffset(astore.index, astore.offset);
        s.key = astore.valueref;
        return true;
    }

    private static boolean AnalyzeSwitchStringTestInstructions(ConstantPool constants, ConstantMethodref cmr, int tsKeyIloadIndex, int previousSwitchAloadIndex, HashMap<Integer, Integer> stringIndexes, Instruction test, Instruction value, int cmp) {
        int index;
        if (test.opcode != 260) {
            return false;
        }
        if (value.opcode != 54) {
            return false;
        }
        IStore istore = (IStore)value;
        if (istore.index != tsKeyIloadIndex) {
            return false;
        }
        int opcode = istore.valueref.opcode;
        if (opcode == 16) {
            index = ((BIPush)istore.valueref).value;
        } else if (opcode == 256) {
            index = ((IConst)istore.valueref).value;
        } else {
            return false;
        }
        IfInstruction ii = (IfInstruction)test;
        if (ii.cmp != cmp || ii.value.opcode != 182) {
            return false;
        }
        Invokevirtual ivTest = (Invokevirtual)ii.value;
        if (ivTest.args.size() != 1 || ivTest.objectref.opcode != 25 || ((ALoad)ivTest.objectref).index != previousSwitchAloadIndex || ((Instruction)ivTest.args.get((int)0)).opcode != 18) {
            return false;
        }
        ConstantMethodref cmrTest = constants.getConstantMethodref(ivTest.index);
        if (cmr.class_index != cmrTest.class_index) {
            return false;
        }
        ConstantNameAndType cnatTest = constants.getConstantNameAndType(cmrTest.name_and_type_index);
        String descriptorNameTest = constants.getConstantUtf8(cnatTest.descriptor_index);
        if (!descriptorNameTest.equals("(Ljava/lang/Object;)Z")) {
            return false;
        }
        String methodNameTest = constants.getConstantUtf8(cnatTest.name_index);
        if (!methodNameTest.equals("equals")) {
            return false;
        }
        stringIndexes.put(index, ((Ldc)ivTest.args.get((int)0)).index);
        return true;
    }

    private static void AnalyzeSwitch(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int afterListOffset, int returnOffset, int switchIndex, int switchOpcode, int switchOffset, int switchLineNumber, Instruction test, FastSwitch.Pair[] pairs, int pairLength) {
        int breakOffset = -1;
        Arrays.sort(pairs);
        int lastSwitchOffset = switchOffset;
        int index = switchIndex + 1;
        if (index < list.size()) {
            int i = 0;
            while (i < pairLength) {
                ArrayList<Instruction> instructions = null;
                int beforeCaseOffset = lastSwitchOffset;
                int afterCaseOffset = pairs[i + 1].getOffset();
                while (index < list.size()) {
                    Instruction instruction = list.get(index);
                    if (instruction.offset >= afterCaseOffset) {
                        int nbrInstrucrions;
                        if (instructions == null || (nbrInstrucrions = instructions.size()) <= 0) break;
                        int breakOffsetTmp = FastInstructionListBuilder.SearchMinusJumpOffset(instructions, 0, nbrInstrucrions, beforeCaseOffset, lastSwitchOffset);
                        if (breakOffsetTmp != -1 && (breakOffset == -1 || breakOffset > breakOffsetTmp)) {
                            breakOffset = breakOffsetTmp;
                        }
                        instruction = instructions.get(nbrInstrucrions - 1);
                        if (instruction.opcode != 167) break;
                        int lineNumber = instruction.lineNumber;
                        if (nbrInstrucrions <= 1 || instructions.get((int)(nbrInstrucrions - 2)).lineNumber == lineNumber) {
                            lineNumber = Instruction.UNKNOWN_LINE_NUMBER;
                        }
                        instructions.set(nbrInstrucrions - 1, new FastInstruction(312, instruction.offset, lineNumber, null));
                        break;
                    }
                    if (instructions == null) {
                        instructions = new ArrayList<Instruction>();
                    }
                    list.remove(index);
                    instructions.add(instruction);
                    lastSwitchOffset = instruction.offset;
                }
                pairs[i].setInstructions(instructions);
                ++i;
            }
            if (breakOffset != -1) {
                int jumpOffset;
                Instruction instruction;
                int afterSwitchOffset = breakOffset >= switchOffset ? breakOffset : list.get((int)(list.size() - 1)).offset + 1;
                int i2 = switchIndex;
                block11: while (i2-- > 0) {
                    instruction = list.get(i2);
                    switch (instruction.opcode) {
                        case 167: 
                        case 260: 
                        case 261: 
                        case 262: 
                        case 314: 
                        case 315: 
                        case 316: {
                            jumpOffset = ((BranchInstruction)instruction).GetJumpOffset();
                            if (lastSwitchOffset >= jumpOffset || jumpOffset >= afterSwitchOffset) continue block11;
                            afterSwitchOffset = jumpOffset;
                        }
                    }
                }
                i2 = list.size();
                while (i2-- > 0) {
                    instruction = list.get(i2);
                    switch (instruction.opcode) {
                        case 167: 
                        case 260: 
                        case 261: 
                        case 262: 
                        case 314: 
                        case 315: 
                        case 316: {
                            jumpOffset = ((BranchInstruction)instruction).GetJumpOffset();
                            if (lastSwitchOffset >= jumpOffset || jumpOffset >= afterSwitchOffset) break;
                            afterSwitchOffset = jumpOffset;
                        }
                    }
                    if (instruction.offset <= afterSwitchOffset || instruction.offset <= lastSwitchOffset) break;
                }
                ArrayList<Instruction> instructions = null;
                while (index < list.size()) {
                    instruction = list.get(index);
                    if (instruction.offset >= afterSwitchOffset) {
                        int nbrInstrucrions;
                        if (instructions == null || (nbrInstrucrions = instructions.size()) <= 0) break;
                        instruction = (Instruction)instructions.get(nbrInstrucrions - 1);
                        if (instruction.opcode != 167) break;
                        int lineNumber = instruction.lineNumber;
                        if (nbrInstrucrions <= 1 || ((Instruction)instructions.get((int)(nbrInstrucrions - 2))).lineNumber == lineNumber) {
                            lineNumber = Instruction.UNKNOWN_LINE_NUMBER;
                        }
                        instructions.set(nbrInstrucrions - 1, new FastInstruction(312, instruction.offset, instruction.lineNumber, null));
                        break;
                    }
                    if (instructions == null) {
                        instructions = new ArrayList<Instruction>();
                    }
                    list.remove(index);
                    instructions.add(instruction);
                    lastSwitchOffset = instruction.offset;
                }
                pairs[pairLength].setInstructions(instructions);
            }
            int beforeListOffset = test.offset;
            if (index < list.size()) {
                afterListOffset = list.get((int)index).offset;
            }
            int i3 = 0;
            while (i3 <= pairLength) {
                int nbrInstrucrions;
                FastSwitch.Pair pair = pairs[i3];
                List<Instruction> instructions = pair.getInstructions();
                if (instructions != null && (nbrInstrucrions = instructions.size()) > 0) {
                    Instruction instruction = instructions.get(nbrInstrucrions - 1);
                    if (instruction.opcode == 312) {
                        instructions.remove(nbrInstrucrions - 1);
                        FastInstructionListBuilder.AnalyzeList(classFile, method, instructions, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, beforeListOffset, afterListOffset, breakOffset, returnOffset);
                        instructions.add(instruction);
                    } else {
                        FastInstructionListBuilder.AnalyzeList(classFile, method, instructions, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, beforeListOffset, afterListOffset, breakOffset, returnOffset);
                        nbrInstrucrions = instructions.size();
                        if (nbrInstrucrions > 0) {
                            instruction = instructions.get(nbrInstrucrions - 1);
                            switch (instruction.opcode) {
                                case 167: 
                                case 260: 
                                case 261: 
                                case 262: 
                                case 306: 
                                case 307: 
                                case 314: 
                                case 315: 
                                case 316: {
                                    int jumpOffset = ((BranchInstruction)instruction).GetJumpOffset();
                                    if (jumpOffset >= switchOffset && lastSwitchOffset >= jumpOffset) break;
                                    instructions.add(new FastInstruction(312, lastSwitchOffset + 1, Instruction.UNKNOWN_LINE_NUMBER, null));
                                }
                            }
                        }
                    }
                    beforeListOffset = instruction.offset;
                }
                ++i3;
            }
        }
        int branch = breakOffset == -1 ? 1 : breakOffset - lastSwitchOffset;
        list.set(switchIndex, new FastSwitch(switchOpcode, lastSwitchOffset, switchLineNumber, branch, test, pairs));
    }

    private static void AddLabels(List<Instruction> list, IntSet offsetLabelSet) {
        int i = offsetLabelSet.size() - 1;
        while (i >= 0) {
            FastInstructionListBuilder.SearchInstructionAndAddLabel(list, offsetLabelSet.get(i));
            --i;
        }
    }

    private static boolean SearchInstructionAndAddLabel(List<Instruction> list, int labelOffset) {
        int index = InstructionUtil.getIndexForOffset(list, labelOffset);
        if (index < 0) {
            return false;
        }
        boolean found = false;
        Instruction instruction = list.get(index);
        switch (instruction.opcode) {
            case 303: {
                List<Instruction> instructions = ((FastList)instruction).instructions;
                if (instructions == null) break;
                found = FastInstructionListBuilder.SearchInstructionAndAddLabel(instructions, labelOffset);
                break;
            }
            case 301: 
            case 302: 
            case 306: {
                FastTestList ftl = (FastTestList)instruction;
                if (labelOffset < ftl.test.offset || ftl.instructions == null) break;
                found = FastInstructionListBuilder.SearchInstructionAndAddLabel(ftl.instructions, labelOffset);
                break;
            }
            case 319: {
                FastSynchronized fs = (FastSynchronized)instruction;
                if (labelOffset < fs.monitor.offset || fs.instructions == null) break;
                found = FastInstructionListBuilder.SearchInstructionAndAddLabel(fs.instructions, labelOffset);
                break;
            }
            case 304: {
                FastFor ff = (FastFor)instruction;
                if (ff.init != null && labelOffset < ff.init.offset || ff.instructions == null) break;
                found = FastInstructionListBuilder.SearchInstructionAndAddLabel(ff.instructions, labelOffset);
                break;
            }
            case 307: {
                FastTest2Lists ft2l = (FastTest2Lists)instruction;
                if (labelOffset < ft2l.test.offset) break;
                found = FastInstructionListBuilder.SearchInstructionAndAddLabel(ft2l.instructions, labelOffset) || FastInstructionListBuilder.SearchInstructionAndAddLabel(ft2l.instructions2, labelOffset);
                break;
            }
            case 314: 
            case 315: 
            case 316: {
                FastSwitch.Pair[] pairs;
                FastSwitch fs = (FastSwitch)instruction;
                if (labelOffset < fs.test.offset || (pairs = fs.pairs) == null) break;
                int i = pairs.length - 1;
                while (i >= 0 && !found) {
                    List<Instruction> instructions = pairs[i].getInstructions();
                    if (instructions != null) {
                        found = FastInstructionListBuilder.SearchInstructionAndAddLabel(instructions, labelOffset);
                    }
                    --i;
                }
                break;
            }
            case 318: {
                FastTry ft = (FastTry)instruction;
                found = FastInstructionListBuilder.SearchInstructionAndAddLabel(ft.instructions, labelOffset);
                if (!found && ft.catches != null) {
                    int i = ft.catches.size() - 1;
                    while (i >= 0 && !found) {
                        found = FastInstructionListBuilder.SearchInstructionAndAddLabel(ft.catches.get((int)i).instructions, labelOffset);
                        --i;
                    }
                }
                if (found || ft.finallyInstructions == null) break;
                found = FastInstructionListBuilder.SearchInstructionAndAddLabel(ft.finallyInstructions, labelOffset);
            }
        }
        if (!found) {
            list.set(index, new FastLabel(320, labelOffset, instruction.lineNumber, instruction));
        }
        return true;
    }
}

