/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001A4A!\u0001\u0002\u0001\u000f\tq\u0012\t\u001c;feJ+\u0007\u000f\\5dC2{w\rR5sgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f\u001e\u0005\u0006\u001b\u0001!\tAD\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0001\"!\u0003\u0001\t\u000bE\u0001A\u0011\t\n\u0002\u00159,XN\u0011:pW\u0016\u00148/F\u0001\u0014!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\rIe\u000e\u001e\u0005\u00065\u0001!\tEE\u0001\fY><G)\u001b:D_VtG\u000fC\u0004\u001d\u0001\t\u0007I\u0011A\u000f\u0002\u000bQ|\u0007/[2\u0016\u0003y\u0001\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\t1\fgn\u001a\u0006\u0002G\u0005!!.\u0019<b\u0013\t)\u0003E\u0001\u0004TiJLgn\u001a\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0010\u0002\rQ|\u0007/[2!\u0011\u0015I\u0003\u0001\"\u0001+\u0003y!Xm\u001d;BYR,'OU3qY&\u001c\u0017\rT8h\t&\u00148OU3rk\u0016\u001cH\u000fF\u0001,!\t!B&\u0003\u0002.+\t!QK\\5uQ\tAs\u0006\u0005\u00021k5\t\u0011G\u0003\u00023g\u0005)!.\u001e8ji*\tA'A\u0002pe\u001eL!AN\u0019\u0003\tQ+7\u000f\u001e\u0005\u0006q\u0001!\tAK\u0001(i\u0016\u001cH/\u00117uKJ\u0014V\r\u001d7jG\u0006dun\u001a#jeN\u0014V-];fgR,%O]8s\u0007>$W\r\u000b\u00028_!)1\b\u0001C\u0005y\u0005q2/\u001a8e\u00032$XM\u001d*fa2L7-\u0019'pO\u0012K'o\u001d*fcV,7\u000f\u001e\u000b\u0004{![\u0006C\u0001 G\u001b\u0005y$B\u0001!B\u0003!\u0011X-];fgR\u001c(B\u0001\"D\u0003\u0019\u0019w.\\7p]*\u0011Q\u0001\u0012\u0006\u0003\u000bN\na!\u00199bG\",\u0017BA$@\u0005m\tE\u000e^3s%\u0016\u0004H.[2b\u0019><G)\u001b:t%\u0016\u001c\bo\u001c8tK\")\u0011J\u000fa\u0001\u0015\u0006i\u0001/\u0019:uSRLwN\u001c#jeN\u0004Ba\u0013*V3:\u0011A\n\u0015\t\u0003\u001bVi\u0011A\u0014\u0006\u0003\u001f\u001a\ta\u0001\u0010:p_Rt\u0014BA)\u0016\u0003\u0019\u0001&/\u001a3fM&\u00111\u000b\u0016\u0002\u0004\u001b\u0006\u0004(BA)\u0016!\t1v+D\u0001B\u0013\tA\u0016I\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005-S\u0016BA\u0013U\u0011\u001da&\b%AA\u0002u\u000bAb]8dW\u0016$8+\u001a:wKJ\u0004\"AX1\u000e\u0003}S!\u0001\u0019\u0003\u0002\u000f9,Go^8sW&\u0011!m\u0018\u0002\r'>\u001c7.\u001a;TKJ4XM\u001d\u0005\bI\u0002\t\n\u0011\"\u0003f\u0003!\u001aXM\u001c3BYR,'OU3qY&\u001c\u0017\rT8h\t&\u00148OU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u00051'FA/hW\u0005A\u0007CA5o\u001b\u0005Q'BA6m\u0003%)hn\u00195fG.,GM\u0003\u0002n+\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005=T'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class AlterReplicaLogDirsRequestTest
extends BaseRequestTest {
    private final String topic;

    @Override
    public int numBrokers() {
        return 1;
    }

    @Override
    public int logDirCount() {
        return 5;
    }

    public String topic() {
        return this.topic;
    }

    @Test
    public void testAlterReplicaLogDirsRequest() {
        int partitionNum = 5;
        String logDir1 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(Random$.MODULE$.nextInt(this.logDirCount()))).getAbsolutePath();
        Map partitionDirs1 = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)partition))), (Object)logDir1), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AlterReplicaLogDirsResponse alterReplicaLogDirsResponse1 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs1, this.sendAlterReplicaLogDirsRequest$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            Assert.assertEquals((Object)Errors.REPLICA_NOT_AVAILABLE, alterReplicaLogDirsResponse1.responses().get(tp));
            LogManager qual$1 = ((KafkaServer)this.servers().head()).logManager();
            TopicPartition x$1 = tp;
            boolean x$2 = qual$1.getLog$default$2();
            Assert.assertTrue((boolean)qual$1.getLog(x$1, x$2).isEmpty());
        });
        this.createTopic(this.topic(), partitionNum, 1, this.createTopic$default$4());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
            TopicPartition x$3 = new TopicPartition(this.topic(), partition);
            boolean x$4 = qual$2.getLog$default$2();
            Assert.assertEquals((Object)logDir1, (Object)((Log)qual$2.getLog(x$3, x$4).get()).dir().getParent());
        });
        String logDir2 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(Random$.MODULE$.nextInt(this.logDirCount()))).getAbsolutePath();
        Map partitionDirs2 = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)partition))), (Object)logDir2), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AlterReplicaLogDirsResponse alterReplicaLogDirsResponse2 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs2, this.sendAlterReplicaLogDirsRequest$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            Assert.assertEquals((Object)Errors.NONE, alterReplicaLogDirsResponse2.responses().get(tp));
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                String string = logDir2;
                LogManager qual$3 = ((KafkaServer)this.servers().head()).logManager();
                TopicPartition x$5 = new TopicPartition(this.topic(), partition);
                boolean x$6 = qual$3.getLog$default$2();
                String string2 = ((Log)qual$3.getLog(x$5, x$6).get()).dir().getParent();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for replica movement", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        });
    }

    @Test
    public void testAlterReplicaLogDirsRequestErrorCode() {
        String offlineDir = new File((String)((IterableLike)((KafkaServer)this.servers().head()).config().logDirs().tail()).head()).getAbsolutePath();
        String validDir1 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(1)).getAbsolutePath();
        String validDir2 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(2)).getAbsolutePath();
        String validDir3 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(3)).getAbsolutePath();
        scala.collection.mutable.Map partitionDirs1 = Map$.MODULE$.empty();
        partitionDirs1.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs1.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir1);
        AlterReplicaLogDirsResponse alterReplicaDirResponse1 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs1.toMap(Predef$.MODULE$.$conforms()), this.sendAlterReplicaLogDirsRequest$default$2());
        Assert.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, alterReplicaDirResponse1.responses().get(new TopicPartition(this.topic(), 0)));
        Assert.assertEquals((Object)Errors.REPLICA_NOT_AVAILABLE, alterReplicaDirResponse1.responses().get(new TopicPartition(this.topic(), 1)));
        this.createTopic(this.topic(), 3, 1, this.createTopic$default$4());
        scala.collection.mutable.Map partitionDirs2 = Map$.MODULE$.empty();
        partitionDirs2.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs2.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir2);
        AlterReplicaLogDirsResponse alterReplicaDirResponse2 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs2.toMap(Predef$.MODULE$.$conforms()), this.sendAlterReplicaLogDirsRequest$default$2());
        Assert.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, alterReplicaDirResponse2.responses().get(new TopicPartition(this.topic(), 0)));
        Assert.assertEquals((Object)Errors.NONE, alterReplicaDirResponse2.responses().get(new TopicPartition(this.topic(), 1)));
        ((KafkaServer)this.servers().head()).logDirFailureChannel().maybeAddOfflineLogDir(offlineDir, (Function0 & Serializable & scala.Serializable)() -> "", new IOException());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !((KafkaServer)this.servers().head()).logManager().isLogDirOnline(offlineDir), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timed out waiting for ", " to be offline"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{offlineDir})), 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        scala.collection.mutable.Map partitionDirs3 = Map$.MODULE$.empty();
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir3);
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 2), (Object)offlineDir);
        AlterReplicaLogDirsResponse alterReplicaDirResponse3 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs3.toMap(Predef$.MODULE$.$conforms()), this.sendAlterReplicaLogDirsRequest$default$2());
        Assert.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, alterReplicaDirResponse3.responses().get(new TopicPartition(this.topic(), 0)));
        Assert.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, alterReplicaDirResponse3.responses().get(new TopicPartition(this.topic(), 1)));
        Assert.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, alterReplicaDirResponse3.responses().get(new TopicPartition(this.topic(), 2)));
    }

    private AlterReplicaLogDirsResponse sendAlterReplicaLogDirsRequest(Map<TopicPartition, String> partitionDirs, SocketServer socketServer) {
        AlterReplicaLogDirsRequest request = (AlterReplicaLogDirsRequest)new AlterReplicaLogDirsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitionDirs).asJava()).build();
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.ALTER_REPLICA_LOG_DIRS, socketServer, this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return AlterReplicaLogDirsResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private SocketServer sendAlterReplicaLogDirsRequest$default$2() {
        return this.controllerSocketServer();
    }

    public AlterReplicaLogDirsRequestTest() {
        this.topic = "topic";
    }
}

