/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import joptsimple.OptionSpec;
import kafka.api.OffsetRequest$;
import kafka.common.MessageFormatter;
import kafka.common.StreamEndException;
import kafka.consumer.BaseConsumer;
import kafka.consumer.BaseConsumerRecord;
import kafka.consumer.NewShinyConsumer;
import kafka.consumer.OldConsumer;
import kafka.tools.ConsoleConsumer;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.WakeupException;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConsoleConsumer$
implements Logging {
    public static ConsoleConsumer$ MODULE$;
    private int messageCount;
    private final CountDownLatch kafka$tools$ConsoleConsumer$$shutdownLatch;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ConsoleConsumer$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ConsoleConsumer$ consoleConsumer$ = this;
        synchronized (consoleConsumer$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int messageCount() {
        return this.messageCount;
    }

    public void messageCount_$eq(int x$1) {
        this.messageCount = x$1;
    }

    public CountDownLatch kafka$tools$ConsoleConsumer$$shutdownLatch() {
        return this.kafka$tools$ConsoleConsumer$$shutdownLatch;
    }

    public void main(String[] args) {
        ConsoleConsumer.ConsumerConfig conf = new ConsoleConsumer.ConsumerConfig(args);
        try {
            this.run(conf);
        }
        catch (AuthenticationException e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Authentication failed: terminating consumer process", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unknown error when running consumer: ", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    public void run(ConsoleConsumer.ConsumerConfig conf) {
        BaseConsumer baseConsumer;
        if (conf.useOldConsumer()) {
            this.checkZk(conf);
            Properties props = this.getOldConsumerProps(conf);
            this.checkAndMaybeDeleteOldPath(conf, props);
            baseConsumer = new OldConsumer(conf.filterSpec(), props);
        } else {
            long timeoutMs = conf.timeoutMs() >= 0 ? (long)conf.timeoutMs() : Long.MAX_VALUE;
            baseConsumer = conf.partitionArg().isDefined() ? new NewShinyConsumer((Option<String>)Option$.MODULE$.apply((Object)conf.topicArg()), conf.partitionArg(), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)conf.offsetArg())), (Option<String>)None$.MODULE$, this.getNewConsumerProps(conf), timeoutMs) : new NewShinyConsumer((Option<String>)Option$.MODULE$.apply((Object)conf.topicArg()), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<String>)Option$.MODULE$.apply((Object)conf.whitelistArg()), this.getNewConsumerProps(conf), timeoutMs);
        }
        BaseConsumer consumer = baseConsumer;
        this.addShutdownHook(consumer, conf);
        try {
            this.process(Predef$.MODULE$.int2Integer(conf.maxMessages()), conf.formatter(), consumer, System.out, conf.skipMessageOnError());
        }
        finally {
            consumer.cleanup();
            conf.formatter().close();
            this.reportRecordCount();
            if (conf.useOldConsumer() && !conf.groupIdPassed()) {
                ZkUtils$.MODULE$.maybeDeletePath((String)conf.options().valueOf(conf.zkConnectOpt()), "/consumers/" + conf.consumerProps().get("group.id"));
            }
            this.kafka$tools$ConsoleConsumer$$shutdownLatch().countDown();
        }
    }

    public void checkZk(ConsoleConsumer.ConsumerConfig config) {
        if (!this.checkZkPathExists((String)config.options().valueOf(config.zkConnectOpt()), "/brokers/ids")) {
            System.err.println("No brokers found in ZK.");
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        if (!config.options().has((OptionSpec)config.deleteConsumerOffsetsOpt()) && config.options().has((OptionSpec)config.resetBeginningOpt()) && this.checkZkPathExists((String)config.options().valueOf(config.zkConnectOpt()), "/consumers/" + config.consumerProps().getProperty("group.id") + "/offsets")) {
            System.err.println("Found previous offset information for this group " + config.consumerProps().getProperty("group.id") + ". Please use --delete-consumer-offsets to delete previous offsets metadata");
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    public void addShutdownHook(BaseConsumer consumer, ConsoleConsumer.ConsumerConfig conf) {
        Runtime.getRuntime().addShutdownHook(new Thread(consumer, conf){
            private final BaseConsumer consumer$1;
            private final ConsoleConsumer.ConsumerConfig conf$1;

            public void run() {
                block0: {
                    this.consumer$1.stop();
                    ConsoleConsumer$.MODULE$.kafka$tools$ConsoleConsumer$$shutdownLatch().await();
                    if (!this.conf$1.enableSystestEventsLogging()) break block0;
                    System.out.println("shutdown_complete");
                }
            }
            {
                this.consumer$1 = consumer$1;
                this.conf$1 = conf$1;
            }
        });
    }

    public void process(Integer maxMessages, MessageFormatter formatter, BaseConsumer consumer, PrintStream output, boolean skipMessageOnError) {
        while (this.messageCount() < Predef$.MODULE$.Integer2int(maxMessages) || BoxesRunTime.equalsNumObject((Number)maxMessages, (Object)BoxesRunTime.boxToInteger((int)-1))) {
            BaseConsumerRecord baseConsumerRecord;
            try {
                baseConsumerRecord = consumer.receive();
            }
            catch (StreamEndException streamEndException) {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Caught StreamEndException because consumer is shutdown, ignore and terminate.");
                return;
            }
            catch (WakeupException wakeupException) {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Caught WakeupException because consumer is shutdown, ignore and terminate.");
                return;
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error processing message, terminating consumer process: ", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
            BaseConsumerRecord msg = baseConsumerRecord;
            this.messageCount_$eq(this.messageCount() + 1);
            try {
                formatter.writeTo((ConsumerRecord<byte[], byte[]>)new ConsumerRecord(msg.topic(), msg.partition(), msg.offset(), msg.timestamp(), msg.timestampType(), Predef$.MODULE$.long2Long(0L), 0, 0, (Object)msg.key(), (Object)msg.value(), msg.headers()), output);
            }
            catch (Throwable e) {
                if (skipMessageOnError) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error processing message, skipping this message: ", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                throw e;
            }
            if (!this.checkErr(output, formatter)) continue;
            return;
        }
    }

    public void reportRecordCount() {
        System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processed a total of ", " messages"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messageCount())})));
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkErr(PrintStream output, MessageFormatter formatter) {
        void var3_3;
        block0: {
            boolean gotError = output.checkError();
            if (!gotError) break block0;
            System.err.println("Unable to write to standard out, closing consumer.");
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getOldConsumerProps(ConsoleConsumer.ConsumerConfig config) {
        void var2_2;
        Properties props = new Properties();
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.consumerProps());
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.extraConsumerProps());
        this.setAutoOffsetResetValue(config, props);
        props.put("zookeeper.connect", config.zkConnectionStr());
        Object object = config.timeoutMs() >= 0 ? props.put("consumer.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)config.timeoutMs())).toString()) : BoxedUnit.UNIT;
        return var2_2;
    }

    public void checkAndMaybeDeleteOldPath(ConsoleConsumer.ConsumerConfig config, Properties props) {
        String consumerGroupBasePath = "/consumers/" + props.getProperty("group.id");
        if (config.options().has((OptionSpec)config.deleteConsumerOffsetsOpt())) {
            ZkUtils$.MODULE$.maybeDeletePath((String)config.options().valueOf(config.zkConnectOpt()), consumerGroupBasePath);
        } else {
            boolean resetToBeginning;
            String string = OffsetRequest$.MODULE$.SmallestTimeString();
            String string2 = props.getProperty("auto.offset.reset");
            boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (resetToBeginning = false);
            if (resetToBeginning && this.checkZkPathExists((String)config.options().valueOf(config.zkConnectOpt()), consumerGroupBasePath + "/offsets")) {
                System.err.println("Found previous offset information for this group " + props.getProperty("group.id") + ". Please use --delete-consumer-offsets to delete previous offsets metadata");
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Properties getNewConsumerProps(ConsoleConsumer.ConsumerConfig config) {
        void var2_2;
        Properties props = new Properties();
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.consumerProps());
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.extraConsumerProps());
        this.setAutoOffsetResetValue(config, props);
        props.put("bootstrap.servers", config.bootstrapServer());
        props.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        props.put("isolation.level", config.isolationLevel());
        return var2_2;
    }

    public void setAutoOffsetResetValue(ConsoleConsumer.ConsumerConfig config, Properties props) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = config.useOldConsumer() ? new Tuple2((Object)OffsetRequest$.MODULE$.SmallestTimeString(), (Object)OffsetRequest$.MODULE$.LargestTimeString()) : new Tuple2((Object)"earliest", (Object)"latest");
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String earliestConfigValue = (String)tuple2._1();
        String latestConfigValue = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)earliestConfigValue, (Object)latestConfigValue);
        Tuple2 tuple24 = tuple23;
        String earliestConfigValue2 = (String)tuple24._1();
        String latestConfigValue2 = (String)tuple24._2();
        if (props.containsKey("auto.offset.reset")) {
            String autoResetOption = props.getProperty("auto.offset.reset");
            if (config.options().has((OptionSpec)config.resetBeginningOpt())) {
                String string = earliestConfigValue2;
                String string2 = autoResetOption;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't simultaneously specify --from-beginning and 'auto.offset.reset=", "', "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{autoResetOption})) + "please remove one option");
                    throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
                }
            }
        } else {
            String autoResetOption = config.options().has((OptionSpec)config.resetBeginningOpt()) ? earliestConfigValue2 : latestConfigValue2;
            props.put("auto.offset.reset", autoResetOption);
        }
    }

    public boolean checkZkPathExists(String zkUrl, String path) {
        boolean bl;
        try {
            ZkClient zk = ZkUtils$.MODULE$.createZkClient(zkUrl, 30000, 30000);
            bl = zk.exists(path);
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private ConsoleConsumer$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.messageCount = 0;
        this.kafka$tools$ConsoleConsumer$$shutdownLatch = new CountDownLatch(1);
    }
}

