/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.security.JaasUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class ExportZkOffsets$
implements Logging {
    public static ExportZkOffsets$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ExportZkOffsets$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ExportZkOffsets$ exportZkOffsets$ = this;
        synchronized (exportZkOffsets$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser(false);
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "WARNING: ExportZkOffsets is deprecated and will be dropped in a future release following 0.11.0.0.");
        ArgumentAcceptingOptionSpec zkConnectOpt = parser.accepts("zkconnect", "ZooKeeper connect string.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec groupOpt = parser.accepts("group", "Consumer group.").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec outFileOpt = parser.accepts("output-file", "Output file").withRequiredArg().ofType(String.class);
        parser.accepts("help", "Print this message.");
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Export consumer offsets to an output file.");
        }
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{zkConnectOpt, outFileOpt}));
        String zkConnect = (String)options.valueOf((OptionSpec)zkConnectOpt);
        java.util.List groups = options.valuesOf((OptionSpec)groupOpt);
        String outfile = (String)options.valueOf((OptionSpec)outFileOpt);
        ObjectRef zkUtils = ObjectRef.create(null);
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), StandardCharsets.UTF_8);
        try {
            zkUtils.elem = ZkUtils$.MODULE$.apply(zkConnect, 30000, 30000, JaasUtils.isZkSecurityEnabled());
            Object consumerGroups = null;
            consumerGroups = groups.size() == 0 ? ((ZkUtils)zkUtils.elem).getChildren(ZkUtils$.MODULE$.ConsumersPath()).toList() : (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(groups).asScala();
            consumerGroups.foreach((Function1 & Serializable & scala.Serializable)consumerGrp -> {
                ExportZkOffsets$.$anonfun$main$2(zkUtils, fileWriter, consumerGrp);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            fileWriter.flush();
            fileWriter.close();
        }
    }

    private List<String> getBrokeridPartition(ZkUtils zkUtils, String consumerGroup, String topic) {
        return zkUtils.getChildrenParentMayNotExist(new StringOps(Predef$.MODULE$.augmentString("/consumers/%s/offsets/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{consumerGroup, topic}))).toList();
    }

    private List<String> getTopicsList(ZkUtils zkUtils, String consumerGroup) {
        return zkUtils.getChildren(new StringOps(Predef$.MODULE$.augmentString("/consumers/%s/offsets")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{consumerGroup}))).toList();
    }

    public static final /* synthetic */ void $anonfun$main$4(ObjectRef zkUtils$1, OutputStreamWriter fileWriter$1, String consumerGrp$1, String topic$1, String bidPid) {
        ZKGroupTopicDirs zkGrpTpDir = new ZKGroupTopicDirs(consumerGrp$1, topic$1);
        String offsetPath = zkGrpTpDir.consumerOffsetDir() + "/" + bidPid;
        Option option = (Option)((ZkUtils)zkUtils$1.elem).readDataMaybeNull(offsetPath)._1();
        if (option instanceof Some) {
            Some some = (Some)option;
            String offsetVal = (String)some.value();
            fileWriter$1.write(offsetPath + ":" + offsetVal + "\n");
            MODULE$.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> offsetPath + " => " + offsetVal);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            MODULE$.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Could not retrieve offset value from " + offsetPath);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$main$3(ObjectRef zkUtils$1, OutputStreamWriter fileWriter$1, String consumerGrp$1, String topic) {
        List<String> bidPidList = MODULE$.getBrokeridPartition((ZkUtils)zkUtils$1.elem, consumerGrp$1, topic);
        bidPidList.foreach((Function1 & Serializable & scala.Serializable)bidPid -> {
            ExportZkOffsets$.$anonfun$main$4(zkUtils$1, fileWriter$1, consumerGrp$1, topic, bidPid);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$main$2(ObjectRef zkUtils$1, OutputStreamWriter fileWriter$1, String consumerGrp) {
        List<String> topicsList = MODULE$.getTopicsList((ZkUtils)zkUtils$1.elem, consumerGrp);
        topicsList.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            ExportZkOffsets$.$anonfun$main$3(zkUtils$1, fileWriter$1, consumerGrp, topic);
            return BoxedUnit.UNIT;
        });
    }

    private ExportZkOffsets$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

