#---------------------------------------------------------------
# Cursor movements
#---------------------------------------------------------------

#---------------------------------------------------------------
# Key bindings
#---------------------------------------------------------------

# Cursor movements (emacs-like and arrow keys)
bind .entry <Control-n> {nextline}
bind .entry <Down> {nextline}
bind .entry <Control-p> {prevline}
bind .entry <Up> {prevline}
bind .entry <Control-f> {nextchar}
bind .entry <Right> {nextchar}
bind .entry <Control-b> {prevchar}
bind .entry <Left> {prevchar}
bind .entry <Control-a> {beginningofline}
bind .entry <Control-e> {endofline}

# Make sure focus doesn't go to text widget when user clicks mouse
bind .text.text <ButtonRelease-1> {movecursor %x %y}
bind .text.text <B1-Motion> {movecursor %x %y}

#---------------------------------------------------------------
# Procedures: nextchar prevchar nextline prevline beginningofline endofline
# Bound to: ^npfbae, arrow keys
#  Moves "here" marker and calls retag to redisplay it
#---------------------------------------------------------------
proc nextchar {} {
    .text.text tag delete here
    .text.text mark set insert "insert + 1 chars"
    retag
}
proc prevchar {} {
    .text.text tag delete here
    .text.text mark set insert "insert - 1 chars"
    retag
}
proc nextline {} {
    .text.text tag delete here
    .text.text mark set insert "insert + 1 lines"
    retag
}
proc prevline {} {
    .text.text tag delete here
    .text.text mark set insert "insert - 1 lines"
    retag
}
proc beginningofline {} {
    .text.text tag delete here
    .text.text mark set insert "insert linestart"
    retag
}
proc endofline {} {
    .text.text tag delete here
    .text.text mark set insert "insert lineend"
    retag
}

#---------------------------------------------------------------
# Procedure: movecursor {x y}
# Bound to: mouse click in text widget
#  Moves cursor to character under position (x,y).
#  Returns focus to .entry.
#---------------------------------------------------------------
proc movecursor {x y} {
    .text.text tag delete here
    .text.text mark set insert "@$x,$y"
    retag
    focus .entry
}

#---------------------------------------------------------------
# Procedure: retag
#  Resets "here" tag indicating the cursor in text.
#  Shows next key in reverse video if $shownextkey is set.
#---------------------------------------------------------------
proc retag {} {
    global foreground background backgroundhome \
	    keylistu keylists \
	    prevnext prevnextu prevnextindex prevnextshifted
    .text.text tag add here insert
    .text.text tag configure here -foreground "$background" \
	    -background "$foreground"
    if [shownextkeyp] {
	if {$prevnextindex != -1} {
	    if [ishomeposition "$prevnext"] {
		.key$prevnextindex configure -foreground "$foreground" \
			-background "$backgroundhome"
	    } else {
		.key$prevnextindex configure -foreground "$foreground" \
			-background "$background"
	    }
	    if {[showkeytopp] == 0} {
		.key$prevnextindex configure -text ""
	    }
	}
	set next [.text.text get insert]
	set nextindex [lsearch "$keylists" "$next"]
	if {$nextindex == -1} {
	    set nextindex [lsearch "$keylistu" "$next"]
	    set nextshifted 0
	} else {
	    set nextshifted 1
	}
	if {$nextindex != -1} {
	    set nextu [lindex "$keylistu" $nextindex]
	} else {
	    set nextu ""
	}
	if {$nextindex != -1} {
	    .key$nextindex configure -foreground "$background" \
		    -background "$foreground"
	    .key$nextindex configure -text "$next"
	}
	set prevnext "$next"
	set prevnextu "$nextu"
	set prevnextindex $nextindex
	set prevnextshifted $nextshifted
    }
    .text.text yview "insert - 5 lines"
}
set prevnext ""
set prevnextu ""
set prevnextindex -1
set prevnextshifted ""
