/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import uk.ac.ic.doc.scenebeans.DoubleBehaviourListener;
import uk.ac.ic.doc.scenebeans.Primitive;
import uk.ac.ic.doc.scenebeans.SceneGraphBase;
import uk.ac.ic.doc.scenebeans.SceneGraphProcessor;
import uk.ac.ic.doc.scenebeans.StringBehaviourListener;

public class Text
extends SceneGraphBase
implements Primitive {
    private String _text;
    private GlyphVector _glyphs;
    private Shape _last_drawn;

    public Text() {
        this._text = "";
    }

    public Text(String string) {
        this._text = string;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String string) {
        this._text = string;
        this.setDirty(true);
    }

    public Shape getShape(Graphics2D graphics2D) {
        return this.getGlyphs(graphics2D).getOutline();
    }

    public Shape getLastDrawnShape() {
        return this._last_drawn;
    }

    public void accept(SceneGraphProcessor sceneGraphProcessor) {
        sceneGraphProcessor.process(this);
    }

    public void draw(Graphics2D graphics2D) {
        GlyphVector glyphVector = this.getGlyphs(graphics2D);
        graphics2D.drawGlyphVector(glyphVector, 0.0f, 0.0f);
        this._last_drawn = glyphVector.getOutline();
        this.setDirty(false);
    }

    private GlyphVector getGlyphs(Graphics2D graphics2D) {
        if (this._glyphs == null || !this._glyphs.getFont().equals(graphics2D.getFont())) {
            Font font = graphics2D.getFont();
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            this._glyphs = font.createGlyphVector(fontRenderContext, this._text);
        }
        return this._glyphs;
    }

    public void setDirty(boolean bl) {
        if (bl) {
            this._glyphs = null;
        }
        super.setDirty(bl);
    }

    public StringBehaviourListener newTextAdapter() {
        return new TextAdapter();
    }

    class TextAdapter
    implements StringBehaviourListener,
    DoubleBehaviourListener {
        TextAdapter() {
        }

        public void behaviourUpdated(String string) {
            Text.this.setText(string);
        }

        public void behaviourUpdated(double d) {
            Text.this.setText(Double.toString(d));
        }
    }
}

