<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SecurityCommandCenter;

class Package extends \Google\Model
{
  /**
   * @var string
   */
  public $cpeUri;
  /**
   * @var string
   */
  public $packageName;
  /**
   * @var string
   */
  public $packageType;
  /**
   * @var string
   */
  public $packageVersion;

  /**
   * @param string
   */
  public function setCpeUri($cpeUri)
  {
    $this->cpeUri = $cpeUri;
  }
  /**
   * @return string
   */
  public function getCpeUri()
  {
    return $this->cpeUri;
  }
  /**
   * @param string
   */
  public function setPackageName($packageName)
  {
    $this->packageName = $packageName;
  }
  /**
   * @return string
   */
  public function getPackageName()
  {
    return $this->packageName;
  }
  /**
   * @param string
   */
  public function setPackageType($packageType)
  {
    $this->packageType = $packageType;
  }
  /**
   * @return string
   */
  public function getPackageType()
  {
    return $this->packageType;
  }
  /**
   * @param string
   */
  public function setPackageVersion($packageVersion)
  {
    $this->packageVersion = $packageVersion;
  }
  /**
   * @return string
   */
  public function getPackageVersion()
  {
    return $this->packageVersion;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Package::class, 'Google_Service_SecurityCommandCenter_Package');
