<?php

declare(strict_types=1);

/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

namespace TYPO3\CMS\Core\PageTitle;

/**
 * Interface for PageTitleProviders with the methods that are needed by the PageTitleProviderManager
 */
interface PageTitleProviderInterface
{
    public function getTitle(): string;

    /**
     * @deprecated Activate in v14 and remove method_exists() call in PageTitleProviderManager
     */
    /**
    public function setRequest(ServerRequestInterface $request): void;
     */
}
