/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions.compass;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelper;

@State(name="CompassSettings")
public class CompassSettings
implements PersistentStateComponent<CompassSettings> {
    @NotNull
    private Module myModule;
    @NotNull
    private ThreeState myCompassSupportEnabled;
    @Nullable
    private String myCompassExecutableFilePath;
    @Nullable
    private String myCompassConfigPath;
    @NotNull
    private List<String> myImportPaths;

    public static CompassSettings getInstance(@NotNull Module module) {
        if (module == null) {
            CompassSettings.$$$reportNull$$$0(0);
        }
        return !module.isDisposed() ? (CompassSettings)ModuleServiceManager.getService((Module)module, CompassSettings.class) : null;
    }

    public void loadState(@NotNull CompassSettings state) {
        if (state == null) {
            CompassSettings.$$$reportNull$$$0(1);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public CompassSettings() {
        this.myCompassSupportEnabled = ThreeState.UNSURE;
        this.myCompassExecutableFilePath = null;
        this.myCompassConfigPath = null;
        this.myImportPaths = ContainerUtil.newArrayList();
    }

    public CompassSettings(@NotNull Module module) {
        if (module == null) {
            CompassSettings.$$$reportNull$$$0(2);
        }
        this.myCompassSupportEnabled = ThreeState.UNSURE;
        this.myCompassExecutableFilePath = null;
        this.myCompassConfigPath = null;
        this.myImportPaths = ContainerUtil.newArrayList();
        this.myModule = module;
    }

    public boolean isCompassSupportEnabled() {
        return this.myCompassSupportEnabled == ThreeState.YES || this.myCompassSupportEnabled == ThreeState.UNSURE && this.myModule != null && SassRubyIntegrationHelper.getInstance().isGemInstalled(SASSBundle.message("compass.gem.name"), this.myModule);
    }

    public void setCompassSupportEnabled(boolean compassSupportEnabled) {
        this.myCompassSupportEnabled = compassSupportEnabled ? ThreeState.YES : ThreeState.NO;
    }

    public void resetEnabledFlag() {
        this.myCompassSupportEnabled = ThreeState.UNSURE;
    }

    @NotNull
    public String getCompassExecutableFilePath() {
        String string = StringUtil.notNullize((String)this.myCompassExecutableFilePath);
        if (string == null) {
            CompassSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setCompassExecutableFilePath(@Nullable String compassExecutablePath) {
        this.myCompassExecutableFilePath = compassExecutablePath;
    }

    @NotNull
    public String getCompassConfigPath() {
        String string = StringUtil.notNullize((String)this.myCompassConfigPath);
        if (string == null) {
            CompassSettings.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setCompassConfigPath(@Nullable String compassConfigPath) {
        this.myCompassConfigPath = compassConfigPath;
    }

    @Nullable
    public CompassSettings getState() {
        return this;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            CompassSettings.$$$reportNull$$$0(5);
        }
        return module;
    }

    @NotNull
    public List<String> getImportPaths() {
        List<String> list = this.myImportPaths;
        if (list == null) {
            CompassSettings.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void setImportPaths(@NotNull List<String> importPaths) {
        if (importPaths == null) {
            CompassSettings.$$$reportNull$$$0(7);
        }
        this.myImportPaths = importPaths;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/extensions/compass/CompassSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/extensions/compass/CompassSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompassExecutableFilePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompassConfigPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setImportPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

