/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraLikeTable;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.model.properties.OraTableType;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraMixinTable
extends OraLikeTable {
    @NotNull
    public OraTableType getTableType();

    @Nullable
    public String getMasterTableName();

    @Override
    default public boolean isAutoCreated() {
        switch (this.getTableType()) {
            case MAT_LOG: {
                return true;
            }
            case MAT_VIEW: {
                OraSchema schema = (OraSchema)this.getSchema();
                if (schema == null) {
                    return false;
                }
                OraMatView mv = (OraMatView)schema.getMatViews().get(this.getName());
                if (mv == null) {
                    return false;
                }
                return !mv.isPrebuilt();
            }
        }
        return false;
    }

    @Override
    @NotNull
    default public String calculateDisplayOrder() {
        String string = this.identity(false);
        if (string == null) {
            OraMixinTable.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    default public String identity(boolean includingSurrogate) {
        if (this.getTableType() == OraTableType.MAT_LOG) {
            if (includingSurrogate) {
                String string = this.getName();
                if (string == null) {
                    OraMixinTable.$$$reportNull$$$0(1);
                }
                return string;
            }
            String masterTableName = StringUtil.notNullize((String)this.getMasterTableName(), (String)"???");
            String string = masterTableName + "'ML";
            if (string == null) {
                OraMixinTable.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = OraLikeTable.super.identity(includingSurrogate);
        if (string == null) {
            OraMixinTable.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/dialects/oracle/model/OraMixinTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDisplayOrder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "identity";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

