/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.intentions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DbUIUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunQueryInConsoleIntentionAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getText() {
        if ("Run query in console" == null) {
            RunQueryInConsoleIntentionAction.$$$reportNull$$$0(0);
        }
        return "Run query in console";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            RunQueryInConsoleIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        if (project == null) {
            RunQueryInConsoleIntentionAction.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            RunQueryInConsoleIntentionAction.$$$reportNull$$$0(3);
        }
        if (editor == null || !EditorUtil.isRealFileEditor((Editor)editor)) {
            return false;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element2);
        if (DbConsoleRootType.isConsoleFile(file)) {
            return false;
        }
        for (PersistenceConsoleProvider provider : (PersistenceConsoleProvider[])PersistenceConsoleProvider.EP_NAME.getExtensions()) {
            if (!provider.hasRunners(element2, editor)) continue;
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (project == null) {
            RunQueryInConsoleIntentionAction.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            RunQueryInConsoleIntentionAction.$$$reportNull$$$0(5);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.console.execute");
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ArrayList runners = ContainerUtil.newArrayList();
        for (PersistenceConsoleProvider provider : (PersistenceConsoleProvider[])PersistenceConsoleProvider.EP_NAME.getExtensions()) {
            runners.addAll(provider.getRunners(element2, editor));
        }
        RunQueryInConsoleIntentionAction.chooseAndRunRunners(runners, editor, null);
    }

    public static void chooseAndRunRunners(@NotNull List<PersistenceConsoleProvider.Runner> runners, @Nullable Editor editor, @Nullable AnActionEvent event) {
        if (runners == null) {
            RunQueryInConsoleIntentionAction.$$$reportNull$$$0(6);
        }
        RunQueryInConsoleIntentionAction.chooseAndRunRunners("Consoles", runners, editor, event);
    }

    public static void chooseAndRunRunners(@Nullable String title, @NotNull List<PersistenceConsoleProvider.Runner> runners, @Nullable Editor editor, @Nullable AnActionEvent event) {
        if (runners == null) {
            RunQueryInConsoleIntentionAction.$$$reportNull$$$0(7);
        }
        if (editor == null && event == null) {
            throw new AssertionError();
        }
        if (runners.size() == 1) {
            PersistenceConsoleProvider.Runner runner = runners.get(0);
            List subRunners = runner.getSubRunners();
            if (subRunners.isEmpty()) {
                runners.get(0).run();
            } else {
                String subTitle = runner.getSubRunnersTitle();
                String adjustedTitle = (String)ObjectUtils.chooseNotNull((Object)subTitle, (Object)title);
                BaseListPopupStep<PersistenceConsoleProvider.Runner> step = RunQueryInConsoleIntentionAction.newRunnerPopupStep(adjustedTitle, subRunners, true);
                ListPopup popup = JBPopupFactory.getInstance().createListPopup(step);
                DbUIUtil.showPopup((JBPopup)popup, editor, event);
            }
        } else if (!runners.isEmpty()) {
            BaseListPopupStep<PersistenceConsoleProvider.Runner> step = RunQueryInConsoleIntentionAction.newRunnerPopupStep(title, runners, false);
            ListPopup popup = JBPopupFactory.getInstance().createListPopup(step);
            DbUIUtil.showPopup((JBPopup)popup, editor, event);
        } else if (editor != null) {
            HintManager.getInstance().showErrorHint(editor, "No runners found", (short)1);
        }
    }

    @NotNull
    private static BaseListPopupStep<PersistenceConsoleProvider.Runner> newRunnerPopupStep(@Nullable String title, @NotNull List<PersistenceConsoleProvider.Runner> runners, final boolean subStep) {
        if (runners == null) {
            RunQueryInConsoleIntentionAction.$$$reportNull$$$0(8);
        }
        ArrayList<PersistenceConsoleProvider.Runner> copy = new ArrayList<PersistenceConsoleProvider.Runner>(runners);
        Collections.sort(copy, (o1, o2) -> {
            PriorityAction.Priority p2;
            PriorityAction.Priority p1 = o1 instanceof PriorityAction ? ((PriorityAction)o1).getPriority() : PriorityAction.Priority.NORMAL;
            int priority = p1.compareTo((Enum)(p2 = o2 instanceof PriorityAction ? ((PriorityAction)o2).getPriority() : PriorityAction.Priority.NORMAL));
            if (priority != 0) {
                return priority;
            }
            if (p1 == PriorityAction.Priority.HIGH) {
                return -1;
            }
            int running = Boolean.compare(o1.isAlreadyRunning(), o2.isAlreadyRunning());
            if (running != 0) {
                return -running;
            }
            return Comparing.compare((Comparable)((Object)o1.getDisplayName()), (Comparable)((Object)o2.getDisplayName()));
        });
        BaseListPopupStep<PersistenceConsoleProvider.Runner> step = new BaseListPopupStep<PersistenceConsoleProvider.Runner>(title, copy){

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @NotNull
            public String getTextFor(PersistenceConsoleProvider.Runner runner) {
                String string = runner.getDisplayName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public Icon getIconFor(PersistenceConsoleProvider.Runner runner) {
                return runner.getIcon();
            }

            @Nullable
            public Color getBackgroundFor(PersistenceConsoleProvider.Runner runner) {
                return runner.getColor();
            }

            public ListSeparator getSeparatorAbove(PersistenceConsoleProvider.Runner value) {
                PriorityAction.Priority prevPriority;
                PriorityAction.Priority priority;
                List values2 = this.getValues();
                int index2 = values2.indexOf(value);
                PersistenceConsoleProvider.Runner prev = index2 > 0 ? (PersistenceConsoleProvider.Runner)values2.get(index2 - 1) : null;
                PriorityAction.Priority priority2 = priority = value instanceof PriorityAction ? ((PriorityAction)value).getPriority() : PriorityAction.Priority.NORMAL;
                PriorityAction.Priority priority3 = prev == null ? priority : (prevPriority = prev instanceof PriorityAction ? ((PriorityAction)prev).getPriority() : PriorityAction.Priority.NORMAL);
                if (value.isAlreadyRunning() && priority != PriorityAction.Priority.HIGH && (prev == null || !prev.isAlreadyRunning())) {
                    return new ListSeparator(subStep ? "" : "Open");
                }
                if (prevPriority != priority || prev != null && !value.isAlreadyRunning() && prev.isAlreadyRunning()) {
                    return new ListSeparator();
                }
                return null;
            }

            public boolean hasSubstep(PersistenceConsoleProvider.Runner runner) {
                return !runner.getSubRunners().isEmpty();
            }

            public PopupStep onChosen(PersistenceConsoleProvider.Runner runner, boolean finalChoice) {
                List subRunners = runner.getSubRunners();
                if (subRunners.isEmpty()) {
                    ApplicationManager.getApplication().invokeLater((Runnable)runner);
                    return PopupStep.FINAL_CHOICE;
                }
                BaseListPopupStep step = RunQueryInConsoleIntentionAction.newRunnerPopupStep(runner.getSubRunnersTitle(), subRunners, true);
                PersistenceConsoleProvider.Runner defChoice = finalChoice ? (PersistenceConsoleProvider.Runner)ContainerUtil.find((Iterable)subRunners, r -> r.isDefaultSubRunner()) : null;
                return defChoice != null ? step.onChosen((Object)defChoice, true) : step;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/intentions/RunQueryInConsoleIntentionAction$1", "getTextFor"));
            }
        };
        step.setDefaultOptionIndex(JBIterable.from(copy).indexOf(o -> o.isDefaultSubRunner()));
        BaseListPopupStep<PersistenceConsoleProvider.Runner> baseListPopupStep = step;
        if (baseListPopupStep == null) {
            RunQueryInConsoleIntentionAction.$$$reportNull$$$0(9);
        }
        return baseListPopupStep;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/intentions/RunQueryInConsoleIntentionAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/intentions/RunQueryInConsoleIntentionAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "newRunnerPopupStep";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndRunRunners";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "newRunnerPopupStep";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

