/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseObjectCommentEditor;
import com.intellij.database.view.editors.DatabaseTableColumnsEditor;
import com.intellij.database.view.editors.DatabaseTableForeignKeysEditor;
import com.intellij.database.view.editors.DatabaseTableIndicesEditor;
import com.intellij.database.view.editors.DatabaseTableKeysEditor;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.ui.TableEditorToolbarsDecorator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableEditor
extends DatabaseEditorBaseEx {
    private static final Border BORDER = IdeBorderFactory.createBorder((int)13);
    private JTextField myTableNameField;
    private JLabel myTableNameLabel;
    private JPanel myMainPanel;
    private JComponent myTabsPanel;
    private JPanel myCommentHolder;
    private JPanel myCommentPanel;
    private JLabel myCommentLabel;
    private JBTextField myCommentField;
    private TabbedPaneWrapper myTabs;
    private final DatabaseEditorCapabilities.TableEditorCaps myCaps;
    private final TableEditorModel myTableModel;
    private final List<TabProvider> myTabProviders;

    private boolean setSelectedTabSafe(@NotNull JComponent comp) {
        int idx;
        if (comp == null) {
            DatabaseTableEditor.$$$reportNull$$$0(0);
        }
        if ((idx = this.myTabs.indexOfComponent(comp)) != -1) {
            this.myTabs.setSelectedIndex(idx);
        }
        return idx != -1;
    }

    @Nullable
    public DatabaseEditorBaseEx startItemEditing(@NotNull DeObject exported) {
        if (exported == null) {
            DatabaseTableEditor.$$$reportNull$$$0(1);
        }
        for (TabProvider provider : this.myTabProviders) {
            if (!provider.isMyObject(exported)) continue;
            return this.setSelectedTabSafe(provider.getComponent()) ? provider.startItemEditing(exported) : null;
        }
        return null;
    }

    @NotNull
    public DatabaseEditorBaseEx getActiveEditor() {
        JComponent tab = this.myTabs.getSelectedComponent();
        DatabaseEditorBaseEx res2 = null;
        for (TabProvider provider : this.myTabProviders) {
            if (tab != provider.getComponent()) continue;
            res2 = provider.getActiveEditor();
        }
        DatabaseEditorBaseEx databaseEditorBaseEx = (DatabaseEditorBaseEx)ObjectUtils.chooseNotNull(res2, (Object)this);
        if (databaseEditorBaseEx == null) {
            DatabaseTableEditor.$$$reportNull$$$0(2);
        }
        return databaseEditorBaseEx;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.TableEditorCaps getCaps() {
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = this.myCaps;
        if (tableEditorCaps == null) {
            DatabaseTableEditor.$$$reportNull$$$0(3);
        }
        return tableEditorCaps;
    }

    public DatabaseTableEditor(@NotNull DatabaseEditorState state, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorModel tableModel) {
        if (state == null) {
            DatabaseTableEditor.$$$reportNull$$$0(4);
        }
        if (caps == null) {
            DatabaseTableEditor.$$$reportNull$$$0(5);
        }
        if (tableModel == null) {
            DatabaseTableEditor.$$$reportNull$$$0(6);
        }
        this(state, caps, tableModel, new TableEditorToolbarsDecorator.DefaultToolbarsDecorator());
    }

    public DatabaseTableEditor(@NotNull DatabaseEditorState state, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorModel tableModel, @NotNull TableEditorToolbarsDecorator decorator) {
        if (state == null) {
            DatabaseTableEditor.$$$reportNull$$$0(7);
        }
        if (caps == null) {
            DatabaseTableEditor.$$$reportNull$$$0(8);
        }
        if (tableModel == null) {
            DatabaseTableEditor.$$$reportNull$$$0(9);
        }
        if (decorator == null) {
            DatabaseTableEditor.$$$reportNull$$$0(10);
        }
        super(state);
        this.myCaps = caps;
        this.myTableModel = tableModel;
        this.myTabProviders = this.getTabProviders(decorator, caps);
        this.$$$setupUI$$$();
        JButton commentBtn = DatabaseObjectCommentEditor.createButton(this.getContext(), this.myTableModel, this.myTableNameField);
        this.myCommentHolder.add((Component)commentBtn, "Center");
        this.myTableNameLabel.setLabelFor(this.myTableNameField);
        this.applyCaps();
        for (JComponent c2 : ((JBTreeTraverser)UIUtil.uiTraverser((Component)this.myTabs.getComponent()).expandAndFilter(Conditions.not((Condition)Conditions.instanceOf(JTable.class)))).filter(JComponent.class)) {
            c2.setFocusCycleRoot(false);
            c2.setFocusTraversalPolicy(null);
        }
        this.initSubscriptions();
        this.updateFromModel();
    }

    @NotNull
    protected Border getTabComponentBorder() {
        Border border = BORDER;
        if (border == null) {
            DatabaseTableEditor.$$$reportNull$$$0(11);
        }
        return border;
    }

    protected void applyCaps() {
        this.myCommentHolder.setVisible(this.myCaps.getComment().isSupported());
        this.myCommentHolder.getComponent(0).setEnabled(this.myCaps.getComment().isAvailable());
        this.myCommentPanel.setVisible(this.myCaps.getComment().isSupported());
        this.myCommentLabel.setVisible(this.myCaps.getComment().isSupported());
        this.myTableNameField.setEnabled(this.myCaps.getRename().isAvailable());
        for (TabProvider provider : this.myTabProviders) {
            provider.configure(this.myCaps);
        }
        this.refillTabs();
    }

    @NotNull
    protected List<TabProvider> getTabProviders(@NotNull TableEditorToolbarsDecorator decorator, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (decorator == null) {
            DatabaseTableEditor.$$$reportNull$$$0(12);
        }
        if (caps == null) {
            DatabaseTableEditor.$$$reportNull$$$0(13);
        }
        List list = ContainerUtil.list((Object[])new TabProvider[]{new DatabaseTableColumnsEditor(this, caps, decorator), new DatabaseTableKeysEditor(this, caps, decorator), new DatabaseTableIndicesEditor(this, caps, decorator), new DatabaseTableForeignKeysEditor(this, caps, decorator)});
        if (list == null) {
            DatabaseTableEditor.$$$reportNull$$$0(14);
        }
        return list;
    }

    public void initSubscriptions() {
        this.myTableNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DatabaseTableEditor.this.myUpdating) {
                    return;
                }
                DatabaseTableEditor.this.myTableModel.setName(DatabaseTableEditor.this.myTableNameField.getText());
                DatabaseTableEditor.this.myTableModel.commit();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/editors/DatabaseTableEditor$1", "textChanged"));
            }
        });
        this.myCommentField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (DatabaseTableEditor.this.myUpdating) {
                    return;
                }
                String newVal = StringUtil.nullize((String)DatabaseTableEditor.this.myCommentField.getText());
                String oldVal = StringUtil.nullize((String)DatabaseTableEditor.this.myTableModel.getComment());
                if (Comparing.equal((String)oldVal, (String)newVal)) {
                    return;
                }
                DatabaseTableEditor.this.myTableModel.setComment(newVal);
                DatabaseTableEditor.this.myTableModel.commit();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/editors/DatabaseTableEditor$2", "textChanged"));
            }
        });
        this.myTableModel.addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseTableEditor.this.fromModelToUi();
            }
        }, this);
    }

    @Override
    @NotNull
    public ObjectEditorModel<DeTable> getModel() {
        TableEditorModel tableEditorModel = this.getTableModel();
        if (tableEditorModel == null) {
            DatabaseTableEditor.$$$reportNull$$$0(15);
        }
        return tableEditorModel;
    }

    @Override
    protected void updateFromModelImpl() {
        DatabaseTableEditor.setValue(this.myTableNameField, this.getTableModel().getName());
        DatabaseTableEditor.setValue((JTextField)this.myCommentField, StringUtil.notNullize((String)this.getTableModel().getComment()));
        this.myTabProviders.forEach(TabProvider::updateFromModel);
        this.updateTabTitles();
    }

    protected void updateTabTitles() {
        for (TabProvider provider : this.myTabProviders) {
            if (!provider.isTabEnabled()) continue;
            this.myTabs.setTitleAt(this.myTabs.indexOfComponent(provider.getComponent()), provider.getTabTitle());
        }
    }

    private void refillTabs() {
        JComponent prevComp = this.myTabs.getSelectedComponent();
        this.myTabs.removeAll();
        for (TabProvider provider : this.myTabProviders) {
            if (!provider.isTabEnabled()) continue;
            JComponent comp = provider.getComponent();
            this.myTabs.addTab(provider.getTabTitle(), comp);
        }
        int index2 = this.myTabs.indexOfComponent(prevComp);
        if (index2 != -1) {
            this.myTabs.setSelectedIndex(index2);
        }
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableModel;
        if (tableEditorModel == null) {
            DatabaseTableEditor.$$$reportNull$$$0(16);
        }
        return tableEditorModel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JTextField jTextField = this.myTableNameField;
        if (jTextField == null) {
            DatabaseTableEditor.$$$reportNull$$$0(17);
        }
        return jTextField;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DatabaseTableEditor.$$$reportNull$$$0(18);
        }
        return jPanel;
    }

    @Nullable
    public ValidationInfo validate() {
        if (StringUtil.isEmpty((String)this.getTableModel().getName())) {
            return new ValidationInfo("'" + this.getTableModel().getName() + "' is not a valid table name", (JComponent)this.myTableNameField);
        }
        for (TabProvider provider : this.myTabProviders) {
            ValidationInfo info = provider.validate();
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private void createUIComponents() {
        this.myTabs = new TabbedPaneWrapper((Disposable)this);
        this.myTabsPanel = this.myTabs.getComponent();
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            DatabaseTableEditor.$$$reportNull$$$0(19);
        }
        return deTable;
    }

    @NotNull
    public JTextField getNameEditor() {
        JTextField jTextField = this.myTableNameField;
        if (jTextField == null) {
            DatabaseTableEditor.$$$reportNull$$$0(20);
        }
        return jTextField;
    }

    @NotNull
    public JTextField getCommentEditor() {
        JBTextField jBTextField = this.myCommentField;
        if (jBTextField == null) {
            DatabaseTableEditor.$$$reportNull$$$0(21);
        }
        return jBTextField;
    }

    @NotNull
    public DatabaseTableColumnsEditor getColumnsEditor() {
        DatabaseTableColumnsEditor databaseTableColumnsEditor = this.get(DatabaseTableColumnsEditor.class);
        if (databaseTableColumnsEditor == null) {
            DatabaseTableEditor.$$$reportNull$$$0(22);
        }
        return databaseTableColumnsEditor;
    }

    @NotNull
    public DatabaseTableIndicesEditor getIndicesEditor() {
        DatabaseTableIndicesEditor databaseTableIndicesEditor = this.get(DatabaseTableIndicesEditor.class);
        if (databaseTableIndicesEditor == null) {
            DatabaseTableEditor.$$$reportNull$$$0(23);
        }
        return databaseTableIndicesEditor;
    }

    @NotNull
    public DatabaseTableKeysEditor getKeysEditor() {
        DatabaseTableKeysEditor databaseTableKeysEditor = this.get(DatabaseTableKeysEditor.class);
        if (databaseTableKeysEditor == null) {
            DatabaseTableEditor.$$$reportNull$$$0(24);
        }
        return databaseTableKeysEditor;
    }

    @NotNull
    public DatabaseTableForeignKeysEditor getForeignKeysEditor() {
        DatabaseTableForeignKeysEditor databaseTableForeignKeysEditor = this.get(DatabaseTableForeignKeysEditor.class);
        if (databaseTableForeignKeysEditor == null) {
            DatabaseTableEditor.$$$reportNull$$$0(25);
        }
        return databaseTableForeignKeysEditor;
    }

    @NotNull
    private <T extends TabProvider> T get(@NotNull Class<T> clazz) {
        if (clazz == null) {
            DatabaseTableEditor.$$$reportNull$$$0(26);
        }
        TabProvider tabProvider = (TabProvider)ObjectUtils.assertNotNull((Object)JBIterable.from(this.myTabProviders).filter(clazz).first());
        if (tabProvider == null) {
            DatabaseTableEditor.$$$reportNull$$$0(27);
        }
        return (T)tabProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exported";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableEditor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableModel";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaps";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabComponentBorder";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabProviders";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableModel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameEditor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentEditor";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsEditor";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicesEditor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysEditor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeysEditor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedTabSafe";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startItemEditing";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTabProviders";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        JBTextField jBTextField;
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JComponent jComponent = this.myTabsPanel;
        jPanel3.add((Component)jComponent, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myTableNameLabel = jLabel2 = new JLabel();
        jLabel2.setText("Table:");
        jLabel2.setDisplayedMnemonic('B');
        jLabel2.setDisplayedMnemonicIndex(2);
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCommentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 0, null, null, null));
        this.myCommentHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "East");
        this.myCommentField = jBTextField = new JBTextField();
        jPanel2.add((Component)jBTextField, "Center");
        this.myCommentLabel = jLabel = new JLabel();
        jLabel.setText("Comment:");
        jLabel.setDisplayedMnemonic('C');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTableNameField = jTextField = new JTextField();
        jTextField.setColumns(0);
        jTextField.setText("");
        jPanel3.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 0, null, null, null));
        jLabel2.setLabelFor(jTextField);
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    public static abstract class TabProvider {
        private boolean myTabEnabled = true;

        @NotNull
        public abstract JComponent getComponent();

        @Nullable
        public abstract DatabaseEditorBaseEx startItemEditing(@NotNull DeObject var1);

        @Nullable
        public abstract DatabaseEditorBaseEx getActiveEditor();

        @NotNull
        public abstract String getTabTitle();

        public abstract boolean isMyObject(@NotNull DeObject var1);

        public abstract void updateFromModel();

        public abstract void configure(@NotNull DatabaseEditorCapabilities.TableEditorCaps var1);

        @Nullable
        public ValidationInfo validate() {
            return null;
        }

        void setTabEnabled(boolean enabled) {
            this.myTabEnabled = enabled;
        }

        boolean isTabEnabled() {
            return this.myTabEnabled;
        }
    }
}

