/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="SqlEditorOptions", storages={@Storage(value="editor.xml")})
public class SqlEditorOptions
implements PersistentStateComponent<SqlEditorOptions> {
    private boolean myConcatenateStringsOnEnter = true;
    private QualificationType myQualificationType = QualificationType.SMART;
    private QualificationType myTableQualification = QualificationType.SMART;
    private QualificationType myAliasQualification = QualificationType.SMART;

    private SqlEditorOptions load(SqlEditorOptions options) {
        this.myConcatenateStringsOnEnter = options.myConcatenateStringsOnEnter;
        this.myQualificationType = options.myQualificationType;
        this.myTableQualification = options.myTableQualification;
        this.myAliasQualification = options.myAliasQualification;
        return this;
    }

    @Nullable
    public SqlEditorOptions getState() {
        return new SqlEditorOptions().load(this);
    }

    public void loadState(@NotNull SqlEditorOptions state) {
        if (state == null) {
            SqlEditorOptions.$$$reportNull$$$0(0);
        }
        if (state != null) {
            this.load(state);
        }
    }

    public boolean isConcatenateStringsOnEnter() {
        return this.myConcatenateStringsOnEnter;
    }

    public void setConcatenateStringsOnEnter(boolean concatenateStringsOnEnter) {
        this.myConcatenateStringsOnEnter = concatenateStringsOnEnter;
    }

    @NotNull
    public QualificationType getNamespaceQualification() {
        QualificationType qualificationType = this.myQualificationType;
        if (qualificationType == null) {
            SqlEditorOptions.$$$reportNull$$$0(1);
        }
        return qualificationType;
    }

    public void setNamespaceQualification(QualificationType type) {
        this.myQualificationType = type;
    }

    @NotNull
    public QualificationType getTableQualification() {
        QualificationType qualificationType = this.myTableQualification;
        if (qualificationType == null) {
            SqlEditorOptions.$$$reportNull$$$0(2);
        }
        return qualificationType;
    }

    public void setTableQualification(QualificationType type) {
        this.myTableQualification = type;
    }

    @NotNull
    public QualificationType getAliasQualification() {
        QualificationType qualificationType = this.myAliasQualification;
        if (qualificationType == null) {
            SqlEditorOptions.$$$reportNull$$$0(3);
        }
        return qualificationType;
    }

    public void setAliasQualification(QualificationType type) {
        this.myAliasQualification = type;
    }

    @NotNull
    public static SqlEditorOptions getInstance() {
        SqlEditorOptions sqlEditorOptions = (SqlEditorOptions)ServiceManager.getService(SqlEditorOptions.class);
        if (sqlEditorOptions == null) {
            SqlEditorOptions.$$$reportNull$$$0(4);
        }
        return sqlEditorOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlEditorOptions options = (SqlEditorOptions)o;
        return this.myConcatenateStringsOnEnter == options.myConcatenateStringsOnEnter && this.myQualificationType == options.myQualificationType && this.myTableQualification == options.myTableQualification && this.myAliasQualification == options.myAliasQualification;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myConcatenateStringsOnEnter, this.myQualificationType, this.myTableQualification, this.myAliasQualification});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/editor/SqlEditorOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/editor/SqlEditorOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceQualification";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableQualification";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasQualification";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum QualificationType {
        ALWAYS{

            @Override
            public boolean shouldQualify(int conflictedObjectsCount) {
                return true;
            }

            public String toString() {
                return "Always";
            }
        }
        ,
        SMART{

            @Override
            public boolean shouldQualify(int conflictedObjectsCount) {
                return conflictedObjectsCount > 1;
            }

            public String toString() {
                return "On collisions";
            }
        }
        ,
        NOT_QUALIFY{

            @Override
            public boolean shouldQualify(int conflictedObjectsCount) {
                return false;
            }

            public String toString() {
                return "Never";
            }
        };


        public abstract boolean shouldQualify(int var1);
    }
}

