/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.html.HtmlEmbeddedContentImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularJSIndexingHandler;
import org.angularjs.index.AngularTemplateUrlIndex;
import org.angularjs.lang.parser.AngularJSElementTypes;
import org.angularjs.lang.psi.AngularJSRecursiveVisitor;
import org.angularjs.lang.psi.AngularJSRepeatExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSProcessor {
    private static final Map<String, String> NG_REPEAT_IMPLICITS = new HashMap<String, String>();
    private static final Set<String> COMPONENT_LIFECYCLE_EVENTS = ContainerUtil.newHashSet((Object[])new String[]{"$onInit", "$onChanges", "$doCheck", "$onDestroy", "$postLink"});
    public static final String $EVENT = "$event";
    private static final String $CTRL = "$ctrl";

    public static void process(PsiElement element, Consumer<? super JSPsiElementBase> consumer) {
        PsiElement original = CompletionUtil.getOriginalOrSelf((PsiElement)element);
        PsiFile hostFile = FileContextUtil.getContextFile((PsiElement)(original != element ? original : element.getContainingFile().getOriginalFile()));
        if (!(hostFile instanceof XmlFile)) {
            hostFile = original.getContainingFile();
        }
        if (!(hostFile instanceof XmlFile)) {
            return;
        }
        XmlFile file = (XmlFile)hostFile;
        Collection cache = (Collection)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            ArrayList<JSPsiElementBase> result = new ArrayList<JSPsiElementBase>();
            AngularJSProcessor.processDocument(file.getDocument(), result);
            JSObjectLiteralExpression component = AngularJSProcessor.getReferencingComponentInitializer((PsiFile)file);
            if (component != null) {
                AngularJSProcessor.processComponentInitializer(file, component, result);
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        for (JSPsiElementBase namedElement : cache) {
            if (!AngularJSProcessor.scopeMatches(original, (PsiElement)namedElement)) continue;
            consumer.accept((JSPsiElementBase)namedElement);
        }
    }

    private static void processComponentInitializer(@NotNull XmlFile file, @NotNull JSObjectLiteralExpression componentInitializer, @NotNull Collection<JSPsiElementBase> result) {
        if (file == null) {
            AngularJSProcessor.$$$reportNull$$$0(0);
        }
        if (componentInitializer == null) {
            AngularJSProcessor.$$$reportNull$$$0(1);
        }
        if (result == null) {
            AngularJSProcessor.$$$reportNull$$$0(2);
        }
        result.add((JSPsiElementBase)new JSLocalImplicitElementImpl(AngularJSProcessor.getCtrlVarName(componentInitializer), AngularJSProcessor.getComponentScopeType(file, componentInitializer), (PsiElement)componentInitializer, JSImplicitElement.Type.Class));
    }

    private static String getCtrlVarName(@NotNull JSObjectLiteralExpression componentInitializer) {
        if (componentInitializer == null) {
            AngularJSProcessor.$$$reportNull$$$0(3);
        }
        String ctrlName = null;
        JSProperty ctrlAs = componentInitializer.findProperty("controllerAs");
        if (ctrlAs != null && ctrlAs.getValue() instanceof JSLiteralExpression && ((JSLiteralExpression)ctrlAs.getValue()).isQuotedLiteral()) {
            ctrlName = AngularJSIndexingHandler.unquote((PsiElement)ctrlAs.getValue());
        }
        return ctrlName != null ? ctrlName : $CTRL;
    }

    @NotNull
    private static JSType getComponentScopeType(@NotNull XmlFile file, @NotNull JSObjectLiteralExpression componentInitializer) {
        if (file == null) {
            AngularJSProcessor.$$$reportNull$$$0(4);
        }
        if (componentInitializer == null) {
            AngularJSProcessor.$$$reportNull$$$0(5);
        }
        ArrayList memberList = new ArrayList();
        HashSet names = new HashSet();
        Consumer<JSRecordType.PropertySignature> processor = member -> {
            if (!COMPONENT_LIFECYCLE_EVENTS.contains(member.getMemberName()) && names.add(member.getMemberName())) {
                memberList.add(member);
            }
        };
        JSProperty property = componentInitializer.findProperty("bindings");
        if (property != null) {
            AngularJSProcessor.contributeBindingProperties(property, processor);
        } else {
            property = componentInitializer.findProperty("bindToController");
            if (property != null) {
                JSExpression bindToController = property.getValue();
                if (bindToController instanceof JSObjectLiteralExpression) {
                    AngularJSProcessor.contributeBindingProperties(property, processor);
                } else if (bindToController instanceof JSLiteralExpression && ((JSLiteralExpression)bindToController).getValue() == Boolean.TRUE && (property = componentInitializer.findProperty("scope")) != null) {
                    AngularJSProcessor.contributeBindingProperties(property, processor);
                }
            }
        }
        AngularJSProcessor.contributeControllerProperties(componentInitializer.findProperty("controller"), processor);
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)file, (boolean)true), memberList);
        if (jSRecordTypeImpl == null) {
            AngularJSProcessor.$$$reportNull$$$0(6);
        }
        return jSRecordTypeImpl;
    }

    private static void contributeBindingProperties(@Nullable JSProperty bindingsProperty, @NotNull Consumer<JSRecordType.PropertySignature> processor) {
        if (processor == null) {
            AngularJSProcessor.$$$reportNull$$$0(7);
        }
        if (bindingsProperty != null && bindingsProperty.getValue() instanceof JSObjectLiteralExpression) {
            JSObjectLiteralExpression bindings = (JSObjectLiteralExpression)bindingsProperty.getValue();
            for (JSProperty binding : bindings.getProperties()) {
                if (binding.getName() == null) continue;
                processor.accept((JSRecordType.PropertySignature)new JSRecordTypeImpl.PropertySignatureImpl(binding.getName(), (JSType)JSAnyType.get((PsiElement)bindings, (boolean)true), true));
            }
        }
    }

    private static void contributeControllerProperties(@Nullable JSProperty controllerProperty, @NotNull Consumer<JSRecordType.PropertySignature> processor) {
        if (processor == null) {
            AngularJSProcessor.$$$reportNull$$$0(8);
        }
        if (controllerProperty != null && controllerProperty.getValue() != null) {
            PsiElement resolved;
            JSExpression controller = controllerProperty.getValue();
            if (controller instanceof JSLiteralExpression && ((JSLiteralExpression)controller).isQuotedLiteral()) {
                for (PsiReference ref : controller.getReferences()) {
                    JSArgumentList args;
                    PsiElement resolved2 = ref.resolve();
                    if (resolved2 instanceof JSImplicitElement) {
                        resolved2 = resolved2.getParent();
                    }
                    if (!(resolved2 instanceof JSLiteralExpression) || !(resolved2.getParent() instanceof JSArgumentList) || (args = (JSArgumentList)resolved2.getParent()).getArguments().length < 2) continue;
                    controller = args.getArguments()[1];
                }
            }
            if (controller instanceof JSReferenceExpression && (resolved = ((JSReferenceExpression)controller).resolve()) != null) {
                controller = resolved;
            }
            JSNamespace namespace = null;
            if (controller instanceof JSFunctionExpression) {
                JSType type = JSResolveUtil.getExpressionJSType((JSExpression)controller);
                if (type instanceof JSNamespace) {
                    namespace = (JSNamespace)type;
                }
            } else if (controller instanceof JSFunction) {
                namespace = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)((JSFunction)controller), (boolean)true);
            }
            if (namespace != null && namespace.getQualifiedName() != null) {
                JSClassResolver.getInstance().findNamespaceMembers(namespace.getQualifiedName().getQualifiedName(), controller.getResolveScope()).stream().filter(el -> el.getName() != null).map(el -> new JSRecordTypeImpl.PropertySignatureImpl(el.getName(), JSResolveUtil.getElementJSType((PsiElement)el, (JSEvaluateContext.JSEvaluationPlace)JSEvaluateContext.JSEvaluationPlace.DEFAULT), true, (PsiElement)el)).forEach(processor);
            }
        }
    }

    private static JSObjectLiteralExpression getReferencingComponentInitializer(PsiFile templateFile) {
        String name = templateFile.getViewProvider().getVirtualFile().getName();
        Ref result = new Ref();
        AngularIndexUtil.multiResolve(templateFile.getProject(), AngularTemplateUrlIndex.KEY, name, (Processor<? super JSImplicitElement>)((Processor)el -> {
            JSExpression value;
            if (el.getParent() instanceof JSProperty && el.getParent().getParent() instanceof JSObjectLiteralExpression && (value = ((JSProperty)el.getParent()).getValue()) != null && AngularIndexUtil.hasFileReference((PsiElement)value, templateFile)) {
                result.set((Object)((JSObjectLiteralExpression)el.getParent().getParent()));
                return false;
            }
            return true;
        }));
        return (JSObjectLiteralExpression)result.get();
    }

    private static void processDocument(XmlDocument document, final Collection<JSPsiElementBase> result) {
        if (document == null) {
            return;
        }
        final AngularInjectedFilesVisitor visitor = new AngularInjectedFilesVisitor(result);
        for (XmlTag tag : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)document, XmlTag.class)) {
            ProgressIndicatorProvider.checkCanceled();
            new XmlBackedJSClassImpl.InjectedScriptsVisitor(tag, null, true, true, (XmlBackedJSClass.InjectedFileVisitor)visitor, true){

                public boolean execute(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ProgressIndicatorProvider.checkCanceled();
                    if (element instanceof HtmlEmbeddedContentImpl) {
                        AngularJSProcessor.processDocument((XmlDocument)PsiTreeUtil.findChildOfType((PsiElement)element, XmlDocument.class), result);
                    }
                    if (element instanceof XmlAttribute) {
                        visitor.accept(element);
                    }
                    return super.execute(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/codeInsight/AngularJSProcessor$1", "execute"));
                }
            }.go();
        }
    }

    private static boolean scopeMatches(PsiElement element, PsiElement declaration) {
        InjectedLanguageManager injector = InjectedLanguageManager.getInstance((Project)element.getProject());
        if (declaration instanceof JSImplicitElement) {
            if ($EVENT.equals(((JSImplicitElement)declaration).getName())) {
                return AngularJSProcessor.eventScopeMatches(injector, element, declaration.getParent());
            }
            declaration = declaration.getParent();
        }
        PsiLanguageInjectionHost elementContainer = injector.getInjectionHost(element);
        XmlTagChild elementTag = (XmlTagChild)PsiTreeUtil.getNonStrictParentOfType((PsiElement)elementContainer, (Class[])new Class[]{XmlTag.class, XmlText.class});
        PsiLanguageInjectionHost declarationContainer = injector.getInjectionHost(declaration);
        XmlTagChild declarationTag = (XmlTagChild)PsiTreeUtil.getNonStrictParentOfType((PsiElement)declarationContainer, (Class[])new Class[]{XmlTag.class});
        if (declarationContainer != null && elementContainer != null && elementTag != null && declarationTag != null) {
            return PsiTreeUtil.isAncestor((PsiElement)declarationTag, (PsiElement)elementTag, (boolean)true) || PsiTreeUtil.isAncestor((PsiElement)declarationTag, (PsiElement)elementTag, (boolean)false) && declarationContainer.getTextOffset() < elementContainer.getTextOffset() || AngularJSProcessor.isInRepeatStartEnd(declarationTag, declarationContainer, elementContainer);
        }
        return true;
    }

    private static boolean isInRepeatStartEnd(XmlTagChild declarationTag, PsiLanguageInjectionHost declarationContainer, PsiLanguageInjectionHost elementContainer) {
        PsiElement parent = declarationContainer.getParent();
        if (parent instanceof XmlAttribute && "ngRepeatStart".equals(DirectiveUtil.normalizeAttributeName(((XmlAttribute)parent).getName(), false))) {
            for (XmlTagChild next = declarationTag.getNextSiblingInTag(); next != null; next = next.getNextSiblingInTag()) {
                if (PsiTreeUtil.isAncestor((PsiElement)next, (PsiElement)elementContainer, (boolean)true)) {
                    return true;
                }
                if (next instanceof XmlTag && ContainerUtil.find((Object[])((XmlTag)next).getAttributes(), attr -> "ngRepeatEnd".equals(DirectiveUtil.normalizeAttributeName(attr.getName(), false))) != null) break;
            }
        }
        return false;
    }

    private static boolean eventScopeMatches(InjectedLanguageManager injector, PsiElement element, PsiElement parent) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{XmlAttribute.class});
        if (attribute == null) {
            PsiLanguageInjectionHost elementContainer = injector.getInjectionHost(element);
            attribute = (XmlAttribute)PsiTreeUtil.getNonStrictParentOfType((PsiElement)elementContainer, (Class[])new Class[]{XmlAttribute.class});
        }
        return attribute != null && CompletionUtil.getOriginalOrSelf((PsiElement)attribute) == CompletionUtil.getOriginalOrSelf((PsiElement)parent);
    }

    static {
        NG_REPEAT_IMPLICITS.put("$index", "Number");
        NG_REPEAT_IMPLICITS.put("$first", "Boolean");
        NG_REPEAT_IMPLICITS.put("$middle", "Boolean");
        NG_REPEAT_IMPLICITS.put("$last", "Boolean");
        NG_REPEAT_IMPLICITS.put("$even", "Boolean");
        NG_REPEAT_IMPLICITS.put("$odd", "Boolean");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentInitializer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/codeInsight/AngularJSProcessor";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/codeInsight/AngularJSProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentScopeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processComponentInitializer";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCtrlVarName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getComponentScopeType";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "contributeBindingProperties";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "contributeControllerProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AngularInjectedFilesVisitor
    extends JSResolveUtil.JSInjectedFilesVisitor {
        private final Collection<JSPsiElementBase> myResult;

        AngularInjectedFilesVisitor(Collection<JSPsiElementBase> result) {
            this.myResult = result;
        }

        protected void process(JSFile file) {
            this.accept((PsiElement)file);
        }

        protected void accept(PsiElement element) {
            element.accept((PsiElementVisitor)new AngularJSRecursiveVisitor(){

                public void visitJSDefinitionExpression(JSDefinitionExpression node) {
                    myResult.add(node);
                    super.visitJSDefinitionExpression(node);
                }

                public void visitJSVariable(JSVariable node) {
                    myResult.add(node);
                    super.visitJSVariable(node);
                }

                @Override
                public void visitAngularJSRepeatExpression(AngularJSRepeatExpression repeatExpression) {
                    if (repeatExpression.getNode().getElementType() == AngularJSElementTypes.REPEAT_EXPRESSION) {
                        for (Map.Entry entry : NG_REPEAT_IMPLICITS.entrySet()) {
                            myResult.add(new JSLocalImplicitElementImpl((String)entry.getKey(), (String)entry.getValue(), (PsiElement)repeatExpression));
                        }
                    }
                    super.visitAngularJSRepeatExpression(repeatExpression);
                }
            });
        }
    }
}

