/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.init;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import com.jetbrains.php.joomla.JoomlaBundle;
import com.jetbrains.php.joomla.JoomlaUtil;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.ui.PhpUiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JoomlaContentConfigurationManager {
    private static final JoomlaContentConfigurationManager INSTANCE = new JoomlaContentConfigurationManager();
    @NonNls
    private static final String DIRECTORIES_CONFIGURABLE_NAME = "Directories";
    @NonNls
    private static final String IGNORE = "ignore";
    @NonNls
    private static final String FIX = "fix";
    @NonNls
    private static final String CONFIGURABLE = "configurable";
    @Nullable
    private VirtualFile myJoomlaConfigFile;

    public static JoomlaContentConfigurationManager getInstance() {
        return INSTANCE;
    }

    private JoomlaContentConfigurationManager() {
    }

    public void refreshIncludePaths(JoomlaDataService.State newState, Project project) {
        if (!project.isDefault() && newState.isEnabled() && !newState.isDoNotAskContentConfigAgain()) {
            VirtualFile joomlaFile = this.getJoomlaFile(newState);
            if (joomlaFile == null) {
                return;
            }
            boolean isPluginInsideJoomla = JoomlaContentConfigurationManager.isProjectInsideJoomla(joomlaFile, project);
            if (isPluginInsideJoomla) {
                Module module;
                boolean isJoomlaIncluded;
                Module[] modules = ModuleManager.getInstance((Project)project).getModules();
                if (modules.length == 1 && !(isJoomlaIncluded = JoomlaContentConfigurationManager.isFileInsideModule(joomlaFile, module = modules[0]))) {
                    JoomlaContentConfigurationManager.suggestToChangeContentRoots(joomlaFile, project, module);
                }
            } else {
                boolean isJoomlaIncluded = JoomlaContentConfigurationManager.isInIncludePath(joomlaFile, project);
                if (!isJoomlaIncluded) {
                    JoomlaContentConfigurationManager.addToIncludeFiles(project, joomlaFile);
                }
            }
        }
    }

    private static void suggestToChangeContentRoots(final @NotNull VirtualFile JoomlaFile, final @NotNull Project project, final @NotNull Module module) {
        if (JoomlaFile == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(1);
        }
        if (module == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(2);
        }
        String message = JoomlaBundle.message("joomla.suggestion.content.roots", new Object[0]);
        Function<Notification, AnAction> fixAction = notification -> {
            if (module == null) {
                JoomlaContentConfigurationManager.$$$reportNull$$$0(20);
            }
            if (project == null) {
                JoomlaContentConfigurationManager.$$$reportNull$$$0(21);
            }
            if (JoomlaFile == null) {
                JoomlaContentConfigurationManager.$$$reportNull$$$0(22);
            }
            return new AnAction("Fix"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ModuleRootModificationUtil.updateModel((Module)module, model -> {
                        if (project == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (JoomlaFile == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        ContentEntry[] contentEntries = model.getContentEntries();
                        ContentEntry rootEntry = null;
                        for (ContentEntry entry : contentEntries) {
                            VirtualFile entryFile = entry.getFile();
                            VirtualFile baseDir = project.getBaseDir();
                            if (entryFile == null || baseDir == null || !VfsUtilCore.isAncestor((VirtualFile)entryFile, (VirtualFile)baseDir, (boolean)false)) continue;
                            rootEntry = entry;
                            break;
                        }
                        model.addContentEntry(JoomlaFile);
                        if (rootEntry != null) {
                            model.removeContentEntry(rootEntry);
                        }
                    });
                    if (PlatformUtils.isPhpStorm()) {
                        Runnable runnable = () -> {
                            if (project == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            ShowSettingsUtil.getInstance().showSettingsDialog(project, JoomlaContentConfigurationManager.DIRECTORIES_CONFIGURABLE_NAME);
                        };
                        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "JoomlaFile";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/joomla/init/JoomlaContentConfigurationManager$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$actionPerformed$1";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$actionPerformed$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        };
        Function<Notification, AnAction> ignoreAction = notification -> {
            if (project == null) {
                JoomlaContentConfigurationManager.$$$reportNull$$$0(19);
            }
            return new AnAction("Ignore"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    JoomlaDataService.getInstance(project).setDoNotAskContentConfigurationAgain(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/joomla/init/JoomlaContentConfigurationManager$2", "actionPerformed"));
                }
            };
        };
        JoomlaContentConfigurationManager.showPopup(project, message, fixAction, ignoreAction);
    }

    private static void suggestToAddToIncludePath(final @NotNull VirtualFile joomlaFile, final @NotNull Project project) {
        if (joomlaFile == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(3);
        }
        if (project == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(4);
        }
        String message = JoomlaBundle.message("joomla.suggestion.include.paths", CONFIGURABLE, FIX, IGNORE);
        Function<Notification, AnAction> configureAction = notification -> {
            if (project == null) {
                JoomlaContentConfigurationManager.$$$reportNull$$$0(18);
            }
            return new AnAction("Configure"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    PhpUiUtil.editConfigurable((Project)project, (Configurable)new PhpProjectConfigurable(project));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/joomla/init/JoomlaContentConfigurationManager$3", "actionPerformed"));
                }
            };
        };
        Function<Notification, AnAction> fixAction = notification -> {
            if (project == null) {
                JoomlaContentConfigurationManager.$$$reportNull$$$0(16);
            }
            if (joomlaFile == null) {
                JoomlaContentConfigurationManager.$$$reportNull$$$0(17);
            }
            return new AnAction("Fix", (Notification)notification){
                final /* synthetic */ Notification val$notification;
                {
                    this.val$notification = notification;
                    super(arg0);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    JoomlaContentConfigurationManager.addToIncludeFiles(project, joomlaFile);
                    this.val$notification.expire();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/joomla/init/JoomlaContentConfigurationManager$4", "actionPerformed"));
                }
            };
        };
        Function<Notification, AnAction> ignoreAction = notification -> {
            if (project == null) {
                JoomlaContentConfigurationManager.$$$reportNull$$$0(15);
            }
            return new AnAction("Configure"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    JoomlaDataService.getInstance(project).setDoNotAskContentConfigurationAgain(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/joomla/init/JoomlaContentConfigurationManager$5", "actionPerformed"));
                }
            };
        };
        NotificationListener listener = new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                String description;
                if (notification == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (JoomlaContentConfigurationManager.CONFIGURABLE.equals(description = event.getDescription())) {
                    PhpUiUtil.editConfigurable((Project)project, (Configurable)new PhpProjectConfigurable(project));
                } else if (JoomlaContentConfigurationManager.FIX.equals(description)) {
                    JoomlaContentConfigurationManager.addToIncludeFiles(project, joomlaFile);
                    notification.expire();
                } else if (JoomlaContentConfigurationManager.IGNORE.equals(description)) {
                    JoomlaDataService.getInstance(project).setDoNotAskContentConfigurationAgain(true);
                } else {
                    throw new IllegalStateException("Unexpected description " + description);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/joomla/init/JoomlaContentConfigurationManager$6";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JoomlaContentConfigurationManager.showPopup(project, message, configureAction, fixAction, ignoreAction);
    }

    private static void addToIncludeFiles(@NotNull Project project, @NotNull VirtualFile joomlaFile) {
        if (project == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(5);
        }
        if (joomlaFile == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(6);
        }
        Runnable runnable = () -> {
            if (project == null) {
                JoomlaContentConfigurationManager.$$$reportNull$$$0(13);
            }
            if (joomlaFile == null) {
                JoomlaContentConfigurationManager.$$$reportNull$$$0(14);
            }
            PhpIncludePathManager facade = PhpIncludePathManager.getInstance((Project)project);
            List includePaths = facade.getIncludePath();
            ArrayList<String> newIncludePaths = new ArrayList<String>(includePaths.size() + 1);
            newIncludePaths.addAll(includePaths);
            String path = joomlaFile.getPath();
            newIncludePaths.add(path);
            facade.setIncludePath(newIncludePaths);
        };
        ApplicationManager.getApplication().runWriteAction(runnable);
    }

    @Nullable
    public PhpFile getConfigurationFile(Project project) {
        String joomlaConfigPath = JoomlaDataService.getInstance(project).getJoomlaConfigPath();
        if (joomlaConfigPath != null && !joomlaConfigPath.isEmpty()) {
            this.myJoomlaConfigFile = LocalFileSystem.getInstance().findFileByPath(joomlaConfigPath);
        } else {
            VirtualFile joomlaDirectoryPath;
            String joomlaPath = JoomlaDataService.getInstance(project).getJoomlaPath();
            if (joomlaPath != null && (joomlaDirectoryPath = LocalFileSystem.getInstance().findFileByPath(joomlaPath)) != null) {
                this.myJoomlaConfigFile = joomlaDirectoryPath.findFileByRelativePath("configuration.php");
            }
        }
        if (this.myJoomlaConfigFile != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiFile psiManagerFile = psiManager.findFile(this.myJoomlaConfigFile);
            return psiManagerFile instanceof PhpFile ? (PhpFile)psiManagerFile : null;
        }
        return null;
    }

    @Nullable
    public PhpClass getConfigurationClass(Project project) {
        PhpIndex index = PhpIndex.getInstance((Project)project);
        Collection configClasses = index.getClassesByName("JConfig");
        PhpFile file = this.getConfigurationFile(project);
        if (file != null) {
            for (PhpClass it : configClasses) {
                if (!it.getContainingFile().getVirtualFile().equals(file.getVirtualFile())) continue;
                return it;
            }
        }
        return null;
    }

    @Nullable
    public String getProperty(Project project, String propertyName) {
        PsiElement defaultValue;
        Field fieldByName;
        PhpClass configurationClass = this.getConfigurationClass(project);
        if (configurationClass != null && (fieldByName = configurationClass.findFieldByName((CharSequence)propertyName, false)) != null && (defaultValue = fieldByName.getDefaultValue()) != null) {
            return PhpCodeInsightUtil.toString((PsiElement)defaultValue);
        }
        return null;
    }

    private static boolean isInIncludePath(@NotNull VirtualFile fileToCheck, @NotNull Project project) {
        if (fileToCheck == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(7);
        }
        if (project == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(8);
        }
        List includePaths = PhpIncludePathManager.getInstance((Project)project).getRoots();
        for (VirtualFile file : includePaths) {
            if (file == null || !VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)fileToCheck, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private VirtualFile getJoomlaFile(JoomlaDataService.State state) {
        String path = state.getJoomlaPath();
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file != null && file.isDirectory()) {
            this.myJoomlaConfigFile = file;
            return file;
        }
        this.myJoomlaConfigFile = null;
        return null;
    }

    private static boolean isProjectInsideJoomla(@NotNull VirtualFile joomlaFile, @NotNull Project project) {
        if (joomlaFile == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(9);
        }
        if (project == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(10);
        }
        return VfsUtilCore.isAncestor((VirtualFile)joomlaFile, (VirtualFile)project.getBaseDir(), (boolean)false);
    }

    private static boolean isFileInsideModule(@NotNull VirtualFile joomlaFile, @NotNull Module module) {
        VirtualFile[] contentRoots;
        if (joomlaFile == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(11);
        }
        if (module == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(12);
        }
        for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)joomlaFile, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static void showPopup(Project project, String message, Function<Notification, AnAction> ... action) {
        Runnable runnable = () -> JoomlaUtil.notifyGlobally(project, JoomlaBundle.message("joomla.plugin.title", new Object[0]), message, NotificationType.INFORMATION, new Function[0]);
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "JoomlaFile";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "joomlaFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToCheck";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/joomla/init/JoomlaContentConfigurationManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestToChangeContentRoots";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestToAddToIncludePath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addToIncludeFiles";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isInIncludePath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isProjectInsideJoomla";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileInsideModule";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addToIncludeFiles$5";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$suggestToAddToIncludePath$4";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$suggestToAddToIncludePath$3";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$suggestToAddToIncludePath$2";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$suggestToChangeContentRoots$1";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$suggestToChangeContentRoots$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

