/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.Mandatory;
import org.jetbrains.io.mandatory.RestModel;

@RestModel
public class GithubErrorMessage {
    @Mandatory
    private String message;
    private List<Error> errors;

    @NotNull
    public String getMessage() {
        String string = this.message;
        if (string == null) {
            GithubErrorMessage.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public List<Error> getErrors() {
        if (this.errors == null) {
            List<Error> list2 = Collections.emptyList();
            if (list2 == null) {
                GithubErrorMessage.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<Error> list3 = this.errors;
        if (list3 == null) {
            GithubErrorMessage.$$$reportNull$$$0(2);
        }
        return list3;
    }

    @NotNull
    public String getPresentableError() {
        if (this.errors == null) {
            String string = this.message;
            if (string == null) {
                GithubErrorMessage.$$$reportNull$$$0(3);
            }
            return string;
        }
        StringBuilder s = new StringBuilder();
        s.append(this.message);
        for (Error e : this.errors) {
            s.append(String.format("<br/>[%s; %s]%s: %s", e.resource, e.field, e.code, e.message));
        }
        String string = s.toString();
        if (string == null) {
            GithubErrorMessage.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean containsReasonMessage(@NotNull String reason) {
        if (reason == null) {
            GithubErrorMessage.$$$reportNull$$$0(5);
        }
        if (this.message == null) {
            return false;
        }
        return this.message.contains(reason);
    }

    public boolean containsErrorCode(@NotNull String code) {
        if (code == null) {
            GithubErrorMessage.$$$reportNull$$$0(6);
        }
        if (this.errors == null) {
            return false;
        }
        for (Error error : this.errors) {
            if (error.code == null || !error.code.contains(code)) continue;
            return true;
        }
        return false;
    }

    public boolean containsErrorMessage(@NotNull String message) {
        if (message == null) {
            GithubErrorMessage.$$$reportNull$$$0(7);
        }
        if (this.errors == null) {
            return false;
        }
        for (Error error : this.errors) {
            if (error.code == null || !error.code.contains(message)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/api/data/GithubErrorMessage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableError";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/api/data/GithubErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsReasonMessage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsErrorCode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsErrorMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @RestModel
    public static class Error {
        @Mandatory
        private String resource;
        private String field;
        @Mandatory
        private String code;
        private String message;

        @NotNull
        public String getResource() {
            String string = this.resource;
            if (string == null) {
                Error.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public String getField() {
            return this.field;
        }

        @NotNull
        public String getCode() {
            String string = this.code;
            if (string == null) {
                Error.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public String getMessage() {
            return this.message;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/plugins/github/api/data/GithubErrorMessage$Error";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCode";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

