/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight;

import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseListImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpImportOptimizer
implements ImportOptimizer {
    public boolean supports(PsiFile file) {
        return file instanceof PhpFile;
    }

    @NotNull
    public Runnable processFile(PsiFile file) {
        final PhpFile phpFile = (PhpFile)file;
        final List toInsert = ContainerUtil.newSmartList();
        final List toDelete = ContainerUtil.newSmartList();
        int unused = 0;
        unused += PhpImportOptimizer.processImports((PhpPsiElement)phpFile, toInsert, toDelete);
        for (PhpNamespace namespace : PhpCodeInsightUtil.collectNamespaces((PsiFile)phpFile)) {
            unused += PhpImportOptimizer.processImports((PhpPsiElement)namespace, toInsert, toDelete);
        }
        final int removed = unused;
        ImportOptimizer.CollectingInfoRunnable collectingInfoRunnable = new ImportOptimizer.CollectingInfoRunnable(){

            @NotNull
            public String getUserNotificationInfo() {
                if (removed > 0) {
                    String string = removed + " 'use' statement" + (removed > 1 ? "s" : "") + " removed";
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                String string = toDelete.size() + " 'use' statements checked, nothing was removed";
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void run() {
                PhpImportOptimizer.commitDocument((PsiFile)phpFile);
                for (Pair pair : toInsert) {
                    PsiElement anchor = (PsiElement)pair.getFirst();
                    PsiElement parent = anchor.getParent();
                    if (parent == null || !parent.isValid()) continue;
                    for (PhpUseList element : (List)pair.getSecond()) {
                        parent.addBefore((PsiElement)element, anchor);
                    }
                }
                for (PhpUseList useList : toDelete) {
                    useList.delete();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/codeInsight/PhpImportOptimizer$1", "getUserNotificationInfo"));
            }
        };
        if (collectingInfoRunnable == null) {
            PhpImportOptimizer.$$$reportNull$$$0(0);
        }
        return collectingInfoRunnable;
    }

    private static void commitDocument(@NotNull PsiFile file) {
        PsiDocumentManager manager;
        Document document;
        if (file == null) {
            PhpImportOptimizer.$$$reportNull$$$0(1);
        }
        if ((document = (manager = PsiDocumentManager.getInstance((Project)file.getProject())).getDocument(file)) != null) {
            manager.commitDocument(document);
        }
    }

    private static int processImports(@NotNull PhpPsiElement scope, @NotNull List<Pair<PhpUseList, List<PhpUseList>>> toInsert, @NotNull List<PhpUseList> toDelete) {
        if (scope == null) {
            PhpImportOptimizer.$$$reportNull$$$0(2);
        }
        if (toInsert == null) {
            PhpImportOptimizer.$$$reportNull$$$0(3);
        }
        if (toDelete == null) {
            PhpImportOptimizer.$$$reportNull$$$0(4);
        }
        Project project = scope.getProject();
        List<PhpUseList> useLists = PhpCodeInsightUtil.collectImports(scope);
        if (useLists.isEmpty()) {
            return 0;
        }
        int unused = 0;
        ArrayList imports = ContainerUtil.newArrayList();
        for (PhpUseList useList : useLists) {
            Object[] declarations = useList.getDeclarations();
            List usedDeclarations = ContainerUtil.filter((Object[])declarations, use -> !PhpCodeInsightUtil.isUnused(use) && !PhpCodeInsightUtil.isUnnecessary(use));
            unused += declarations.length - usedDeclarations.size();
            if (usedDeclarations.isEmpty()) continue;
            PhpNamespaceReference namespaceReference = useList.getNamespaceReference();
            if (namespaceReference != null) {
                PhpImportOptimizer.processGroupUseDeclarations(project, useList, usedDeclarations, namespaceReference, imports);
                continue;
            }
            PhpImportOptimizer.processUseDeclarations(project, useList, usedDeclarations, imports);
        }
        ContainerUtil.sort((List)imports);
        toInsert.add((Pair<PhpUseList, List<PhpUseList>>)Pair.create((Object)useLists.get(0), (Object)ContainerUtil.map((Collection)imports, phpImport -> ((PhpImport)phpImport).useList)));
        toDelete.addAll(useLists);
        return unused;
    }

    private static void processGroupUseDeclarations(@NotNull Project project, @NotNull PhpUseList useList, @NotNull List<PhpUse> usedDeclarations, @NotNull PhpNamespaceReference namespaceReference, @NotNull List<PhpImport> imports) {
        if (project == null) {
            PhpImportOptimizer.$$$reportNull$$$0(5);
        }
        if (useList == null) {
            PhpImportOptimizer.$$$reportNull$$$0(6);
        }
        if (usedDeclarations == null) {
            PhpImportOptimizer.$$$reportNull$$$0(7);
        }
        if (namespaceReference == null) {
            PhpImportOptimizer.$$$reportNull$$$0(8);
        }
        if (imports == null) {
            PhpImportOptimizer.$$$reportNull$$$0(9);
        }
        String useListKeyword = PhpGroupUseElement.getKeyword(null, useList);
        String fqn = PhpLangUtil.toFQN(namespaceReference.getFullName());
        ArrayList uses = ContainerUtil.newArrayList();
        for (PhpUse declaration : usedDeclarations) {
            String name = PhpUseImpl.getReferenceText(declaration);
            String alias = declaration.getAliasName();
            String useKeyword = PhpGroupUseElement.getKeyword(declaration, null);
            uses.add(new PhpGroupUseElement(useKeyword, name, alias));
        }
        if (!uses.isEmpty()) {
            ContainerUtil.sort((List)uses);
            boolean trailingComma = PhpUseListImpl.getTrailingComma(useList) != null;
            PhpUseList newGroupUse = PhpPsiElementFactory.createGroupUseStatement(project, useListKeyword, fqn, uses, trailingComma);
            imports.add(new PhpImport(useListKeyword, fqn, null, newGroupUse));
        }
    }

    private static void processUseDeclarations(@NotNull Project project, @NotNull PhpUseList useList, @NotNull List<PhpUse> usedDeclarations, @NotNull List<PhpImport> imports) {
        if (project == null) {
            PhpImportOptimizer.$$$reportNull$$$0(10);
        }
        if (useList == null) {
            PhpImportOptimizer.$$$reportNull$$$0(11);
        }
        if (usedDeclarations == null) {
            PhpImportOptimizer.$$$reportNull$$$0(12);
        }
        if (imports == null) {
            PhpImportOptimizer.$$$reportNull$$$0(13);
        }
        for (PhpUse use : usedDeclarations) {
            String keyword = PhpGroupUseElement.getKeyword(use, useList);
            String fqn = use.getFQN();
            String alias = use.getAliasName();
            PhpUseList newUseList = PhpPsiElementFactory.createUseStatementWithKeyword(project, keyword, fqn, alias);
            imports.add(new PhpImport(keyword, fqn, alias, newUseList));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/PhpImportOptimizer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInsert";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDelete";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useList";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedDeclarations";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceReference";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "processFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/PhpImportOptimizer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "commitDocument";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processImports";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processGroupUseDeclarations";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processUseDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PhpImport
    extends PhpGroupUseElement {
        @NotNull
        private final PhpUseList useList;

        private PhpImport(@NotNull String keyword, @NotNull String name, @Nullable String alias, @NotNull PhpUseList useList) {
            if (keyword == null) {
                PhpImport.$$$reportNull$$$0(0);
            }
            if (name == null) {
                PhpImport.$$$reportNull$$$0(1);
            }
            if (useList == null) {
                PhpImport.$$$reportNull$$$0(2);
            }
            super(keyword, name, alias);
            this.useList = useList;
        }

        @Override
        public String toString() {
            return "PhpImport{useList=" + this.useList + "} " + super.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "keyword";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "useList";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/codeInsight/PhpImportOptimizer$PhpImport";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

