/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.inspections.PhpUndefinedMemberInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpUndefinedClassConstantInspection
extends PhpUndefinedMemberInspection {
    private static final AddConstantDeclarationQuickFix FIX = new AddConstantDeclarationQuickFix();
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{FIX};
    private static final String UNDEFINED_CLASS_CONSTANT = "Constant '#ref' not found in ";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedClassConstantInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpClassConstantReference(ClassConstantReference reference) {
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null || nameNode.getElementType() == PhpTokenTypes.kwCLASS) {
                    return;
                }
                PhpExpression classReference = reference.getClassReference();
                if (classReference instanceof PhpReference && ((PhpReference)classReference).multiResolve(false).length > 0 && reference.multiResolve(false).length == 0) {
                    Project project = reference.getProject();
                    PhpType type = classReference.getType().global(project);
                    String template = isOnTheFly ? PhpUndefinedClassConstantInspection.UNDEFINED_CLASS_CONSTANT + type.toStringRelativized(reference.getNamespaceName()) : PhpUndefinedClassConstantInspection.UNDEFINED_CLASS_CONSTANT;
                    holder.registerProblem(nameNode.getPsi(), template, FIXES);
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpUndefinedClassConstantInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassConstantInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassConstantInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddConstantDeclarationQuickFix
    extends PhpQuickFixBase {
        AddConstantDeclarationQuickFix() {
        }

        @NotNull
        public String getName() {
            if ("Add constant" == null) {
                AddConstantDeclarationQuickFix.$$$reportNull$$$0(0);
            }
            return "Add constant";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                AddConstantDeclarationQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            MemberReference reference;
            PhpClass klass;
            if (project == null) {
                AddConstantDeclarationQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AddConstantDeclarationQuickFix.$$$reportNull$$$0(3);
            }
            if ((klass = AddConstantDeclarationQuickFix.resolveClass(reference = (MemberReference)PsiTreeUtil.getParentOfType((PsiElement)(element = descriptor.getPsiElement()), MemberReference.class, (boolean)false), true)) != null) {
                ASTNode semicolon;
                PsiElement problem = descriptor.getPsiElement();
                Field field = PhpPsiElementFactory.createFromText(klass.getProject(), Field.class, "class c { const " + problem.getText() + " = ;}");
                assert (field != null);
                PsiElement inserted = PhpCodeEditUtil.insertClassMember(klass, field.getParent());
                ASTNode insertedNode = inserted.getNode();
                if (insertedNode != null && insertedNode.getElementType() == PhpElementTypes.CLASS_CONSTANTS && (semicolon = insertedNode.findChildByType(PhpTokenTypes.opSEMICOLON)) != null) {
                    PhpCodeUtil.openRelatedFile(project, semicolon.getPsi());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassConstantInspection$AddConstantDeclarationQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassConstantInspection$AddConstantDeclarationQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

