/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.zend;

import com.jetbrains.php.debug.zend.connection.ZendDebuggerConnection;
import com.jetbrains.php.debug.zend.messages.GetCallTraceResponse;
import com.jetbrains.php.debug.zend.messages.GetScriptProfilerInfoResponse;
import com.jetbrains.php.profiler.model.ProfilerModel;
import com.jetbrains.php.profiler.model.impl.CallableImpl;
import com.jetbrains.php.profiler.model.impl.ProfilerModelBuilder;
import com.jetbrains.php.profiler.zend.ZendDebuggerProfilerCallableCreator;
import com.jetbrains.php.profiler.zend.ZendProfilerModel;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class ZendDebuggerProfilerModelBuilder
extends ProfilerModelBuilder {
    @NotNull
    private final ZendDebuggerConnection.ProfilerData myProfilerData;

    public ZendDebuggerProfilerModelBuilder(@NotNull ZendDebuggerConnection.ProfilerData profilerData) {
        if (profilerData == null) {
            ZendDebuggerProfilerModelBuilder.$$$reportNull$$$0(0);
        }
        super(ZendDebuggerProfilerCallableCreator.INSTANCE);
        this.myProfilerData = profilerData;
        this.myModel = new ZendProfilerModel();
    }

    public ProfilerModel build() {
        ProfilerModel profilerModel = this.myModel;
        LinkedList<GetCallTraceResponse.CallTraceEvent> callTraceEventStack = new LinkedList<GetCallTraceResponse.CallTraceEvent>();
        LinkedList<Integer> callTimeSStack = new LinkedList<Integer>();
        LinkedList<Integer> callTimeMStack = new LinkedList<Integer>();
        for (GetScriptProfilerInfoResponse response : this.myProfilerData.getScriptProfilerInfoResponses()) {
            String scriptPath = response.getPath();
            for (GetScriptProfilerInfoResponse.FunctionInfo functionInfo : response.getFunctionInfos()) {
                if (functionInfo.getCalls() == 0) continue;
                this.getOrCreate(scriptPath, functionInfo.getName(), functionInfo.getLine(), String.valueOf(functionInfo.getId()));
            }
        }
        GetCallTraceResponse.CallTraceEvent[] callTraceEvents = this.myProfilerData.getCallTraceResponses().getCallTraceEvents();
        callTimeMStack.push(0);
        callTimeSStack.push(0);
        for (GetCallTraceResponse.CallTraceEvent callTraceEvent : callTraceEvents) {
            if (callTraceEvent.getType() == 1) {
                callTraceEventStack.push(callTraceEvent);
                callTimeSStack.push(0);
                callTimeMStack.push(0);
                continue;
            }
            GetCallTraceResponse.CallTraceEvent startEvent = (GetCallTraceResponse.CallTraceEvent)callTraceEventStack.pop();
            int totalTimeS = callTraceEvent.getTimestampS() - startEvent.getTimestampS();
            int totalTimeM = callTraceEvent.getTimestampM() - startEvent.getTimestampM();
            int currFunctionId = callTraceEvent.getFunctionId();
            assert (startEvent.getFunctionId() == currFunctionId);
            CallableImpl callee = this.getCallable(String.valueOf(currFunctionId));
            assert (callee != null);
            int ownTimeM = totalTimeM - (Integer)callTimeMStack.pop();
            int ownTimeS = totalTimeS - (Integer)callTimeSStack.pop();
            profilerModel.addCallee(callee, ZendDebuggerProfilerModelBuilder.convertTime(ownTimeS, ownTimeM));
            GetCallTraceResponse.CallTraceEvent callStackPeek = (GetCallTraceResponse.CallTraceEvent)callTraceEventStack.peek();
            CallableImpl caller = callStackPeek != null ? this.getCallable(String.valueOf(callStackPeek.getFunctionId())) : null;
            profilerModel.addCall(caller, callee, ZendDebuggerProfilerModelBuilder.convertTime(totalTimeS, totalTimeM));
            callTimeMStack.push((Integer)callTimeMStack.pop() + totalTimeM);
            callTimeSStack.push((Integer)callTimeSStack.pop() + totalTimeS);
        }
        return profilerModel;
    }

    private static long convertTime(int seconds, int milliseconds) {
        return (long)(seconds * 1000000) + (long)milliseconds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profilerData", "com/jetbrains/php/profiler/zend/ZendDebuggerProfilerModelBuilder", "<init>"));
    }
}

