/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectWorkspaceConfiguration;
import com.jetbrains.php.tools.quality.QualityToolConfigurationComboBox;
import com.jetbrains.php.tools.quality.QualityToolsIgnoreFilesConfigurable;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolProjectConfigurableForm
implements SearchableConfigurable {
    static ExtensionPointName<ConfigurableEP<QualityToolProjectConfigurableForm>> EP_NAME = ExtensionPointName.create((String)"com.jetbrains.php.tools.projectConfigurableForm");
    private JPanel myMainPanel;
    private QualityToolConfigurationComboBox myConfigurationBox;
    private JPanel myConfigurationPanel;
    private JLabel myWarningLabel;
    private ActionLink myShowIgnoredFilesActionLink;
    private ActionListener myValidateConfigurationListener;
    protected final Project myProject;

    public QualityToolProjectConfigurableForm(@NotNull Project project) {
        if (project == null) {
            QualityToolProjectConfigurableForm.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myProject.getMessageBus().connect().subscribe(PhpProjectWorkspaceConfiguration.TOPIC, () -> this.updateWarningLabel());
        this.myValidateConfigurationListener = e -> this.updateWarningLabel();
        this.myConfigurationBox.getComboBox().addActionListener(this.myValidateConfigurationListener);
        this.myWarningLabel.setVisible(false);
    }

    protected abstract void updateSelectedConfiguration(@Nullable String var1);

    @Nullable
    protected abstract String getSavedSelectedConfigurationId();

    @Nullable
    protected abstract String validate(@Nullable String var1);

    private void updateWarningLabel() {
        String warning = this.validate(this.myConfigurationBox.getSelectedItemId());
        if (warning != null) {
            this.myWarningLabel.setVisible(true);
            this.myWarningLabel.setText(warning);
            this.myWarningLabel.setIcon(UIUtil.getBalloonErrorIcon());
        } else {
            this.myWarningLabel.setVisible(false);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            QualityToolProjectConfigurableForm.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public void apply() throws ConfigurationException {
        this.updateSelectedConfiguration(this.myConfigurationBox.getSelectedItemId());
    }

    public boolean isModified() {
        return !StringUtil.notNullize((String)this.myConfigurationBox.getSelectedItemId()).equals(this.getSavedSelectedConfigurationId());
    }

    public void reset() {
        this.myConfigurationBox.reset(this.myProject, this.getSavedSelectedConfigurationId());
    }

    public void disposeUIResources() {
        if (this.myValidateConfigurationListener != null) {
            this.myConfigurationBox.getComboBox().removeActionListener(this.myValidateConfigurationListener);
            this.myValidateConfigurationListener = null;
        }
        Disposer.dispose((Disposable)this.myConfigurationBox);
    }

    private void createUIComponents() {
        this.myConfigurationBox = this.createConfigurationComboBox();
        this.myShowIgnoredFilesActionLink = new ActionLink(PhpBundle.message("action.detect.composer.json.open", new Object[0]), new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (QualityToolProjectConfigurableForm.this.myShowIgnoredFilesActionLink.isEnabled()) {
                    ShowSettingsUtil.getInstance().editConfigurable(QualityToolProjectConfigurableForm.this.myProject, (Configurable)QualityToolProjectConfigurableForm.this.getIgnoredFilesConfigurable());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/QualityToolProjectConfigurableForm$1", "actionPerformed"));
            }
        });
        this.myShowIgnoredFilesActionLink.setPaintUnderline(false);
    }

    @NotNull
    protected abstract QualityToolConfigurationComboBox createConfigurationComboBox();

    protected abstract QualityToolsIgnoreFilesConfigurable getIgnoredFilesConfigurable();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolProjectConfigurableForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolProjectConfigurableForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myConfigurationPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Configuration:");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        QualityToolConfigurationComboBox qualityToolConfigurationComboBox = this.myConfigurationBox;
        jPanel3.add((Component)((Object)qualityToolConfigurationComboBox), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        ActionLink actionLink = this.myShowIgnoredFilesActionLink;
        this.$$$loadLabelText$$$((JLabel)actionLink, ResourceBundle.getBundle("messages/PhpBundle").getString("guality.tool.configuration.show.ignored.files"));
        jPanel3.add((Component)actionLink, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myWarningLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

