/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DistinctRootsCollections;
import com.jetbrains.plugins.webDeployment.ServerTreeContentListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.actions.createproject.ServerTreeForm;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleRemoteExclusionAction
extends AnAction
implements DumbAware {
    public ToggleRemoteExclusionAction(@Nullable Icon icon) {
        super(WDBundle.message("excluded.from.download.action.title", new Object[0]), WDBundle.message("exclude.path.action.description", new Object[0]), icon);
    }

    public ToggleRemoteExclusionAction() {
        this(null);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ToggleRemoteExclusionAction.$$$reportNull$$$0(0);
        }
        super.update(event);
        FileObject[] remoteFiles = (FileObject[])WebDeploymentDataKeys.REMOTE_ITEMS.getData(event.getDataContext());
        Presentation presentation = event.getPresentation();
        String place = event.getPlace();
        if (remoteFiles == null || remoteFiles.length == 0) {
            ToggleRemoteExclusionAction.setEnabled(presentation, false, place);
            return;
        }
        Deployable serverConfig = (Deployable)WebDeploymentDataKeys.DEPLOYABLE.getData(event.getDataContext());
        if (serverConfig == null) {
            ToggleRemoteExclusionAction.setEnabled(presentation, false, place);
            return;
        }
        PublishConfig config = (PublishConfig)event.getData(WebDeploymentDataKeys.PUBLISH_CONFIG);
        boolean isPopupPlace = ActionPlaces.isPopupPlace((String)place);
        if (config == null) {
            ToggleRemoteExclusionAction.setEnabled(presentation, false, place);
        } else if (config.getNearestMappingDeploy2Local(remoteFiles[0], false, (Mappable)serverConfig).getFirst() != null) {
            if (isPopupPlace) {
                presentation.setText(WDBundle.message("exclude.path.action.title", new Object[0]));
                presentation.setDescription(WDBundle.message("exclude.path.action.description", new Object[0]));
            }
            ToggleRemoteExclusionAction.setEnabled(presentation, true, place);
        } else if (ToggleRemoteExclusionAction.isPathExcluded(remoteFiles[0], config, serverConfig)) {
            if (isPopupPlace) {
                presentation.setText(WDBundle.message("remove.path.from.excluded.action.title", new Object[0]));
                presentation.setDescription(WDBundle.message("remove.from.excluded.paths.action.description", new Object[0]));
            }
            ToggleRemoteExclusionAction.setEnabled(presentation, true, place);
        } else {
            ToggleRemoteExclusionAction.setEnabled(presentation, false, place);
        }
    }

    private static void setEnabled(Presentation presentation, boolean enabled, String place) {
        presentation.setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)place)) {
            presentation.setVisible(enabled);
        }
    }

    private static boolean isPathExcluded(FileObject remoteFile, PublishConfig publishConfig, Deployable serverConfig) {
        if (publishConfig.isExcludedByName(serverConfig.getPresentablePath(remoteFile))) {
            return true;
        }
        for (ExcludedPath excludedPath : publishConfig.getExcludedPaths(serverConfig.getId())) {
            if (excludedPath.isLocal() || !excludedPath.isParentForRemotePath(remoteFile.getName(), false, serverConfig)) continue;
            return true;
        }
        return false;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleRemoteExclusionAction.$$$reportNull$$$0(1);
        }
        boolean state = !this.isSelected(e);
        this.setSelected(e, state);
    }

    private boolean isSelected(AnActionEvent event) {
        Deployable serverConfig = (Deployable)WebDeploymentDataKeys.DEPLOYABLE.getData(event.getDataContext());
        PublishConfig publishConfig = (PublishConfig)event.getData(WebDeploymentDataKeys.PUBLISH_CONFIG);
        if (publishConfig == null) {
            return false;
        }
        FileObject[] files = (FileObject[])WebDeploymentDataKeys.REMOTE_ITEMS.getData(event.getDataContext());
        if (files == null || files.length == 0) {
            return false;
        }
        if (publishConfig.isExcludedByName(serverConfig.getPresentablePath(files[0]))) {
            return true;
        }
        Pair<DeploymentPathMapping, Boolean> mapping = publishConfig.getNearestMappingDeploy2Local(files[0], false, (Mappable)serverConfig);
        return mapping.getFirst() == null && Boolean.TRUE == mapping.getSecond();
    }

    private static WebServerConfig.RemotePath getRemotePathForMappings(FileObject file, Deployable serverConfig) {
        String remotePathPresentation = !serverConfig.getAccessType().isProtocolBased() ? DeploymentPathUtils.getPathRemainder(serverConfig.getMountedFolder(), serverConfig.getPresentablePath(file), serverConfig.isCaseSensitive()) : file.getName().getPath();
        return new WebServerConfig.RemotePath(remotePathPresentation);
    }

    private void setSelected(AnActionEvent event, boolean state) {
        FileObject[] files = (FileObject[])WebDeploymentDataKeys.REMOTE_ITEMS.getData(event.getDataContext());
        Object remoteItems = state ? new DistinctRootsCollections.FileObjects(files){

            @Override
            protected boolean isAncestor(@NotNull FileObject ancestor, @NotNull FileObject fileObject) {
                if (ancestor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fileObject == null) {
                    1.$$$reportNull$$$0(1);
                }
                return fileObject.getName().isAncestor(ancestor.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "ancestor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fileObject";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/plugins/webDeployment/actions/ToggleRemoteExclusionAction$1";
                objectArray[2] = "isAncestor";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        } : Arrays.asList(files);
        final Deployable serverConfig = (Deployable)WebDeploymentDataKeys.DEPLOYABLE.getData(event.getDataContext());
        PublishConfig publishConfig = (PublishConfig)event.getData(WebDeploymentDataKeys.PUBLISH_CONFIG);
        boolean skippedSelectedByName = false;
        Project project = event.getProject();
        List<ExcludedPath> excludedPaths = publishConfig.getExcludedPaths(serverConfig.getId());
        final ArrayList<String> pathsToRefresh = new ArrayList<String>();
        Iterator iterator = remoteItems.iterator();
        while (iterator.hasNext()) {
            FileObject path = (FileObject)iterator.next();
            Pair<DeploymentPathMapping, Boolean> mappingPair = publishConfig.getNearestMappingDeploy2Local(path, false, (Mappable)serverConfig);
            boolean isSelected = publishConfig.isExcludedByName(serverConfig.getPresentablePath(path)) || mappingPair.getFirst() == null && Boolean.TRUE == mappingPair.getSecond();
            if (isSelected == state) continue;
            if (state) {
                ExcludedPath newRemotePath = new ExcludedPath(ToggleRemoteExclusionAction.getRemotePathForMappings((FileObject)path, (Deployable)serverConfig).path, false);
                excludedPaths.add(newRemotePath);
                pathsToRefresh.add(serverConfig.getPresentablePath(path));
            } else {
                if (publishConfig.isExcludedByName(serverConfig.getPresentablePath(path))) {
                    skippedSelectedByName = true;
                }
                ExcludedPath nearest = null;
                for (ExcludedPath excludedPath : excludedPaths) {
                    if (excludedPath.isLocal() || !excludedPath.isParentForRemotePath(path.getName(), false, serverConfig) || nearest != null && !nearest.isParent(excludedPath, serverConfig)) continue;
                    nearest = excludedPath;
                }
                assert (nearest != null || skippedSelectedByName);
                if (nearest != null) {
                    if (nearest.isParentForRemotePath(path.getName(), true, serverConfig)) {
                        excludedPaths.remove(nearest);
                        pathsToRefresh.add(serverConfig.getPresentablePath(path));
                    } else {
                        int result;
                        String shortPath = ServerTreeForm.getMountedServerRelativePath(serverConfig.getPresentablePath(path), serverConfig);
                        String text = WDBundle.message("file.0.is.child.of.excluded.file.change.parent.settings.warning.message", shortPath, nearest.getPath());
                        if (project != null && !project.isDefault() && !project.isDefault()) {
                            result = Messages.showOkCancelDialog((Project)project, (String)text, (String)WDBundle.message("remove.path.from.excluded.error.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                        } else {
                            ServerTree tree = (ServerTree)((Object)WebDeploymentDataKeys.SERVER_TREE.getData(event.getDataContext()));
                            result = Messages.showOkCancelDialog((Component)((Object)tree), (String)text, (String)WDBundle.message("remove.path.from.excluded.error.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                        }
                        if (result != 0) continue;
                        excludedPaths.remove(nearest);
                        if (!serverConfig.getAccessType().isProtocolBased()) {
                            pathsToRefresh.add(DeploymentPathUtils.join(serverConfig.getMountedFolder(), nearest.getPath(), File.separatorChar));
                        } else {
                            pathsToRefresh.add(nearest.getPath());
                        }
                    }
                }
            }
            publishConfig.setExcludedPaths(serverConfig.getId(), excludedPaths);
        }
        if (skippedSelectedByName) {
            Messages.showInfoMessage((String)WDBundle.message("some.paths.were.skipped.as.excluded.by.name.change.that.setting.in.settings.deployment.options", new Object[0]), (String)WDBundle.message("remove.path.from.excluded.error.title", new Object[0]));
        }
        if (pathsToRefresh.isEmpty()) {
            return;
        }
        ((DeploymentConfigChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).excludedPathsChanged();
        PerformInBackgroundOption backgroundOption = new PerformInBackgroundOption(){

            public boolean shouldStartInBackground() {
                return true;
            }
        };
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, WDBundle.message("refreshing.remote.files", new Object[0]), false, backgroundOption){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                indicator.setText(WDBundle.message("refreshing.remote.files", new Object[0]));
                indicator.setIndeterminate(true);
                ArrayList<WebServerConfig.RemotePath> refreshList = new ArrayList<WebServerConfig.RemotePath>(pathsToRefresh.size());
                for (String s : pathsToRefresh) {
                    refreshList.add(new WebServerConfig.RemotePath(s));
                }
                ((ServerTreeContentListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.SERVER_TREE)).refreshSubtree(serverConfig, refreshList, false, false, (WebServerConfig.RemotePath)refreshList.get(0), (Object)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/webDeployment/actions/ToggleRemoteExclusionAction$3", "run"));
            }
        });
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/ToggleRemoteExclusionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

