/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.changeBrowser;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.changeBrowser.CvsChangeList;
import com.intellij.cvsSupport2.changeBrowser.CvsChangeListsBuilder;
import com.intellij.cvsSupport2.changeBrowser.CvsRepositoryLocation;
import com.intellij.cvsSupport2.changeBrowser.CvsVersionFilterComponent;
import com.intellij.cvsSupport2.changeBrowser.LoadHistoryOperation;
import com.intellij.cvsSupport2.changeBrowser.LogInformationWrapper;
import com.intellij.cvsSupport2.changeBrowser.RevisionWrapper;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationGroup;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipperAdapter;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import gnu.trove.TObjectLongHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.log.Revision;

public class CvsCommittedChangesProvider
implements CachingCommittedChangesProvider<CvsChangeList, ChangeBrowserSettings> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.changeBrowser.CvsCommittedChangesProvider");
    private final Project myProject;
    private final ChangeListColumn<CvsChangeList> BRANCH_COLUMN = new ChangeListColumn<CvsChangeList>(){

        public String getTitle() {
            return CvsBundle.message((String)"changelist.column.branch", (Object[])new Object[0]);
        }

        public Object getValue(CvsChangeList changeList) {
            String branch = changeList.getBranch();
            return branch == null ? "HEAD" : branch;
        }
    };

    public CvsCommittedChangesProvider(Project project) {
        this.myProject = project;
    }

    public ChangesBrowserSettingsEditor<ChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new CvsVersionFilterComponent(showDateFilter);
    }

    @Nullable
    public VcsCommittedListsZipper getZipper() {
        return new MyZipper();
    }

    @Nullable
    public CvsRepositoryLocation getLocationFor(FilePath root) {
        if (!CvsUtil.fileIsUnderCvs(root.getIOFile())) {
            return null;
        }
        VirtualFile rootDir = root.isDirectory() ? root.getVirtualFile() : root.getVirtualFileParent();
        String module = CvsUtil.getModuleName(root);
        CvsConnectionSettings connectionSettings = CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(rootDir);
        return new CvsRepositoryLocation(root.getVirtualFile(), connectionSettings, module);
    }

    public ChangeListColumn[] getColumns() {
        return new ChangeListColumn[]{ChangeListColumn.DATE, ChangeListColumn.NAME, ChangeListColumn.DESCRIPTION, this.BRANCH_COLUMN};
    }

    @Nullable
    public VcsCommittedViewAuxiliary createActions(DecoratorManager manager, RepositoryLocation location) {
        return null;
    }

    public int getUnlimitedCountValue() {
        return 0;
    }

    @Nullable
    public Pair<CvsChangeList, FilePath> getOneList(VirtualFile file, VcsRevisionNumber number) throws VcsException {
        Date dateTo;
        long t;
        Date dateFrom;
        File ioFile = new File(file.getPath());
        FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(ioFile);
        VirtualFile vcsRoot = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsRootFor(filePath);
        CvsRepositoryLocation cvsLocation = this.getLocationFor(filePath);
        if (cvsLocation == null) {
            return null;
        }
        String module = CvsUtil.getModuleName(vcsRoot);
        CvsEnvironment connectionSettings = cvsLocation.getEnvironment();
        if (connectionSettings.isOffline()) {
            return null;
        }
        CvsChangeListsBuilder builder = new CvsChangeListsBuilder(module, connectionSettings, this.myProject, vcsRoot);
        Ref result = new Ref();
        LoadHistoryOperation operation = new LoadHistoryOperation(connectionSettings, (Consumer<LogInformationWrapper>)((Consumer)wrapper -> {
            List<Revision> revisions = wrapper.getRevisions();
            if (revisions.isEmpty()) {
                return;
            }
            RevisionWrapper revision = new RevisionWrapper(wrapper.getFile(), revisions.get(0), null);
            result.set((Object)builder.addRevision(revision));
        }), cvsLocation.getModuleName(), number.asString());
        CvsResult executionResult = operation.run(this.myProject);
        if (executionResult.isCanceled()) {
            throw new ProcessCanceledException();
        }
        if (executionResult.hasErrors()) {
            throw executionResult.composeError();
        }
        if (result.isNull()) {
            return null;
        }
        Date commitDate = ((CvsChangeList)result.get()).getCommitDate();
        CvsConnectionSettings rootConnectionSettings = CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(vcsRoot);
        LoadHistoryOperation operation2 = new LoadHistoryOperation((CvsEnvironment)rootConnectionSettings, module, dateFrom = new Date((t = commitDate.getTime()) - 120000L), dateTo = new Date(t + 120000L), (Consumer<LogInformationWrapper>)((Consumer)wrapper -> {
            List<RevisionWrapper> wrappers = builder.revisionWrappersFromLog((LogInformationWrapper)wrapper);
            if (wrappers != null) {
                for (RevisionWrapper revisionWrapper : wrappers) {
                    if (((CvsChangeList)result.get()).containsFileRevision(revisionWrapper)) continue;
                    builder.addRevision(revisionWrapper);
                }
            }
        }));
        CvsResult cvsResult = operation2.run(this.myProject);
        if (cvsResult.hasErrors()) {
            throw cvsResult.composeError();
        }
        return Pair.create((Object)result.get(), (Object)filePath);
    }

    public RepositoryLocation getForNonLocal(VirtualFile file) {
        return null;
    }

    public boolean supportsIncomingChanges() {
        return true;
    }

    public List<CvsChangeList> getCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount) throws VcsException {
        CvsRepositoryLocation cvsLocation = (CvsRepositoryLocation)location;
        String module = cvsLocation.getModuleName();
        VirtualFile rootFile = cvsLocation.getRootFile();
        return this.loadCommittedChanges(settings, module, cvsLocation.getEnvironment(), rootFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount, AsynchConsumer<CommittedChangeList> consumer) throws VcsException {
        try {
            ChangeBrowserSettings.Filter filter;
            HashSet controlSet;
            LoadHistoryOperation operation;
            CvsResult executionResult;
            CvsRepositoryLocation cvsLocation = (CvsRepositoryLocation)location;
            String module = cvsLocation.getModuleName();
            CvsEnvironment connectionSettings = cvsLocation.getEnvironment();
            if (connectionSettings.isOffline()) {
                return;
            }
            CvsChangeListsBuilder builder = new CvsChangeListsBuilder(module, connectionSettings, this.myProject, cvsLocation.getRootFile());
            Date dateTo = settings.getDateBeforeFilter();
            Date dateFrom = settings.getDateAfterFilter();
            if (dateFrom == null) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(1970, 2, 2);
                dateFrom = calendar.getTime();
            }
            if ((executionResult = (operation = new LoadHistoryOperation(connectionSettings, module, dateFrom, dateTo, (Consumer<LogInformationWrapper>)((Consumer)arg_0 -> CvsCommittedChangesProvider.lambda$loadCommittedChanges$2(builder, controlSet = new HashSet(), filter = settings.createFilter(), consumer, arg_0)))).run(this.myProject)).isCanceled()) {
                throw new ProcessCanceledException();
            }
            if (executionResult.hasErrors()) {
                throw executionResult.composeError();
            }
        }
        finally {
            consumer.finished();
        }
    }

    private List<CvsChangeList> loadCommittedChanges(ChangeBrowserSettings settings, String module, CvsEnvironment connectionSettings, VirtualFile rootFile) throws VcsException {
        LoadHistoryOperation operation;
        CvsResult executionResult;
        if (connectionSettings.isOffline()) {
            return Collections.emptyList();
        }
        CvsChangeListsBuilder builder = new CvsChangeListsBuilder(module, connectionSettings, this.myProject, rootFile);
        Date dateTo = settings.getDateBeforeFilter();
        Date dateFrom = settings.getDateAfterFilter();
        if (dateFrom == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1970, 2, 2);
            dateFrom = calendar.getTime();
        }
        if ((executionResult = (operation = new LoadHistoryOperation(connectionSettings, module, dateFrom, dateTo, (Consumer<LogInformationWrapper>)((Consumer)logInformationWrapper -> builder.add((LogInformationWrapper)logInformationWrapper)))).run(this.myProject)).isCanceled()) {
            throw new ProcessCanceledException();
        }
        if (executionResult.hasErrors()) {
            throw executionResult.composeError();
        }
        List<CvsChangeList> versions = builder.getVersions();
        settings.filterChanges(versions);
        return versions;
    }

    public int getFormatVersion() {
        return 3;
    }

    public void writeChangeList(DataOutput stream, CvsChangeList list) throws IOException {
        list.writeToStream(stream);
    }

    public CvsChangeList readChangeList(RepositoryLocation location, DataInput stream) throws IOException {
        CvsRepositoryLocation cvsLocation = (CvsRepositoryLocation)location;
        return new CvsChangeList(this.myProject, cvsLocation.getEnvironment(), cvsLocation.getRootFile(), stream);
    }

    public boolean isMaxCountSupported() {
        return false;
    }

    public Collection<FilePath> getIncomingFiles(RepositoryLocation location) {
        return null;
    }

    public boolean refreshCacheByNumber() {
        return false;
    }

    public String getChangelistTitle() {
        return null;
    }

    public boolean isChangeLocallyAvailable(FilePath filePath, @Nullable VcsRevisionNumber localRevision, VcsRevisionNumber changeRevision, CvsChangeList changeList) {
        if (localRevision instanceof CvsRevisionNumber && changeRevision instanceof CvsRevisionNumber) {
            CvsRevisionNumber cvsLocalRevision = (CvsRevisionNumber)localRevision;
            CvsRevisionNumber cvsChangeRevision = (CvsRevisionNumber)changeRevision;
            int[] localSubRevisions = cvsLocalRevision.getSubRevisions();
            int[] changeSubRevisions = cvsChangeRevision.getSubRevisions();
            if (localSubRevisions != null && changeSubRevisions != null) {
                if (localSubRevisions.length != changeSubRevisions.length) {
                    return true;
                }
                for (int i = 2; i < localSubRevisions.length; i += 2) {
                    if (localSubRevisions[i] == changeSubRevisions[i]) continue;
                    return true;
                }
            }
        }
        return CvsCommittedChangesProvider.isDifferentBranch(filePath, changeList) || localRevision != null && localRevision.compareTo((Object)changeRevision) >= 0;
    }

    private static boolean isDifferentBranch(FilePath filePath, CvsChangeList changeList) {
        String localTag;
        CvsEntriesManager cvsEntriesManager = CvsEntriesManager.getInstance();
        VirtualFile parent = filePath.getVirtualFileParent();
        if (parent != null) {
            Entry entry = cvsEntriesManager.getEntryFor(parent, filePath.getName());
            localTag = entry != null ? entry.getStickyTag() : CvsCommittedChangesProvider.getDirectoryTag(parent);
        } else {
            VirtualFile validParent = ChangesUtil.findValidParentAccurately((FilePath)filePath);
            if (validParent == null) {
                return false;
            }
            localTag = CvsCommittedChangesProvider.getDirectoryTag(validParent);
        }
        String remoteTag = changeList.getBranch();
        if (!Comparing.equal((String)localTag, (String)remoteTag)) {
            if (LOG.isDebugEnabled()) {
                LOG.info(filePath + ": local tag " + localTag + ", remote tag " + remoteTag);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static String getDirectoryTag(@NotNull VirtualFile parent) {
        String dirTag;
        if (parent == null) {
            CvsCommittedChangesProvider.$$$reportNull$$$0(0);
        }
        if ((dirTag = CvsEntriesManager.getInstance().getCvsInfoFor(parent).getStickyTag()) == null || !CvsUtil.isNonDateTag(dirTag)) {
            return null;
        }
        return dirTag.substring(1);
    }

    public boolean refreshIncomingWithCommitted() {
        return true;
    }

    private static /* synthetic */ void lambda$loadCommittedChanges$2(CvsChangeListsBuilder builder, Set controlSet, ChangeBrowserSettings.Filter filter, AsynchConsumer consumer, LogInformationWrapper wrapper) {
        List<RevisionWrapper> wrappers = builder.revisionWrappersFromLog(wrapper);
        if (wrappers != null) {
            for (RevisionWrapper revisionWrapper : wrappers) {
                CvsChangeList changeList = builder.addRevision(revisionWrapper);
                if (controlSet.contains(changeList)) continue;
                controlSet.add(changeList);
                if (!filter.accepts((CommittedChangeList)changeList)) continue;
                consumer.consume((Object)changeList);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/cvsSupport2/changeBrowser/CvsCommittedChangesProvider", "getDirectoryTag"));
    }

    private static class CommittedChangeListKey
    extends Trinity<String, Long, String> {
        CommittedChangeListKey(String name, Long commitDate, String comment) {
            super((Object)name, (Object)commitDate, (Object)comment);
        }
    }

    private static class MyZipper
    extends VcsCommittedListsZipperAdapter {
        private long lastNumber = 1L;
        private final TObjectLongHashMap<CommittedChangeListKey> numberCache = new TObjectLongHashMap();

        private MyZipper() {
            super(new VcsCommittedListsZipperAdapter.GroupCreator(){

                public Object createKey(RepositoryLocation location) {
                    CvsRepositoryLocation cvsLocation = (CvsRepositoryLocation)location;
                    return cvsLocation.getEnvironment().getRepository();
                }

                public RepositoryLocationGroup createGroup(Object key, Collection<RepositoryLocation> locations) {
                    RepositoryLocationGroup group = new RepositoryLocationGroup((String)key);
                    for (RepositoryLocation location : locations) {
                        group.add(location);
                    }
                    return group;
                }
            });
        }

        public long getNumber(CommittedChangeList list) {
            long time = list.getCommitDate().getTime();
            Long roundedTime = time - time % 120000L;
            CommittedChangeListKey key = new CommittedChangeListKey(list.getCommitterName(), roundedTime, list.getComment());
            long number = this.numberCache.get((Object)key);
            if (number == 0L) {
                this.numberCache.put((Object)key, this.lastNumber);
                return this.lastNumber++;
            }
            return number;
        }
    }
}

