/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CodeBlockProvider;
import com.intellij.codeInsight.editorActions.CodeBlockProviders;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.highlighting.CodeBlockSupportHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class CodeBlockUtil {
    private CodeBlockUtil() {
    }

    private static Language getBraceType(HighlighterIterator iterator) {
        IElementType type = iterator.getTokenType();
        return type.getLanguage();
    }

    public static void moveCaretToCodeBlockEnd(Project project, Editor editor, boolean isWithSelection) {
        Document document = editor.getDocument();
        int selectionStart = editor.getSelectionModel().getLeadSelectionOffset();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return;
        }
        IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
        CodeBlockProvider provider = (CodeBlockProvider)CodeBlockProviders.INSTANCE.forLanguage(file2.getLanguage());
        if (provider != null) {
            TextRange range2 = provider.getCodeBlockRange(editor, file2);
            if (range2 != null) {
                editor.getCaretModel().moveToOffset(range2.getEndOffset());
            }
        } else {
            IndentGuideDescriptor guide = editor.getIndentsModel().getCaretIndentGuide();
            if (guide != null) {
                editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(guide.endLine, guide.indentLevel));
            } else {
                int endOffset = CodeBlockUtil.calcBlockEndOffset(editor, file2);
                if (endOffset != -1) {
                    editor.getCaretModel().moveToOffset(endOffset);
                }
            }
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        if (isWithSelection) {
            editor.getSelectionModel().setSelection(selectionStart, editor.getCaretModel().getOffset());
        } else {
            editor.getSelectionModel().removeSelection();
        }
    }

    public static void moveCaretToCodeBlockStart(Project project, Editor editor, boolean isWithSelection) {
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        int selectionStart = editor.getSelectionModel().getLeadSelectionOffset();
        if (file2 == null) {
            return;
        }
        IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
        CodeBlockProvider provider = (CodeBlockProvider)CodeBlockProviders.INSTANCE.forLanguage(file2.getLanguage());
        if (provider != null) {
            TextRange range2 = provider.getCodeBlockRange(editor, file2);
            if (range2 != null) {
                editor.getCaretModel().moveToOffset(range2.getStartOffset());
            }
        } else {
            IndentGuideDescriptor guide = editor.getIndentsModel().getCaretIndentGuide();
            if (guide != null && guide.startLine != editor.getCaretModel().getLogicalPosition().line) {
                editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(guide.startLine, guide.indentLevel));
            } else {
                int start2 = CodeBlockUtil.calcBlockStartOffset(editor, file2);
                if (start2 < 0) {
                    return;
                }
                editor.getCaretModel().moveToOffset(start2);
            }
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        if (isWithSelection) {
            editor.getSelectionModel().setSelection(selectionStart, editor.getCaretModel().getOffset());
        } else {
            editor.getSelectionModel().removeSelection();
        }
    }

    private static int calcBlockEndOffset(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            CodeBlockUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            CodeBlockUtil.$$$reportNull$$$0(1);
        }
        int offsetFromBraceMatcher = CodeBlockUtil.calcBlockEndOffsetFromBraceMatcher(editor, file2);
        TextRange rangeFromStructuralSupport = CodeBlockSupportHandler.findCodeBlockRange(editor, file2);
        if (rangeFromStructuralSupport.isEmpty()) {
            return offsetFromBraceMatcher;
        }
        if (offsetFromBraceMatcher == -1) {
            return rangeFromStructuralSupport.getEndOffset();
        }
        return Math.min(rangeFromStructuralSupport.getEndOffset(), offsetFromBraceMatcher);
    }

    private static int calcBlockEndOffsetFromBraceMatcher(@NotNull Editor editor, @NotNull PsiFile file2) {
        Language braceType;
        if (editor == null) {
            CodeBlockUtil.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            CodeBlockUtil.$$$reportNull$$$0(3);
        }
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        FileType fileType = file2.getFileType();
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            return -1;
        }
        int depth = 0;
        boolean isBeforeLBrace = false;
        if (CodeBlockUtil.isLStructuralBrace(fileType, iterator, document.getCharsSequence())) {
            isBeforeLBrace = true;
            depth = -1;
            braceType = CodeBlockUtil.getBraceType(iterator);
        } else {
            braceType = null;
        }
        boolean moved = false;
        while (true) {
            if (iterator.atEnd()) {
                return -1;
            }
            if (CodeBlockUtil.isRStructuralBrace(fileType, iterator, document.getCharsSequence()) && (braceType == CodeBlockUtil.getBraceType(iterator) || braceType == null)) {
                if (moved) {
                    if (depth == 0) break;
                    --depth;
                }
                if (braceType == null) {
                    braceType = CodeBlockUtil.getBraceType(iterator);
                }
            } else if (CodeBlockUtil.isLStructuralBrace(fileType, iterator, document.getCharsSequence()) && (braceType == CodeBlockUtil.getBraceType(iterator) || braceType == null)) {
                if (braceType == null) {
                    braceType = CodeBlockUtil.getBraceType(iterator);
                }
                ++depth;
            }
            moved = true;
            iterator.advance();
        }
        return isBeforeLBrace ? iterator.getEnd() : iterator.getStart();
    }

    private static int calcBlockStartOffset(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            CodeBlockUtil.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            CodeBlockUtil.$$$reportNull$$$0(5);
        }
        int offsetFromBraceMatcher = CodeBlockUtil.calcBlockStartOffsetFromBraceMatcher(editor, file2);
        TextRange rangeFromStructuralSupport = CodeBlockSupportHandler.findCodeBlockRange(editor, file2);
        if (rangeFromStructuralSupport.isEmpty()) {
            return offsetFromBraceMatcher;
        }
        if (offsetFromBraceMatcher == -1) {
            return rangeFromStructuralSupport.getStartOffset();
        }
        return Math.max(rangeFromStructuralSupport.getStartOffset(), offsetFromBraceMatcher);
    }

    private static int calcBlockStartOffsetFromBraceMatcher(Editor editor, PsiFile file2) {
        Language braceType;
        int offset = editor.getCaretModel().getOffset() - 1;
        if (offset < 0) {
            return -1;
        }
        Document document = editor.getDocument();
        FileType fileType = file2.getFileType();
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        int depth = 0;
        boolean isAfterRBrace = false;
        if (CodeBlockUtil.isRStructuralBrace(fileType, iterator, document.getCharsSequence())) {
            isAfterRBrace = true;
            depth = -1;
            braceType = CodeBlockUtil.getBraceType(iterator);
        } else {
            braceType = null;
        }
        boolean moved = false;
        while (true) {
            if (iterator.atEnd()) {
                return -1;
            }
            if (CodeBlockUtil.isLStructuralBrace(fileType, iterator, document.getCharsSequence()) && (braceType == CodeBlockUtil.getBraceType(iterator) || braceType == null)) {
                if (braceType == null) {
                    braceType = CodeBlockUtil.getBraceType(iterator);
                }
                if (moved) {
                    if (depth == 0) break;
                    --depth;
                }
            } else if (CodeBlockUtil.isRStructuralBrace(fileType, iterator, document.getCharsSequence()) && (braceType == CodeBlockUtil.getBraceType(iterator) || braceType == null)) {
                if (braceType == null) {
                    braceType = CodeBlockUtil.getBraceType(iterator);
                }
                ++depth;
            }
            moved = true;
            iterator.retreat();
        }
        return isAfterRBrace ? iterator.getStart() : iterator.getEnd();
    }

    private static boolean isLStructuralBrace(FileType fileType, HighlighterIterator iterator, CharSequence fileText) {
        return BraceMatchingUtil.isLBraceToken(iterator, fileText, fileType) && BraceMatchingUtil.isStructuralBraceToken(fileType, iterator, fileText);
    }

    private static boolean isRStructuralBrace(FileType fileType, HighlighterIterator iterator, CharSequence fileText) {
        return BraceMatchingUtil.isRBraceToken(iterator, fileText, fileType) && BraceMatchingUtil.isStructuralBraceToken(fileType, iterator, fileText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/CodeBlockUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calcBlockEndOffset";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calcBlockEndOffsetFromBraceMatcher";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "calcBlockStartOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

