/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixChangedBuiltinTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateWrapper;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PostfixTemplates", storages={@Storage(value="postfixTemplates.xml")})
public class PostfixTemplateStorage
extends SimpleModificationTracker
implements PersistentStateComponent<Element> {
    private static final String TEMPLATE_TAG = "template";
    private static final String PROVIDER_ATTR_NAME = "provider";
    private static final String ID_ATTR_NAME = "id";
    private static final String KEY_ATTR_NAME = "key";
    private static final String BUILTIN_ATTR_NAME = "builtin";
    private final Map<String, PostfixTemplateProvider> myTemplateProviders;
    private final MultiMap<String, PostfixTemplate> myTemplates = MultiMap.createSmart();
    private final List<Element> myUnloadedTemplates = ContainerUtil.newSmartList();

    public PostfixTemplateStorage() {
        LanguageExtensionPoint[] extensions;
        this.myTemplateProviders = new HashMap<String, PostfixTemplateProvider>();
        for (LanguageExtensionPoint extension : extensions = (LanguageExtensionPoint[])new ExtensionPointName("com.intellij.codeInsight.template.postfixTemplateProvider").getExtensions()) {
            Object provider = extension.getInstance();
            if (!(provider instanceof PostfixTemplateProvider)) continue;
            this.myTemplateProviders.put(((PostfixTemplateProvider)provider).getId(), (PostfixTemplateProvider)provider);
        }
    }

    @NotNull
    public static PostfixTemplateStorage getInstance() {
        PostfixTemplateStorage postfixTemplateStorage = (PostfixTemplateStorage)((Object)ServiceManager.getService(PostfixTemplateStorage.class));
        if (postfixTemplateStorage == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(0);
        }
        return postfixTemplateStorage;
    }

    @NotNull
    public Set<PostfixTemplate> getTemplates(@NotNull PostfixTemplateProvider provider) {
        if (provider == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(1);
        }
        HashSet<PostfixTemplate> hashSet = new HashSet<PostfixTemplate>(this.myTemplates.get((Object)provider.getId()));
        if (hashSet == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    public void setTemplates(@NotNull PostfixTemplateProvider provider, @NotNull Collection<PostfixTemplate> templates) {
        Collection oldTemplates;
        if (provider == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(3);
        }
        if (templates == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(4);
        }
        if (!templates.equals(oldTemplates = this.myTemplates.get((Object)provider.getId()))) {
            this.myTemplates.put((Object)provider.getId(), templates);
            this.incModificationCount();
        }
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(5);
        }
        this.myTemplates.clear();
        for (Element templateElement : state.getChildren(TEMPLATE_TAG)) {
            PostfixTemplateProvider provider = this.myTemplateProviders.get(templateElement.getAttributeValue(PROVIDER_ATTR_NAME, ""));
            if (provider != null) {
                String templateId = templateElement.getAttributeValue(ID_ATTR_NAME, "");
                String templateName = StringUtil.trimStart((String)StringUtil.notNullize((String)templateElement.getAttributeValue(KEY_ATTR_NAME)), (String)".");
                if (StringUtil.isEmpty((String)templateId) || StringUtil.isEmpty((String)templateName)) continue;
                PostfixTemplate externalTemplate = provider.readExternalTemplate(templateId, templateName, templateElement);
                String builtinId = templateElement.getAttributeValue(BUILTIN_ATTR_NAME);
                PostfixTemplate builtinTemplate = PostfixTemplateStorage.findBuiltinTemplate(builtinId, provider);
                if (builtinTemplate != null) {
                    PostfixTemplate delegate = externalTemplate != null ? externalTemplate : new PostfixTemplateWrapper(templateId, templateName, "." + templateName, builtinTemplate, provider);
                    this.myTemplates.putValue((Object)provider.getId(), (Object)new PostfixChangedBuiltinTemplate(delegate, builtinTemplate));
                    continue;
                }
                if (externalTemplate != null) {
                    this.myTemplates.putValue((Object)provider.getId(), (Object)externalTemplate);
                    continue;
                }
                this.myUnloadedTemplates.add(templateElement);
                continue;
            }
            this.myUnloadedTemplates.add(templateElement);
        }
    }

    @Nullable
    private static PostfixTemplate findBuiltinTemplate(@Nullable String id, @NotNull PostfixTemplateProvider provider) {
        if (provider == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(6);
        }
        return (PostfixTemplate)ContainerUtil.find(provider.getTemplates(), p -> p.getId().equals(id));
    }

    public Element getState() {
        Element element = new Element("state");
        for (Element template : this.myUnloadedTemplates) {
            element.addContent(template.clone());
        }
        for (Map.Entry entry : this.myTemplates.entrySet()) {
            for (PostfixTemplate template : (Collection)entry.getValue()) {
                PostfixTemplateProvider provider = template.getProvider();
                if (provider == null) continue;
                if (template instanceof PostfixChangedBuiltinTemplate) {
                    PostfixChangedBuiltinTemplate changedBuiltinTemplate = (PostfixChangedBuiltinTemplate)template;
                    String builtin = changedBuiltinTemplate.getBuiltinTemplate().getId();
                    element.addContent(PostfixTemplateStorage.writeTemplate(changedBuiltinTemplate.getDelegate(), provider, builtin));
                    continue;
                }
                element.addContent(PostfixTemplateStorage.writeTemplate(template, provider, null));
            }
        }
        return element;
    }

    private static Element writeTemplate(@NotNull PostfixTemplate template, @NotNull PostfixTemplateProvider provider, @Nullable String builtinId) {
        if (template == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(7);
        }
        if (provider == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(8);
        }
        Element templateElement = new Element(TEMPLATE_TAG);
        templateElement.setAttribute(ID_ATTR_NAME, template.getId());
        templateElement.setAttribute(KEY_ATTR_NAME, template.getKey());
        templateElement.setAttribute(PROVIDER_ATTR_NAME, provider.getId());
        if (builtinId != null) {
            templateElement.setAttribute(BUILTIN_ATTR_NAME, builtinId);
        }
        provider.writeExternalTemplate(template, templateElement);
        return templateElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplateStorage";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROVIDER_ATTR_NAME;
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = TEMPLATE_TAG;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplateStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTemplates";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTemplates";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findBuiltinTemplate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

