/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.templateLanguages;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.DelegatingFormattingModelBuilder;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.templateLanguages.BlockUtil;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class TemplateLanguageFormattingModelBuilder
implements DelegatingFormattingModelBuilder,
TemplateLanguageBlockFactory {
    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        PsiFile file2 = element.getContainingFile();
        Block rootBlock = this.getRootBlock((PsiElement)file2, file2.getViewProvider(), settings);
        DocumentBasedFormattingModel documentBasedFormattingModel = new DocumentBasedFormattingModel(rootBlock, element.getProject(), settings, file2.getFileType(), file2);
        if (documentBasedFormattingModel == null) {
            TemplateLanguageFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        return documentBasedFormattingModel;
    }

    protected Block getRootBlock(PsiElement element, FileViewProvider viewProvider, CodeStyleSettings settings) {
        ASTNode node = element.getNode();
        if (node == null) {
            return this.createDummyBlock(node);
        }
        if (viewProvider instanceof TemplateLanguageFileViewProvider) {
            Language dataLanguage = ((TemplateLanguageFileViewProvider)viewProvider).getTemplateDataLanguage();
            FormattingModelBuilder builder2 = (FormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(dataLanguage);
            if (builder2 instanceof DelegatingFormattingModelBuilder && ((DelegatingFormattingModelBuilder)builder2).dontFormatMyModel(element)) {
                return this.createDummyBlock(node);
            }
            if (builder2 != null) {
                FormattingModel model = builder2.createModel((PsiElement)viewProvider.getPsi(dataLanguage), settings);
                List<DataLanguageBlockWrapper> childWrappers = BlockUtil.buildChildWrappers(model.getRootBlock());
                if (childWrappers.size() == 1) {
                    childWrappers = BlockUtil.buildChildWrappers(childWrappers.get(0).getOriginal());
                }
                return this.createTemplateLanguageBlock(node, Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), null, BlockUtil.filterBlocksByRange(childWrappers, node.getTextRange()), settings);
            }
        }
        return this.createTemplateLanguageBlock(node, Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), null, Collections.emptyList(), settings);
    }

    protected AbstractBlock createDummyBlock(ASTNode node) {
        return new AbstractBlock(node, Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), Alignment.createAlignment()){

            @Override
            protected List<Block> buildChildren() {
                return Collections.emptyList();
            }

            public Spacing getSpacing(Block child1, @NotNull Block child2) {
                if (child2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return Spacing.getReadOnlySpacing();
            }

            public boolean isLeaf() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/formatting/templateLanguages/TemplateLanguageFormattingModelBuilder$1", "getSpacing"));
            }
        };
    }

    @Override
    public boolean dontFormatMyModel() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/templateLanguages/TemplateLanguageFormattingModelBuilder", "createModel"));
    }
}

