/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.PluginsGroupComponentWithProgress;
import com.intellij.ide.plugins.newui.SearchPopupController;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchResultPanel {
    public final SearchPopupController controller;
    public final int tabIndex;
    public final int backTabIndex;
    protected final PluginsGroupComponent myPanel;
    private JScrollBar myVerticalScrollBar;
    private final PluginsGroup myGroup;
    private String myQuery;
    private AtomicBoolean myRunQuery;
    private boolean myEmpty;

    public SearchResultPanel(@Nullable SearchPopupController controller, @NotNull PluginsGroupComponent panel2, int tabIndex, int backTabIndex) {
        if (panel2 == null) {
            SearchResultPanel.$$$reportNull$$$0(0);
        }
        this.myGroup = new PluginsGroup("Search Results");
        this.myEmpty = true;
        this.controller = controller;
        this.myPanel = panel2;
        this.tabIndex = tabIndex;
        this.backTabIndex = backTabIndex;
        this.setEmptyText();
        if (this.isProgressMode()) {
            this.loading(false);
        }
    }

    @NotNull
    public JComponent createScrollPane() {
        JBScrollPane pane = new JBScrollPane((Component)((Object)this.myPanel));
        pane.setBorder((Border)JBUI.Borders.empty());
        if (this.isProgressMode()) {
            this.myVerticalScrollBar = pane.getVerticalScrollBar();
        }
        JBScrollPane jBScrollPane = pane;
        if (jBScrollPane == null) {
            SearchResultPanel.$$$reportNull$$$0(1);
        }
        return jBScrollPane;
    }

    private void setEmptyText() {
        this.myPanel.getEmptyText().setText("Nothing to show");
    }

    public boolean isEmpty() {
        return this.myEmpty;
    }

    public void setEmpty() {
        this.myEmpty = true;
    }

    @NotNull
    public String getQuery() {
        String string = StringUtil.defaultIfEmpty((String)this.myQuery, (String)"");
        if (string == null) {
            SearchResultPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setQuery(@NotNull String query) {
        if (query == null) {
            SearchResultPanel.$$$reportNull$$$0(3);
        }
        this.setEmptyText();
        if (query.equals(this.myQuery)) {
            this.myEmpty = query.isEmpty();
            return;
        }
        if (this.myRunQuery != null) {
            this.myRunQuery.set(false);
            this.myRunQuery = null;
            this.loading(false);
        }
        this.removeGroup();
        this.myQuery = query;
        this.myEmpty = query.isEmpty();
        if (!this.myEmpty) {
            this.handleQuery(query);
        }
    }

    private void handleQuery(@NotNull String query) {
        if (query == null) {
            SearchResultPanel.$$$reportNull$$$0(4);
        }
        this.myGroup.clear();
        if (this.isProgressMode()) {
            this.loading(true);
            AtomicBoolean runQuery = this.myRunQuery = new AtomicBoolean(true);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                this.handleQuery(this.myQuery, this.myGroup);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!runQuery.get()) {
                        return;
                    }
                    this.myRunQuery = null;
                    this.loading(false);
                    if (!this.myGroup.descriptors.isEmpty()) {
                        this.myGroup.titleWithCount();
                        this.myPanel.addLazyGroup(this.myGroup, this.myVerticalScrollBar, 100, this::fullRepaint);
                    }
                    this.myPanel.initialSelection(false);
                    this.fullRepaint();
                }, ModalityState.any());
            });
        } else {
            this.handleQuery(query, this.myGroup);
            if (!this.myGroup.descriptors.isEmpty()) {
                this.myPanel.addGroup(this.myGroup);
                this.myGroup.titleWithCount();
                this.myPanel.initialSelection(false);
            }
            this.fullRepaint();
        }
    }

    protected abstract void handleQuery(@NotNull String var1, @NotNull PluginsGroup var2);

    private void loading(boolean start2) {
        PluginsGroupComponentWithProgress panel2 = (PluginsGroupComponentWithProgress)this.myPanel;
        if (start2) {
            panel2.startLoading();
        } else {
            panel2.stopLoading();
        }
    }

    public void dispose() {
        if (this.isProgressMode()) {
            ((PluginsGroupComponentWithProgress)this.myPanel).dispose();
        }
    }

    private boolean isProgressMode() {
        return this.myPanel instanceof PluginsGroupComponentWithProgress;
    }

    private void removeGroup() {
        if (this.myGroup.ui != null) {
            this.myPanel.removeGroup(this.myGroup);
            this.fullRepaint();
        }
    }

    private void fullRepaint() {
        this.myPanel.doLayout();
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/SearchResultPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/SearchResultPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createScrollPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setQuery";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleQuery";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

