/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.AllFileTemplatesConfigurable;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class TraverseUIStarter
extends ApplicationStarterEx {
    private static final String OPTIONS = "options";
    private static final String CONFIGURABLE = "configurable";
    private static final String ID = "id";
    private static final String CONFIGURABLE_NAME = "configurable_name";
    private static final String OPTION = "option";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String HIT = "hit";
    private String OUTPUT_PATH;

    public boolean isHeadless() {
        return true;
    }

    public String getCommandName() {
        return "traverseUI";
    }

    public void premain(String[] args) {
        this.OUTPUT_PATH = args[1];
    }

    public void main(String[] args) {
        System.out.println("Starting searchable options index builder");
        try {
            TraverseUIStarter.startup(this.OUTPUT_PATH);
            ((ApplicationEx)ApplicationManager.getApplication()).exit(true, true);
        }
        catch (Throwable e) {
            System.out.println("Searchable options index builder failed");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startup(String outputPath) throws IOException {
        LinkedHashMap<SearchableConfigurable, Set<OptionDescription>> options = new LinkedHashMap<SearchableConfigurable, Set<OptionDescription>>();
        try {
            SearchUtil.processProjectConfigurables(ProjectManager.getInstance().getDefaultProject(), options);
            Element root = new Element(OPTIONS);
            Iterator iterator = options.keySet().iterator();
            while (iterator.hasNext()) {
                UnnamedConfigurable wrapped;
                SearchableConfigurable option;
                SearchableConfigurable configurable = option = (SearchableConfigurable)iterator.next();
                Element configurableElement = new Element(CONFIGURABLE);
                String id = configurable.getId();
                configurableElement.setAttribute(ID, id);
                configurableElement.setAttribute(CONFIGURABLE_NAME, configurable.getDisplayName());
                Set sortedOptions = (Set)options.get(configurable);
                TraverseUIStarter.writeOptions(configurableElement, sortedOptions);
                if (configurable instanceof ConfigurableWrapper && (wrapped = ((ConfigurableWrapper)configurable).getConfigurable()) instanceof SearchableConfigurable) {
                    configurable = (SearchableConfigurable)wrapped;
                }
                if (configurable instanceof KeymapPanel) {
                    TraverseUIStarter.processKeymap(configurableElement);
                } else if (configurable instanceof OptionsContainingConfigurable) {
                    TraverseUIStarter.processOptionsContainingConfigurable((OptionsContainingConfigurable)configurable, configurableElement);
                } else if (configurable instanceof PluginManagerConfigurable) {
                    for (OptionDescription description : TraverseUIStarter.wordsToOptionDescriptors(Collections.singleton("Manage repositories..."))) {
                        TraverseUIStarter.append(null, "Manage repositories...", description.getOption(), configurableElement);
                    }
                } else if (configurable instanceof AllFileTemplatesConfigurable) {
                    TraverseUIStarter.processFileTemplates(configurableElement);
                }
                root.addContent(configurableElement);
            }
            FileUtil.ensureCanCreateFile((File)new File(outputPath));
            JDOMUtil.writeDocument((Document)new Document(root), (String)outputPath, (String)"\n");
            System.out.println("Searchable options index builder completed");
        }
        finally {
            for (SearchableConfigurable configurable : options.keySet()) {
                configurable.disposeUIResources();
            }
        }
    }

    private static void processFileTemplates(Element configurableElement) {
        SearchableOptionsRegistrar optionsRegistrar = SearchableOptionsRegistrar.getInstance();
        TreeSet options = new TreeSet();
        FileTemplateManager fileTemplateManager = FileTemplateManager.getDefaultInstance();
        TraverseUIStarter.processTemplates(optionsRegistrar, options, fileTemplateManager.getAllTemplates());
        TraverseUIStarter.processTemplates(optionsRegistrar, options, fileTemplateManager.getAllPatterns());
        TraverseUIStarter.processTemplates(optionsRegistrar, options, fileTemplateManager.getAllCodeTemplates());
        TraverseUIStarter.processTemplates(optionsRegistrar, options, fileTemplateManager.getAllJ2eeTemplates());
        TraverseUIStarter.writeOptions(configurableElement, options);
    }

    private static void processTemplates(SearchableOptionsRegistrar registrar, Set<? super OptionDescription> options, FileTemplate[] templates) {
        for (FileTemplate template : templates) {
            TraverseUIStarter.collectOptions(registrar, options, template.getName(), null);
        }
    }

    private static void collectOptions(SearchableOptionsRegistrar registrar, Set<? super OptionDescription> options, @NotNull String text, String path) {
        if (text == null) {
            TraverseUIStarter.$$$reportNull$$$0(0);
        }
        for (String word : registrar.getProcessedWordsWithoutStemming(text)) {
            options.add((OptionDescription)new OptionDescription(word, text, path));
        }
    }

    private static void processOptionsContainingConfigurable(OptionsContainingConfigurable configurable, Element configurableElement) {
        Set<String> optionsPath = configurable.processListOptions();
        Set<OptionDescription> result2 = TraverseUIStarter.wordsToOptionDescriptors(optionsPath);
        TraverseUIStarter.writeOptions(configurableElement, result2);
    }

    private static Set<OptionDescription> wordsToOptionDescriptors(@NotNull Set<String> optionsPath) {
        if (optionsPath == null) {
            TraverseUIStarter.$$$reportNull$$$0(1);
        }
        SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
        TreeSet<OptionDescription> result2 = new TreeSet<OptionDescription>();
        for (String opt : optionsPath) {
            for (String word : registrar.getProcessedWordsWithoutStemming(opt)) {
                if (word == null) continue;
                result2.add(new OptionDescription(word, opt, null));
            }
        }
        return result2;
    }

    private static void processKeymap(Element configurableElement) {
        ActionManager actionManager = ActionManager.getInstance();
        String componentName = actionManager.getComponentName();
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Set<String> ids = ((ActionManagerImpl)actionManager).getActionIds();
        TreeSet options = new TreeSet();
        for (String id : ids) {
            String description;
            AnAction anAction = actionManager.getAction(id);
            String text = anAction.getTemplatePresentation().getText();
            if (text != null) {
                TraverseUIStarter.collectOptions(searchableOptionsRegistrar, options, text, componentName);
            }
            if ((description = anAction.getTemplatePresentation().getDescription()) == null) continue;
            TraverseUIStarter.collectOptions(searchableOptionsRegistrar, options, description, componentName);
        }
        TraverseUIStarter.writeOptions(configurableElement, options);
    }

    private static void writeOptions(Element configurableElement, Set<? extends OptionDescription> options) {
        for (OptionDescription optionDescription : options) {
            TraverseUIStarter.append(optionDescription.getPath(), optionDescription.getHit(), optionDescription.getOption(), configurableElement);
        }
    }

    private static void append(String path, String hit, String word, Element configurableElement) {
        Element optionElement = new Element(OPTION);
        optionElement.setAttribute(NAME, word);
        if (path != null) {
            optionElement.setAttribute(PATH, path);
        }
        optionElement.setAttribute(HIT, hit);
        configurableElement.addContent(optionElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/ui/search/TraverseUIStarter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "wordsToOptionDescriptors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

